/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.report.controller;

import com.qianjiang.report.bean.Report;
import com.qianjiang.report.service.ReportService;
import com.qianjiang.report.util.DateUtil;
import com.qianjiang.thirdaudit.service.AuditService;
import com.qianjiang.util.PageBean;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ReportController {
    @Resource(name="ReportService")
    private ReportService reportService;
    @Resource(name="auditService")
    private AuditService auditService;

    @RequestMapping(value={"checkReport"})
    public ModelAndView checkReport(PageBean pb, Report report, String startDate, String endDate, String attrName, String attrValue) {
        pb.setUrl("checkReport.htm");
        if (endDate != null && !"".equals(endDate)) {
            report.setEndDate(DateUtil.addOneDay((String)endDate));
        }
        if (startDate != null && !"".equals(startDate)) {
            report.setStartDate(startDate);
        }
        HashMap<String, String> dateMap = new HashMap<String, String>();
        dateMap.put("today", DateUtil.dateToString((Date)new Date()));
        dateMap.put("recentOneMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)1));
        dateMap.put("recentThreeMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)3));
        dateMap.put("recentSixMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)6));
        return new ModelAndView("jsp/report/reportlist").addObject("pb", (Object)this.reportService.selectList(report, pb)).addObject("startDate", (Object)startDate).addObject("endDate", (Object)endDate).addObject("dateMap", dateMap).addObject("attrName", (Object)attrName).addObject("attrValue", (Object)attrValue).addObject("storeName", (Object)report.getStoreName()).addObject("totalOrderMoney", (Object)report.getTotalOrderMoney());
    }

    @RequestMapping(value={"queryReportCate"})
    public ModelAndView queryReportCate(PageBean pb, Report report, String attrName, String attrValue) {
        pb.setUrl("queryReportCate.htm");
        HashMap<String, String> dateMap = new HashMap<String, String>();
        dateMap.put("today", DateUtil.dateToString((Date)new Date()));
        dateMap.put("recentOneMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)1));
        dateMap.put("recentThreeMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)3));
        dateMap.put("recentSixMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)6));
        return new ModelAndView("jsp/report/reportcatelist").addObject("pb", (Object)this.reportService.selectReportCateList(report, pb)).addObject("report", (Object)report).addObject("store", (Object)this.auditService.selectByCustomerId(report.getStoreId())).addObject("dateMap", dateMap).addObject("attrName", (Object)attrName).addObject("attrValue", (Object)attrValue).addObject("cateName", (Object)report.getCateName()).addObject("totalOrderMoney", (Object)report.getTotalOrderMoney());
    }

    @RequestMapping(value={"queryReportOrderCate"})
    public ModelAndView queryReportOrderCate(PageBean pb, Long storeId, String startTime, String endTime, String attrName, String attrValue) throws ParseException {
        pb.setUrl("queryReportCate.htm");
        HashMap<String, String> dateMap = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date starttime = sdf.parse(startTime);
        Date endtime = sdf.parse(endTime);
        dateMap.put("today", DateUtil.dateToString((Date)new Date()));
        dateMap.put("recentOneMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)1));
        dateMap.put("recentThreeMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)3));
        dateMap.put("recentSixMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)6));
        return new ModelAndView("jsp/report/ordercatelist").addObject("pb", (Object)this.reportService.selectReportOrderCateList(storeId, starttime, endtime, pb)).addObject("store", (Object)this.auditService.selectByCustomerId(storeId)).addObject("storeId", (Object)storeId).addObject("dateMap", dateMap).addObject("attrName", (Object)attrName).addObject("attrValue", (Object)attrValue);
    }

    @RequestMapping(value={"queryReportOrderCateDetail"})
    public ModelAndView queryReportOrderCateDetail(PageBean pb, Long storeId, Long orderId, String attrName, String attrValue) throws ParseException {
        pb.setUrl("queryReportCate.htm");
        HashMap<String, String> dateMap = new HashMap<String, String>();
        dateMap.put("today", DateUtil.dateToString((Date)new Date()));
        dateMap.put("recentOneMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)1));
        dateMap.put("recentThreeMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)3));
        dateMap.put("recentSixMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)6));
        return new ModelAndView("jsp/report/ordercatedetail").addObject("pb", (Object)this.reportService.selectReportOrderCateDdetailList(storeId, orderId, pb)).addObject("store", (Object)this.auditService.selectByCustomerId(storeId)).addObject("storeId", (Object)storeId).addObject("dateMap", dateMap).addObject("attrName", (Object)attrName).addObject("attrValue", (Object)attrValue);
    }

    @RequestMapping(value={"queryReportBackOrderCate"})
    public ModelAndView queryReportBackOrderCate(PageBean pb, Long storeId, String startTime, String endTime, String attrName, String attrValue) throws ParseException {
        pb.setUrl("queryReportCate.htm");
        HashMap<String, String> dateMap = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date starttime = sdf.parse(startTime);
        Date endtime = sdf.parse(endTime);
        dateMap.put("today", DateUtil.dateToString((Date)new Date()));
        dateMap.put("recentOneMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)1));
        dateMap.put("recentThreeMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)3));
        dateMap.put("recentSixMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)6));
        return new ModelAndView("jsp/report/backordercatelist").addObject("pb", (Object)this.reportService.selectReportBackOrderCateList(storeId, starttime, endtime, pb)).addObject("store", (Object)this.auditService.selectByCustomerId(storeId)).addObject("storeId", (Object)storeId).addObject("dateMap", dateMap).addObject("attrName", (Object)attrName).addObject("attrValue", (Object)attrValue);
    }

    @RequestMapping(value={"queryReportBackOrderCateDetail"})
    public ModelAndView queryReportBackOrderCateDetail(PageBean pb, Long storeId, Long orderId, String attrName, String attrValue) throws ParseException {
        pb.setUrl("queryReportCate.htm");
        HashMap<String, String> dateMap = new HashMap<String, String>();
        dateMap.put("today", DateUtil.dateToString((Date)new Date()));
        dateMap.put("recentOneMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)1));
        dateMap.put("recentThreeMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)3));
        dateMap.put("recentSixMonth", DateUtil.getDateOfLastNMonth((String)DateUtil.dateToString((Date)new Date()), (int)6));
        return new ModelAndView("jsp/report/backordercatedetail").addObject("pb", (Object)this.reportService.selectReportBackOrderCateDdetailList(storeId, orderId, pb)).addObject("store", (Object)this.auditService.selectByCustomerId(storeId)).addObject("storeId", (Object)storeId).addObject("dateMap", dateMap).addObject("attrName", (Object)attrName).addObject("attrValue", (Object)attrValue);
    }

    @RequestMapping(value={"generatReport"})
    public ModelAndView generatReport(String startDate, String endDate, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String startDateNew = startDate;
        String endDateNew = endDate;
        if (startDateNew == null || "".equals(startDateNew)) {
            startDateNew = DateUtil.getDateOfLastMonth((String)DateUtil.dateToString((Date)new Date()));
        }
        if (endDateNew == null || "".equals(endDateNew)) {
            endDateNew = DateUtil.dateToString((Date)new Date());
        }
        this.reportService.generateReport(startDateNew, endDateNew);
        return new ModelAndView((View)new RedirectView("checkReport.htm"));
    }

    @RequestMapping(value={"deleReportByStoreId"})
    public ModelAndView deleReport(Long[] storeIds, HttpServletRequest request) {
        for (Long storeId : storeIds) {
            this.reportService.deleteByReportByStoreId(storeId);
        }
        return new ModelAndView("redirect:checkReport.htm?CSRFToken=" + request.getSession().getAttribute("token"));
    }

    @RequestMapping(value={"deleReportById"})
    public ModelAndView deleReportById(Long[] reportIds, Long storeId, HttpServletRequest request) {
        for (Long reportId : reportIds) {
            this.reportService.delete(reportId);
        }
        return new ModelAndView("redirect:queryReportCate.htm?CSRFToken=" + request.getSession().getAttribute("token") + "&storeId=" + storeId);
    }

    @RequestMapping(value={"reportDetail"})
    public ModelAndView reportDetail(Long reportId) {
        return new ModelAndView("jsp/report/reportdetail").addObject("report", (Object)this.reportService.select(reportId));
    }
}

