/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.LogisticsCompany;
import com.qianjiang.system.cache.IDictionarysCache;
import com.qianjiang.system.controller.BaseController;
import com.qianjiang.system.service.ILogisticsCompanyBiz;
import com.qianjiang.system.service.ISysDictionaryBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="logisticsCompanyController")
public class LogisticsCompanyController
extends BaseController {
    private static final MyLogger LOGGER = new MyLogger(LogisticsCompanyController.class);
    public static final String OPERAPATH = "operaPath";
    private static final String PAGEBEAN = "pageBean";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="logisticsCompanyBizImpl")
    private ILogisticsCompanyBiz logisticsCompanyBizImpl;
    private static final String[] DICTIONARYS_LIST = new String[0];
    @Resource(name="dictionarysCache")
    private IDictionarysCache dictionarysCache;
    @Resource(name="sysDictionaryBizImpl")
    private ISysDictionaryBiz sysDictionaryBizImpl;
    private static final String INIT_LOGISTICSCOMPANY = "initLogisticsCompany.htm";
    private static final String ADD_LOGISTICSCOMPANY_JSP = "jsp/system/logistics/logisticscompany_add";
    private static final String LOGISTICSCOMPANY_LIST_JSP = "jsp/system/logistics/logisticscompany_list";
    private static final String UPDATE_LOGISTICSCOMPANY_JSP = "jsp/system/logistics/logisticscompany_update";
    private static final String READ_LOGISTICSCOMPANY_JSP = "jsp/system/logistics/logisticscompany_read";
    private static final String DELETESTATUS = "deleteStatus";
    private static final String MSG = "msg";
    private static final String LOGISTICSCOMPANY = "logisticsCompany";
    private static final String IDS = "ids";
    private static final String NAME = "name";
    private static final String CODE = "code";

    @RequestMapping(value={"/initLogisticsCompany"})
    public ModelAndView initLogisticsCompany(PageBean pageBean, @RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, HttpServletRequest request) {
        pageBean.setUrl(INIT_LOGISTICSCOMPANY);
        ModelAndView mav = new ModelAndView();
        mav.setViewName(LOGISTICSCOMPANY_LIST_JSP);
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, deleteStatus);
        mav.addObject(PAGEBEAN, (Object)this.logisticsCompanyBizImpl.getLogisticsCompanyByField(pa, pageBean));
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        mav.addObject(MSG, request.getAttribute(MSG));
        mav.addObject(MSG, (Object)request.getParameter(MSG));
        mav.addObject("deleteObjectSize", (Object)this.getDeleteObjectSize());
        return mav;
    }

    private int getDeleteObjectSize() {
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, 1);
        try {
            return this.logisticsCompanyBizImpl.getLogisticsCompanyByFieldTotal(pa);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u5220\u9664\u5bf9\u8c61\u7684\u6570\u91cf\u5f02\u5e38\uff01", (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/openAddLogisticsCompanyPage"})
    public ModelAndView openAddLogisticsCompanyPage(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName(ADD_LOGISTICSCOMPANY_JSP);
        this.fullDictionarys(mav);
        return mav;
    }

    @RequestMapping(value={"/addLogisticsCompany"})
    public ModelAndView addLogisticsCompany(LogisticsCompany logisticsCompany, BindingResult bindingResult, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            boolean flag;
            logisticsCompany.setInsertDate(new Date());
            Long loginUserId = this.getLoginUserId(request);
            logisticsCompany.setInsertId(loginUserId.intValue());
            logisticsCompany.setDeleteStatus(0);
            if (logisticsCompany.getSort() == 0) {
                logisticsCompany.setSort(this.logisticsCompanyBizImpl.getLogisticsCompanyMaxSort() + 1);
            }
            if (!(flag = this.logisticsCompanyBizImpl.saveLogisticsCompany(logisticsCompany))) {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5931\u8d25\uff01");
                return this.backAddPage(logisticsCompany, mav);
            }
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u7269\u6d41\u516c\u53f8", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_LOGISTICSCOMPANY));
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u7269\u6d41\u516c\u53f8\u9519\u8bef\uff1a=>", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5931\u8d25\uff01");
            return this.backAddPage(logisticsCompany, mav);
        }
        return mav;
    }

    private ModelAndView backAddPage(LogisticsCompany logisticsCompany, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(LOGISTICSCOMPANY, (Object)logisticsCompany);
        mav.setViewName(ADD_LOGISTICSCOMPANY_JSP);
        return mav;
    }

    @RequestMapping(value={"/openUpdateLogisticsCompanyPage"})
    public ModelAndView openUpdateLogisticsCompanyPage(@RequestParam(value="id") int id) {
        ModelAndView mav = new ModelAndView();
        try {
            this.fullDictionarys(mav);
            mav.addObject(LOGISTICSCOMPANY, (Object)this.logisticsCompanyBizImpl.getLogisticsCompanyById(id));
            mav.setViewName(UPDATE_LOGISTICSCOMPANY_JSP);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/selectLogisticsCompanyById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public LogisticsCompany selectLogisticsCompanyById(Integer companyId) {
        return this.logisticsCompanyBizImpl.getLogisticsCompanyById(companyId.intValue());
    }

    @RequestMapping(value={"/ajaxCheckLogisticsCompany"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int ajaxCheckLogisticsCompany(String name, String code) {
        int result = 0;
        List logisticsCompanyList = this.logisticsCompanyBizImpl.queryLogisticsCompanys();
        for (LogisticsCompany logisticsCompany : logisticsCompanyList) {
            if (name.equals(logisticsCompany.getName())) {
                result = 1;
                return result;
            }
            if (!code.equals(logisticsCompany.getCode())) continue;
            result = 2;
            return result;
        }
        if (result == 1 || result == 2) {
            return result;
        }
        return result;
    }

    @RequestMapping(value={"/updateLogisticsCompany"})
    public ModelAndView updateLogisticsCompany(@Valid LogisticsCompany logisticsCompany, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(INIT_LOGISTICSCOMPANY));
        }
        ModelAndView mav = new ModelAndView();
        try {
            logisticsCompany.setModifyDate(new Date());
            Long loginUserId = this.getLoginUserId(request);
            logisticsCompany.setModifyId(loginUserId.intValue());
            if (this.logisticsCompanyBizImpl.updateLogisticsCompany(logisticsCompany) < 1) {
                mav.addObject(MSG, (Object)"\u4fee\u6539\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5931\u8d25\uff01");
                return this.backUpdatePage(logisticsCompany, mav);
            }
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u7269\u6d41\u516c\u53f8", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            mav.addObject(MSG, (Object)"\u4fee\u6539\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_LOGISTICSCOMPANY));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u7269\u6d41\u516c\u53f8\u9519\u8bef\uff1a=>", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fee\u6539\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5931\u8d25\uff01");
            return this.backUpdatePage(logisticsCompany, mav);
        }
        return mav;
    }

    private ModelAndView backUpdatePage(LogisticsCompany logisticsCompany, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(LOGISTICSCOMPANY, (Object)logisticsCompany);
        mav.setViewName(UPDATE_LOGISTICSCOMPANY_JSP);
        return mav;
    }

    @RequestMapping(value={"/readLogisticsCompany"})
    public ModelAndView readLogisticsCompany(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="id") int id) {
        ModelAndView mav = new ModelAndView();
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        if (id == 0) {
            mav.addObject(MSG, (Object)"\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\uff01");
            mav.setView((View)new RedirectView(INIT_LOGISTICSCOMPANY));
        } else {
            mav.setViewName(READ_LOGISTICSCOMPANY_JSP);
            mav.addObject(LOGISTICSCOMPANY, (Object)this.logisticsCompanyBizImpl.getLogisticsCompanyById(id));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteLogisticsCompany"})
    public ModelAndView deleteLogisticsCompany(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="ids") String ids, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_LOGISTICSCOMPANY));
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5220\u9664\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            if (deleteStatus == 1) {
                if (this.logisticsCompanyBizImpl.deleteLogisticsCompany(ids) >= 1) {
                    String customerName = (String)request.getSession().getAttribute(NAME);
                    OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u7269\u6d41\u516c\u53f8", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                    mav.addObject(MSG, (Object)"\u5220\u9664\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5931\u8d25\uff01");
                }
            } else {
                HashMap<String, Object> pa = new HashMap<String, Object>(2);
                pa.put(DELETESTATUS, 1);
                pa.put(IDS, ids);
                if (this.logisticsCompanyBizImpl.updateLogisticsCompanyFieldById(pa) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
                }
            }
            mav.addObject(DELETESTATUS, (Object)deleteStatus);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u7269\u6d41\u516c\u53f8\u9519\u8bef\uff1a=>", (Throwable)e);
            mav.addObject(MSG, (Object)"\u5220\u9664\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/restoreLogisticsCompany"})
    public ModelAndView restoreLogisticsCompany(@RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_LOGISTICSCOMPANY));
        mav.addObject(DELETESTATUS, (Object)1);
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u8fd8\u539f\u5220\u9664\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            HashMap<String, Object> pa = new HashMap<String, Object>(2);
            pa.put(DELETESTATUS, 0);
            pa.put(IDS, ids);
            if (this.logisticsCompanyBizImpl.updateLogisticsCompanyFieldById(pa) >= 1) {
                mav.addObject(MSG, (Object)"\u5220\u9664\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
            } else {
                mav.addObject(MSG, (Object)"\u5220\u9664\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fd8\u539f\u5220\u9664\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u8fd8\u539f\u5220\u9664\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/queryLogisticsCompany"})
    public ModelAndView queryLogisticsCompany(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="code", required=false, defaultValue="") String code, PageBean pageBean) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> queryParam = new HashMap<String, String>();
        if (name != null && name.trim().length() != 0) {
            param.put(NAME, name);
            queryParam.put(NAME, name);
            queryParam.put("searchField", NAME);
            queryParam.put("searchValue", name);
            queryParam.put("searchName", "\u7269\u6d41\u516c\u53f8\u540d\u79f0");
        }
        if (code != null && code.trim().length() != 0) {
            param.put(CODE, code);
            queryParam.put(CODE, code);
            queryParam.put("searchField", CODE);
            queryParam.put("searchValue", code);
            queryParam.put("searchName", "\u7269\u6d41\u516c\u53f8\u4ee3\u7801");
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName(LOGISTICSCOMPANY_LIST_JSP);
        mav.addObject("queryParam", queryParam);
        param.put(DELETESTATUS, deleteStatus);
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        try {
            mav.addObject(PAGEBEAN, (Object)this.logisticsCompanyBizImpl.getLogisticsCompanyByField(param, pageBean));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/queryLogisticsCompanyNew"})
    public ModelAndView queryLogisticsCompanyNew(String companyName, String companyCode, PageBean pageBean) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(NAME, companyName);
        param.put(CODE, companyCode);
        param.put(DELETESTATUS, 0);
        ModelAndView mav = new ModelAndView();
        mav.setViewName(LOGISTICSCOMPANY_LIST_JSP);
        try {
            mav.addObject(PAGEBEAN, (Object)this.logisticsCompanyBizImpl.getLogisticsCompanyByField(param, pageBean));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7269\u6d41\u516c\u53f8\u8bbe\u7f6e\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.addObject("companyName", (Object)companyName);
        mav.addObject("companyCode", (Object)companyCode);
        return mav;
    }

    @RequestMapping(value={"/changeUserdStatucForLogCom"})
    public ModelAndView changeUserdStatucForLogCom(Long logComId) {
        try {
            if (this.logisticsCompanyBizImpl.changeUserdStatus(logComId)) {
                LOGGER.debug("===============\u914d\u9001\u65b9\u5f0f\u542f\u7528\u72b6\u6001\u4fee\u6539\u6210\u529f");
            } else {
                LOGGER.debug("===============\u914d\u9001\u65b9\u5f0f\u542f\u7528\u72b6\u6001\u4fee\u6539\u5931\u8d25");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u7269\u6d41\u516c\u53f8\u542f\u7528\u72b6\u6001\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(INIT_LOGISTICSCOMPANY));
    }

    @ResponseBody
    @RequestMapping(value={"/checkExpressCount"}, produces={"application/json;charset=UTF-8"})
    public boolean checkExpressCount(Long logComId) {
        return this.logisticsCompanyBizImpl.checkDeleteLogistics(logComId);
    }

    private void fullDictionarys(ModelAndView mav) {
        for (String dep : DICTIONARYS_LIST) {
            try {
                mav.addObject(dep, this.dictionarysCache.getDictionaryByName(dep));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u5f97\u5b57\u5178\u7f13\u5b58\u5f02\u5e38\uff0c\u5b57\u5178\u540d\uff1a" + dep, (Throwable)e);
            }
        }
        PageBean pg = new PageBean();
        int pageSize = 100;
        pg.setPageSize(pageSize);
        HashMap<String, Integer> pa = new HashMap<String, Integer>(2);
        int parentId = 113;
        pa.put("parentId", parentId);
        pa.put("status", 1);
        try {
            mav.addObject("sysDicLogisticsCode", (Object)this.sysDictionaryBizImpl.getSysDictionaryByField(pa, pg).getList());
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u8d27\u5e01\u8bbe\u7f6e\u5b57\u5178\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    private Long getLoginUserId(HttpServletRequest request) {
        Long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        return loginUserId;
    }

    @RequestMapping(value={"/deleteLogisticsCompanyOne"})
    public ModelAndView deleteLogisticsCompanyOne(Integer companyId) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_LOGISTICSCOMPANY));
        this.logisticsCompanyBizImpl.deleteLogisticsCompanyOne(companyId);
        return mav;
    }

    @RequestMapping(value={"/deleteLogisticsCompanyBatch"})
    public ModelAndView deleteLogisticsCompanyBatch(Integer[] companyIds) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_LOGISTICSCOMPANY));
        for (Integer companyId : companyIds) {
            this.logisticsCompanyBizImpl.deleteLogisticsCompanyOne(companyId);
        }
        return mav;
    }
}

