/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.temp.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qianjiang.channel.bean.ChannelBar;
import com.qianjiang.channel.service.ChannelBarService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class TempBarController {
    private static final MyLogger LOGGER = new MyLogger(TempBarController.class);
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private static final String LOGGERINFO2 = "\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u6210\u529f\uff01";
    private static final String LOGGERINFO3 = "\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u5931\u8d25\uff01";
    private static final String LOGGERINFO4 = "\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01";
    private static final String LOGINUSERID = "loginUserId";
    private static final String REDIRECT = "queryTempBarByPageBean.htm?tempId=";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    @Resource(name="TempService")
    private TempService tempService;
    @Resource(name="ChannelBarService")
    private ChannelBarService channelBarService;

    @RequestMapping(value={"/queryTempBarByPageBean"})
    public ModelAndView queryTempBarByPageBean(PageBean pb, Long tempId) {
        SysTemp temp = this.tempService.getSystempById(tempId);
        return new ModelAndView("jsp/temp/temp_bar_list", "pb", (Object)this.channelBarService.selectChannelBarByParam(pb, null, tempId, null)).addObject("temp", (Object)temp);
    }

    @RequestMapping(value={"/queryTempBarByAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryTempBarByAjax(PageBean pb, Long tempId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.channelBarService.selectChannelBarByParam(pb, null, tempId, null));
        map.put("temp", this.tempService.getSystempById(tempId));
        return map;
    }

    @RequestMapping(value={"/showTempBar"})
    public ModelAndView showTempBar(Long barId, Long tempId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysTemp temp = this.tempService.getSystempById(tempId);
        map.put("temp", temp);
        if (null != barId) {
            ChannelBar channelBar = this.channelBarService.getChannelBarById(barId);
            map.put("channelBar", channelBar);
        }
        return new ModelAndView("jsp/temp/show_temp_bar", "map", map);
    }

    @RequestMapping(value={"/showtempbarbyid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ChannelBar showTempBarById(Long barId) {
        return this.channelBarService.getChannelBarById(barId);
    }

    @RequestMapping(value={"/createTempBar"})
    public ModelAndView createTempBar(HttpServletRequest request, @Valid ChannelBar channelBar, BindingResult bindingResult, Long tempId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(REDIRECT + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelBar.setInsertId(loginUserId);
            int n = this.channelBarService.saveChannelBar(channelBar);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u9875\u9762\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug(LOGGERINFO2);
            } else {
                LOGGER.debug(LOGGERINFO3);
            }
        }
        catch (Exception e) {
            LOGGER.error(LOGGERINFO4, (Throwable)e);
        }
        mav.setView((View)new RedirectView(REDIRECT + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/createTempBarAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createTempBarAjax(HttpServletRequest request, @Valid ChannelBar channelBar, BindingResult bindingResult, Long tempId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelBar.setInsertId(loginUserId);
            int n = this.channelBarService.saveChannelBar(channelBar);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u9875\u9762\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug(LOGGERINFO2);
            } else {
                LOGGER.debug(LOGGERINFO3);
            }
            return n;
        }
        catch (Exception e) {
            LOGGER.error(LOGGERINFO4, (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/updateTempBar"})
    public ModelAndView updateTempBar(HttpServletRequest request, @Valid ChannelBar channelBar, BindingResult bindingResult, Long tempId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView("showTempInfo.htm?tempId=" + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelBar.setModifyId(loginUserId);
            int n = this.channelBarService.updateChannelBar(channelBar);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9875\u9762\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug(LOGGERINFO2);
            } else {
                LOGGER.debug(LOGGERINFO3);
            }
        }
        catch (Exception e) {
            LOGGER.error(LOGGERINFO4, (Throwable)e);
        }
        mav.setView((View)new RedirectView(REDIRECT + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/updatetempbarbyajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateTempBarByAjax(HttpServletRequest request, @Valid ChannelBar channelBar, BindingResult bindingResult, Long tempId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        int n = 0;
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelBar.setModifyId(loginUserId);
            n = this.channelBarService.updateChannelBar(channelBar);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9875\u9762\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug(LOGGERINFO2);
            } else {
                LOGGER.debug(LOGGERINFO3);
            }
            return n;
        }
        catch (Exception e) {
            LOGGER.error(LOGGERINFO4, (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/deleteTempBar"})
    public void deleteTempBar(HttpServletRequest request, HttpServletResponse response) {
        String[] barIds = request.getParameterValues("barIds[]");
        for (int i = 0; i < barIds.length; ++i) {
            this.channelBarService.deleteChannelBar(Long.valueOf(barIds[i]));
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u9875\u9762\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/deleteTempBarAjxs"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void deleteTempBarAjxs(HttpServletRequest request, HttpServletResponse response, String[] barId) {
        for (int i = 0; i < barId.length; ++i) {
            this.channelBarService.deleteChannelBar(Long.valueOf(barId[i]));
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u9875\u9762\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/serveTempBarAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int serveTempBarAjax(HttpServletRequest request, HttpServletResponse resp, @RequestBody JSONObject obj) {
        int count = 0;
        int countAddChannelBar = 0;
        int countEditChannelBar = 0;
        LOGGER.info((Object)("channel bar data:" + obj.toJSONString()));
        String data = obj.toJSONString();
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        try {
            int i;
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            JSONObject json = JSON.parseObject((String)data);
            String createArr = json.getString("createArr");
            String modifyArr = json.getString("modifyArr");
            if (StringUtils.isNotEmpty((String)createArr)) {
                JSONArray createArray = JSONArray.parseArray((String)createArr);
                for (i = 0; i < createArray.size(); ++i) {
                    Long tempId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getLong("tempId");
                    String barName = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("keyword");
                    String barUrl = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("linkAddress");
                    Integer barSort = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getInteger("sort");
                    ChannelBar channelBar = new ChannelBar();
                    channelBar.setTempId(tempId);
                    channelBar.setBarName(barName);
                    channelBar.setBarUrl(barUrl);
                    channelBar.setBarSort(barSort);
                    channelBar.setOpenChannel("0");
                    channelBar.setUsedStatus("1");
                    channelBar.setInsertId(loginUserId);
                    countAddChannelBar = this.channelBarService.saveChannelBar(channelBar);
                }
            }
            if (StringUtils.isNotEmpty((String)modifyArr)) {
                JSONArray modifyArray = JSONArray.parseArray((String)modifyArr);
                for (i = 0; i < modifyArray.size(); ++i) {
                    Long barId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("id");
                    Long tempId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("tempId");
                    String barName = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("keyword");
                    String barUrl = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("linkAddress");
                    Integer barSort = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getInteger("sort");
                    ChannelBar channelBar = new ChannelBar();
                    channelBar.setBarId(barId);
                    channelBar.setTempId(tempId);
                    channelBar.setBarName(barName);
                    channelBar.setBarUrl(barUrl);
                    channelBar.setBarSort(barSort);
                    channelBar.setOpenChannel("0");
                    channelBar.setUsedStatus("1");
                    channelBar.setModifyId(loginUserId);
                    countEditChannelBar = this.channelBarService.updateChannelBar(channelBar);
                }
            }
            if (countAddChannelBar > 0 || countEditChannelBar > 0) {
                count = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error(LOGGERINFO4 + e.getMessage(), (Throwable)e);
            return count;
        }
        return count;
    }
}

