/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.goods.bean.GoodsGroup;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsGroupReleProductService;
import com.qianjiang.goods.service.GoodsGroupService;
import com.qianjiang.goods.vo.GoodsGroupVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.util.MyLogger;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class GoodsGroupController {
    private static final MyLogger LOGGER = new MyLogger(GoodsGroupController.class);
    private static final String LOGGERINFO1 = "-->\u7ec4\u5408\u540d\u79f0\u3010";
    private static final String LOGGERINFO2 = "\u3011,\u7528\u6237\u540d\uff1a";
    private static final String LOGGERINFO3 = ",\u7ec4\u5408\u540d\u79f0:";
    @Resource(name="GoodsGroupService")
    private GoodsGroupService goodsGroupService;
    @Resource(name="GoodsGroupReleProductService")
    private GoodsGroupReleProductService goodsGroupReleProductService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="GoodsCateService")
    private GoodsCateService goodsCateService;
    @Resource(name="GoodsBrandService")
    private GoodsBrandService goodsBrandService;

    @RequestMapping(value={"/findAllGroup"})
    public ModelAndView queryAllGroup(PageBean pb, GoodsGroup group, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            LOGGER.info((Object)"\u5206\u9875\u67e5\u8be2\u6240\u6709\u7684\u5546\u54c1\u7ec4\u5408");
            PageBean queryGoodsGroupByPageBeanAndSearchBean = this.goodsGroupService.queryGoodsGroupByPageBeanAndSearchBean(pb, group);
            mav.addObject("pageBean", (Object)queryGoodsGroupByPageBeanAndSearchBean);
            mav.setViewName("jsp/goods/goods_group");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5546\u54c1\u7ec4\u5408\u521d\u59cb\u5316\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/delGroup"})
    public ModelAndView delGroup(Long groupId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        String name = (String)request.getSession().getAttribute("name");
        try {
            LOGGER.info((Object)"\u5220\u9664\u5546\u54c1\u7ec4\u5408");
            this.goodsGroupService.delGoodsGroup(groupId, name);
            Long[] ids = new Long[]{groupId};
            this.goodsGroupService.deleteShoppingCartByFitIds(ids);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u7ec4\u5408\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
            mav.setView((View)new RedirectView("findAllGroup.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5220\u9664\u7ec4\u5408\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/batchDelGroup"})
    public ModelAndView batchDelGroup(Long[] groupIds, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        String name = (String)request.getSession().getAttribute("name");
        try {
            LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u7ec4\u5408");
            Long thirdId = (Long)request.getSession().getAttribute("thirdId");
            this.goodsGroupService.batchDelGroup(thirdId, groupIds, name);
            this.goodsGroupService.deleteShoppingCartByFitIds(groupIds);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u7ec4\u5408", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
            mav.setView((View)new RedirectView("findAllGroup.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6279\u91cf\u5220\u9664\u5546\u54c1\u7ec4\u5408\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/saveGroup"})
    public ModelAndView saveGroup(HttpServletRequest request, @Valid GoodsGroup goodsGroup, BindingResult resut) {
        ModelAndView mav = new ModelAndView();
        String name = (String)request.getSession().getAttribute("name");
        try {
            goodsGroup.setThirdId(Long.valueOf(0L));
            goodsGroup.setThirdName("BOSS");
            goodsGroup.setIsThird("0");
            goodsGroup.setGroupDelflag("0");
            goodsGroup.setGroupCreateTime(new Date());
            goodsGroup.setGroupCreateName(name);
            this.goodsGroupService.saveGoodsGroup(goodsGroup);
            if (null != goodsGroup.getGroupName()) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u65b0\u589e\u5546\u54c1\u7ec4\u5408", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + goodsGroup.getGroupName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
                LOGGER.info((Object)("\u4fdd\u5b58\u5546\u54c1\u7ec4\u5408,\u7ec4\u5408\u540d\u79f0:" + goodsGroup.getGroupName()));
            }
            mav.setView((View)new RedirectView("findAllGroup.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5e73\u53f0\u7aef\u6dfb\u52a0\u4e00\u4e2a\u5546\u54c1\u7ec4\u5408\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/queryGoodsGroupById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public GoodsGroup queryGoodsGroupById(Long groupId) {
        GoodsGroup queryGoodsGroupByPrimaryKey = null;
        try {
            GoodsGroup goodsGroup = this.goodsGroupService.queryGoodsGroupByPrimaryKey(groupId);
            if (null != goodsGroup.getGroupName()) {
                LOGGER.info((Object)("AJAX\u67e5\u8be2\u5546\u54c1\u7ec4\u5408\u4fe1\u606f,\u7ec4\u5408\u540d\u79f0:" + goodsGroup.getGroupName()));
            }
            queryGoodsGroupByPrimaryKey = this.goodsGroupService.queryGoodsGroupByPrimaryKey(groupId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u5546\u54c1\u7ec4\u5408\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return queryGoodsGroupByPrimaryKey;
    }

    @RequestMapping(value={"/updateGroup"})
    public ModelAndView updateGroup(@Valid GoodsGroup group, BindingResult resut, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        String name = (String)request.getSession().getAttribute("name");
        try {
            this.goodsGroupService.updateGoodsGroup(group, name);
            GoodsGroup goodsGroup = this.goodsGroupService.queryGoodsGroupByPrimaryKey(group.getGroupId());
            if (null != goodsGroup.getGroupName()) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u5546\u54c1\u7ec4\u5408", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + goodsGroup.getGroupName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
                LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u7ec4\u5408\u4fe1\u606f,\u7ec4\u5408\u540d\u79f0:" + goodsGroup.getGroupName()));
            }
            mav.setView((View)new RedirectView("findAllGroup.htm"));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u66f4\u65b0\u5546\u54c1\u7ec4\u5408\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/queryGroupByPrimaryKey"})
    public ModelAndView queryByPrimaryKey(Long groupId, HttpServletRequest req) {
        ModelAndView mav = new ModelAndView();
        try {
            GoodsGroupVo groupVo = this.goodsGroupService.queryVoByPrimaryKey(groupId);
            List oneCateList = this.goodsCateService.querySonCateByParentIdAndName(Long.valueOf(0L), null);
            List brandList = this.goodsBrandService.queryAllBrand();
            String basicAddress = this.basicSetService.findBasicSet().getBsetAddress();
            String bsetAddress = BasicSetUtil.getAddress((String)basicAddress);
            mav.addObject("groupVo", (Object)groupVo);
            mav.addObject("oneCateList", (Object)oneCateList);
            mav.addObject("brandList", (Object)brandList);
            mav.addObject("basicAddress", (Object)bsetAddress);
            mav.setViewName("jsp/goods/goods_groupProduct");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u4e3b\u952e\u67e5\u8be2\u5546\u54c1\u7ec4\u5408ID\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/delGroupReleProduct"})
    public ModelAndView delGroupReleProduct(Long groupId, Long productId, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            this.goodsGroupReleProductService.delGroupReleProductByGroupIdAndProductId(groupId, productId);
            GoodsGroup goodsGroup = this.goodsGroupService.queryGoodsGroupByPrimaryKey(groupId);
            if (null != goodsGroup.getGroupName()) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u7ec4\u5408\u5173\u8054\u7684\u8d27\u54c1\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + goodsGroup.getGroupName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
                LOGGER.info((Object)("\u5220\u9664\u7ec4\u5408\u5173\u8054\u7684\u8d27\u54c1\u4fe1\u606f,\u7ec4\u5408\u540d\u79f0:" + goodsGroup.getGroupName()));
            }
            mav.setView((View)new RedirectView("queryGroupByPrimaryKey.htm?groupId=" + groupId));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u7ec4\u5408ID\u548cproductId\u5220\u9664\u7ec4\u5408\u5173\u8054\u7684\u8d27\u54c1\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/batchDelGroupReleProduct"})
    public ModelAndView batchDelGroupReleProduct(Long groupId, Long[] productIds, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u7ec4\u5408\u5173\u8054\u7684\u8d27\u54c1\u4fe1\u606f");
            this.goodsGroupReleProductService.batchDelGroupReleProductByGroupIdAndProductIds(groupId, productIds);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u7ec4\u5408\u5173\u8054\u7684\u8d27\u54c1\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
            mav.setView((View)new RedirectView("queryGroupByPrimaryKey.htm?groupId=" + groupId));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6279\u91cf\u5220\u9664\u7ec4\u5408\u5173\u8054\u8d27\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/saveGroupReleProduct"})
    public ModelAndView saveGroupReleProduct(Long groupId, Long[] productId, Long[] num, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            this.goodsGroupReleProductService.addGroupReleProductNew(groupId, productId, num);
            GoodsGroup goodsGroup = this.goodsGroupService.queryGoodsGroupByPrimaryKey(groupId);
            if (null != goodsGroup.getGroupName()) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u4fdd\u5b58\u5546\u54c1\u7ec4\u5408\u5173\u8054\u7684\u8d27\u54c1\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + goodsGroup.getGroupName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
                LOGGER.info((Object)("\u4fdd\u5b58\u5546\u54c1\u7ec4\u5408\u5173\u8054\u7684\u8d27\u54c1\u4fe1\u606f,\u7ec4\u5408\u540d\u79f0:" + goodsGroup.getGroupName()));
            }
            mav.setView((View)new RedirectView("queryGroupByPrimaryKey.htm?groupId=" + groupId));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u7ec4\u5408ID\u548c\u8d27\u54c1ID\u6570\u7ec4\u65b0\u5efa\u5173\u8054\u5173\u7cfb\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }
}

