/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.controller;

import com.qianjiang.information.bean.InformationType;
import com.qianjiang.information.service.InformationService;
import com.qianjiang.information.service.InformationTypeService;
import com.qianjiang.information.vo.InformationTypeVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.PageBean;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class InformationTypeController {
    private InformationTypeService infoTypeService;
    private InformationService infoService;
    private static final String JUMPURL = "jumpForInfoTypeView.htm";
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    public static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    public static final String CSRFToken = "?CSRFToken=";

    @RequestMapping(value={"/delInfoType"})
    public ModelAndView delInfoType(HttpServletRequest request, Long infoTypeId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        this.infoTypeService.delInformation(infoTypeId, loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u6587\u7ae0\u680f\u76ee", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView("jumpForInfoTypeView.htm?CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/delInfoTypePro"})
    public ModelAndView delInfoTypePro(HttpServletRequest request, Long infoTypeId) {
        this.infoTypeService.delInformationPro(infoTypeId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u6587\u7ae0\u680f\u76ee", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView("jumpForInfoTypeView.htm?CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/batchDelInfoType"})
    public ModelAndView batchDelInfoType(HttpServletRequest request, Long[] infoTypeIds) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        this.infoTypeService.batchDelInformation(infoTypeIds, loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6279\u91cf\u5220\u9664\u6587\u7ae0\u680f\u76ee", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView("jumpForInfoTypeView.htm?CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/showInfoType"})
    public ModelAndView showInfo(HttpServletRequest request, HttpServletResponse response, Long infoTypeId) {
        InformationType infoType = new InformationType();
        if (null != infoTypeId) {
            infoType = this.infoTypeService.selectByPrimaryKey(infoTypeId);
        }
        List infoTypes = this.infoTypeService.selectAll();
        return new ModelAndView("jsp/information/showInfoType", "infoTypes", (Object)infoTypes).addObject("infoType", (Object)infoType);
    }

    @RequestMapping(value={"/showInfoTypeajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public InformationType showInfoajax(Long infoTypeId) {
        InformationType infoType = new InformationType();
        if (null != infoTypeId) {
            infoType = this.infoTypeService.selectByPrimaryKey(infoTypeId);
        }
        return infoType;
    }

    @RequestMapping(value={"/saveInfoType"})
    public ModelAndView saveInfoType(HttpServletRequest request, @Valid InformationType infotype, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView("jumpForInfoTypeView.htm?CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        infotype.setCreateUserId(loginUserId);
        infotype.setUpdateUserId(loginUserId);
        infotype.setTemp3("1");
        this.infoTypeService.saveInformation(infotype);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u6587\u7ae0\u680f\u76ee", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView("jumpForInfoTypeView.htm?CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateInfoType"})
    public ModelAndView updateInfoType(HttpServletRequest request, @Valid InformationType infotype, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView("jumpForInfoTypeView.htm?CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        infotype.setUpdateUserId(loginUserId);
        this.infoTypeService.updateInformation(infotype);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u6587\u7ae0\u680f\u76ee", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView("jumpForInfoTypeView.htm?CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/checkDelInfoType"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> checkDelInfoType(Long infoTypeId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean flag = false;
        flag = this.infoTypeService.checkDelWithInfoTypeId(infoTypeId);
        if (flag) {
            flag = this.infoService.checkDelInfoTypeByInfoCount(infoTypeId);
            if (flag) {
                map.put("flag", flag);
            } else {
                map.put("flag", flag);
                map.put("msg", "\u8be5\u680f\u76ee\u4e0b\u6709\u6587\u7ae0\uff0c\u5220\u9664\u5b83\u4f1a\u5220\u9664\u6240\u6709\u5173\u8054\u6587\u7ae0\uff0c\u662f\u5426\u786e\u5b9a\u5220\u9664\uff1f");
            }
        } else {
            map.put("flag", flag);
            map.put("msg", "\u8be5\u680f\u76ee\u4e0b\u6709\u5b50\u680f\u76ee\uff0c\u5220\u9664\u5b83\u4f1a\u5220\u9664\u5b50\u680f\u76ee\u53ca\u6240\u6709\u5173\u8054\u6587\u7ae0\uff0c\u662f\u5426\u786e\u5b9a\u5220\u9664\uff1f");
        }
        return map;
    }

    @RequestMapping(value={"/selectAllInfoType"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<InformationTypeVo> selectAllInfoType() {
        return this.infoTypeService.selectAll();
    }

    @RequestMapping(value={"/queryInfoTypeVoList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public PageBean queryInfoTypeVoList(PageBean pb, String searchText, String newFlag) throws UnsupportedEncodingException {
        String searchTextNew = searchText;
        if (newFlag != null) {
            searchTextNew = URLDecoder.decode(searchTextNew, "UTF-8");
            return this.infoTypeService.queryByPageBeanList(pb, searchTextNew);
        }
        return this.infoTypeService.queryByPageBean(pb, searchTextNew);
    }

    @RequestMapping(value={"/jumpForInfoTypeView"})
    public ModelAndView jumpForInfoTypeView(HttpServletRequest request) {
        return new ModelAndView("jsp/information/information_type");
    }

    @RequestMapping(value={"/checkInfoTypeName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkInfoTypeName(String name, Long infoTypeId) {
        if (null != infoTypeId) {
            return this.infoTypeService.checkAddInfoTypeByName(name, infoTypeId);
        }
        return this.infoTypeService.checkAddInfoTypeByName(name);
    }

    @RequestMapping(value={"/getInfoTypeWhenHaveInfo"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<InformationTypeVo> getInfoTypeWhenHaveInfo() {
        return this.infoTypeService.selectInfoTypeByAttrForAddInfo();
    }

    public InformationTypeService getInfoTypeService() {
        return this.infoTypeService;
    }

    @Resource(name="InformationTypeService")
    public void setInfoTypeService(InformationTypeService infoTypeService) {
        this.infoTypeService = infoTypeService;
    }

    public InformationService getInfoService() {
        return this.infoService;
    }

    @Resource(name="InformationService")
    public void setInfoService(InformationService infoService) {
        this.infoService = infoService;
    }
}

