/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.City;
import com.qianjiang.system.bean.District;
import com.qianjiang.system.bean.Province;
import com.qianjiang.system.service.CityService;
import com.qianjiang.system.service.DefaultAddressService;
import com.qianjiang.system.service.DistrictService;
import com.qianjiang.system.service.ProvinceService;
import com.qianjiang.system.service.StreetService;
import com.qianjiang.system.util.AddressUtil;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class AddressManagerController {
    private static final MyLogger LOGGER = new MyLogger(AddressManagerController.class);
    private static final String NUMBER = "^[0-9]*$";
    private static final String ISNEW = "isNew";
    private String addressManager = "jsp/system/addressManager";
    private String addressManagerNew = "jsp/system/addressManagerNew";
    private String findAllProvince = "findAllProvince.htm";
    private String findAllProvinceNew = "findAllProvinceNew.htm";
    private String addressName = "addressName";
    private String parentId = "parentId";
    private String addressId = "addressId";
    private String addressSort = "addressSort";
    private ProvinceService provinceService;
    private CityService cityService;
    private DistrictService districtService;
    private StreetService streetService;
    @Resource(name="DefaultAddressService")
    private DefaultAddressService addressService;

    @RequestMapping(value={"/batchAllAddress"})
    public ModelAndView batchAllAddress(HttpServletRequest request) {
        String[] provinceIds = request.getParameterValues("province");
        String[] cityIds = request.getParameterValues("city");
        String[] districtIds = request.getParameterValues("district");
        String[] streetIds = request.getParameterValues("street");
        this.provinceService.batchDelProvince(provinceIds);
        this.cityService.batchDelCity(cityIds);
        this.districtService.batchDelDistrict(districtIds);
        this.streetService.batchDelStreet(streetIds);
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"/findAllProvince"})
    public ModelAndView findAllProvince(PageBean pb, HttpServletRequest request, SelectBean selectBean) {
        Long defaultDistrictId = this.addressService.getDefaultIdService();
        District district = null;
        if (defaultDistrictId != null) {
            district = this.districtService.findDistrictByPrimaryKey(defaultDistrictId);
        }
        City city = null;
        if (district != null) {
            city = this.cityService.findCityByPrimaryKey(district.getCityId());
        }
        Province province = null;
        if (city != null) {
            province = this.provinceService.findProvinceByPrimaryKey(city.getProvinceId());
        }
        return new ModelAndView(this.addressManager).addObject("selectBean", (Object)selectBean).addObject("defaultProvince", (Object)province).addObject("defaultCity", (Object)city).addObject("defaultDistrict", (Object)district).addObject("pb", (Object)this.provinceService.findListByPageBean(pb, selectBean));
    }

    @RequestMapping(value={"/findAllProvinceNew"})
    public ModelAndView findAllProvinceNew(PageBean pb, HttpServletRequest request, SelectBean selectBean) {
        return new ModelAndView(this.addressManagerNew).addObject("selectBean", (Object)selectBean).addObject("pb", (Object)this.provinceService.findListByPageBeanNew(pb, selectBean));
    }

    @RequestMapping(value={"/queryAllProvince"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryAllProvince(String provinceName) {
        return this.provinceService.queryAllProvinceByName(provinceName);
    }

    @RequestMapping(value={"/saveProvince"})
    public ModelAndView saveProvince(HttpServletRequest request) {
        String provinceName = request.getParameter(this.addressName);
        String provinceSort = request.getParameter(this.addressSort);
        Matcher mat = this.checkRegExForT(provinceName);
        Matcher mat2 = this.checkRegEx(NUMBER, provinceSort);
        if (!mat.find() && mat2.find()) {
            this.provinceService.saveProvince(provinceName, provinceSort);
        }
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    private Matcher checkRegExForT(String provinceName) {
        String regEx = "[''\\[\\]<>?\\\\!]";
        Pattern pat = Pattern.compile(regEx);
        return pat.matcher(provinceName);
    }

    private Matcher checkRegEx(String regEx, String provinceName) {
        Pattern pat = Pattern.compile(regEx);
        return pat.matcher(provinceName);
    }

    @RequestMapping(value={"/delProvince"})
    public ModelAndView deleteProvince(Long provinceId) {
        if (null != provinceId) {
            LOGGER.info((Object)("\u5220\u9664\u7701\u4efd\u5b9e\u4f53\uff0c\u7701\u4efd\u7684\u540d\u79f0\u4e3a\uff1a" + this.provinceService.findProvinceByPrimaryKey(provinceId).getProvinceName()));
        }
        this.provinceService.delProvince(provinceId);
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"/updateProvince"})
    public ModelAndView updateProvince(HttpServletRequest request) {
        String provinceName = request.getParameter(this.addressName);
        String provinceId = request.getParameter(this.addressId);
        String provinceSort = request.getParameter(this.addressSort);
        Matcher mat = this.checkRegExForT(provinceName);
        Matcher mat2 = this.checkRegEx(NUMBER, provinceSort);
        if (null != provinceId) {
            LOGGER.info((Object)("\u66f4\u65b0\u7701\u4efd\u5b9e\u4f53\uff0c\u7701\u4efd\u7684\u540d\u79f0\u4e3a\uff1a" + this.provinceService.findProvinceByPrimaryKey(Long.valueOf(provinceId)).getProvinceName()));
        }
        if (!mat.find() && mat2.find()) {
            this.provinceService.updateProvince(provinceId, provinceName, provinceSort);
        }
        if (request.getParameter(ISNEW) != null) {
            return new ModelAndView((View)new RedirectView(this.findAllProvinceNew));
        }
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @ResponseBody
    @RequestMapping(value={"/searchProvinceById"}, produces={"application/json;charset=UTF-8"})
    public Province searchProvinceById(Long provinceId) {
        if (null != provinceId) {
            LOGGER.info((Object)("\u66f4\u65b0\u7701\u4efd\u5b9e\u4f53\uff0c\u7701\u4efd\u7684\u540d\u79f0\u4e3a\uff1a" + this.provinceService.findProvinceByPrimaryKey(Long.valueOf(provinceId)).getProvinceName()));
        }
        return this.provinceService.findProvinceByPrimaryKey(provinceId);
    }

    @RequestMapping(value={"/batchDelProvince"})
    public ModelAndView batchDelProvince(String[] provinceIds) {
        this.provinceService.batchDelProvince(provinceIds);
        return null;
    }

    @RequestMapping(value={"/checkProvinceName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkProvinceName(HttpServletRequest request) {
        return this.provinceService.checkProvinceName(request.getParameter("provinceName"));
    }

    @RequestMapping(value={"/findAllCity"})
    public ModelAndView findAllCity(PageBean pb, SelectBean selectBean) {
        this.cityService.findListByPageBean(pb, selectBean);
        return null;
    }

    @RequestMapping(value={"/queryCityByProvinceId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryCityByProvinceId(Long provinceId, String cityName) {
        return this.cityService.queryCityByProvinceIdAndCityName(provinceId, cityName);
    }

    @RequestMapping(value={"/saveCity"})
    public ModelAndView saveCity(HttpServletRequest request) {
        String cityName = request.getParameter(this.addressName);
        String provinceId = request.getParameter(this.parentId);
        String citySort = request.getParameter(this.addressSort);
        Matcher mat = this.checkRegExForT(cityName);
        Matcher mat2 = this.checkRegEx(NUMBER, citySort);
        if (!mat.find() && mat2.find()) {
            this.cityService.saveCity(cityName, provinceId, citySort);
        }
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"/delCity"})
    public ModelAndView delCity(Long cityId) {
        this.cityService.delPCity(cityId);
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"/batchDelCity"})
    public ModelAndView batchDelCity(String[] cityIds) {
        this.cityService.batchDelCity(cityIds);
        return null;
    }

    @RequestMapping(value={"/updateCity"})
    public ModelAndView updateCity(HttpServletRequest request) {
        String cityName = request.getParameter(this.addressName);
        String cityId = request.getParameter(this.addressId);
        String citySort = request.getParameter(this.addressSort);
        Matcher mat = this.checkRegExForT(cityName);
        Matcher mat2 = this.checkRegEx(NUMBER, citySort);
        if (!mat.find() && mat2.find()) {
            this.cityService.updateCity(cityId, cityName, citySort);
        }
        if (request.getParameter(ISNEW) != null) {
            return new ModelAndView((View)new RedirectView(this.findAllProvinceNew));
        }
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"/queryCityByPrimaryKey"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public City queryCityByPrimaryKey(Long cityId) {
        return this.cityService.findCityByPrimaryKey(cityId);
    }

    @RequestMapping(value={"/checkCityName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkCityName(HttpServletRequest request) {
        return this.cityService.checkCityName(request.getParameter("cityName"));
    }

    @RequestMapping(value={"/queryAddressUtilByCityId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public AddressUtil queryAddressUtilByCityId(Long cityId) {
        return this.cityService.queryAddressNameByCityId(cityId);
    }

    @RequestMapping(value={"/findAllDistrict"})
    public ModelAndView findAllDistrict(PageBean pb, SelectBean selectBean) {
        this.districtService.findListByPageBean(pb, selectBean);
        return null;
    }

    @RequestMapping(value={"/queryDistrictByCityId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryDistrictByCityId(Long cityId, String districtName) {
        return this.districtService.queryDistrictByCityIdAndDistName(cityId, districtName);
    }

    @RequestMapping(value={"/saveDistrict"})
    public ModelAndView saveDistrict(HttpServletRequest request) {
        String districtName = request.getParameter(this.addressName);
        String districtSort = request.getParameter(this.addressSort);
        String cityId = request.getParameter(this.parentId);
        Matcher mat = this.checkRegExForT(districtName);
        Matcher mat2 = this.checkRegEx(NUMBER, districtSort);
        if (!mat.find() && mat2.find()) {
            this.districtService.saveDistrict(districtName, cityId, districtSort);
        }
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"/delDistrict"})
    public ModelAndView delDistrict(Long districtId) {
        this.districtService.delDistrict(districtId);
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"/batchDelDistrict"})
    public ModelAndView batchDelDistrict(String[] districtIds) {
        this.districtService.batchDelDistrict(districtIds);
        return null;
    }

    @RequestMapping(value={"/updateDistrict"})
    public ModelAndView updateDistrict(HttpServletRequest request) {
        String districtName = request.getParameter(this.addressName);
        String districtId = request.getParameter(this.addressId);
        String distrcitSort = request.getParameter(this.addressSort);
        Matcher mat = this.checkRegExForT(districtName);
        Matcher mat2 = this.checkRegEx(NUMBER, distrcitSort);
        if (!mat.find() && mat2.find()) {
            this.districtService.updateDistrict(districtId, districtName, distrcitSort);
        }
        if (request.getParameter(ISNEW) != null) {
            return new ModelAndView((View)new RedirectView(this.findAllProvinceNew));
        }
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"/checkDistrictName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkDistrictName(HttpServletRequest request) {
        return this.districtService.checkDistrictName(request.getParameter("districtName"));
    }

    @RequestMapping(value={"/queryAddressNameByDistrictId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public AddressUtil queryAddressNameByDistrictId(Long districtId) {
        return this.districtService.queryAddressNameByDistrictId(districtId);
    }

    @RequestMapping(value={"/findAllStreet"})
    public ModelAndView findAllStreet(PageBean pb, SelectBean selectBean) {
        this.streetService.findListByPageBean(pb, selectBean);
        return null;
    }

    @RequestMapping(value={"queryStreetByDistrictId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryStreetByDistrictId(Long districtId, String streetName) {
        return this.streetService.queryStreetByDistrictIdAndStreetName(districtId, streetName);
    }

    @RequestMapping(value={"/saveStreet"})
    public ModelAndView saveStreet(HttpServletRequest request) {
        String streetName = request.getParameter(this.addressName);
        String districtId = request.getParameter(this.parentId);
        String streetSort = request.getParameter(this.addressSort);
        Matcher mat = this.checkRegExForT(streetName);
        Matcher mat2 = this.checkRegEx(NUMBER, streetSort);
        if (!mat.find() && mat2.find()) {
            this.streetService.saveStreet(streetName, districtId, streetSort);
        }
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"delStreet"})
    public ModelAndView delStreet(Long streetId) {
        this.streetService.delStreet(streetId);
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"/batchDelStreet"})
    public ModelAndView batchDelStreet(String[] streetIds) {
        this.streetService.batchDelStreet(streetIds);
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"/updateStreet"})
    public ModelAndView updateStreet(HttpServletRequest request) {
        String streetName = request.getParameter(this.addressName);
        String streetId = request.getParameter(this.addressId);
        String streetSort = request.getParameter(this.addressSort);
        Matcher mat = this.checkRegExForT(streetName);
        Matcher mat2 = this.checkRegEx(NUMBER, streetSort);
        if (!mat.find() && mat2.find()) {
            this.streetService.updateStreet(streetId, streetName, streetSort);
        }
        if (request.getParameter(ISNEW) != null) {
            return new ModelAndView((View)new RedirectView(this.findAllProvinceNew));
        }
        return new ModelAndView((View)new RedirectView(this.findAllProvince));
    }

    @RequestMapping(value={"/checkStreetName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkStreetName(HttpServletRequest request) {
        return this.streetService.checkStreetName(request.getParameter("streetName"));
    }

    @RequestMapping(value={"/queryAddressNameByStreetId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public AddressUtil queryAddressNameByStreetId(Long streetId) {
        return this.streetService.queryAddressNameByStreetId(streetId);
    }

    @RequestMapping(value={"/setthedefault"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int setTheDefault(Long districtId) {
        return this.addressService.insertAddressDefaultService(districtId);
    }

    @RequestMapping(value={"/ajaxqueryprovincename"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int queryProvinceNameCount(String provinceName) {
        return this.provinceService.queryProvinceNameCount(provinceName);
    }

    @RequestMapping(value={"/ajaxquerycityname"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int queryCityNameCount(String cityName, Long provinceId) {
        City city = new City();
        city.setCityName(cityName);
        city.setProvinceId(Long.valueOf(provinceId));
        return this.cityService.queryCityNameCount(city);
    }

    @RequestMapping(value={"/ajaxquerydistrictname"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int queryDistrictNameCount(Long cityId, String districtName) {
        District district = new District();
        district.setCityId(Long.valueOf(cityId));
        district.setDistrictName(districtName);
        return this.districtService.queryDistrictNameCount(district);
    }

    public ProvinceService getProvinceService() {
        return this.provinceService;
    }

    @Resource(name="ProvinceService")
    public void setProvinceService(ProvinceService provinceService) {
        this.provinceService = provinceService;
    }

    public CityService getCityService() {
        return this.cityService;
    }

    @Resource(name="CityService")
    public void setCityService(CityService cityService) {
        this.cityService = cityService;
    }

    public DistrictService getDistrictService() {
        return this.districtService;
    }

    @Resource(name="DistrictService")
    public void setDistrictService(DistrictService districtService) {
        this.districtService = districtService;
    }

    public StreetService getStreetService() {
        return this.streetService;
    }

    @Resource(name="StreetService")
    public void setStreetService(StreetService streetService) {
        this.streetService = streetService;
    }
}

