/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.controller;

import com.qianjiang.customer.bean.DepositInfo;
import com.qianjiang.customer.service.DepositInfoService;
import com.qianjiang.customer.service.TradeInfoService;
import com.qianjiang.customer.util.DateUtil;
import com.qianjiang.customer.vo.DepositInfoVo;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DepositInfoController {
    private static final String PAGEBEAN = "pageBean";
    public static final MyLogger LOGGER = new MyLogger(DepositInfoController.class);
    @Autowired
    private DepositInfoService depositInfoService;
    @Autowired
    private TradeInfoService tradeInfoService;

    @RequestMapping(value={"/initDepositInfoList"})
    public ModelAndView selectDepositInfoList(HttpServletRequest request, DepositInfoVo depositInfo, PageBean pageBean) {
        Map result = null;
        try {
            result = this.depositInfoService.selectTotalDesposit();
            pageBean.setUrl("initDepositInfoList.htm");
            LOGGER.info((Object)"\u67e5\u8be2\u4f1a\u5458\u8d44\u91d1\uff01");
            pageBean = this.depositInfoService.selectDepositInfoList(depositInfo, pageBean);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
        }
        return new ModelAndView("jsp/customer/depositInfoList", PAGEBEAN, (Object)pageBean).addObject("result", (Object)result);
    }

    @RequestMapping(value={"/selectDepositInfoById"})
    public ModelAndView selectDepositInfoById(HttpServletRequest request, DepositInfoVo depositInfoVo, PageBean pageBean) {
        Long customerId = depositInfoVo.getCustomerId();
        String startTime = null;
        String endTime = null;
        DepositInfo depositInfo = null;
        try {
            SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            startTime = request.getParameter("startTime");
            endTime = request.getParameter("endTime");
            depositInfoVo.setStartDate(startTime == null || "".equals(startTime) ? null : formatDate.parse(startTime));
            depositInfoVo.setEndDate(endTime == null || "".equals(endTime) ? null : DateUtil.getLastTime((Date)formatDate.parse(endTime)));
            depositInfo = this.depositInfoService.selectDepositInfoById(customerId);
            pageBean = this.tradeInfoService.selectTradeInfoList(depositInfoVo, pageBean);
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u770b\u4f1a\u5458\u8d44\u91d1\u660e\u7ec6\uff1a", (Throwable)e);
        }
        return new ModelAndView("jsp/customer/depositInfo_customer", PAGEBEAN, (Object)pageBean).addObject("depositInfo", depositInfo).addObject("pageNo", (Object)pageBean.getPageNo()).addObject("startTime", (Object)startTime).addObject("endTime", (Object)endTime);
    }

    @RequestMapping(value={"/selectDepositInfoDetail"})
    public ModelAndView selectDepositInfoDetail(HttpServletRequest request, DepositInfoVo depositInfoVo, PageBean pageBean) {
        Map result = null;
        String startTime = null;
        String endTime = null;
        try {
            SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            startTime = request.getParameter("startTime");
            endTime = request.getParameter("endTime");
            depositInfoVo.setStartDate(startTime == null || "".equals(startTime) ? null : formatDate.parse(startTime));
            depositInfoVo.setEndDate(endTime == null || "".equals(endTime) ? null : DateUtil.getLastTime((Date)formatDate.parse(endTime)));
            result = this.depositInfoService.selectTotalDesposit();
            pageBean.setUrl("selectDepositInfoDetail.htm");
            LOGGER.info((Object)"\u67e5\u8be2\u9884\u5b58\u6b3e\u660e\u7ec6\uff01");
            pageBean = this.tradeInfoService.selectTradeInfoList(depositInfoVo, pageBean);
        }
        catch (Exception e) {
            LOGGER.error("\u9884\u5b58\u6b3e\u660e\u7ec6:", (Throwable)e);
        }
        return new ModelAndView("jsp/customer/depositInfo_detail", PAGEBEAN, (Object)pageBean).addObject("result", result).addObject("startTime", (Object)startTime).addObject("endTime", (Object)endTime);
    }
}

