/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.feedback.controller;

import com.qianjiang.feedback.bean.Feedback;
import com.qianjiang.feedback.service.FeedBackService;
import com.qianjiang.util.DateUtils;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class FeedbackManagerController {
    private static final MyLogger logger = new MyLogger(FeedbackManagerController.class);
    @Autowired
    private FeedBackService feedBackService;

    @RequestMapping(value={"/toFeedbackManagerPages"})
    public ModelAndView toFeedbackPages(HttpServletRequest request, ModelMap modelMap, PageBean page, Feedback feedback) {
        ModelAndView view = new ModelAndView("jsp/feedbackManager/feedbackManagerList");
        if (null != feedback && feedback.getStatus() == null) {
            feedback.setStatus(Integer.valueOf(0));
        }
        PageBean pageBean = this.feedBackService.queryFeedBackByPage(page, feedback);
        modelMap.put((Object)"page", (Object)pageBean);
        modelMap.put((Object)"status", (Object)feedback.getStatus());
        return view;
    }

    @RequestMapping(value={"/updateFeedback"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String updateFeedback(HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("status", "0");
        try {
            String id = request.getParameter("id");
            String replyContent = request.getParameter("replyContent");
            if (!StringUtils.isEmpty((String)id) && !StringUtils.isEmpty((String)replyContent)) {
                Feedback upFeedback = new Feedback();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String nowDate = DateUtils.getTodayDate((SimpleDateFormat)format);
                upFeedback.setReplyTime(format.parse(nowDate));
                upFeedback.setId(Long.valueOf(id));
                upFeedback.setReplyContent(replyContent);
                upFeedback.setStatus(Integer.valueOf(1));
                if (this.feedBackService.updateFeedBack(upFeedback)) {
                    result.put("status", "1");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u56de\u590d\u610f\u89c1\u53cd\u9988\u5f02\u5e38", (Throwable)e);
        }
        return JsonUtil.buildNonDefaultBinder().toJson(result);
    }
}

