/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goodsCommon.controller;

import com.qianjiang.comment.bean.Comment;
import com.qianjiang.comment.service.CommentServiceMapper;
import com.qianjiang.goods.service.BrowserecordService;
import com.qianjiang.order.service.OrderService;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GoodsManagerController {
    @Resource(name="commentServiceMapper")
    private CommentServiceMapper commentServiceMapper;
    @Resource(name="browserecordServiceMix")
    private BrowserecordService browserecordService;
    @Resource(name="OrderService")
    private OrderService orderService;

    @RequestMapping(value={"/queryGoodsManagerComment"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int queryGoodsManagerComment(Long goodsId, Character commentType, String paramString) {
        return this.commentServiceMapper.queryCommentCountByType(goodsId, commentType, paramString);
    }

    @RequestMapping(value={"/queryCustomerConsult"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long queryCustomerConsult(Long goodsId) {
        Comment comment = new Comment();
        comment.setGoodsId(goodsId);
        return this.commentServiceMapper.queryConsultCount(comment);
    }

    @RequestMapping(value={"/queryGoodsManagerBrowseRecord"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int selectBrowserecordCountByGoodsId(Long goodsId) {
        return this.browserecordService.selectBrowserecordCountByGoodsId(goodsId);
    }

    @RequestMapping(value={"/queryGoodsBuyRecord"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int queryGoodsBuyRecord(Long goodsId) {
        return this.orderService.queryGoodsBuyRecordCount(goodsId);
    }

    @RequestMapping(value={"/queryGoodsBuyTotalLately"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long queryGoodsBuyTotalLately(Long goodsId) {
        return this.orderService.queryGoodsBuyTotalWeek(goodsId);
    }

    @RequestMapping(value={"/queryGoodsBrowserTotalLately"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int queryGoodsBrowserTotalLately(Long goodsId) {
        return this.browserecordService.selectBrowserecordWeek(goodsId);
    }
}

