/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.mobile.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.mobile.bean.MobSiteBasic;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class MobSiteBasicController {
    @Resource(name="MobSiteBasicService")
    private MobSiteBasicService mobSiteBasicService;
    private static final String NAME = "name";
    private static final String OPERAPATH = "operaPath";
    private static final Logger LOGGER = Logger.getLogger(MobSiteBasicController.class);

    @RequestMapping(value={"/showMobSiteBasic"})
    public ModelAndView showMobSiteBasic(HttpServletRequest request) {
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        return new ModelAndView("jsp/mobile/show_site_basic", "mobSiteBasic", (Object)this.mobSiteBasicService.selectCurrMobSiteBasic(basePath));
    }

    @RequestMapping(value={"/updateMobSiteBasic"})
    public ModelAndView updateMobSiteBasic(@Valid MobSiteBasic mobSiteBasic, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            LOGGER.debug((Object)"\u4fee\u6539\u79fb\u52a8\u7248\u7ad9\u70b9\u57fa\u7840\u8bbe\u7f6e\u5c5e\u6027\u9519\u8bef");
            throw new RuntimeException("\u4fee\u6539\u79fb\u52a8\u7248\u7ad9\u70b9\u57fa\u7840\u8bbe\u7f6e\u5c5e\u6027\u9519\u8bef");
        }
        this.mobSiteBasicService.updateMobSiteBasic(mobSiteBasic);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u79fb\u52a8\u7248\u7ad9\u70b9\u57fa\u7840\u8bbe\u7f6e", (String)(null == request.getSession().getAttribute(OPERAPATH) ? "" : request.getSession().getAttribute(OPERAPATH).toString()));
        return new ModelAndView((View)new RedirectView("showMobSiteBasic.htm"));
    }

    @RequestMapping(value={"/ajaxQueryMobSiteBasic"})
    @ResponseBody
    public Map<String, String> ajaxQueryMobSiteBasic(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        MobSiteBasic msb = this.mobSiteBasicService.selectCurrMobSiteBasic(basePath);
        map.put("logo", msb.getTemp1());
        map.put("title", msb.getName());
        map.put("shareTimelineDesc", msb.getTemp3());
        map.put("sendAppMessageDesc", msb.getTemp4());
        return map;
    }
}

