/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.temp.controller;

import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.channel.service.GoodsCateService;
import com.qianjiang.goods.bean.GoodsBrand;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class TempStoreyController {
    private static final MyLogger LOGGER = new MyLogger(TempStoreyController.class);
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String REDIRECT = "queryTempStoreyByPageBean.htm?tempId=";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private static final String LOGGERINFO2 = "\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u6210\u529f\uff01";
    private static final String LOGGERINFO3 = "\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u5931\u8d25\uff01";
    private static final String LOGGERINFO4 = "\u4fdd\u5b58\u697c\u5c42\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01";
    private static final String LOGGERINFO5 = "\u5220\u9664\u6a21\u677f\u697c\u5c42";
    @Resource(name="InfoImageManageService")
    private InfoImageManageService infoImageManageService;
    @Resource(name="ChannelGoodsCateService")
    private GoodsCateService goodsCateService;
    @Resource(name="GoodsBrandService")
    private GoodsBrandService goodsBrandService;
    @Resource(name="TempService")
    private TempService tempService;
    @Resource(name="ChannelStoreyService")
    private ChannelStoreyService storeyService;

    @RequestMapping(value={"/queryTempStoreyByPageBean"})
    public ModelAndView queryTempStoreyByPageBean(PageBean pb, Long tempId) {
        SysTemp temp = this.tempService.getSystempById(tempId);
        return new ModelAndView("jsp/temp/temp_storey_list", "pb", (Object)this.storeyService.selectchannelStoreyByParam(pb, null, tempId, null)).addObject("temp", (Object)temp);
    }

    @RequestMapping(value={"/querytempstoreybypagebeanajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryTempStoreyByPageBeanAjax(PageBean pb, Long tempId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.storeyService.selectchannelStoreyByParam(pb, null, tempId, null));
        map.put("goodsCate", this.goodsCateService.queryAllFirstGradeGoosCate());
        return map;
    }

    @RequestMapping(value={"/showTempStorey"})
    public ModelAndView showTempStorey(Long storeyId, Long tempId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SysTemp temp = this.tempService.getSystempById(tempId);
        map.put("temp", temp);
        List goodsCates = this.goodsCateService.queryAllFirstGradeGoosCate();
        map.put("goodsCates", goodsCates);
        if (null != storeyId) {
            ChannelStorey channelStorey = this.storeyService.getChannelStoreyById(storeyId);
            map.put("channelStorey", channelStorey);
        }
        return new ModelAndView("jsp/temp/show_temp_storey", "map", map);
    }

    @RequestMapping(value={"/showtempstoreynew"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ChannelStorey showTempStoreyNew(Long storeyId, Long tempId) {
        return this.storeyService.getChannelStoreyById(storeyId);
    }

    @RequestMapping(value={"/createTempStorey"})
    public ModelAndView createTempStorey(MultipartHttpServletRequest request, HttpServletResponse response, @Valid ChannelStorey channelStorey, BindingResult bindingResult, Long tempId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(REDIRECT + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            MultipartFile file2;
            MultipartFile file = request.getFile("netLogo");
            if (file.getSize() != 0L) {
                channelStorey.setStoreyImg(UploadUtil.uploadFileOne((MultipartFile)file, (HttpServletRequest)request));
                this.infoImageManageService.saveImage(channelStorey.getStoreyImg());
            }
            if (null != (file2 = request.getFile("netLogo_temp2")) && file2.getSize() != 0L) {
                channelStorey.setTemp2(UploadUtil.uploadFileOne((MultipartFile)file2, (HttpServletRequest)request));
                this.infoImageManageService.saveImage(channelStorey.getTemp2());
            }
            channelStorey.setTempId(tempId);
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelStorey.setCreateUserId(loginUserId);
            int n = this.storeyService.saveChannelStorey(channelStorey);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u6a21\u677f\u697c\u5c42", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug(LOGGERINFO2);
            } else {
                LOGGER.debug(LOGGERINFO3);
            }
        }
        catch (Exception e) {
            LOGGER.error(LOGGERINFO4, (Throwable)e);
        }
        mav.setView((View)new RedirectView(REDIRECT + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/createtempstoreyajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createTempStoreyAjax(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStorey channelStorey, BindingResult bindingResult, Long tempId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        channelStorey.setTempId(tempId);
        channelStorey.setCreateUserId(loginUserId);
        int n = this.storeyService.saveChannelStorey(channelStorey);
        if (n > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u6a21\u677f\u697c\u5c42", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            LOGGER.debug(LOGGERINFO2);
        } else {
            LOGGER.debug(LOGGERINFO3);
        }
        return n;
    }

    @RequestMapping(value={"/addTempStoreyAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long addTempStorey(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStorey channelStorey, BindingResult bindingResult, Long tempId) {
        Long channelStoreyId = null;
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        String customerName = (String)request.getSession().getAttribute(NAME);
        try {
            if (bindingResult.hasErrors()) {
                return null;
            }
            channelStorey.setTempId(tempId);
            channelStorey.setUserStatus("1");
            channelStorey.setCreateUserId(loginUserId);
            int n = this.storeyService.saveChannelStorey(channelStorey);
            if (n > 0) {
                channelStoreyId = channelStorey.getChannelStoreyId();
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u6a21\u677f\u697c\u5c42", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.info((Object)LOGGERINFO2);
            } else {
                LOGGER.info((Object)LOGGERINFO3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6dfb\u52a0\u697c\u5c42\u5e7f\u544a\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return channelStoreyId;
    }

    @RequestMapping(value={"/updatetempstoreyajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updatetempstoreyajax(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStorey channelStorey, BindingResult bindingResult, Long tempId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        channelStorey.setTempId(tempId);
        channelStorey.setUpdateUserId(loginUserId);
        int n = this.storeyService.updateChannelStorey(channelStorey);
        if (n > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u6a21\u677f\u697c\u5c42", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            LOGGER.debug("\u4fee\u6539\u697c\u5c42\u8bbe\u7f6e\u6210\u529f\uff01");
        } else {
            LOGGER.debug("\u4fee\u6539\u697c\u5c42\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return n;
    }

    @RequestMapping(value={"/updateTempStorey"})
    public ModelAndView updateTempStorey(MultipartHttpServletRequest request, HttpServletResponse response, @Valid ChannelStorey channelStorey, BindingResult bindingResult, Long tempId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(REDIRECT + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            MultipartFile file2;
            MultipartFile file = request.getFile("netLogo");
            if (file.getSize() != 0L) {
                channelStorey.setStoreyImg(UploadUtil.uploadFileOne((MultipartFile)file, (HttpServletRequest)request));
                this.infoImageManageService.saveImage(channelStorey.getStoreyImg());
            }
            if (null != (file2 = request.getFile("netLogo_temp2")) && file2.getSize() != 0L) {
                channelStorey.setTemp2(UploadUtil.uploadFileOne((MultipartFile)file2, (HttpServletRequest)request));
                this.infoImageManageService.saveImage(channelStorey.getTemp2());
            }
            channelStorey.setTempId(tempId);
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelStorey.setUpdateUserId(loginUserId);
            int n = this.storeyService.updateChannelStorey(channelStorey);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u6a21\u677f\u697c\u5c42", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug(LOGGERINFO2);
            } else {
                LOGGER.debug(LOGGERINFO3);
            }
        }
        catch (Exception e) {
            LOGGER.error(LOGGERINFO4, (Throwable)e);
        }
        mav.setView((View)new RedirectView(REDIRECT + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/deleteTempStorey"})
    public void deleteTempStorey(HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        String[] storeyIds = request.getParameterValues("storeyIds[]");
        for (int i = 0; i < storeyIds.length; ++i) {
            this.storeyService.deleteChannelStorey(Long.valueOf(storeyIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)LOGGERINFO5, (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/deletetempstoreyajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void deleteTempStoreyAjax(HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        String[] storeyIds = request.getParameterValues("storeyId");
        for (int i = 0; i < storeyIds.length; ++i) {
            this.storeyService.deleteChannelStorey(Long.valueOf(storeyIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)LOGGERINFO5, (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/deleteTempStoreyPro"})
    public void deleteTempStoreyPro(HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        String[] storeyIds = request.getParameterValues("storeyIds[]");
        for (int i = 0; i < storeyIds.length; ++i) {
            this.storeyService.deleteByPrimaryKeyCallPro(Long.valueOf(storeyIds[i]));
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)LOGGERINFO5, (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/queryGoodsBrand"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<GoodsBrand> queryGoodsBrand(HttpServletRequest req, HttpServletResponse resp) {
        ArrayList<GoodsBrand> goodsBrands = new ArrayList();
        try {
            goodsBrands = this.goodsBrandService.queryAllBrand();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5546\u54c1\u54c1\u724c\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return goodsBrands;
    }

    @RequestMapping(value={"/queryTempStorey"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryTempStorey(HttpServletRequest req, HttpServletResponse resp, Long storeyId) {
        HashMap<String, Object> resultMap = new HashMap();
        try {
            resultMap = this.storeyService.queryTempStore(storeyId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u4e3b\u952e\u548c\u6a21\u677fid\u67e5\u8be2\u697c\u5c42\u4fe1\u606f" + e.getMessage(), (Throwable)e);
        }
        return resultMap;
    }

    @RequestMapping(value={"/serveTempStoreyAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int serveTempStoreyAjax(HttpServletRequest request, HttpServletResponse response, @RequestBody Map<String, Object> obj) {
        int count = 0;
        try {
            Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
            count = this.storeyService.operateTempStoreyAjax(loginUserId, obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u64cd\u4f5c\u6a21\u677f\u697c\u5c42\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return count;
    }

    @RequestMapping(value={"/delTempStorey"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delTempStorey(HttpServletRequest request, HttpServletResponse response, Long storeyId) {
        int count = 0;
        try {
            Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
            count = this.storeyService.deleteTempStorey(loginUserId, storeyId);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5220\u9664\u697c\u5c42\u64cd\u4f5c\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return count;
    }
}

