/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.controller;

import com.qianjiang.customer.bean.CustomerConsume;
import com.qianjiang.customer.service.CustomerConsumeServiceMapper;
import com.qianjiang.customer.util.DateUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class CustomerConsumeController {
    private static final MyLogger LOGGER = new MyLogger(CustomerConsumeController.class);
    private static final String REDIRECT = "querycustomerconsume.htm";
    private CustomerConsumeServiceMapper customerConsumeServiceMapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/querycustomerconsume"})
    public ModelAndView queryCustomerConsume(@Valid CustomerConsume consume, PageBean pageBean, String createTimeF, String createTimeT, String showFlag, String[] attr) throws ParseException {
        pageBean.setUrl(REDIRECT);
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            consume.setCreateTime(createTimeF == null || "".equals(createTimeF) ? null : formatDate.parse(createTimeF));
            consume.setCreateTimeTo(createTimeT == null || "".equals(createTimeT) ? null : DateUtil.getLastTime((Date)formatDate.parse(createTimeT)));
            resultMap.put("pageBean", this.customerConsumeServiceMapper.selectCustConsumeByCustConsume(consume, pageBean, "1"));
            resultMap.put("showFlag", showFlag);
            resultMap.put("attr", attr);
            resultMap.put("consume", consume);
            ModelAndView modelAndView = new ModelAndView("jsp/customer/customerconsume").addAllObjects(resultMap);
            return modelAndView;
        }
        finally {
            formatDate = null;
            resultMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/deletecustomerconsume"})
    public ModelAndView deleteCustomerConsume(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            pr.print(this.customerConsumeServiceMapper.deleteCustomerConsume(request.getParameterValues("parameterIds[]")));
        }
        finally {
            LOGGER.debug("\u5220\u9664\u4f1a\u5458\u6d88\u8d39\u8bb0\u5f55!");
            pr = null;
        }
        return null;
    }

    @RequestMapping(value={"/deletenewcustomerconsume"})
    public ModelAndView deleteNewCustomerConsume(HttpServletRequest request, HttpServletResponse response, Long balanceId) throws IOException {
        String[] balanceIds = new String[]{"" + balanceId + ""};
        this.customerConsumeServiceMapper.deleteCustomerConsume(balanceIds);
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/deleteallnewcustomerconsume"})
    public ModelAndView deleteAllNewCustomerConsume(HttpServletRequest request, HttpServletResponse response, Long[] balanceId, int delFlag) throws IOException {
        String[] balanceIds = request.getParameterValues("balanceId");
        this.customerConsumeServiceMapper.deleteCustomerConsume(balanceIds);
        if (delFlag == 2) {
            return new ModelAndView((View)new RedirectView("initrecharge.htm"));
        }
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    public CustomerConsumeServiceMapper getCustomerConsumeServiceMapper() {
        return this.customerConsumeServiceMapper;
    }

    @Resource(name="customerConsumeServiceMapper")
    public void setCustomerConsumeServiceMapper(CustomerConsumeServiceMapper customerConsumeServiceMapper) {
        this.customerConsumeServiceMapper = customerConsumeServiceMapper;
    }
}

