/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.AuthCheckConf;
import com.qianjiang.system.cache.IDictionarysCache;
import com.qianjiang.system.controller.BaseController;
import com.qianjiang.system.service.IAuthCheckConfBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.Date;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="authCheckConfController")
public class AuthCheckConfController
extends BaseController {
    private static final MyLogger LOGGER = new MyLogger(AuthCheckConfController.class);
    private AuthCheckConf authCheckConf;
    private IAuthCheckConfBiz authCheckConfBizImpl;
    private static final String[] DICTIONARYS_LIST = new String[0];
    private IDictionarysCache dictionarysCache;
    private static final String INIT_AUTHCHECKCONF = "initAuthCheckConf.htm";
    private static final String ADD_AUTHCHECKCONF_JSP = "jsp/system/check/authcheckconf_add";
    private static final String AUTHCHECKCONF_LIST_JSP = "jsp/system/check/authcheckconf_list";
    private static final String UPDATE_AUTHCHECKCONF_JSP = "jsp/system/check/authcheckconf_update";
    private static final String READ_AUTHCHECKCONF_JSP = "jsp/system/check/authcheckconf_read";
    private static final String DELETESTATUS = "deleteStatus";
    private static final String MSG = "msg";
    private static final String AUTHCHECKCONF = "authCheckConf";
    private static final String IDS = "ids";
    private static final String TITLE = "title";
    private static final String SETCODE = "setCode";

    @RequestMapping(value={"/initAuthCheckConf"})
    public ModelAndView initAuthCheckConf(PageBean pageBean, @RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, HttpServletRequest request) {
        pageBean.setUrl(INIT_AUTHCHECKCONF);
        ModelAndView mav = new ModelAndView();
        mav.setViewName(AUTHCHECKCONF_LIST_JSP);
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, deleteStatus);
        mav.addObject("pageBean", (Object)this.authCheckConfBizImpl.getAuthCheckConfByField(pa, pageBean));
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        mav.addObject(MSG, request.getAttribute(MSG));
        mav.addObject(MSG, (Object)request.getParameter(MSG));
        mav.addObject("deleteObjectSize", (Object)this.getDeleteObjectSize());
        return mav;
    }

    private int getDeleteObjectSize() {
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(DELETESTATUS, 1);
        try {
            return this.authCheckConfBizImpl.getAuthCheckConfByFieldTotal(pa);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u5f97\u5220\u9664\u5bf9\u8c61\u7684\u6570\u91cf\u5f02\u5e38\uff01", (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/openAddAuthCheckConfPage"})
    public final ModelAndView openAddAuthCheckConfPage(HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName(ADD_AUTHCHECKCONF_JSP);
        this.fullDictionarys(mav);
        return mav;
    }

    @RequestMapping(value={"/addAuthCheckConf"})
    public ModelAndView addAuthCheckConf(AuthCheckConf authCheckConf, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            authCheckConf.setInsertDate(new Date());
            authCheckConf.setInsertId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            authCheckConf.setDeleteStatus(0);
            boolean flag = this.authCheckConfBizImpl.saveAuthCheckConf(authCheckConf);
            if (!flag) {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58\u9a8c\u8bc1\u8bbe\u7f6e\u5931\u8d25\uff01");
                return this.backAddPage(authCheckConf, mav);
            }
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u9a8c\u8bc1\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_AUTHCHECKCONF));
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9a8c\u8bc1\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u9a8c\u8bc1\u8bbe\u7f6e\u5931\u8d25\uff01");
            return this.backAddPage(authCheckConf, mav);
        }
        return mav;
    }

    private ModelAndView backAddPage(AuthCheckConf authCheckConf, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(AUTHCHECKCONF, (Object)authCheckConf);
        mav.setViewName(ADD_AUTHCHECKCONF_JSP);
        return mav;
    }

    @RequestMapping(value={"/openUpdateAuthCheckConfPage"})
    public ModelAndView openUpdateAuthCheckConfPage(@RequestParam(value="id") Integer id) {
        ModelAndView mav = new ModelAndView();
        try {
            this.fullDictionarys(mav);
            mav.addObject(AUTHCHECKCONF, (Object)this.authCheckConfBizImpl.getAuthCheckConfById(id.intValue()));
            mav.setViewName(UPDATE_AUTHCHECKCONF_JSP);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u9a8c\u8bc1\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u52a0\u8f7d\u9a8c\u8bc1\u8bbe\u7f6e\u5bf9\u8c61\u5931\u8d25\uff01");
            mav.setView((View)new RedirectView(INIT_AUTHCHECKCONF));
            return mav;
        }
        return mav;
    }

    @RequestMapping(value={"/updateAuthCheckConf"})
    public ModelAndView updateAuthCheckConf(AuthCheckConf authCheckConf, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            authCheckConf.setModifyDate(new Date());
            authCheckConf.setModifyId(((Long)request.getSession().getAttribute("loginUserId")).intValue());
            if (this.authCheckConfBizImpl.updateAuthCheckConf(authCheckConf) < 1) {
                mav.addObject(MSG, (Object)"\u4fee\u6539\u9a8c\u8bc1\u8bbe\u7f6e\u5931\u8d25\uff01");
                return this.backUpdatePage(authCheckConf, mav);
            }
            mav.addObject(MSG, (Object)"\u4fee\u6539\u9a8c\u8bc1\u8bbe\u7f6e\u6210\u529f\uff01");
            mav.setView((View)new RedirectView(INIT_AUTHCHECKCONF));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u9a8c\u8bc1\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fee\u6539\u9a8c\u8bc1\u8bbe\u7f6e\u5931\u8d25\uff01");
            return this.backUpdatePage(authCheckConf, mav);
        }
        return mav;
    }

    private ModelAndView backUpdatePage(AuthCheckConf authCheckConf, ModelAndView mav) {
        this.fullDictionarys(mav);
        mav.addObject(AUTHCHECKCONF, (Object)authCheckConf);
        mav.setViewName(UPDATE_AUTHCHECKCONF_JSP);
        return mav;
    }

    @RequestMapping(value={"/readAuthCheckConf"})
    public ModelAndView readAuthCheckConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="id") Integer id) {
        ModelAndView mav = new ModelAndView();
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        if (id == 0) {
            mav.addObject(MSG, (Object)"\u9a8c\u8bc1\u8bbe\u7f6e\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\uff01");
            mav.setView((View)new RedirectView(INIT_AUTHCHECKCONF));
        } else {
            mav.setViewName(READ_AUTHCHECKCONF_JSP);
            mav.addObject(AUTHCHECKCONF, (Object)this.authCheckConfBizImpl.getAuthCheckConfById(id.intValue()));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteAuthCheckConf"})
    public ModelAndView deleteAuthCheckConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_AUTHCHECKCONF));
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            if (deleteStatus == 1) {
                if (this.authCheckConfBizImpl.deleteAuthCheckConf(ids) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u5931\u8d25\uff01");
                }
            } else {
                HashMap<String, Object> pa = new HashMap<String, Object>(2);
                pa.put(DELETESTATUS, 1);
                pa.put(IDS, ids);
                if (this.authCheckConfBizImpl.updateAuthCheckConfFieldById(pa) >= 1) {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u6210\u529f\uff01");
                } else {
                    mav.addObject(MSG, (Object)"\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u5230\u56de\u6536\u7ad9\u5931\u8d25\uff01");
                }
            }
            mav.addObject(DELETESTATUS, (Object)deleteStatus);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/restoreAuthCheckConf"})
    public ModelAndView restoreAuthCheckConf(@RequestParam(value="ids") String ids) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_AUTHCHECKCONF));
        mav.addObject(DELETESTATUS, (Object)1);
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u8fd8\u539f\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            HashMap<String, Object> pa = new HashMap<String, Object>(2);
            pa.put(DELETESTATUS, 0);
            pa.put(IDS, ids);
            if (this.authCheckConfBizImpl.updateAuthCheckConfFieldById(pa) >= 1) {
                mav.addObject(MSG, (Object)"\u8fd8\u539f\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u6210\u529f\uff01");
            } else {
                mav.addObject(MSG, (Object)"\u8fd8\u539f\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fd8\u539f\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u8fd8\u539f\u5220\u9664\u9a8c\u8bc1\u8bbe\u7f6e\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/queryAuthCheckConf"})
    public ModelAndView queryAuthCheckConf(@RequestParam(value="deleteStatus", required=false, defaultValue="0") Integer deleteStatus, @RequestParam(value="title", required=false, defaultValue="") String title, @RequestParam(value="setCode", required=false, defaultValue="") String setCode, PageBean pageBean) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> queryParam = new HashMap<String, String>();
        if (title != null && title.trim().length() != 0) {
            param.put(TITLE, title);
            queryParam.put(TITLE, title);
            queryParam.put("searchField", TITLE);
            queryParam.put("searchValue", title);
            queryParam.put("searchName", "\u65b9\u6848\u6807\u9898");
        }
        if (setCode != null && setCode.trim().length() != 0) {
            param.put(SETCODE, setCode);
            queryParam.put(SETCODE, setCode);
            queryParam.put("searchField", SETCODE);
            queryParam.put("searchValue", setCode);
            queryParam.put("searchName", "\u65b9\u6848\u4ee3\u7801");
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName(AUTHCHECKCONF_LIST_JSP);
        mav.addObject("queryParam", queryParam);
        param.put(DELETESTATUS, deleteStatus);
        mav.addObject(DELETESTATUS, (Object)deleteStatus);
        try {
            mav.addObject("pageBean", (Object)this.authCheckConfBizImpl.getAuthCheckConfByField(param, pageBean));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u9a8c\u8bc1\u8bbe\u7f6e\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        return mav;
    }

    private void fullDictionarys(ModelAndView mav) {
        for (String dep : DICTIONARYS_LIST) {
            try {
                mav.addObject(dep, this.dictionarysCache.getDictionaryByName(dep));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u5f97\u5b57\u5178\u7f13\u5b58\u5f02\u5e38\uff0c\u5b57\u5178\u540d\uff1a" + dep, (Throwable)e);
            }
        }
    }

    public final AuthCheckConf getAuthCheckConf() {
        return this.authCheckConf;
    }

    @Resource(name="authCheckConf")
    public void setAuthCheckConf(AuthCheckConf authCheckConf) {
        this.authCheckConf = authCheckConf;
    }

    public IAuthCheckConfBiz getAuthCheckConfBizImpl() {
        return this.authCheckConfBizImpl;
    }

    @Resource(name="authCheckConfBizImpl")
    public void setAuthCheckConfBizImpl(IAuthCheckConfBiz authCheckConfBizImpl) {
        this.authCheckConfBizImpl = authCheckConfBizImpl;
    }

    public IDictionarysCache getDictionarysCache() {
        return this.dictionarysCache;
    }

    @Resource(name="dictionarysCache")
    public void setDictionarysCache(IDictionarysCache dictionarysCache) {
        this.dictionarysCache = dictionarysCache;
    }
}

