/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.Payment;
import com.qianjiang.system.service.PaymentService;
import com.qianjiang.util.PageBean;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class PaymentController {
    private static final Logger LOGGER = Logger.getLogger(PaymentController.class);
    private static final String REDIRECT_PAYMENT = "queryPaymentByPb.htm";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    @Resource(name="PaymentService")
    private PaymentService paymentService;

    @RequestMapping(value={"/queryPaymentByPb"})
    public ModelAndView queryPaymentByPb(PageBean pb, HttpServletRequest request) {
        LOGGER.debug((Object)"==========\u5206\u9875\u67e5\u770b\u652f\u4ed8\u65b9\u5f0f\u5217\u8868==========");
        return new ModelAndView("jsp/system/payment/payment_list", "pb", (Object)this.paymentService.selectAllByPb(pb));
    }

    @RequestMapping(value={"/createPayment"})
    public ModelAndView createPayment(@Valid Payment payment, BindingResult bindingResult, HttpServletRequest request) {
        LOGGER.debug((Object)"==========\u6dfb\u52a0\u652f\u4ed8\u65b9\u5f0f==========");
        if (bindingResult.hasErrors()) {
            throw new RuntimeException("\u652f\u4ed8\u65b9\u5f0f\u5b57\u6bb5\u9519\u8bef\uff01");
        }
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        this.paymentService.createPayment(payment, loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u652f\u4ed8\u65b9\u5f0f", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT_PAYMENT));
    }

    @RequestMapping(value={"/ajaxGetPayment"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Payment ajaxGetPayment(Long paymentId) {
        LOGGER.debug((Object)"==========ajax\u67e5\u770b\u652f\u4ed8\u65b9\u5f0f==========");
        return this.paymentService.getPayment(paymentId);
    }

    @RequestMapping(value={"/updatePayment"})
    public ModelAndView updatePayment(Payment payment, HttpServletRequest request) {
        LOGGER.debug((Object)"==========\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f==========");
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        this.paymentService.updatePayment(payment, loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT_PAYMENT));
    }

    @RequestMapping(value={"/deletePayment"})
    public ModelAndView deletePayment(Long paymentId, HttpServletRequest request) {
        LOGGER.debug((Object)"==========\u5220\u9664\u652f\u4ed8\u65b9\u5f0f==========");
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        this.paymentService.deletePayment(paymentId, loginUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u652f\u4ed8\u65b9\u5f0f", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT_PAYMENT));
    }

    @RequestMapping(value={"/updateOpenStatus"})
    public ModelAndView updateOpenStatus(HttpServletRequest request, Long paymentId) {
        LOGGER.debug((Object)"==========ajax\u4fee\u6539\u652f\u4ed8\u65b9\u5f0f\u542f\u7528\u72b6\u6001==========");
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        this.paymentService.setPaymentOpenStatus(paymentId, loginUserId);
        return new ModelAndView((View)new RedirectView(REDIRECT_PAYMENT));
    }

    @RequestMapping(value={"/ajaxCheckOpenCount"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean ajaxCheckOpenCount(Long paymentId) {
        LOGGER.debug((Object)"==========ajax\u68c0\u67e5\u542f\u7528\u7684\u652f\u4ed8\u65b9\u5f0f\u6570\u91cf==========");
        return this.paymentService.checkOpenCount(paymentId);
    }

    @RequestMapping(value={"/ajaxCheckDelete"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean ajaxCheckDelete(Long paymentId) {
        LOGGER.debug((Object)"==========ajax\u68c0\u67e5\u652f\u4ed8\u65b9\u5f0f\u80fd\u5426\u5220\u9664==========");
        return this.paymentService.checkDelete(paymentId);
    }
}

