/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.temp.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.Megawizard;
import com.qianjiang.temp.service.MegawizardService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.StringCommonUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class MegawizardController {
    private static final MyLogger LOGGER = new MyLogger(MegawizardController.class);
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    public static final String TYPES = "types";
    public static final String QUERYMEGAWIZARDBYPAGEBEAN_HTM = "queryMegawizardByPageBean.htm?tempId=";
    public static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="MegawizardService")
    private MegawizardService megawizardService;

    @RequestMapping(value={"/queryMegawizardByPageBean"})
    public ModelAndView queryMegawizardByPageBean(PageBean pb, Long tempId) {
        this.megawizardService.selectByTempId(pb, tempId);
        return new ModelAndView("jsp/temp/temp_megawizardList", "pb", (Object)pb).addObject("tempId", (Object)tempId).addObject(TYPES, this.getPropertiesValue());
    }

    @RequestMapping(value={"/querymegawizardbypagebeanbyajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryMegawizardByPageBeanByAjax(PageBean pb, Long tempId) {
        this.megawizardService.selectByTempId(pb, tempId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", pb);
        map.put(TYPES, this.getPropertiesValue());
        return map;
    }

    @RequestMapping(value={"/updateSelectMegawizardById"})
    public ModelAndView selectMegawizardById(Long id) {
        Megawizard meg = this.megawizardService.selectById(id);
        return new ModelAndView("jsp/temp/show_megawizard", "meg", (Object)meg).addObject(TYPES, this.getPropertiesValue());
    }

    @RequestMapping(value={"/updateMegawizard"})
    public ModelAndView updateMegawizard(@Valid Megawizard meg, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYMEGAWIZARDBYPAGEBEAN_HTM + meg.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long updateUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        meg.setUpdateUserId(updateUserId);
        this.megawizardService.updateByIdToContent(meg);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9875\u9762\u8bf4\u660e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYMEGAWIZARDBYPAGEBEAN_HTM + meg.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updatemegawizardajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateMegawizardAjax(@Valid Megawizard meg, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long updateUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        meg.setUpdateUserId(updateUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9875\u9762\u8bf4\u660e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return this.megawizardService.updateByIdToContent(meg);
    }

    @RequestMapping(value={"/showMegawizardNew"})
    public ModelAndView showMegawizardNew(Long tempId) {
        Megawizard meg = new Megawizard();
        meg.setTempId(tempId);
        return new ModelAndView("jsp/temp/show_megawizard", "meg", (Object)meg).addObject(TYPES, this.getPropertiesValue());
    }

    @RequestMapping(value={"/newMegawizard"})
    public ModelAndView createMegawizard(@Valid Megawizard meg, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYMEGAWIZARDBYPAGEBEAN_HTM + meg.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long updateUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        meg.setUpdateUserId(updateUserId);
        this.megawizardService.insert(meg);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u65b0\u589e\u6a21\u677f\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYMEGAWIZARDBYPAGEBEAN_HTM + meg.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/newmegawizardajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createMegawizardAjax(@Valid Megawizard meg, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long updateUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        meg.setUpdateUserId(updateUserId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u65b0\u589e\u6a21\u677f\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return this.megawizardService.insert(meg);
    }

    @RequestMapping(value={"/delectMegawizard"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ModelAndView delectMegawizard(HttpServletRequest request) {
        String[] ids = request.getParameterValues("id[]");
        this.megawizardService.updateById(ids);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u6a21\u677f\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return null;
    }

    @RequestMapping(value={"/delectmegawizardajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delectMegawizardAjax(HttpServletRequest request) {
        String[] ids = request.getParameterValues("id");
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u6a21\u677f\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return this.megawizardService.updateById(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getPropertiesValue() {
        HashMap<String, String> map = new HashMap<String, String>();
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            String classPath = new File(MegawizardController.class.getResource("/").getFile()).getCanonicalPath();
            String configFilePath = classPath + "config/megawizard.properties";
            inputStream = new FileInputStream(configFilePath);
            properties.load(inputStream);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("", (Throwable)e);
                }
            }
        }
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            Object obj = enu.nextElement();
            try {
                map.put(obj.toString(), StringCommonUtil.changeToUtf8((String)properties.getProperty(obj.toString())));
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("\u5b57\u7b26\u4e32\u8f6c\u6362\u9519\u8bef\uff1a=>", (Throwable)e);
            }
        }
        return map;
    }
}

