/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.image.controller;

import com.qianjiang.image.bean.InfoImageClassify;
import com.qianjiang.image.bean.InfoImageManage;
import com.qianjiang.image.service.InfoImageClassifyService;
import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.manager.service.SysHelperService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.uploadfileset.bean.UploadFileSet;
import com.qianjiang.uploadfileset.service.UploadFileSetService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class InfoImageManageController {
    private static final MyLogger LOGGER = new MyLogger(InfoImageManageController.class);
    private static final String LOGGERINFO1 = "======\u6839\u636e\u5206\u7c7b\uff0c\u5206\u9875\u67e5\u8be2\u56fe\u7247\u4fe1\u606f======";
    private static final String LOGGERINFO2 = ",\u7528\u6237\u540d:";
    private static final String QUERYIMAGEMANAGEBYPBANDCID_CSRFTOKEN = "queryImageManageByPbAndCid.htm?CSRFToken=";
    private static final String QUERYIMAGEMANAGEBYPBANDCID_CLASSIFYID = "queryImageManageByPbAndCid.htm?classifyId=";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private InfoImageClassifyService infoImageClassifyService;
    private InfoImageManageService infoImageManageService;
    @Resource(name="UploadFileSetService")
    private UploadFileSetService uploadFileSetService;
    @Resource(name="SysHelperMapper")
    private SysHelperService sysHelperService;

    @RequestMapping(value={"/queryImageManageByPbAndCid"})
    public ModelAndView queryImageManageByPbAndCid(PageBean pb, Long classifyId) {
        LOGGER.debug(LOGGERINFO1);
        ModelAndView mav = new ModelAndView();
        mav.addObject("classifyId", (Object)classifyId);
        mav.addObject("classifyList", (Object)this.infoImageClassifyService.selectAllImageClassifyForImg());
        if (null != classifyId && classifyId >= 0L) {
            mav.addObject("pb", (Object)this.infoImageManageService.selectImageManageByParam(pb, classifyId, null, null, null));
        } else {
            mav.addObject("pb", (Object)this.infoImageManageService.selectImageManageByParam(pb, null, null, null, null));
        }
        mav.setViewName("jsp/infoImage/infoImageManageList");
        return mav;
    }

    @RequestMapping(value={"/queryImageManageByPbAndCidForChoose"})
    public ModelAndView queryImageManageByPbAndCidForChoose(PageBean pb, Long classifyId, Integer size, String location) {
        LOGGER.debug(LOGGERINFO1);
        ModelAndView mav = new ModelAndView();
        mav.addObject("classifyList", (Object)this.infoImageClassifyService.selectAllImageClassify());
        mav.addObject("size", (Object)size);
        UploadFileSet ufs = this.uploadFileSetService.getCurrUploadFileSet();
        mav.addObject("ufs", (Object)ufs);
        mav.setViewName("jsp/infoImage/chooseImage" + (location == null || "".equals(location) ? "" : "_" + location));
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/ajaxQueryImageForChoose"}, produces={"application/json;charset=UTF-8"})
    public PageBean ajaxQueryImageForChoose(PageBean pb, Long classifyId, String startDate, String endDate, Long thirdId) {
        LOGGER.debug(LOGGERINFO1);
        if (null != classifyId && classifyId >= 0L) {
            return this.infoImageManageService.selectImageManageByParam(pb, classifyId, startDate, endDate, thirdId);
        }
        return this.infoImageManageService.selectImageManageByParam(pb, null, startDate, endDate, thirdId);
    }

    @RequestMapping(value={"/saveImageManagerAction"})
    public ModelAndView saveImageManagerAction(MultipartHttpServletRequest request, HttpServletResponse response, @Valid InfoImageManage infoImageManage, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYIMAGEMANAGEBYPBANDCID_CSRFTOKEN + request.getParameter("CSRFToken")));
        }
        List muFiles = request.getFiles("imgSrc");
        if (CollectionUtils.isNotEmpty((Collection)muFiles)) {
            for (MultipartFile muFile : muFiles) {
                if (muFile.getSize() > 0L) {
                    Map map = UploadUtil.uploadFile((MultipartFile)muFile);
                    infoImageManage.setImageManageUrl((String)map.get("oldimg"));
                    infoImageManage.setBigImgUrl((String)map.get("2"));
                    infoImageManage.setMiddleImgUrl((String)map.get("1"));
                    infoImageManage.setSmallImgUrl((String)map.get("0"));
                }
                infoImageManage.setImageOnlineDate(new Date());
                this.infoImageManageService.saveInfoImageManage(infoImageManage);
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fdd\u5b58\u56fe\u7247\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO2 + customerName));
            }
        }
        return new ModelAndView((View)new RedirectView(QUERYIMAGEMANAGEBYPBANDCID_CSRFTOKEN + request.getParameter("CSRFToken")));
    }

    @ResponseBody
    @RequestMapping(value={"/ajaxQueryImageCateForAdd"}, produces={"application/json;charset=UTF-8"})
    public List<InfoImageClassify> ajaxQueryImageCateForAdd() {
        LOGGER.debug("=====\u67e5\u8be2\u6240\u6709\u56fe\u7247\u5e93\u5206\u7c7b=======");
        return this.infoImageClassifyService.selectAllImageClassifyForImg();
    }

    @RequestMapping(value={"/updateImageManageAction"})
    public ModelAndView updateImageManageAction(@Valid InfoImageManage infoImageManage, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYIMAGEMANAGEBYPBANDCID_CSRFTOKEN + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("======\u4fee\u6539\u56fe\u7247\u4fe1\u606f======");
        this.infoImageManageService.updateInfoImageManage(infoImageManage);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u56fe\u7247\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO2 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYIMAGEMANAGEBYPBANDCID_CLASSIFYID + infoImageManage.getClassifyId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateImageManageActionToFormer"})
    public ModelAndView updateImageManageActionToFormer(@Valid InfoImageManage infoImageManage, BindingResult bindingResult, Long oldClassifyId, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYIMAGEMANAGEBYPBANDCID_CSRFTOKEN + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("======\u4fee\u6539\u56fe\u7247\u4fe1\u606f======");
        this.infoImageManageService.updateInfoImageManage(infoImageManage);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u56fe\u7247\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO2 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYIMAGEMANAGEBYPBANDCID_CLASSIFYID + oldClassifyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/deleteImageManageAction"})
    public ModelAndView deleteImageManageAction(Long infoImageManageId, HttpServletRequest request) {
        LOGGER.debug("======\u5220\u9664\u56fe\u7247\u4fe1\u606f======\u8981\u5220\u9664\u7684\u56fe\u7247ID\u4e3a\uff1a" + infoImageManageId);
        this.infoImageManageService.deleteInfoImageManage(infoImageManageId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u56fe\u7247\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO2 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYIMAGEMANAGEBYPBANDCID_CSRFTOKEN + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/deleteImageManageActionToFormer"})
    public ModelAndView deleteImageManageActionToFormer(Long infoImageManageId, Long classifyId, HttpServletRequest request) {
        LOGGER.debug("======\u5220\u9664\u56fe\u7247\u4fe1\u606f======");
        this.infoImageManageService.deleteInfoImageManage(infoImageManageId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u56fe\u7247\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO2 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYIMAGEMANAGEBYPBANDCID_CLASSIFYID + classifyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/deleteimagemanageactiontoformerbath"})
    public ModelAndView deleteImageManageActionToFormerBath(Long[] pids, Long classifyId, HttpServletRequest request) {
        LOGGER.debug("======\u5220\u9664\u56fe\u7247\u4fe1\u606f======");
        if (!ArrayUtils.isEmpty((Object[])pids)) {
            for (Long id : pids) {
                this.infoImageManageService.deleteInfoImageManage(id);
            }
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u56fe\u7247\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO2 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYIMAGEMANAGEBYPBANDCID_CLASSIFYID + classifyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/batchDeleteImageManageAction"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void batchDeleteImageManageAction(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("======\u6279\u91cf\u5220\u9664\u56fe\u7247\u4fe1\u606f======");
        try {
            String[] imageManageIds = request.getParameterValues("imageManageIds[]");
            for (int i = 0; i < imageManageIds.length; ++i) {
                Long infoImageManageId = Long.valueOf(imageManageIds[i]);
                this.infoImageManageService.deleteInfoImageManage(infoImageManageId);
            }
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6279\u91cf\u5220\u9664\u56fe\u7247\u4fe1\u606f", (String)(request.getSession().getAttribute(OPERAPATH) + ",\u7528\u6237\u540d\uff1a" + customerName));
        }
        catch (Exception e) {
            LOGGER.error("============\u6279\u91cf\u5220\u9664\u56fe\u7247\u4fe1\u606f\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public InfoImageClassifyService getInfoImageClassifyService() {
        return this.infoImageClassifyService;
    }

    @Resource(name="InfoImageClassifyService")
    public void setInfoImageClassifyService(InfoImageClassifyService infoImageClassifyService) {
        this.infoImageClassifyService = infoImageClassifyService;
    }

    public InfoImageManageService getInfoImageManageService() {
        return this.infoImageManageService;
    }

    @Resource(name="InfoImageManageService")
    public void setInfoImageManageService(InfoImageManageService infoImageManageService) {
        this.infoImageManageService = infoImageManageService;
    }
}

