/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.temp.controller;

import com.qianjiang.channel.bean.ChannelTrademark;
import com.qianjiang.channel.service.ChannelTrademarkService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.ClassifyBar;
import com.qianjiang.temp.service.ClassifyBarService;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class TempClassifyBarBrandController {
    private static final MyLogger LOGGER = new MyLogger(TempClassifyBarBrandController.class);
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String TEMP2 = "1";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private static final String QUERYCLASSIFYBARBRANDBYPAGEBEAN_HTM = "queryClassifybarBrandByPageBean.htm?temp1=";
    private static final String QUERYCLASSIFYBARBRANDBYBOX_TEMPID = "queryClassifybarBrandByBox.htm?tempId=";
    private static final String QUERYCLASSIFYBARBRANDBYBOX_CHANNELID = "queryClassifybarBrandByBox.htm?channelId=";
    private TempService tempService;
    private ClassifyBarService classifyBarService;
    private ChannelTrademarkService channelTrademarkService;

    @RequestMapping(value={"/queryClassifybarBrandByPageBean"})
    public ModelAndView queryClassifybarBrandByPageBean(PageBean pb, String temp1) {
        ModelAndView mav = new ModelAndView();
        ClassifyBar classifyBar = this.classifyBarService.getClassifyBarById(Long.valueOf(temp1));
        mav.addObject("classifyBar", (Object)classifyBar);
        mav.addObject("pb", (Object)this.channelTrademarkService.selectClassifyTrademarkByParam(pb, null, null, temp1, null));
        mav.setViewName("jsp/temp/temp_classifybar_brand_list");
        return mav;
    }

    @RequestMapping(value={"/showClassifybarBrand"})
    public ModelAndView showClassifybarBrand(Long trademarkId, String temp1) {
        ClassifyBar classifyBar = this.classifyBarService.getClassifyBarById(Long.valueOf(temp1));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("classifyBar", classifyBar);
        if (null != trademarkId) {
            ChannelTrademark channelTrademark = this.channelTrademarkService.getChannelTrademarkById(trademarkId);
            map.put("channelTrademark", channelTrademark);
        }
        return new ModelAndView("jsp/temp/show_temp_classifybar_brand", "map", map);
    }

    @RequestMapping(value={"/createClassifybarBrand"})
    public ModelAndView createClassifybarBrand(HttpServletRequest request, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, String temp1) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCLASSIFYBARBRANDBYPAGEBEAN_HTM + temp1 + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelTrademark.setCreateUserId(Long.valueOf(1L));
            } else {
                channelTrademark.setCreateUserId(loginUserId);
            }
            int n = this.channelTrademarkService.saveChannelTrademark(channelTrademark);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u5206\u7c7b\u5bfc\u822a\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fdd\u5b58\u5206\u7c7b\u5bfc\u822a\u54c1\u724c\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fdd\u5b58\u5206\u7c7b\u5bfc\u822a\u54c1\u724c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u6a21\u677f\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYCLASSIFYBARBRANDBYPAGEBEAN_HTM + temp1 + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/modifClassifybarBrand"})
    public ModelAndView updateClassifybarBrand(HttpServletRequest request, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, String temp1) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCLASSIFYBARBRANDBYPAGEBEAN_HTM + temp1 + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelTrademark.setUpdateUserId(Long.valueOf(1L));
            } else {
                channelTrademark.setUpdateUserId(loginUserId);
            }
            int n = this.channelTrademarkService.updateChannelTrademark(channelTrademark);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u5206\u7c7b\u5bfc\u822a\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fee\u6539\u5206\u7c7b\u5bfc\u822a\u54c1\u724c\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fee\u6539\u5206\u7c7b\u5bfc\u822a\u54c1\u724c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u6a21\u677f\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYCLASSIFYBARBRANDBYPAGEBEAN_HTM + temp1 + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/queryClassifybarBrandByBox"})
    public ModelAndView queryClassifybarBrandByBox(PageBean pb, Long tempId, Long channelId) {
        ModelAndView mav = new ModelAndView();
        mav.addObject("pb", (Object)this.channelTrademarkService.selectClassifyTrademarkByParam(pb, tempId, channelId, null, TEMP2));
        mav.addObject("tempId", (Object)tempId);
        mav.addObject("channelId", (Object)channelId);
        mav.setViewName("jsp/temp/temp_classifybarbox_brand_list");
        return mav;
    }

    @RequestMapping(value={"/showClassifybarBrandBox"})
    public ModelAndView showClassifybarBrandBox(Long trademarkId, Long tempId, Long channelId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != trademarkId) {
            ChannelTrademark channelTrademark = this.channelTrademarkService.getChannelTrademarkById(trademarkId);
            map.put("channelTrademark", channelTrademark);
        }
        map.put("tempId", tempId);
        map.put("channelId", channelId);
        map.put("temp2", TEMP2);
        return new ModelAndView("jsp/temp/show_temp_classifybarbox_brand", "map", map);
    }

    @RequestMapping(value={"/createClassifybarBrandBox"})
    public ModelAndView createClassifybarBrandBox(HttpServletRequest request, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            if (null == channelTrademark.getChannelId()) {
                return new ModelAndView((View)new RedirectView(QUERYCLASSIFYBARBRANDBYBOX_TEMPID + channelTrademark.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
            }
            return new ModelAndView((View)new RedirectView(QUERYCLASSIFYBARBRANDBYBOX_CHANNELID + channelTrademark.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        String view = "";
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        channelTrademark.setCreateUserId(loginUserId);
        this.channelTrademarkService.saveChannelTrademark(channelTrademark);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u5206\u7c7b\u5bfc\u822a\u6846\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        view = null == channelTrademark.getChannelId() ? QUERYCLASSIFYBARBRANDBYBOX_TEMPID + channelTrademark.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken") : QUERYCLASSIFYBARBRANDBYBOX_CHANNELID + channelTrademark.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken");
        mav.setView((View)new RedirectView(view));
        return mav;
    }

    @RequestMapping(value={"/modifClassifybarBrandBox"})
    public ModelAndView updateClassifybarBrandBox(HttpServletRequest request, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            if (null == channelTrademark.getChannelId()) {
                return new ModelAndView((View)new RedirectView(QUERYCLASSIFYBARBRANDBYBOX_TEMPID + channelTrademark.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
            }
            return new ModelAndView((View)new RedirectView(QUERYCLASSIFYBARBRANDBYBOX_CHANNELID + channelTrademark.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        String view = "";
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        channelTrademark.setCreateUserId(loginUserId);
        this.channelTrademarkService.updateChannelTrademark(channelTrademark);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u5206\u7c7b\u5bfc\u822a\u6846\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        view = null == channelTrademark.getChannelId() ? QUERYCLASSIFYBARBRANDBYBOX_TEMPID + channelTrademark.getTempId() + "&CSRFToken=" + request.getParameter("CSRFToken") : QUERYCLASSIFYBARBRANDBYBOX_CHANNELID + channelTrademark.getChannelId() + "&CSRFToken=" + request.getParameter("CSRFToken");
        mav.setView((View)new RedirectView(view));
        return mav;
    }

    @RequestMapping(value={"/delClassifybarBrand"})
    public void deleteClassifybarBrand(HttpServletRequest request, HttpServletResponse response) {
        String[] trademarkIds = request.getParameterValues("trademarkIds[]");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < trademarkIds.length; ++i) {
            this.channelTrademarkService.deleteChannelTrademark(Long.valueOf(trademarkIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u5206\u7c7b\u5bfc\u822a\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/queryclassifybarbrandbypagebeanajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryClassifybarBrandByPageBeanAjax(PageBean pb, String temp1, Long tempId, Long channelId, String temp2) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.channelTrademarkService.selectClassifyTrademarkByParam(pb, tempId, channelId, temp1, temp2));
        return map;
    }

    public TempService getTempService() {
        return this.tempService;
    }

    @Resource(name="TempService")
    public void setTempService(TempService tempService) {
        this.tempService = tempService;
    }

    public ChannelTrademarkService getChannelTrademarkService() {
        return this.channelTrademarkService;
    }

    @Resource(name="ChannelTrademarkService")
    public void setChannelTrademarkService(ChannelTrademarkService channelTrademarkService) {
        this.channelTrademarkService = channelTrademarkService;
    }

    public ClassifyBarService getClassifyBarService() {
        return this.classifyBarService;
    }

    @Resource(name="ClassifyBarService")
    public void setClassifyBarService(ClassifyBarService classifyBarService) {
        this.classifyBarService = classifyBarService;
    }
}

