/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.customer.bean.Customer;
import com.qianjiang.excel.ExportGoodsList;
import com.qianjiang.goods.bean.Goods;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.bean.ProductLogger;
import com.qianjiang.goods.service.GetOnOffService;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsImageService;
import com.qianjiang.goods.service.GoodsImportService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsRelatedGoodsService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.GoodsTagService;
import com.qianjiang.goods.service.ProductLoggerService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.service.SearchAsyncService;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.goods.util.GoodsSearchBean;
import com.qianjiang.goods.vo.GoodsMoifiedVo;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.ServiceSupportMapperService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.UploadUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class GoodsController {
    private static final MyLogger LOGGER = new MyLogger(GoodsController.class);
    private static final String SEARCHBEAN = "searchBean";
    private static final String ONECATELIST = "oneCateList";
    private static final String PAGENO = "pageNo";
    private static final String VARNAME = "\u3011-->\u7528\u6237\u540d\uff1a";
    private static final String VARPRODUCT = ",\u5546\u54c1\u540d\u79f0\u4e3a:";
    private static final String VARNAME2 = ",\u7528\u6237\u540d\uff1a";
    private static final String GOODSIMAGE = "goodsImage";
    private static final String EXPANDPARAMID = "expandParamId";
    private static final String EXPANDPARAMVALUE = "expandparamValue";
    private static final String PARAMID = "paramId";
    private static final String PARAMVALUE = "paramValue";
    private static final String ABOUTGOODSID = "aboutGoodsId";
    private static final String PAGESIZE = "&pageSize=";
    private static final String PRODUCTIDSPECIDSPECDETAILID = "productIdSpecIdSpecdetailId";
    private static final String BRANDLIST = "brandList";
    private static final String TAGLIST = "tagList";
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    private GoodsService goodsService;
    private GoodsBrandService goodsBrandService;
    private GoodsTagService goodsTagService;
    private GoodsCateService goodsCateService;
    private ProductWareService productWareService;
    @Resource(name="GetOnOffService")
    private GetOnOffService getOnOffService;
    @Resource(name="GoodsProductService")
    private GoodsProductService goodsProductService;
    @Resource(name="serviceSupportMapperService")
    private ServiceSupportMapperService serviceSupportMapperService;
    private WareHouseService wareHouseService;
    @Autowired
    private SearchAsyncService searchAsyncService;
    @Resource(name="GoodsRelatedGoodsService")
    private GoodsRelatedGoodsService relatedGoodsService;
    @Resource(name="GoodsImportService")
    private GoodsImportService goodsImportService;
    @Resource(name="productLoggerService")
    private ProductLoggerService productLoggerService;
    @Autowired
    private GoodsImageService goodsImageService;
    private static String name = "admin";

    @RequestMapping(value={"/newUploadGoods"})
    public ModelAndView newUploadGoods(HttpServletRequest req, HttpServletResponse resp) {
        ModelAndView mav = new ModelAndView();
        try {
            List goodsBrandsList = this.goodsBrandService.queryAllBrand();
            List goodsTagList = this.goodsTagService.queryAllTag();
            List wareHousesList = this.wareHouseService.queryAllWareHouse();
            List serviceSupportsList = this.serviceSupportMapperService.selectAll();
            mav.addObject(BRANDLIST, (Object)goodsBrandsList);
            mav.addObject(TAGLIST, (Object)goodsTagList);
            mav.addObject("wareHouse", (Object)wareHousesList);
            mav.addObject("support", (Object)serviceSupportsList);
            mav.setViewName("jsp/goods/newupload");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u53d1\u5e03\u5546\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/findAllGoods"})
    public ModelAndView test(PageBean pb, HttpServletRequest request, GoodsSearchBean searchBean, Long oneCateId, Long twoCateId, String goodType) {
        ModelAndView mav = null;
        pb.setUrl("findAllGoods.htm");
        if (searchBean.getQueryStatus() == null || "".equals(searchBean.getQueryStatus())) {
            searchBean.setQueryStatus("1");
        }
        List twoCateList = null;
        List threeCateList = null;
        try {
            List oneCateList = this.goodsCateService.querySonCateByParentIdAndName(Long.valueOf(0L), null);
            if (oneCateId != null) {
                twoCateList = this.goodsCateService.querySonCateByParentIdAndName(oneCateId, null);
            }
            if (twoCateId != null) {
                threeCateList = this.goodsCateService.querySonCateByParentIdAndName(twoCateId, null);
            }
            if (goodType != null && "1".equals(goodType)) {
                searchBean.setQueryStatus("1");
            } else if (goodType != null && "2".equals(goodType)) {
                searchBean.setQueryStatus("2");
            } else if (goodType != null && "3".equals(goodType)) {
                searchBean.setQueryStatus("3");
            } else if (goodType != null && "4".equals(goodType)) {
                searchBean.setQueryStatus("4");
            }
            PageBean pageBean = this.goodsService.searchBySearchBeanAndPageBean(pb, searchBean);
            mav = new ModelAndView("jsp/goods/goods_list", "pageBean", (Object)pageBean);
            mav.addObject(ONECATELIST, (Object)oneCateList);
            mav.addObject("twoCateList", (Object)twoCateList);
            mav.addObject("threeCateList", (Object)threeCateList);
            mav.addObject("oneCateId", (Object)oneCateId);
            mav.addObject("twoCateId", (Object)twoCateId);
            mav.addObject(SEARCHBEAN, (Object)searchBean);
            mav.addObject(BRANDLIST, (Object)this.goodsBrandService.queryAllBrand());
            mav.addObject(TAGLIST, (Object)this.goodsTagService.queryAllTag());
            String bsetaddress = BasicSetUtil.getAddress((String)this.basicSetService.findBasicSet().getBsetAddress());
            mav.addObject("bset", (Object)bsetaddress);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/findAllGoodsisthird"})
    public ModelAndView testisthird(PageBean pb, HttpServletRequest request) {
        pb.setUrl("findAllGoodsisthird.htm");
        List oneCateList = this.goodsCateService.querySonCateByParentIdAndName(Long.valueOf(0L), null);
        String pageNo = request.getParameter(PAGENO);
        if (pageNo == null) {
            pageNo = "1";
        }
        String bsetAddress = BasicSetUtil.getAddress((String)this.basicSetService.findBasicSet().getBsetAddress());
        pb.setFirstPageNo(Integer.parseInt(pageNo));
        pb = this.goodsService.queryListVo(pb, "1");
        ModelAndView mav = new ModelAndView("jsp/goods/goods_list_isthird", "pageBean", (Object)pb).addObject(BRANDLIST, (Object)this.goodsBrandService.queryAllBrand()).addObject(TAGLIST, (Object)this.goodsTagService.queryAllTag()).addObject("bset", (Object)bsetAddress);
        mav.addObject(ONECATELIST, (Object)oneCateList);
        LOGGER.info((Object)"\u5206\u9875\u67e5\u8be2\u5546\u54c1\u5217\u8868");
        return mav;
    }

    @RequestMapping(value={"/delGoods"})
    public ModelAndView delGoods(Long goodsId, HttpServletRequest request) {
        int result = this.goodsService.delGoods(goodsId, (String)request.getSession().getAttribute("name"));
        GoodsMoifiedVo goodsMoifiedVo = this.goodsService.queryModeifiedVoByGoodsId(goodsId);
        Long[] goodsIds = new Long[]{goodsId};
        List sList = this.goodsProductService.selectInfoIdList(goodsIds);
        this.searchAsyncService.batchDeleteGoodsIndexToEs(sList);
        if (null != goodsMoifiedVo.getGoodsName() && 1 == result) {
            String name = (String)request.getSession().getAttribute("name");
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)name, (String)"\u5220\u9664\u5546\u54c1\u4fe1\u606f", (String)("\u5220\u9664\u5546\u54c1\u4fe1\u606f-->\u5546\u54c1\u540d\u79f0\u3010" + goodsMoifiedVo.getGoodsName() + VARNAME + name));
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u4fe1\u606f,\u5546\u54c1\u540d\u79f0\u4e3a:" + goodsMoifiedVo.getGoodsName()));
        }
        return new ModelAndView((View)new RedirectView("findAllGoods.htm"));
    }

    @RequestMapping(value={"/delGoodsisthird"})
    public ModelAndView delGoodsisthird(Long goodsId, HttpServletRequest request) {
        int result = this.goodsService.delGoods(goodsId, (String)request.getSession().getAttribute("name"));
        GoodsMoifiedVo goodsMoifiedVo = this.goodsService.queryModeifiedVoByGoodsId(goodsId);
        if (null != goodsMoifiedVo.getGoodsName() && 1 == result) {
            String name = (String)request.getSession().getAttribute("name");
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)name, (String)"\u5220\u9664\u5546\u54c1\u4fe1\u606f", (String)("\u5220\u9664\u5546\u54c1\u4fe1\u606f-->\u5546\u54c1\u540d\u79f0\u3010" + goodsMoifiedVo.getGoodsName() + VARNAME + name));
            LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u4fe1\u606f,\u5546\u54c1\u540d\u79f0\u4e3a:" + goodsMoifiedVo.getGoodsName()));
        }
        return new ModelAndView((View)new RedirectView("findAllGoodsisthird.htm"));
    }

    @RequestMapping(value={"/batchDelGoods"})
    public ModelAndView batchDelGoods(Long[] goodsIds, HttpServletRequest request) {
        this.goodsService.batchDel(goodsIds, (String)request.getSession().getAttribute("name"));
        LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u4fe1\u606f");
        List sList = this.goodsProductService.selectInfoIdList(goodsIds);
        this.searchAsyncService.batchDeleteGoodsIndexToEs(sList);
        this.goodsProductService.delShoppingGoodsByGoodsInfoIds(sList);
        for (int i = 0; i < goodsIds.length; ++i) {
            Goods goodsInfo = this.goodsService.selectByPrimaryKey(goodsIds[i]);
            if (!"1".equals("1")) continue;
            ProductLogger productLogger = new ProductLogger();
            productLogger.setName((String)request.getSession().getAttribute("name"));
            productLogger.setProductId(goodsInfo.getGoodsNo());
            productLogger.setProductName(goodsInfo.getGoodsName());
            productLogger.setType("\u5220\u9664");
            productLogger.setStatus("0");
            this.productLoggerService.saveProduct(productLogger);
        }
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + VARNAME2 + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findAllGoods.htm"));
    }

    @RequestMapping(value={"/delGoodsByChangeCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String deleteGoods(Long[] goodsIds, HttpServletRequest request) {
        String result = "0";
        try {
            this.goodsService.batchDel(goodsIds, (String)request.getSession().getAttribute("name"));
            List sList = this.goodsProductService.selectInfoIdList(goodsIds);
            this.searchAsyncService.batchDeleteGoodsIndexToEs(sList);
            this.goodsProductService.delShoppingGoodsByGoodsInfoIds(sList);
            result = "1";
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5207\u6362\u5206\u7c7b\u5220\u9664\u5546\u54c1\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/batchDelGoodsisthird"})
    public ModelAndView batchDelGoodsisthird(Long[] goodsIds, HttpServletRequest request) {
        this.goodsService.batchDel(goodsIds, (String)request.getSession().getAttribute("name"));
        LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u4fe1\u606f");
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + VARNAME2 + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findAllGoodsisthird.htm"));
    }

    @RequestMapping(value={"/saveGoods"})
    public ModelAndView saveGoods(@Valid Goods goods, HttpServletRequest request, MultipartHttpServletRequest request2) {
        try {
            MultipartFile imageFile;
            String[] aboutGoodsId = request.getParameterValues(ABOUTGOODSID);
            String[] tags = request.getParameterValues("goods_tags");
            String[] expandParamIds = request.getParameterValues(EXPANDPARAMID);
            String[] expandParamValues = request.getParameterValues(EXPANDPARAMVALUE);
            String[] paramIds = request.getParameterValues(PARAMID);
            String[] paramValue = request.getParameterValues(PARAMVALUE);
            String[] openSpecs = request.getParameterValues("openSpecs");
            String[] openSpecValue = request.getParameterValues("openSpecValue");
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            map.put("tags", tags);
            map.put("expandParamIds", expandParamIds);
            map.put("expandParamValues", expandParamValues);
            map.put("paramIds", paramIds);
            map.put(PARAMVALUE, paramValue);
            map.put(ABOUTGOODSID, aboutGoodsId);
            if (null != openSpecs && null != openSpecValue) {
                map.put("specId", openSpecs);
                map.put("specValues", openSpecValue);
                String[] openSpecValueImg = new String[openSpecValue.length];
                for (int i = 0; i < openSpecValue.length; ++i) {
                    openSpecValueImg[i] = !request2.getFile("specValueImages_" + openSpecValue[i]).isEmpty() ? (String)UploadUtil.uploadFile((MultipartFile)request2.getFile("specValueImages_" + openSpecValue[i])).get("0") : null;
                }
                map.put("openSpecValueImg", openSpecValueImg);
            }
            if (!(imageFile = request2.getFile(GOODSIMAGE)).isEmpty()) {
                goods.setGoodsImg((String)UploadUtil.uploadFile((MultipartFile)imageFile).get("0"));
            }
            goods.setIsThird("0");
            goods.setGoodsBelo(Long.valueOf(0L));
            goods.setGoodsBeloName("BOSS");
            Long result = this.goodsService.saveGoods(goods, (String)request.getSession().getAttribute("name"), map);
            if (null != goods.getGoodsName() && 1L == result) {
                String name = (String)request.getSession().getAttribute("name");
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)name, (String)"\u65b0\u589e\u5546\u54c1\u4fe1\u606f", (String)("\u65b0\u589e\u5546\u54c1\u4fe1\u606f-->\u5546\u54c1\u540d\u79f0\u3010" + goods.getGoodsName() + VARNAME + name));
                LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u4fe1\u606f,\u5546\u54c1\u540d\u79f0\u4e3a:" + goods.getGoodsName()));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5546\u54c1\u540d\u79f0\u4e3a:" + goods.getGoodsName() + "\u5931\u8d25", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView("findAllGoods.htm"));
    }

    @RequestMapping(value={"/findDetailGoodsVoByGoodsId"})
    public ModelAndView findDetailGoodsVoByGoodsId(Long goodsId) {
        GoodsMoifiedVo goodsMoifiedVo = this.goodsService.queryModeifiedVoByGoodsId(goodsId);
        if (null != goodsMoifiedVo.getGoodsName()) {
            LOGGER.info((Object)("\u6839\u636e\u5546\u54c1ID\u67e5\u8be2\u5546\u54c1\u8be6\u60c5,\u67e5\u8be2\u7684\u5546\u54c1\u540d\u79f0\u4e3a:" + goodsMoifiedVo.getGoodsName()));
        }
        return new ModelAndView("jsp/goods/goods_detail", "detailGoods", (Object)this.goodsService.queryModeifiedVoByGoodsId(goodsId));
    }

    @RequestMapping(value={"/updateGoods"})
    public ModelAndView updateGoods(@Valid Goods goods, HttpServletRequest request, MultipartHttpServletRequest request2, int pageNo, int pageSize) {
        try {
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            String[] tags = request.getParameterValues("update_goods_tags");
            String[] expandParamId = request.getParameterValues(EXPANDPARAMID);
            String[] expandparamValue = request.getParameterValues(EXPANDPARAMVALUE);
            String[] paramId = request.getParameterValues(PARAMID);
            String[] paramValue = request.getParameterValues(PARAMVALUE);
            String[] aboutGoodsId = request.getParameterValues(ABOUTGOODSID);
            map.put("tags", tags);
            map.put(EXPANDPARAMID, expandParamId);
            map.put(EXPANDPARAMVALUE, expandparamValue);
            map.put(PARAMID, paramId);
            map.put(PARAMVALUE, paramValue);
            map.put(ABOUTGOODSID, aboutGoodsId);
            MultipartFile imageFile = request2.getFile(GOODSIMAGE);
            if (!imageFile.isEmpty()) {
                goods.setGoodsImg((String)UploadUtil.uploadFile((MultipartFile)imageFile).get("0"));
            }
            String isThirdAuditUsed = this.getOnOffService.getOnOffFlag();
            List goodsProduct = this.goodsProductService.queryProductsByGoodsId(goods.getGoodsId());
            for (int i = 0; i < goodsProduct.size(); ++i) {
                this.goodsProductService.updateGoodsSubtitleById(((GoodsProduct)goodsProduct.get(i)).getGoodsInfoId(), goods.getGoodsSubtitle());
            }
            int result = this.goodsService.updateGoods(goods, map, isThirdAuditUsed, (String)request.getSession().getAttribute("name"), "");
            if (null != goods.getGoodsName() && 1 == result) {
                String name = (String)request.getSession().getAttribute("name");
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)name, (String)"\u4fee\u6539\u5546\u54c1\u4fe1\u606f", (String)("\u4fee\u6539\u5546\u54c1\u4fe1\u606f-->\u5546\u54c1\u540d\u79f0\u3010" + goods.getGoodsName() + VARNAME + name));
                LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u4fe1\u606f,\u5546\u54c1\u540d\u79f0\u4e3a:" + goods.getGoodsName()));
            }
            this.searchAsyncService.updateOneGoodsIndexToEs(goods.getGoodsId());
            if ("0".equals(goods.getIsThird())) {
                return new ModelAndView((View)new RedirectView("findAllGoods.htm?pageNo=" + pageNo + PAGESIZE + pageSize));
            }
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return new ModelAndView((View)new RedirectView("findAllGoods.htm?pageNo=" + pageNo + PAGESIZE + pageSize));
        }
        LOGGER.info((Object)"\u4fee\u6539\u5546\u54c1\u62a5\u9519");
        return new ModelAndView((View)new RedirectView("findAllGoodsisthird.htm?pageNo=" + pageNo + PAGESIZE + pageSize));
    }

    @RequestMapping(value={"/updateGoodsNew"})
    public ModelAndView updateGoodsNew(Goods goods, HttpServletRequest request, MultipartHttpServletRequest request2, int pageNo, int pageSize) {
        try {
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            String[] tags = request.getParameterValues("update_goods_tags");
            String[] expandParamId = request.getParameterValues(EXPANDPARAMID);
            String[] expandparamValue = request.getParameterValues(EXPANDPARAMVALUE);
            String[] paramId = request.getParameterValues(PARAMID);
            String[] paramValue = request.getParameterValues(PARAMVALUE);
            String[] aboutGoodsId = request.getParameterValues(ABOUTGOODSID);
            String[] productIdSpecIdSpecdetailId = request.getParameterValues(PRODUCTIDSPECIDSPECDETAILID);
            map.put("tags", tags);
            map.put(EXPANDPARAMID, expandParamId);
            map.put(EXPANDPARAMVALUE, expandparamValue);
            map.put(PARAMID, paramId);
            map.put(PARAMVALUE, paramValue);
            map.put(ABOUTGOODSID, aboutGoodsId);
            map.put(PRODUCTIDSPECIDSPECDETAILID, productIdSpecIdSpecdetailId);
            MultipartFile imageFile = request2.getFile(GOODSIMAGE);
            if (imageFile != null && !imageFile.isEmpty()) {
                goods.setGoodsImg((String)UploadUtil.uploadFile((MultipartFile)imageFile).get("0"));
            }
            String isThirdAuditUsed = this.getOnOffService.getOnOffFlag();
            List goodsProduct = this.goodsProductService.queryProductsByGoodsId(goods.getGoodsId());
            for (int i = 0; i < goodsProduct.size(); ++i) {
                this.goodsProductService.updateGoodsSubtitleById(((GoodsProduct)goodsProduct.get(i)).getGoodsInfoId(), goods.getGoodsSubtitle());
            }
            int result = this.goodsService.updateGoodsNew(goods, map, isThirdAuditUsed, (String)request.getSession().getAttribute("name"));
            if (null != goods.getGoodsName() && 1 == result) {
                String name = (String)request.getSession().getAttribute("name");
                if ("1".equals("1")) {
                    ProductLogger productLogger = new ProductLogger();
                    productLogger.setName(name);
                    productLogger.setProductId(goods.getGoodsNo());
                    productLogger.setProductName(goods.getGoodsName());
                    productLogger.setType("\u5546\u54c1\u4fee\u6539");
                    productLogger.setStatus("0");
                    this.productLoggerService.saveProduct(productLogger);
                }
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)name, (String)"\u4fee\u6539\u5546\u54c1\u4fe1\u606f", (String)("\u4fee\u6539\u5546\u54c1\u4fe1\u606f-->\u5546\u54c1\u540d\u79f0\u3010" + goods.getGoodsName() + VARNAME + name));
                LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u4fe1\u606f,\u5546\u54c1\u540d\u79f0\u4e3a:" + goods.getGoodsName()));
            }
            if ("0".equals(goods.getIsThird())) {
                return new ModelAndView((View)new RedirectView("findAllGoods.htm?pageNo=" + pageNo + PAGESIZE + pageSize));
            }
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return new ModelAndView((View)new RedirectView("findAllGoods.htm?pageNo=" + pageNo + PAGESIZE + pageSize));
        }
        return new ModelAndView((View)new RedirectView("findAllGoodsisthird.htm?pageNo=" + pageNo + PAGESIZE + pageSize));
    }

    @RequestMapping(value={"/updateGoodsParamSpec"})
    public void updateGoodsParamSpec(Goods goods, HttpServletRequest request, HttpServletResponse response) {
        PrintWriter out = null;
        try {
            out = response.getWriter();
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            String[] expandParamId = request.getParameterValues(EXPANDPARAMID);
            String[] expandparamValue = request.getParameterValues(EXPANDPARAMVALUE);
            String[] paramId = request.getParameterValues(PARAMID);
            String[] paramValue = request.getParameterValues(PARAMVALUE);
            String[] productIdSpecIdSpecdetailId = request.getParameterValues(PRODUCTIDSPECIDSPECDETAILID);
            map.put(EXPANDPARAMID, expandParamId);
            map.put(EXPANDPARAMVALUE, expandparamValue);
            map.put(PARAMID, paramId);
            map.put(PARAMVALUE, paramValue);
            map.put(PRODUCTIDSPECIDSPECDETAILID, productIdSpecIdSpecdetailId);
            String isThirdAuditUsed = this.getOnOffService.getOnOffFlag();
            int result = this.goodsService.updateGoodsParamSpec(goods, map, isThirdAuditUsed, (String)request.getSession().getAttribute("name"));
            if (null != goods.getGoodsName() && 1 == result) {
                String name = (String)request.getSession().getAttribute("name");
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)name, (String)"\u4fee\u6539\u5546\u54c1\u53c2\u6570\u548c\u89c4\u683c\u4fe1\u606f", (String)("\u4fee\u6539\u5546\u54c1\u53c2\u6570\u4fe1\u606f-->\u5546\u54c1\u540d\u79f0\u3010" + goods.getGoodsName() + VARNAME + name));
                LOGGER.info((Object)("\u5220\u9664\u5546\u54c1\u4fe1\u606f,\u5546\u54c1\u540d\u79f0\u4e3a:" + goods.getGoodsName()));
            }
            this.searchAsyncService.updateOneGoodsIndexToEs(goods.getGoodsId());
            out.append("<script>parent.call_update_goods();</script>");
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            LOGGER.info((Object)"\u51fa\u9519");
        }
    }

    @RequestMapping(value={"/updateGoodsSta"})
    public ModelAndView updateGoods(Goods upGoods, HttpServletRequest request) {
        Goods goods = new Goods();
        String pageNo = request.getParameter(PAGENO);
        try {
            goods.setGoodsId(upGoods.getGoodsId());
            goods.setGoodsAdded(upGoods.getGoodsAdded());
            goods.setGoodsModifiedName((String)request.getSession().getAttribute("name"));
            int result = this.goodsService.updateGoodsDesc(goods);
            this.searchAsyncService.updateOneGoodsIndexToEs(upGoods.getGoodsId());
            if (null != upGoods.getGoodsName() && 1 == result) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u3010" + upGoods.getGoodsName() + "\u3011\u4e0a\u4e0b\u67b6\u5546\u54c1"), (String)((String)request.getSession().getAttribute("operaPath") + VARNAME2 + (String)request.getSession().getAttribute("name")));
            }
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\uff0c\u66f4\u65b0\u7684\u5546\u54c1\u540d\u79f0\u4e3a," + upGoods.getGoodsName()));
        }
        return new ModelAndView((View)new RedirectView("findAllGoods.htm?pageNo=" + pageNo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/updateGoodsStaisthird"})
    public ModelAndView updateGoodsisthird(Goods upGoods, HttpServletRequest request) {
        Goods goods = new Goods();
        String pageNo = request.getParameter(PAGENO);
        try {
            goods.setGoodsId(upGoods.getGoodsId());
            goods.setGoodsAdded(upGoods.getGoodsAdded());
            goods.setGoodsModifiedName((String)request.getSession().getAttribute("name"));
            int result = this.goodsService.updateGoodsDesc(goods);
            if (null != upGoods.getGoodsName() && 1 == result) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\u3010" + upGoods.getGoodsName() + "\u3011\u4e0a\u4e0b\u67b6\u5546\u54c1"), (String)((String)request.getSession().getAttribute("operaPath") + VARNAME2 + (String)request.getSession().getAttribute("name")));
            }
            this.searchAsyncService.updateThirdOneGoodsIndexToEs(upGoods.getGoodsId());
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            LOGGER.info((Object)("\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\uff0c\u66f4\u65b0\u7684\u7b2c\u4e09\u65b9\u5546\u54c1\u540d\u79f0\u4e3a," + upGoods.getGoodsName()));
        }
        finally {
            goods = null;
        }
        return new ModelAndView((View)new RedirectView("findAllGoodsisthird.htm?pageNo=" + pageNo));
    }

    @RequestMapping(value={"/queryByParam"})
    public ModelAndView queryByParam(PageBean pb, GoodsSearchBean searchBean) {
        pb.setUrl("queryByParam.htm");
        LOGGER.info((Object)"\u9ad8\u7ea7\u67e5\u8be2");
        return new ModelAndView("jsp/goods/goods_list", "pb", (Object)this.goodsService.searchBySearchBeanAndPageBean(pb, searchBean)).addObject(SEARCHBEAN, (Object)searchBean).addObject(BRANDLIST, (Object)this.goodsBrandService.queryAllBrand()).addObject("cateList", (Object)this.goodsCateService.queryAllCate()).addObject(TAGLIST, (Object)this.goodsTagService.queryAllTag());
    }

    @RequestMapping(value={"/queryByParamisthird"})
    public ModelAndView queryByParamisthird(PageBean pb, GoodsSearchBean searchBean, Long oneCateId, Long twoCateId) {
        pb.setUrl("queryByParamisthird.htm");
        LOGGER.info((Object)"\u9ad8\u7ea7\u67e5\u8be2");
        if (StringUtils.isEmpty((String)searchBean.getStatus())) {
            searchBean.setStatus("-1");
        }
        pb = this.goodsService.searchBySearchBeanAndPageBean(pb, searchBean);
        ModelAndView mav = new ModelAndView("jsp/goods/goods_list_isthird", "pageBean", (Object)pb).addObject(SEARCHBEAN, (Object)searchBean).addObject(BRANDLIST, (Object)this.goodsBrandService.queryAllBrand()).addObject("cateList", (Object)this.goodsCateService.queryAllCate()).addObject(TAGLIST, (Object)this.goodsTagService.queryAllTag());
        List oneCateList = this.goodsCateService.querySonCateByParentIdAndName(Long.valueOf(0L), null);
        mav.addObject(ONECATELIST, (Object)oneCateList);
        if (oneCateId != null) {
            List twoCateList = this.goodsCateService.querySonCateByParentIdAndName(oneCateId, null);
            mav.addObject("twoCateList", (Object)twoCateList);
            if (twoCateId != null) {
                List threeCateList = this.goodsCateService.querySonCateByParentIdAndName(twoCateId, null);
                mav.addObject("threeCateList", (Object)threeCateList);
            }
        }
        mav.addObject("oneCateId", (Object)oneCateId);
        mav.addObject("twoCateId", (Object)twoCateId);
        return mav;
    }

    @RequestMapping(value={"/toAddGoods"})
    public ModelAndView toAddGoods() {
        LOGGER.info((Object)"\u8df3\u8f6c\u5230\u6dfb\u52a0\u5546\u54c1\u7684\u9875\u9762");
        return new ModelAndView("jsp/goods/goodsAdd").addObject(BRANDLIST, (Object)this.goodsBrandService.queryAllBrand()).addObject("cateList", (Object)this.goodsCateService.queryAllCate()).addObject(TAGLIST, (Object)this.goodsTagService.queryAllTag());
    }

    @RequestMapping(value={"/toModifyGoods"})
    public ModelAndView toModifyGoods(Long goodsId, int pageNo, int pageSize, Long isThird) {
        Long isThirdNew = isThird;
        LOGGER.info((Object)"\u8df3\u8f6c\u5230\u4fee\u6539\u5546\u54c1\u4fe1\u606f\u7684\u9875\u9762");
        if (isThirdNew == null) {
            isThirdNew = 0L;
        }
        return new ModelAndView("jsp/goods/goodsModify").addObject(BRANDLIST, (Object)this.goodsBrandService.queryAllBrand()).addObject("goodsMoifiedVo", (Object)this.goodsService.queryModeifiedVoByGoodsId(goodsId)).addObject("cateList", (Object)this.goodsCateService.queryAllCate()).addObject(TAGLIST, (Object)this.goodsTagService.queryAllTag()).addObject("goodsId", (Object)goodsId).addObject(PAGENO, (Object)pageNo).addObject("pageSize", (Object)pageSize).addObject("isThird", (Object)isThirdNew);
    }

    @RequestMapping(value={"/toModifyGoodsNew"})
    public ModelAndView toModifyGoodsNew(Long goodsId, int pageNo, int pageSize, Long isThird) {
        ModelAndView mav = new ModelAndView();
        Long isThirdNew = isThird;
        if (isThirdNew == null) {
            isThirdNew = 0L;
        }
        try {
            GoodsMoifiedVo goodsMoifiedVo = this.goodsService.queryModeifiedVoByGoodsId(goodsId);
            Long catId = goodsMoifiedVo.getGoodsCate().getCatId();
            String catName = goodsMoifiedVo.getGoodsCate().getCatName();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("catId", catId);
            paramMap.put("catName", catName);
            String allCatName = this.goodsCateService.getAllCatName(paramMap).get("catName").toString();
            LOGGER.info((Object)("allCatName:" + allCatName));
            List products = this.goodsProductService.queryProductListByGoodsId(goodsId);
            if (products != null && products.size() > 0) {
                for (GoodsProductVo product : products) {
                    List imgs = this.goodsImageService.queryImageListByProductId(product.getGoodsInfoId());
                    product.setImages(imgs);
                }
            }
            mav.addObject("goodsId", (Object)goodsId);
            mav.addObject("allCatName", (Object)allCatName);
            mav.addObject("isThird", (Object)isThirdNew);
            mav.addObject(PAGENO, (Object)pageNo);
            mav.addObject("pageSize", (Object)pageSize);
            mav.addObject("goodsMoifiedVo", (Object)goodsMoifiedVo);
            mav.addObject("products", (Object)products);
            mav.addObject(BRANDLIST, (Object)this.goodsBrandService.queryAllBrand());
            mav.addObject(TAGLIST, (Object)this.goodsTagService.queryAllTag());
            mav.addObject("support", (Object)this.serviceSupportMapperService.selectAll());
            mav.addObject("wareHouse", (Object)this.wareHouseService.queryAllWareHouse());
            mav.setViewName("jsp/goods/goodsModify");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6839\u636e\u5546\u54c1id\u67e5\u8be2\u5546\u54c1\u76f8\u5173\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/exportGoodsList"})
    public void exportGoodsList(HttpServletResponse response, GoodsSearchBean searchBean) throws IOException {
        LOGGER.info((Object)"\u5bfc\u51fa\u6240\u6709\u7684\u5546\u54c1\u4fe1\u606f");
        ExportGoodsList.exportGoodsList((List)this.goodsService.queryAllGoodsForExport(searchBean.getIsThird()), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/exportGoodsPageList"})
    public void exportGoodsPageList(PageBean pb, HttpServletResponse response, GoodsSearchBean searchBean) {
        LOGGER.info((Object)"\u5bfc\u51fa\u5f53\u524d\u9875\u7684\u5546\u54c1\u6570\u636e");
        ExportGoodsList.exportGoodsList((List)this.goodsService.searchBySearchBeanAndPageBean(pb, searchBean).getList(), (HttpServletResponse)response);
    }

    @RequestMapping(value={"/exportGoodsCheck"})
    public void exportGoodsCheck(HttpServletResponse response, Long[] goodsIds) {
        LOGGER.info((Object)"\u5bfc\u51fa\u9009\u4e2d\u7684\u5546\u54c1\u6570\u636e");
        if (null != goodsIds) {
            ExportGoodsList.exportGoodsList((List)this.goodsService.queryGoodsListVoListForExportByGoodsIds(goodsIds), (HttpServletResponse)response);
        } else {
            ExportGoodsList.exportGoodsList(null, (HttpServletResponse)response);
        }
    }

    @RequestMapping(value={"/batchCreateProduct"})
    public ModelAndView batchCreateProduct(Long goodsId, HttpServletRequest request) {
        try {
            this.goodsService.saveProductWhenClickBatchCreate(goodsId, (String)request.getSession().getAttribute("name"));
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u751f\u6210\u8d27\u54c1", (String)((String)request.getSession().getAttribute("operaPath") + VARNAME2 + (String)request.getSession().getAttribute("name")));
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return new ModelAndView((View)new RedirectView("queryAllByGoodsId.htm?goodsId=" + goodsId));
        }
        return new ModelAndView((View)new RedirectView("queryAllByGoodsId.htm?goodsId=" + goodsId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/syncGoodsinfo"})
    public void syncGoodsinfo(HttpServletRequest request, HttpServletResponse response) throws IOException {
        JSONObject jsonObject = null;
        String data = this.getBody(request);
        HashMap<String, String> returnObj = new HashMap<String, String>();
        try {
            data = URLDecoder.decode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            returnObj.put("resultCode", "0");
            returnObj.put("message", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u6570\u636e");
            jsonObject = JSONObject.fromObject(returnObj);
            response.setContentType("text/html;charset=utf-8");
            PrintWriter out = null;
            try {
                out = response.getWriter();
                out.print(jsonObject);
                out.flush();
                out.close();
            }
            catch (IOException es) {
                es.printStackTrace();
            }
            return;
        }
        if (null == data) {
            returnObj.put("resultCode", "0");
            returnObj.put("message", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u6570\u636e");
        } else {
            JSONObject object = JSONObject.fromObject((Object)data);
            Long catId = object.getLong("cat_id");
            Long brandId = object.getLong("brand_id");
            String goodsImg = object.getString("goods_img");
            String goodsInfoItemNo = object.getString("goods_info_item_no");
            String goodsNo = object.getString("goods_no");
            String goodsName = object.getString("goods_name");
            String desc = object.getString("desc");
            String goodsPrice = object.getString("goods_price");
            JSONArray expandParamIdList = object.getJSONArray("expand_param_id");
            JSONArray expandParamValueList = object.getJSONArray("expand_param_value");
            JSONArray specsList = object.getJSONArray("specs");
            JSONArray specsValueList = object.getJSONArray("specs_value");
            JSONArray specsValueRemarkArrayList = object.getJSONArray("specs_value_remark");
            PrintWriter out = response.getWriter();
            String[] expandParamId = new String[expandParamIdList.size()];
            String[] expandParamValue = new String[expandParamValueList.size()];
            String[] specs = new String[specsList.size()];
            String[] specsValue = new String[specsValueList.size()];
            String[] specsValueRemark = new String[specsValueRemarkArrayList.size()];
            int index = 0;
            int index_2 = 0;
            int index_3 = 0;
            int index_4 = 0;
            int index_5 = 0;
            for (Map map : expandParamIdList) {
                expandParamId[index] = map.get("id").toString();
                ++index;
            }
            for (Map map : expandParamValueList) {
                expandParamValue[index_2] = map.get("value").toString();
                ++index_2;
            }
            for (Map map : specsList) {
                specs[index_3] = map.get("id").toString();
                ++index_3;
            }
            for (Map map : specsValueList) {
                specsValue[index_4] = map.get("value").toString();
                ++index_4;
            }
            for (Map map : specsValueRemarkArrayList) {
                specsValueRemark[index_5] = map.get("remark").toString();
                ++index_5;
            }
            HashMap<String, String[]> map = new HashMap<String, String[]>();
            Goods goods = new Goods();
            goods.setBrandId(brandId);
            goods.setCatId(catId);
            goods.setGoodsAdded("1");
            goods.setGoodsNo(goodsNo);
            goods.setGoodsName(goodsName);
            goods.setGoodsImg(goodsImg);
            goods.setGoodsInfoItemNo(goodsInfoItemNo);
            goods.setMobileDesc(desc);
            goods.setIsThird("0");
            goods.setGoodsBelo(Long.valueOf(0L));
            goods.setGoodsBeloName("BOSS");
            goods.setGoodsPrice(new BigDecimal(goodsPrice));
            Long newId = null;
            try {
                map.put("expandParamIds", expandParamId);
                map.put("expandParamValues", expandParamValue);
                map.put(ABOUTGOODSID, null);
                map.put("specId", specs);
                map.put("specValues", specsValue);
                map.put("openSpecValueRemark", specsValueRemark);
                map.put("openSpecValueImg", new String[]{goodsImg});
                goods.setIsThird("0");
                goods.setGoodsBelo(Long.valueOf(0L));
                goods.setGoodsBeloName("BOSS");
                newId = this.goodsService.saveGoodsInterface(goods, name, map);
                ProductLogger productLogger = new ProductLogger();
                productLogger.setName(name);
                productLogger.setProductId(goods.getGoodsNo());
                productLogger.setProductName(goods.getGoodsName());
                productLogger.setType("\u5546\u54c1\u540c\u6b65");
                productLogger.setStatus("0");
                this.productLoggerService.saveProduct(productLogger);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("\u51fa\u9519\u4e86\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
            }
            finally {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)name, (String)"\u4fdd\u5b58\u5546\u54c1\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + VARNAME2 + name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBody(HttpServletRequest request) {
        String body = null;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            request.setCharacterEncoding("UTF-8");
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, "UTF-8"));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                    System.out.println(charBuffer);
                }
            } else {
                stringBuilder.append("");
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    System.out.println(ex.toString());
                }
            }
        }
        body = stringBuilder.toString();
        return body;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/newUploadGood"})
    public void newUploadGood(Goods goods, HttpServletRequest request, HttpServletResponse resp, Long importGoodsId, String importGoodsIdArray) throws IOException {
        PrintWriter out = resp.getWriter();
        String[] about = null;
        if (null != importGoodsIdArray && !"".equals(importGoodsIdArray)) {
            about = importGoodsIdArray.split(",");
        }
        String[] tags = request.getParameterValues("tags");
        String[] paramId = request.getParameterValues(PARAMID);
        String[] paramValue = request.getParameterValues(PARAMVALUE);
        String[] expandParamId = request.getParameterValues(EXPANDPARAMID);
        String[] expandParamValue = request.getParameterValues(EXPANDPARAMVALUE);
        String[] specs = request.getParameterValues("specs");
        String[] specsValue = request.getParameterValues("specsValue");
        String[] specsValueImg = request.getParameterValues("specsValueImg");
        String[] specsValueRemark = request.getParameterValues("specsValueRemark");
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (importGoodsId != null && this.goodsImportService.selectByPrimaryKey(importGoodsId) != null) {
            this.goodsImportService.updateGoodsImportAdded(importGoodsId);
        }
        request.getSession().setAttribute("importGoodsId", (Object)"");
        Long newId = null;
        try {
            map.put("tags", tags);
            map.put("expandParamIds", expandParamId);
            map.put("expandParamValues", expandParamValue);
            map.put("paramIds", paramId);
            map.put(PARAMVALUE, paramValue);
            map.put(ABOUTGOODSID, about);
            map.put("specId", specs);
            map.put("specValues", specsValue);
            map.put("openSpecValueImg", specsValueImg);
            map.put("openSpecValueRemark", specsValueRemark);
            goods.setIsThird("0");
            goods.setGoodsBelo(Long.valueOf(0L));
            goods.setGoodsBeloName("BOSS");
            newId = this.goodsService.saveGoods(goods, (String)request.getSession().getAttribute("name"), map);
            if ("1".equals("1")) {
                ProductLogger productLogger = new ProductLogger();
                productLogger.setName((String)request.getSession().getAttribute("name"));
                productLogger.setProductId(goods.getGoodsNo());
                productLogger.setProductName(goods.getGoodsName());
                productLogger.setType("\u5546\u54c1\u53d1\u5e03");
                productLogger.setStatus("0");
                this.productLoggerService.saveProduct(productLogger);
            }
            out.append("<script>parent.call_save_goods('" + newId + "');</script>");
        }
        finally {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u4fdd\u5b58\u5546\u54c1\u4fe1\u606f", (String)((String)request.getSession().getAttribute("operaPath") + VARNAME2 + (String)request.getSession().getAttribute("name")));
            out.flush();
            tags = null;
            paramId = null;
            paramValue = null;
            expandParamId = null;
            expandParamValue = null;
            specs = null;
            specsValue = null;
            specsValueImg = null;
            about = null;
            map = null;
            newId = null;
        }
    }

    @RequestMapping(value={"/newUploadSaveGoodsDesc"})
    public void newUploadSaveGoodsDesc(Long goodsId, String goodsDetailDesc, String goodsMobileDesc, String goodsMobileDesc2, String goodsMobileDesc3, String goodsMobileDesc4, String goodsMobileDesc5, String goodsMobileDesc6, HttpServletResponse resp, HttpServletRequest request) throws IOException {
        PrintWriter out = resp.getWriter();
        Goods goods = new Goods();
        goods.setGoodsId(goodsId);
        if (null != goodsDetailDesc && goodsDetailDesc.length() > 0 && !"".equals(goodsDetailDesc)) {
            goods.setGoodsDetailDesc(goodsDetailDesc);
        } else {
            goods.setGoodsDetailDesc("");
        }
        if (null != goodsMobileDesc && goodsMobileDesc.length() > 0 && !"".equals(goodsMobileDesc)) {
            goods.setMobileDesc(goodsMobileDesc);
        } else {
            goods.setMobileDesc("");
        }
        if (null != goodsMobileDesc2 && goodsMobileDesc2.length() > 0 && !"".equals(goodsMobileDesc2)) {
            goods.setMobileDesc2(goodsMobileDesc2);
        } else {
            goods.setMobileDesc2("");
        }
        if (null != goodsMobileDesc3 && goodsMobileDesc3.length() > 0 && !"".equals(goodsMobileDesc3)) {
            goods.setMobileDesc3(goodsMobileDesc3);
        } else {
            goods.setMobileDesc3("");
        }
        if (null != goodsMobileDesc4 && goodsMobileDesc4.length() > 0 && !"".equals(goodsMobileDesc4)) {
            goods.setMobileDesc4(goodsMobileDesc4);
        } else {
            goods.setMobileDesc4("");
        }
        if (null != goodsMobileDesc5 && goodsMobileDesc5.length() > 0 && !"".equals(goodsMobileDesc5)) {
            goods.setMobileDesc5(goodsMobileDesc5);
        } else {
            goods.setMobileDesc5("");
        }
        if (null != goodsMobileDesc6 && goodsMobileDesc6.length() > 0 && !"".equals(goodsMobileDesc6)) {
            goods.setMobileDesc6(goodsMobileDesc6);
        } else {
            goods.setMobileDesc6("");
        }
        GoodsMoifiedVo goodsMoifiedVo = this.goodsService.queryModeifiedVoByGoodsId(goodsId);
        if (1 == this.goodsService.updateGoodsDesc(goods) && null != goodsMoifiedVo.getGoodsName()) {
            LOGGER.info((Object)("\u66f4\u65b0\u7684\u5546\u54c1" + goodsMoifiedVo.getGoodsName() + "\u6210\u529f\uff01"));
        } else {
            this.goodsService.updateGoodsDesc(goods);
        }
        out.append("<script>parent.call_save_desc('" + goodsId + "');</script>");
    }

    @RequestMapping(value={"/batchDownGoods"})
    public ModelAndView batchDownGoods(Long[] goodsIds, HttpServletRequest request) {
        this.goodsService.batchDown(goodsIds, (String)request.getSession().getAttribute("name"));
        return new ModelAndView((View)new RedirectView("findAllGoods.htm"));
    }

    @RequestMapping(value={"/batchUpGoods"})
    public ModelAndView batchUpGoods(Long[] goodsIds, HttpServletRequest request) {
        this.goodsService.batchUp(goodsIds, (String)request.getSession().getAttribute("name"));
        return new ModelAndView((View)new RedirectView("findAllGoods.htm"));
    }

    @RequestMapping(value={"/deleteRelatedProduct"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int deleteRelatedProduct(Long relatedId, Long relatedProductId) {
        if (null != relatedId && null != relatedProductId) {
            return this.relatedGoodsService.deleteRelatedProduct(relatedId, relatedProductId);
        }
        return 0;
    }

    @RequestMapping(value={"/batchUpdateStock"})
    public ModelAndView batchUpdateStock(HttpServletRequest request, Long[] goodsIds, String stock) {
        int num = 0;
        if (stock != null) {
            ConcurrentHashMap<String, Object> requestmap = new ConcurrentHashMap<String, Object>();
            requestmap.put("name", request.getSession().getAttribute("name"));
            requestmap.put("url", request.getRequestURL().toString());
            requestmap.put("ip", IPAddress.getIpAddr((HttpServletRequest)request));
            requestmap.put("loginUserId", (Long)request.getSession().getAttribute("loginUserId"));
            Customer cust = (Customer)request.getSession().getAttribute("cust");
            if (null != cust) {
                requestmap.put("customerUsername", cust.getCustomerUsername());
            }
            num = this.goodsService.batchUpdateStock(requestmap, goodsIds, stock);
        }
        return new ModelAndView((View)new RedirectView("findAllGoods.htm"));
    }

    @RequestMapping(value={"/batchUpdateProduct"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String batchUpdateProduct(HttpServletRequest request) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("status", "0");
        result.put("msg", "\u5931\u8d25");
        try {
            String[] products = request.getParameterValues("products");
            if (products != null && products.length > 0) {
                ArrayList<Map> goodInfos = new ArrayList<Map>();
                for (String info : products) {
                    if (StringUtils.isEmpty((String)info)) continue;
                    Map goodsInfo = (Map)com.alibaba.fastjson.JSONObject.parseObject((String)info, Map.class);
                    goodInfos.add(goodsInfo);
                }
                if (goodInfos.size() > 0) {
                    this.goodsProductService.batchUpdateGoodsInfo(goodInfos);
                    result.put("status", "1");
                    result.put("msg", "\u6210\u529f");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return com.alibaba.fastjson.JSONObject.toJSONString(result);
    }

    @RequestMapping(value={"/updateGoodsUpCate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> updateGoodsUpCate(HttpServletRequest request) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("status", "0");
        result.put("msg", "\u5931\u8d25");
        String[] products = request.getParameterValues("products");
        String[] specs = request.getParameterValues("specs");
        if (products != null && specs != null) {
            Customer cust = (Customer)request.getSession().getAttribute("cust");
            String ip = IPAddress.getIpAddr((HttpServletRequest)request);
            String name = (String)request.getSession().getAttribute("name");
            Long loginUserId = (Long)request.getSession().getAttribute("loginUserId");
            this.goodsService.addGoods(cust, ip, name, loginUserId, products, specs);
            result.put("status", "1");
            result.put("msg", "\u6210\u529f");
        }
        return result;
    }

    public ProductWareService getProductWareService() {
        return this.productWareService;
    }

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }

    public GoodsTagService getGoodsTagService() {
        return this.goodsTagService;
    }

    @Resource(name="GoodsTagServiceImpl")
    public void setGoodsTagService(GoodsTagService goodsTagService) {
        this.goodsTagService = goodsTagService;
    }

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="GoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }

    public GoodsService getGoodsService() {
        return this.goodsService;
    }

    @Resource(name="GoodsService")
    public void setGoodsService(GoodsService goodsService) {
        this.goodsService = goodsService;
    }

    @Resource(name="ProductWareService")
    public void setProductWareService(ProductWareService productWareService) {
        this.productWareService = productWareService;
    }

    public WareHouseService getWareHouseService() {
        return this.wareHouseService;
    }

    @Resource(name="WareHouseService")
    public void setWareHouseService(WareHouseService wareHouseService) {
        this.wareHouseService = wareHouseService;
    }
}

