/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.controller;

import com.qianjiang.mobile.bean.MobAdver;
import com.qianjiang.mobile.service.MobAdverService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.Arrays;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class MobAdverController {
    private static final String REDIRECT = "queryMobAdverByStoreyIdAndPb.htm?storeyId=";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    @Resource(name="MobAdverService")
    private MobAdverService mobAdverService;

    @RequestMapping(value={"/queryMobAdverByStoreyIdAndPb"})
    public ModelAndView queryMobAdverByStoreyIdAndPb(PageBean pb, Long storeyId) {
        return new ModelAndView("jsp/mobile/mobadver_list", "pb", (Object)this.mobAdverService.selectByStoreyIdAndPb(pb, storeyId)).addObject("storeyId", (Object)storeyId);
    }

    @RequestMapping(value={"/showMobAdver"})
    public ModelAndView showMobAdver(Long mobAdverId, Long storeyId) {
        MobAdver mobAdver;
        ModelAndView mav = new ModelAndView();
        if (null != mobAdverId && null != (mobAdver = this.mobAdverService.getMobAdver(mobAdverId))) {
            mav.addObject("mobAdver", (Object)mobAdver);
        }
        mav.addObject("storeyId", (Object)storeyId);
        mav.setViewName("jsp/mobile/show_mobadver");
        return mav;
    }

    @RequestMapping(value={"/createMobAdver"})
    public ModelAndView createMobAdver(@Valid MobAdver mobAdver, BindingResult bindingResult, MultipartHttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(REDIRECT + mobAdver.getStoreyId()));
        }
        MultipartFile muFile = request.getFile("imgSrc");
        if (null != muFile && muFile.getSize() > 0L) {
            mobAdver.setAdverImgSrc(UploadUtil.uploadFileOne((MultipartFile)muFile));
        }
        this.mobAdverService.createMobAdver(mobAdver);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u79fb\u52a8\u7248\u5e7f\u544a", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT + mobAdver.getStoreyId()));
    }

    @RequestMapping(value={"/updateMobAdver"})
    public ModelAndView updateMobAdver(@Valid MobAdver mobAdver, BindingResult bindingResult, MultipartHttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(REDIRECT + mobAdver.getStoreyId()));
        }
        MultipartFile muFile = request.getFile("imgSrc");
        if (null != muFile && muFile.getSize() > 0L) {
            mobAdver.setAdverImgSrc(UploadUtil.uploadFileOne((MultipartFile)muFile));
        }
        this.mobAdverService.updateMobAdver(mobAdver);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u79fb\u52a8\u7248\u5e7f\u544a", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT + mobAdver.getStoreyId()));
    }

    @RequestMapping(value={"/batchDelMobAdver"})
    public ModelAndView batchDelMobAdver(Long[] adverId, Long storeyId, HttpServletRequest request) {
        this.mobAdverService.batchDelMobAdver(Arrays.asList(adverId));
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u79fb\u52a8\u7248\u5e7f\u544a", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT + storeyId));
    }

    @RequestMapping(value={"/changeMobAdverUserdStatus"})
    public ModelAndView changeMobAdverUserdStatus(Long mobAdverId, Long storeyId, HttpServletRequest request) {
        this.mobAdverService.changeMobAdverUserdStatus(mobAdverId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u79fb\u52a8\u7248\u5e7f\u544a\u542f\u7528\u72b6\u6001", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT + storeyId));
    }
}

