/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.uploadfileset.controller;

import com.qianjiang.uploadfileset.bean.UploadFileSet;
import com.qianjiang.uploadfileset.service.UploadFileSetService;
import com.qianjiang.util.PropertieUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class UploadFileSetController {
    private static final String SUFFIXARRAY = "suffixArray";
    @Resource(name="UploadFileSetService")
    private UploadFileSetService uploadFileSetService;

    @ResponseBody
    @RequestMapping(value={"/getUploadFileSet"}, produces={"application/json;charset=UTF-8"})
    public Map<String, Object> getUploadFileSet() {
        UploadFileSet ufs = this.uploadFileSetService.getCurrUploadFileSet();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxSize", ufs.getMaxSize());
        String[] suffixArray = ufs.getSuffixArray().split(",");
        map.put(SUFFIXARRAY, suffixArray);
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/updateUploadFileSet"}, produces={"application/json;charset=UTF-8"})
    public Map<String, Object> updateUploadFileSet(Long maxSize, HttpServletRequest request) {
        Properties properties = PropertieUtil.readPropertiesFile((InputStream)this.getClass().getClassLoader().getResourceAsStream("config/image.properties"));
        String[] extendNames = properties.get("FILE_EXTEND_NAME").toString().split(",");
        HashMap<String, Object> map = new HashMap<String, Object>();
        String[] suffixArray = request.getParameterValues("suffixArray[]");
        map.put("maxSize", maxSize);
        map.put(SUFFIXARRAY, suffixArray);
        UploadFileSet ufs = this.uploadFileSetService.getCurrUploadFileSet();
        ufs.setMaxSize(maxSize);
        StringBuilder suffixs = new StringBuilder();
        if (suffixArray != null) {
            for (int i = 0; i < suffixArray.length; ++i) {
                boolean isExtendNameValid = false;
                for (String extendName : extendNames) {
                    if (!suffixArray[i].equals(extendName)) continue;
                    isExtendNameValid = true;
                    break;
                }
                if (!isExtendNameValid) continue;
                suffixs.append(suffixArray[i] + ",");
            }
            ufs.setSuffixArray(suffixs.toString());
        }
        map.put(SUFFIXARRAY, suffixs.toString().split(","));
        this.uploadFileSetService.updateUploadFileSet(ufs);
        return map;
    }

    @ResponseBody
    @RequestMapping(value={"/updateUploadFileSetNew"}, produces={"application/json;charset=UTF-8"})
    public int updateUploadFileSetNew(UploadFileSet ufs, HttpServletRequest request) {
        this.uploadFileSetService.updateUploadFileSet(ufs);
        return 1;
    }
}

