/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.controller;

import com.qianjiang.common.util.DateUtil;
import com.qianjiang.customer.bean.Customer;
import com.qianjiang.customer.bean.CustomerInfo;
import com.qianjiang.customer.bean.CustomerLogger;
import com.qianjiang.customer.bean.CustomerPoint;
import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.service.CustomerFollowServiceMapper;
import com.qianjiang.customer.service.CustomerLoggerService;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.vo.CustomerStatisticVo;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.other.bean.CityBean;
import com.qianjiang.other.bean.CustBean;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.other.bean.DistrictBean;
import com.qianjiang.other.bean.ProvinceBean;
import com.qianjiang.other.bean.StreetBean;
import com.qianjiang.other.util.IPAddress;
import com.qianjiang.other.util.SelectBean;
import com.qianjiang.third.supplier.service.StoreInfoService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UtilDate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="customerController")
public class CustomerController {
    private static final MyLogger LOGGER = new MyLogger(CustomerController.class);
    private static final String PAGEBEAN = "pageBean";
    private static final String LOGGERINFO = ",\u7528\u6237\u7f16\u53f7:";
    private CustomerServiceMapper customerServiceMapper;
    private CustomerFollowServiceMapper customerFollowServiceMapper;
    @Resource(name="StoreServiceMix")
    private StoreInfoService storeInfoService;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Resource(name="customerLoggerService")
    private CustomerLoggerService customerLoggerService;

    @RequestMapping(value={"/syncCustomerBalance"})
    public void syncCustomerBalance(HttpServletRequest request, HttpServletResponse response) {
        int result = 0;
        JSONObject jsonObject = null;
        String data = this.getBody(request);
        HashMap<String, String> returnObj = new HashMap<String, String>();
        try {
            data = URLDecoder.decode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            returnObj.put("resultCode", "0");
            returnObj.put("message", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u6570\u636e");
            jsonObject = JSONObject.fromObject(returnObj);
            response.setContentType("text/html;charset=utf-8");
            PrintWriter out = null;
            try {
                out = response.getWriter();
                out.print(jsonObject);
                out.flush();
                out.close();
            }
            catch (IOException es) {
                es.printStackTrace();
            }
            return;
        }
        if (null == data) {
            returnObj.put("resultCode", "0");
            returnObj.put("message", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u6570\u636e");
        } else {
            try {
                JSONObject object = JSONObject.fromObject((Object)data);
                System.out.println("\u50a8\u503c\u6570\u636e" + object);
                String infoMobile = object.getString("info_mobile");
                String customerBalance = object.getString("customer_balance");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("infoMobile", infoMobile);
                map.put("customerBalance", customerBalance);
                int num = this.customerServiceMapper.updateCustomerByInfomobile(map);
                result = num > 0 ? num : 0;
                returnObj.put("resultCode", "" + result);
                returnObj.put("message", "\u4fee\u6539\u4f1a\u5458\u4f59\u989d\u6210\u529f");
            }
            catch (Exception e) {
                e.printStackTrace();
                result = 0;
            }
            jsonObject = JSONObject.fromObject(returnObj);
            System.out.println("===return ==jsonObject=" + jsonObject.toString());
            response.setContentType("text/html;charset=utf-8");
            PrintWriter out = null;
            try {
                out = response.getWriter();
                out.print(jsonObject);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/syncCustomer"})
    public void syncCustomer(HttpServletRequest request, HttpServletResponse response) {
        int result = 0;
        JSONObject jsonObject = null;
        String data = this.getBody(request);
        HashMap<String, String> returnObj = new HashMap<String, String>();
        try {
            data = URLDecoder.decode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            returnObj.put("resultCode", "0");
            returnObj.put("message", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u6570\u636e");
            jsonObject = JSONObject.fromObject(returnObj);
            response.setContentType("text/html;charset=utf-8");
            PrintWriter out = null;
            try {
                out = response.getWriter();
                out.print(jsonObject);
                out.flush();
                out.close();
            }
            catch (IOException es) {
                es.printStackTrace();
            }
            return;
        }
        if (null == data) {
            returnObj.put("resultCode", "0");
            returnObj.put("message", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u6570\u636e");
        } else {
            try {
                JSONArray argArray;
                JSONObject object = JSONObject.fromObject((Object)data);
                JSONArray argMapList = argArray = object.getJSONArray("customerList");
                for (Map map : argMapList) {
                    String customerId = map.get("customer_id").toString();
                    String customerPassword = map.get("customer_password").toString();
                    String customerUsername = map.get("customer_username").toString();
                    String infoMobileP = object.getString("info_mobile_p");
                    String infoRealname = map.get("info_realname").toString();
                    String birthday = map.get("birthday").toString();
                    String infoMobile = map.get("info_mobile").toString();
                    CustomerInfo customerInfo = this.customerPointServiceMapper.selectCustInfoByMobile(infoMobileP);
                    CustomerAllInfo allInfo = new CustomerAllInfo();
                    allInfo.setCustomerUsername(infoMobile);
                    allInfo.setCustomerNickname(infoMobile);
                    allInfo.setCustomerPassword("111111");
                    allInfo.setStartRowNum(0);
                    allInfo.setEndRowNum(0);
                    allInfo.setInfoMobile(infoMobile);
                    allInfo.setIsSeller("0");
                    allInfo.setIsMobile("1");
                    allInfo.setInfoBirthday(birthday);
                    allInfo.setInfoRealname(infoRealname);
                    if (customerInfo != null) {
                        allInfo.setPid(customerInfo.getCustomerId());
                    }
                    this.customerServiceMapper.addCustomer(allInfo);
                    result = 1;
                    returnObj.put("resultCode", "" + result);
                    returnObj.put("message", "\u521b\u5efa\u4f1a\u5458\u6210\u529f");
                    System.out.println("\u6ce8\u518c\u7528\u6237\u4fe1\u606f \u7ed3\u679c \u7528\u6237\u540d=" + customerUsername + ",\u7ed3\u679c" + result);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = 0;
            }
            jsonObject = JSONObject.fromObject(returnObj);
            System.out.println("===return ==jsonObject=" + jsonObject.toString());
            response.setContentType("text/html;charset=utf-8");
            PrintWriter out = null;
            try {
                out = response.getWriter();
                out.print(jsonObject);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBody(HttpServletRequest request) {
        String body = null;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            request.setCharacterEncoding("UTF-8");
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, "UTF-8"));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                    System.out.println(charBuffer);
                }
            } else {
                stringBuilder.append("");
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    System.out.println(ex.toString());
                }
            }
        }
        body = stringBuilder.toString();
        return body;
    }

    @RequestMapping(value={"/initCustomer"})
    public ModelAndView initMethod(PageBean pageBean, CustomerAllInfo allinfo, String customerType) {
        ModelAndView mav = null;
        pageBean.setUrl("initCustomer.htm");
        String startTime = "";
        String endTime = "";
        try {
            if (customerType != null && "1".equals(customerType)) {
                startTime = DateUtil.getSysCurrentDate() + " 00:00:00";
                endTime = DateUtil.getSysCurrentDate() + " 23:59:59";
                allinfo.setStartTime(startTime);
                allinfo.setEndTime(endTime);
            } else if (customerType != null && "2".equals(customerType)) {
                startTime = DateUtil.dateSub((int)-1) + " 00:00:00";
                endTime = DateUtil.dateSub((int)-1) + " 23:59:59";
                allinfo.setStartTime(startTime);
                allinfo.setEndTime(endTime);
            }
            PageBean pageBeans = this.customerServiceMapper.selectCustmerByAllInfo(allinfo, pageBean);
            this.setCustomerPointLevelName(pageBeans);
            mav = new ModelAndView("jsp/customer/customerlist", PAGEBEAN, (Object)pageBeans);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u4f1a\u5458\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    private void setCustomerPointLevelName(PageBean pageBean) {
        List list = pageBean.getList();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        CustomerAllInfo customerAllInfo = null;
        for (Object o : list) {
            if (o.getClass() != CustomerAllInfo.class) continue;
            customerAllInfo = (CustomerAllInfo)o;
            customerAllInfo.setPointLevelName(this.getCustomerPointLevelName(customerAllInfo.getCustomerId()));
        }
    }

    @RequestMapping(value={"/addCustomer"})
    public ModelAndView addCustomer(@Valid CustomerAllInfo allinfo, HttpServletRequest request, MultipartHttpServletRequest multipartRequest) {
        if (null != allinfo.getInfoRealname()) {
            LOGGER.info((Object)("\u4fdd\u5b58\u540d\u79f0\u4e3a\u3010" + allinfo.getInfoRealname() + "\u3011\u7684\u4f1a\u5458\u4fe1\u606f"));
        }
        allinfo.setLoginIp(IPAddress.getIpAddr((HttpServletRequest)request));
        allinfo.setIsSeller("0");
        if (StringUtils.isNotEmpty((String)allinfo.getInfoMobile())) {
            allinfo.setIsMobile("1");
        }
        if (StringUtils.isNotEmpty((String)allinfo.getInfoEmail())) {
            allinfo.setIsEmail("1");
        }
        this.customerServiceMapper.addCustomer(allinfo);
        if ("1".equals("1")) {
            CustomerLogger customerLogger = new CustomerLogger();
            customerLogger.setName((String)request.getSession().getAttribute("name"));
            customerLogger.setCustomerId(null == allinfo.getCustomerId() ? null : allinfo.getCustomerId().toString());
            customerLogger.setType("\u624b\u52a8\u6dfb\u52a0\u4f1a\u5458");
            customerLogger.setCustomerName(allinfo.getCustomerUsername());
            customerLogger.setStatus("0");
            this.customerLoggerService.saveLogger(customerLogger);
        }
        LOGGER.debug("\u6dfb\u52a0\u4f1a\u5458:" + allinfo.getCustomerUsername());
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6dfb\u52a0\u4f1a\u5458:", (String)(request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d:" + allinfo.getCustomerUsername()));
        return new ModelAndView((View)new RedirectView("initCustomer.htm"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/deleteCustomer"})
    public ModelAndView deleteCustomer(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pr = null;
        String[] customerIds = null;
        StringBuilder str = new StringBuilder("[");
        String empStr = "";
        try {
            pr = response.getWriter();
            customerIds = request.getParameterValues("parameterIds[]");
            pr.print(this.customerServiceMapper.deleteCustomer(customerIds));
            for (String id : customerIds) {
                str.append(id + ",");
            }
            for (int i = 0; i < customerIds.length; ++i) {
                if (!"1".equals(this.customerServiceMapper.selectStatus(customerIds[i]))) continue;
                String id = this.customerServiceMapper.findStore(customerIds[i]);
                String[] ids = new String[]{id};
                String username = request.getSession().getAttribute("name").toString();
                this.storeInfoService.delStoreInfoById(ids, username);
            }
            empStr = str.toString().substring(0, str.length() - 1) + "]";
        }
        finally {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u4f1a\u5458", (String)(request.getSession().getAttribute("operaPath") + "\u5220\u9664\u4f1a\u5458" + LOGGERINFO + empStr));
            customerIds = null;
            str = null;
            pr = null;
            empStr = null;
        }
        return null;
    }

    @RequestMapping(value={"/deleteNewCustomer"})
    public ModelAndView deleteNewCustomer(HttpServletRequest request, Long customerId) {
        String[] customerIds = new String[]{"" + customerId + ""};
        this.customerServiceMapper.deleteCustomer(customerIds);
        CustomerAllInfo allinfo = this.customerServiceMapper.selectByPrimaryKey(customerId);
        if ("1".equals("1")) {
            CustomerLogger customerLogger = new CustomerLogger();
            customerLogger.setName((String)request.getSession().getAttribute("name"));
            customerLogger.setCustomerId(allinfo.getCustomerId().toString());
            customerLogger.setType("\u5220\u9664\u4f1a\u5458");
            customerLogger.setCustomerName(allinfo.getCustomerUsername());
            customerLogger.setStatus("0");
            this.customerLoggerService.saveLogger(customerLogger);
        }
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u4f1a\u5458", (String)(request.getSession().getAttribute("operaPath") + "\u5220\u9664\u4f1a\u5458" + LOGGERINFO + customerId));
        return new ModelAndView((View)new RedirectView("initCustomer.htm"));
    }

    @RequestMapping(value={"/deleteAllNewCustomer"})
    public ModelAndView deleteAllNewCustomer(HttpServletRequest request, Long[] customerId) {
        String[] customerIds = request.getParameterValues("customerId");
        this.customerServiceMapper.deleteCustomer(customerIds);
        for (int i = 0; i < customerIds.length; ++i) {
            CustomerAllInfo allinfo = this.customerServiceMapper.selectByPrimaryKey(Long.valueOf(customerIds[i]));
            if (!"1".equals("1")) continue;
            CustomerLogger customerLogger = new CustomerLogger();
            customerLogger.setName((String)request.getSession().getAttribute("name"));
            customerLogger.setCustomerId(allinfo.getCustomerId().toString());
            customerLogger.setType("\u5220\u9664\u4f1a\u5458");
            customerLogger.setCustomerName(allinfo.getCustomerUsername());
            customerLogger.setStatus("0");
            this.customerLoggerService.saveLogger(customerLogger);
        }
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u4f1a\u5458", (String)(request.getSession().getAttribute("operaPath") + "\u5220\u9664\u4f1a\u5458" + LOGGERINFO + customerId[0].toString()));
        return new ModelAndView((View)new RedirectView("initCustomer.htm"));
    }

    @RequestMapping(value={"/updateCustomer"})
    public ModelAndView updateCustomer(@Valid CustomerAllInfo allinfo, HttpServletRequest request) {
        if (null != allinfo.getInfoRealname()) {
            LOGGER.info((Object)("\u4fee\u6539\u540d\u79f0\u4e3a\u3010" + allinfo.getInfoRealname() + "\u3011\u7684\u4f1a\u5458\u4fe1\u606f"));
        }
        allinfo.setCustomerPassword(null);
        String pageNo = StringUtils.isNotEmpty((String)request.getParameter("pageNo")) ? request.getParameter("pageNo") : "1";
        this.customerServiceMapper.updateCustomer(allinfo);
        if ("1".equals("1")) {
            CustomerLogger customerLogger = new CustomerLogger();
            customerLogger.setName((String)request.getSession().getAttribute("name"));
            customerLogger.setCustomerId(allinfo.getCustomerId().toString());
            customerLogger.setType("\u4fee\u6539\u4f1a\u5458");
            customerLogger.setCustomerName(allinfo.getCustomerUsername());
            customerLogger.setStatus("0");
            this.customerLoggerService.saveLogger(customerLogger);
        }
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u4fee\u6539\u4f1a\u5458\u4fe1\u606f:", (String)(request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d:" + allinfo.getCustomerUsername()));
        return new ModelAndView((View)new RedirectView("initCustomer.htm?pageNo=" + pageNo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/setcustomer"})
    public ModelAndView setCustomer(@Valid CustomerAllInfo allinfo, HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pr = null;
        String[] customerIds = null;
        StringBuilder str = new StringBuilder("[");
        String empStr = "";
        try {
            pr = response.getWriter();
            customerIds = request.getParameterValues("parameterIds[]");
            pr.print(this.customerServiceMapper.setCustomer(customerIds, allinfo.getIsSiteManager()));
            for (String id : customerIds) {
                str.append(id + ",");
            }
            empStr = str.toString().substring(0, str.length() - 1) + "]";
            if (null != allinfo.getInfoRealname()) {
                LOGGER.info((Object)("\u8bbe\u7f6e\u540d\u79f0\u4e3a\u3010" + allinfo.getInfoRealname() + "\u3011\u7684\u4f1a\u5458\u7684\u7c7b\u578b"));
            }
        }
        finally {
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u4f1a\u5458", (String)(request.getSession().getAttribute("operaPath") + "\u5220\u9664\u4f1a\u5458" + LOGGERINFO + empStr));
            customerIds = null;
            str = null;
            pr = null;
            empStr = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryCustomer"})
    public ModelAndView queryCustomer(Long customerId, CustomerPoint point, PageBean pageBean, String status) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            CustomerAllInfo customerAllInfo = this.customerServiceMapper.selectByPrimaryKey(customerId);
            customerAllInfo.setInfoPointSum(Integer.valueOf(customerAllInfo.getInfoPointSum() - this.customerPointServiceMapper.getCustomerReducePoint(customerId + "")));
            resultMap.put("customer", customerAllInfo);
            resultMap.put("follows", this.customerFollowServiceMapper.selectByCustomerId(customerId));
            if ("6".equals(status)) {
                resultMap.put("point", this.customerPointServiceMapper.selectCustPointByCustPoint(point, pageBean));
            }
            ModelAndView modelAndView = new ModelAndView("jsp/customer/customerdetail").addAllObjects(resultMap);
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/saveCustomerPoint"}, produces={"application/json;charset=UTF-8"})
    public int saveCustomerPoint(Long customerId, CustomerPoint customerpoint, String mgUserName) {
        return this.customerPointServiceMapper.saveCustomerPoint(customerId, customerpoint, mgUserName);
    }

    @ResponseBody
    @RequestMapping(value={"/ajaxqueryCustomerDetail"}, produces={"application/json;charset=UTF-8"})
    public PageBean ajaxqueryCustomerDetail(CustomerPoint point, PageBean pageBean, String status) {
        if ("6".equals(status)) {
            return this.customerPointServiceMapper.selectCustPointByCustPoint(point, pageBean);
        }
        return null;
    }

    @RequestMapping(value={"/queryByCustomerId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<CustomerAllInfo> queryByCustomerId(Long customerId, Long[] customerIds, HttpServletRequest request) {
        List<Object> customerList = new ArrayList<CustomerAllInfo>();
        if (null != customerId) {
            customerList.add(this.customerServiceMapper.selectByPrimaryKey(customerId));
            return customerList;
        }
        if (null != customerIds && customerIds.length > 0) {
            HashMap<String, Long[]> map = new HashMap<String, Long[]>();
            map.put("customerIds", customerIds);
            customerList = this.customerServiceMapper.selectBycustomerIds(map);
            return customerList;
        }
        return Collections.emptyList();
    }

    @RequestMapping(value={"queryCustomerById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public CustomerAllInfo queryCustomerById(Long customerId) {
        CustomerAllInfo customer = this.customerServiceMapper.queryCustomerInfo(customerId);
        CustomerPointLevel customerPointLevel = this.getCustomerPointLevel(customerId);
        if (null != customerPointLevel) {
            customer.setPointLevelId(customerPointLevel.getPointLevelId());
            customer.setPointLevelName(customerPointLevel.getPointLevelName());
        }
        customer.setCustomerAddress(null);
        customer.setCustomerPassword(null);
        return customer;
    }

    private String getCustomerPointLevelName(Long customerId) {
        CustomerPointLevel customerPointLevel = this.getCustomerPointLevel(customerId);
        if (null == customerPointLevel) {
            return "";
        }
        return customerPointLevel.getPointLevelName();
    }

    private CustomerPointLevel getCustomerPointLevel(Long customerId) {
        return this.customerPointServiceMapper.getCustomerPointLevelByPoint(this.customerPointServiceMapper.getCustomerAllPoint(customerId + "").intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/checkExistCustomerUsername"})
    public ModelAndView checkExistCustomerUsername(String customerUsername, HttpServletResponse response) throws IOException {
        if (null != customerUsername) {
            LOGGER.info((Object)("\u68c0\u67e5\u540d\u79f0\u4e3a\u3010" + customerUsername + "\u3011\u7684\u4f1a\u5458\u662f\u5426\u5b58\u5728"));
        }
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            pr.print(this.customerServiceMapper.checkExistsByCustNameAndType(customerUsername));
        }
        finally {
            pr = null;
        }
        return null;
    }

    @RequestMapping(value={"/getAllProvince"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<ProvinceBean> getAllProvince() {
        return this.customerServiceMapper.selectAllProvince();
    }

    @RequestMapping(value={"/getAllCityByPid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<CityBean> getAllCityByPid(Long provinceId) {
        return this.customerServiceMapper.selectAllCityByPid(provinceId);
    }

    @RequestMapping(value={"/getAllCity"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<CityBean> getAllCity() {
        return this.customerServiceMapper.selectAllCity();
    }

    @RequestMapping(value={"/getAllDistrictByCid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<DistrictBean> getAllDistrictByCid(Long cityId) {
        return this.customerServiceMapper.selectAllDistrictByCid(cityId);
    }

    @RequestMapping(value={"/getAllDistrict"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<DistrictBean> getAllDistrict() {
        return this.customerServiceMapper.selectAllDistrict();
    }

    @RequestMapping(value={"/getAllStreetByDid"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<StreetBean> getAllStreetByDid(Long dId) {
        return this.customerServiceMapper.getAllStreetByDid(dId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryByCustomerAllInfo"})
    public ModelAndView queryByCustomerAllInfo(String createtime, String createtimeto, CustomerAllInfo customerAllInfo, PageBean pageBean, CustBean custBean) throws UnsupportedEncodingException, ParseException {
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dataStart = createtime + " " + "00:00:00";
        String dataEnd = createtimeto + " " + "23:59:59";
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            customerAllInfo.setLoginTime(createtime == null || "".equals(createtime) ? null : formatDate.parse(dataStart));
            customerAllInfo.setLoginTimeTo(createtimeto == null || "".equals(createtimeto) ? null : formatDate.parse(dataEnd));
            pageBean.setUrl("queryByCustomerAllInfo.htm");
            resultMap.put(PAGEBEAN, this.customerServiceMapper.selectCustmerByAllInfo(customerAllInfo, pageBean));
            resultMap.put("customerAllInfo", customerAllInfo);
            resultMap.put("custBean", custBean);
            ModelAndView modelAndView = new ModelAndView("jsp/customer/customerlist").addAllObjects(resultMap);
            return modelAndView;
        }
        finally {
            formatDate = null;
            resultMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/businessList"})
    public ModelAndView businessList(CustomerAllInfo customerAllInfo, PageBean pageBean) throws UnsupportedEncodingException, ParseException {
        customerAllInfo.setIsSeller("1");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            resultMap.put(PAGEBEAN, this.customerServiceMapper.selectCustmerByAllInfo(customerAllInfo, pageBean));
            resultMap.put("customerAllInfo", customerAllInfo);
            ModelAndView modelAndView = new ModelAndView("jsp/customer/customerBusinessList").addAllObjects(resultMap);
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    @RequestMapping(value={"/queryByDetail"})
    public ModelAndView queryByDetail(Long orderId, CustomerAllInfo customer) {
        if (null != customer.getInfoRealname()) {
            LOGGER.info((Object)("\u67e5\u8be2\u540d\u79f0\u4e3a\u3010" + customer.getInfoRealname() + "\u3011\u7684\u4f1a\u5458\u7684\u8d2d\u4e70\u8be6\u7ec6\u4fe1\u606f"));
        }
        return new ModelAndView("jsp/customer/buydetail").addObject("orderInfo", (Object)this.customerServiceMapper.queryByDetail(orderId)).addObject("customer", (Object)this.customerServiceMapper.selectByPrimaryKey(customer.getCustomerId()));
    }

    public void check(CustomerAllInfo customerAllInfo) {
        int ch = 44;
        if (customerAllInfo.getCustomerUsername() != null) {
            int indexu = customerAllInfo.getCustomerUsername().indexOf(ch);
            customerAllInfo.setCustomerUsername(customerAllInfo.getCustomerUsername().substring(0, indexu == -1 ? customerAllInfo.getCustomerUsername().length() : indexu));
        }
        if (customerAllInfo.getInfoRealname() != null) {
            int indexr = customerAllInfo.getInfoRealname().indexOf(ch);
            customerAllInfo.setInfoRealname(customerAllInfo.getInfoRealname().substring(0, indexr == -1 ? customerAllInfo.getInfoRealname().length() : indexr));
        }
        if (customerAllInfo.getInfoMobile() != null) {
            int indexm = customerAllInfo.getInfoMobile().indexOf(ch);
            customerAllInfo.setInfoMobile(customerAllInfo.getInfoMobile().substring(0, indexm == -1 ? customerAllInfo.getInfoMobile().length() : indexm));
        }
    }

    @RequestMapping(value={"selectcountbytime"})
    public ModelAndView selectCountByTime(String startTime, String endTime) {
        String startTimeNew = startTime;
        String endTimeNew = endTime;
        if (startTimeNew == null || endTimeNew == null || "".equals(startTimeNew) || "".equals(endTimeNew)) {
            endTimeNew = UtilDate.todayFormat((Date)new Date());
            startTimeNew = UtilDate.addDay((String)endTimeNew, (int)-7);
        }
        String sttime = startTimeNew;
        String entime = endTimeNew;
        List csvList = this.customerServiceMapper.selectCountByTime();
        ArrayList<String> ctime = new ArrayList<String>();
        while (UtilDate.compare_date((String)startTimeNew, (String)endTimeNew)) {
            ctime.add(startTimeNew);
            startTimeNew = UtilDate.addDay((String)startTimeNew, (int)1);
        }
        JSONArray times = JSONArray.fromObject(ctime);
        ArrayList<Long> ccount = new ArrayList<Long>();
        for (int i = 0; i < ctime.size(); ++i) {
            boolean flg = true;
            for (int j = 0; j < csvList.size(); ++j) {
                CustomerStatisticVo csv = (CustomerStatisticVo)csvList.get(j);
                if (!((String)ctime.get(i)).equals(csv.getCtime())) continue;
                ccount.add(csv.getCountSum());
                flg = false;
                break;
            }
            if (!flg) continue;
            ccount.add(0L);
        }
        JSONArray counts = JSONArray.fromObject(ccount);
        if (null != startTimeNew && null != endTime) {
            LOGGER.info((Object)("\u7edf\u8ba1" + startTimeNew + "-" + endTimeNew + "\u65f6\u95f4\u6bb5\u6ce8\u518c\u4f1a\u5458\u7684\u4e2a\u6570"));
        }
        return new ModelAndView("jsp/statistic/custgrown").addObject("times", (Object)times.toString()).addObject("counts", (Object)counts).addObject("startTime", (Object)sttime).addObject("endTime", (Object)entime);
    }

    @RequestMapping(value={"selectcountbyweek"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public JSONArray selectCountByWeek(String startTime, String endTime) {
        String startTimeNew = startTime;
        String endTimeNew = endTime;
        if (startTimeNew == null || endTimeNew == null || "".equals(startTimeNew) || "".equals(endTimeNew) || "undefined".equals(startTimeNew) || "undefined".equals(endTimeNew)) {
            endTimeNew = UtilDate.todayFormat((Date)new Date());
            startTimeNew = UtilDate.addDay((String)endTimeNew, (int)-7);
        }
        List csvList = this.customerServiceMapper.selectCountByTime();
        ArrayList<String> ctime = new ArrayList<String>();
        while (UtilDate.compare_date((String)startTimeNew, (String)endTimeNew)) {
            ctime.add(startTimeNew);
            startTimeNew = UtilDate.addDay((String)startTimeNew, (int)1);
        }
        ArrayList<Long> ccount = new ArrayList<Long>();
        for (int i = 0; i < ctime.size(); ++i) {
            boolean flg = true;
            for (int j = 0; j < csvList.size(); ++j) {
                CustomerStatisticVo csv = (CustomerStatisticVo)csvList.get(j);
                if (!((String)ctime.get(i)).equals(csv.getCtime())) continue;
                ccount.add(csv.getCountSum());
                flg = false;
                break;
            }
            if (!flg) continue;
            ccount.add(0L);
        }
        return JSONArray.fromObject(ccount);
    }

    @RequestMapping(value={"selectcountbyaddress"})
    public ModelAndView selectCountByAddress() {
        List csvList = this.customerServiceMapper.selectCountByAddress();
        Long qita = 0L;
        HashMap<String, Long> addMap = new HashMap<String, Long>();
        for (int j = 0; j < csvList.size(); ++j) {
            CustomerStatisticVo csv = (CustomerStatisticVo)csvList.get(j);
            if (csv.getAddress() == 0L) {
                qita = csv.getCountSum();
                continue;
            }
            addMap.put(((ProvinceBean)csv.getProvinceList().get(0)).getProvinceName(), csv.getCountSum());
        }
        ArrayList<String> addlist = new ArrayList<String>();
        for (String key : addMap.keySet()) {
            addlist.add("{name:'" + key + "',value:" + addMap.get(key) + "}");
        }
        JSONArray qitas = JSONArray.fromObject((Object)qita);
        JSONArray addmap = JSONArray.fromObject(addlist);
        return new ModelAndView("jsp/statistic/custaddress").addObject("qita", (Object)qitas).addObject("addmap", (Object)addmap);
    }

    public CustomerServiceMapper getCustomerServiceMapper() {
        return this.customerServiceMapper;
    }

    @RequestMapping(value={"/customerRank"})
    public ModelAndView queryCustomerRank(PageBean pageBean, SelectBean selectBean, String startTime, String endTime, HttpServletRequest request) {
        request.setAttribute("startTime", (Object)startTime);
        request.setAttribute("endTime", (Object)endTime);
        request.setAttribute("condition", (Object)selectBean.getCondition());
        ModelAndView mav = new ModelAndView();
        mav.setViewName("jsp/customer/customer_rank");
        mav.addObject(PAGEBEAN, (Object)this.customerServiceMapper.queryCustomerRank(pageBean, selectBean, startTime, endTime)).addObject("condition", (Object)selectBean.getCondition());
        return mav;
    }

    @RequestMapping(value={"/checkbossemailexist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkEmailExist(HttpServletRequest request, String email) {
        if (null != email) {
            LOGGER.info((Object)("\u68c0\u67e5\u90ae\u7bb1\u4e3a\u3010" + email + "\u3011\u7684\u662f\u5426\u5df2\u88ab\u4f7f\u7528"));
        }
        return this.customerServiceMapper.checkEmailExist(email);
    }

    @RequestMapping(value={"/checkbossmobileexist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkMobileExist(HttpServletRequest request, String mobile) {
        if (null != mobile) {
            LOGGER.info((Object)("\u68c0\u67e5\u624b\u673a\u53f7\u4e3a\u3010" + mobile + "\u3011\u7684\u662f\u5426\u5df2\u88ab\u4f7f\u7528"));
        }
        return this.customerServiceMapper.checkMobileExist(mobile);
    }

    @RequestMapping(value={"/selectnewcustomer"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Customer> selectNewCustomer() {
        return this.customerServiceMapper.selectNewCustoer();
    }

    @Resource(name="customerServiceMapper")
    public void setCustomerServiceMapper(CustomerServiceMapper customerServiceMapper) {
        this.customerServiceMapper = customerServiceMapper;
    }

    public CustomerFollowServiceMapper getCustomerFollowServiceMapper() {
        return this.customerFollowServiceMapper;
    }

    @Resource(name="customerFollowServiceMapper")
    public void setCustomerFollowServiceMapper(CustomerFollowServiceMapper customerFollowServiceMapper) {
        this.customerFollowServiceMapper = customerFollowServiceMapper;
    }
}

