/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.promotion.controller;

import com.qianjiang.promotion.bean.PerfectInformation;
import com.qianjiang.promotion.service.PromotionService;
import com.qianjiang.util.MyLogger;
import java.math.BigDecimal;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class PerfectInformationController {
    private static final MyLogger LOGGER = new MyLogger(PerfectInformationController.class);
    @Resource(name="MarketingService")
    private PromotionService marketingService;

    @RequestMapping(value={"/perfectInformationMarketing"})
    public ModelAndView perfectInformationMarketing(@RequestParam(value="flag", required=false, defaultValue="0") Integer flag) {
        ModelAndView mav = new ModelAndView();
        try {
            PerfectInformation perfectInformation = this.marketingService.selectPerfectInformation();
            mav.addObject("parameter", (Object)perfectInformation);
            mav.addObject("flag", (Object)flag);
            mav.setViewName("jsp/coupon/perfectInformation");
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u521d\u59cb\u5316\u5b8c\u5584\u4fe1\u606f\u9001\u91d1\u989d\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/updatePerfectInformation"})
    public ModelAndView updatePerfectInformation(PerfectInformation perfectInformation) {
        ModelAndView mav = new ModelAndView();
        try {
            if (perfectInformation != null) {
                if ("0".equals(perfectInformation.getIsUsed())) {
                    PerfectInformation information = new PerfectInformation();
                    information.setIsUsed("0");
                    information.setActiveDescribe(null);
                    information.setStartTime(null);
                    information.setEndTime(null);
                    information.setDelFlag("0");
                    information.setPresentedMoney(new BigDecimal("0.00"));
                    this.marketingService.updatePerfectInformation(information);
                    mav.setView((View)new RedirectView("perfectInformationMarketing.htm"));
                    return mav;
                }
                int status = this.marketingService.updatePerfectInformation(perfectInformation);
                LOGGER.info((Object)("\u4fee\u6539\u5b8c\u5584\u4fe1\u606f\u9001\u91d1\u989d\u72b6\u6001\u503c\u4e3a\uff1a" + status));
                mav.setView((View)new RedirectView("perfectInformationMarketing.htm"));
                return mav;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4fee\u6539\u5b8c\u5584\u4fe1\u606f\u9001\u91d1\u989d\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }
}

