/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.adv.controller;

import com.qianjiang.adv.bean.Adv;
import com.qianjiang.adv.service.AdvService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class AdvController {
    private static String page_list = "jsp/adv/adv_list";
    private static String page_edit = "jsp/adv/adv_edit";
    @Resource(name="AdvService")
    private AdvService advService;
    private static Logger logger = Logger.getLogger(AdvController.class);
    private static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";

    @RequestMapping(value={"/selectbbadvlist"})
    public ModelAndView initMethod(PageBean pageBean, Adv adv) {
        pageBean.setUrl("selectBbadvList");
        return new ModelAndView(page_list, "pageBean", (Object)this.advService.selectPageList(pageBean, adv));
    }

    @RequestMapping(value={"/toeditbbadv"})
    public ModelAndView toEdit(Long advId) {
        ModelAndView mav = new ModelAndView(page_edit);
        if (advId != null) {
            mav.addObject("adv", (Object)this.advService.select(advId));
        }
        return mav;
    }

    @RequestMapping(value={"/toeditbbadvNew"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Adv toEditNew(Long advId) {
        Adv adv = new Adv();
        if (advId != null) {
            adv = this.advService.select(advId);
        }
        return adv;
    }

    @RequestMapping(value={"/addbbadv"})
    public ModelAndView add(Adv adv, HttpServletRequest request, MultipartHttpServletRequest partRequest) {
        MultipartFile file = partRequest.getFile("advImgInput");
        if (file != null && file.getSize() > 0L) {
            adv.setAdvImg(UploadUtil.uploadFileOne((MultipartFile)file));
        }
        if (this.advService.insert(adv) == 1) {
            logger.debug((Object)"\u6dfb\u52a0\u5e7f\u544a\u6210\u529f");
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute(NAME)), (String)"\u6dfb\u52a0\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + "\u6dfb\u52a0\u5e7f\u544aid:" + adv.getAdvId()));
        } else {
            logger.debug((Object)"\u6dfb\u52a0\u5e7f\u544a\u5931\u8d25");
        }
        return new ModelAndView((View)new RedirectView("selectbbadvlist.htm?CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updatebbadv"})
    public ModelAndView update(Adv adv, HttpServletRequest request, MultipartHttpServletRequest partRequest) {
        int flag;
        MultipartFile file = partRequest.getFile("advImgInput");
        if (file != null && file.getSize() > 0L) {
            adv.setAdvImg(UploadUtil.uploadFileOne((MultipartFile)file));
        }
        if ((flag = this.advService.update(adv)) == 1) {
            if (null != adv.getAdvName()) {
                logger.debug((Object)("\u4fee\u6539\u5e7f\u544a\u6210\u529f\uff0c\u5e7f\u544a\u540d\u79f0\u4e3a\uff1a" + adv.getAdvName()));
            }
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute(NAME)), (String)"\u4fee\u6539\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + "\u4fee\u6539\u5e7f\u544a" + adv.getAdvId()));
        } else if (null != adv.getAdvName()) {
            logger.debug((Object)("\u4fee\u6539\u5e7f\u544a\u5931\u8d25\uff0c\u5e7f\u544a\u540d\u79f0\u4e3a\uff1a" + adv.getAdvName()));
        }
        return new ModelAndView((View)new RedirectView("selectbbadvlist.htm?CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/deleteMuiltiBbadv"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int delete(@RequestParam(value="advIds[]") Long[] advIds, HttpServletRequest request) {
        int flag = this.advService.deleteAll(advIds);
        if (flag > 0) {
            logger.debug((Object)("\u5220\u9664\u5e7f\u544a" + advIds.length + "\u6761\u8bb0\u5f55\u6210\u529f"));
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute(NAME)), (String)"\u5220\u9664\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + "\u5220\u9664\u5e7f\u544a" + advIds[0].toString() + "\u6761\u8bb0\u5f55"));
        } else {
            logger.debug((Object)"\u5220\u9664\u5e7f\u544a\u5931\u8d25");
        }
        return flag;
    }

    @RequestMapping(value={"/selectadvlist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Adv> selectAdvListByPosition(@RequestParam String flag) {
        return this.advService.selectAdvListByPosition(flag);
    }
}

