/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.qianjiang.channel.bean.Channel;
import com.qianjiang.channel.bean.ChannelStoreyGoods;
import com.qianjiang.channel.service.ChannelGoodsService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.TempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelGoodsController {
    private static final MyLogger LOGGER = new MyLogger(ChannelGoodsController.class);
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private static final String QUERYCHANNELGOODSBYPAGEBEAN_HTM = "queryChannelGoodsByPageBean.htm?tempId=";
    @Resource(name="TempService")
    private TempService tempService;
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    @Resource(name="ChannelGoodsService")
    private ChannelGoodsService channelGoodsService;

    @RequestMapping(value={"/queryChannelGoodsByPageBean"})
    public ModelAndView queryChannelGoodsByPageBean(PageBean pb, Long tempId, Long channelId) {
        ModelAndView mav = new ModelAndView();
        mav.addObject("pb", (Object)this.channelGoodsService.selectchannelStoreyGoodsByParam(pb, tempId.toString(), null, null));
        mav.addObject("tempId", (Object)tempId);
        mav.addObject("channelId", (Object)channelId);
        mav.setViewName("jsp/channel/channel_goods_list");
        return mav;
    }

    @RequestMapping(value={"/querychannelgoodsbypagebeanajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryChannelGoodsByPageBeanAjax(PageBean pb, String tempId, Long channelId, String storeyTagId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.channelGoodsService.selectchannelStoreyGoodsByParam(pb, tempId, storeyTagId, null));
        return map;
    }

    @RequestMapping(value={"/showchannelgoodsajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ChannelStoreyGoods showChannelGoodsAjax(Long channelStoreyGoodsproductId) {
        return this.channelGoodsService.getChannelStoreyGoodsById(channelStoreyGoodsproductId);
    }

    @RequestMapping(value={"/showChannelGoods"})
    public ModelAndView showChannelGoods(Long channelStoreyGoodsproductId, Long tempId, Long channelId) {
        ModelAndView mav = new ModelAndView();
        if (null == channelId) {
            SysTemp temp = this.tempService.getSystempById(tempId);
            mav.addObject("temp", (Object)temp);
        } else {
            Channel channel = this.channelService.findChannelByID(channelId);
            mav.addObject("channel", (Object)channel);
        }
        if (null != channelStoreyGoodsproductId) {
            ChannelStoreyGoods channelStoreyGoods = this.channelGoodsService.getChannelStoreyGoodsById(channelStoreyGoodsproductId);
            mav.addObject("channelStoreyGoods", (Object)channelStoreyGoods);
        }
        mav.setViewName("jsp/channel/showChannelGoods");
        return mav;
    }

    @RequestMapping(value={"/createchannelgoodsajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createChannelGoodsAjax(HttpServletRequest request, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long tempId, Long channelId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        int n = 0;
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setCreateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setCreateUserId(loginUserId);
            }
            if (tempId != null) {
                channelStoreyGoods.setTemp1(tempId.toString());
            }
            if ((n = this.channelGoodsService.saveChannelStoreyGoods(channelStoreyGoods)) > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        return n;
    }

    @RequestMapping(value={"/createChannelGoods"})
    public ModelAndView createChannelGoods(HttpServletRequest request, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long tempId, Long channelId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELGOODSBYPAGEBEAN_HTM + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setCreateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setCreateUserId(loginUserId);
            }
            channelStoreyGoods.setTemp1(tempId.toString());
            int n = this.channelGoodsService.saveChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYCHANNELGOODSBYPAGEBEAN_HTM + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/updatechannelgoodsajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateChannelGoodsAjax(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long tempId, Long channelId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        int n = 0;
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setUpdateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setUpdateUserId(loginUserId);
            }
            n = this.channelGoodsService.updateChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYCHANNELGOODSBYPAGEBEAN_HTM + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return n;
    }

    @RequestMapping(value={"/updateChannelGoods"})
    public ModelAndView updateChannelGoods(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long tempId, Long channelId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELGOODSBYPAGEBEAN_HTM + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setUpdateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setUpdateUserId(loginUserId);
            }
            int n = this.channelGoodsService.updateChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYCHANNELGOODSBYPAGEBEAN_HTM + tempId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/deleteChannelGoodsAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void deleteChannelGoodsAjax(HttpServletRequest request, HttpServletResponse response, Long[] storeyGoodsIds) {
        for (int i = 0; i < storeyGoodsIds.length; ++i) {
            this.channelGoodsService.deleteChannelStoreyGoodsnew(storeyGoodsIds[i]);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u70ed\u9500\u63a8\u8350\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/deleteChannelGoods"})
    public void deleteChannelGoods(HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        String[] storeyGoodsIds = request.getParameterValues("storeyGoodsIds[]");
        for (int i = 0; i < storeyGoodsIds.length; ++i) {
            this.channelGoodsService.deleteChannelStoreyGoods(Long.valueOf(storeyGoodsIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u70ed\u9500\u63a8\u8350\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/serveChannelGoodsAjax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int serveChannelGoodsAjax(HttpServletRequest request, HttpServletResponse resp, @RequestBody JSONObject obj) {
        int count = 0;
        int countAddChannelGoods = 0;
        int countEditChannelGoods = 0;
        LOGGER.info((Object)("channel goods data:" + obj.toJSONString()));
        String data = obj.toJSONString();
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        try {
            Long sort;
            BigDecimal goodsproductPrice;
            String goodsproductImgsrc;
            String goodsproductName;
            String goodsproductNo;
            Long goodsproductId;
            int i;
            String storeTitle;
            JSONArray titleArray;
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            JSONObject json = JSON.parseObject((String)data);
            String createArr = json.getString("createArr");
            String modifyArr = json.getString("modifyArr");
            String channleGoodsTitleArr = json.getString("title");
            if (!StringUtils.isEmpty((String)createArr)) {
                JSONArray createArray = JSONArray.parseArray((String)createArr);
                titleArray = JSONArray.parseArray((String)channleGoodsTitleArr);
                storeTitle = JSONObject.parseObject((String)JSONObject.toJSONString((Object)titleArray.get(0))).getString("title");
                for (i = 0; i < createArray.size(); ++i) {
                    goodsproductId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getLong("goodsproductsId");
                    goodsproductNo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("goodsproductNo");
                    goodsproductName = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("goodsproductName");
                    goodsproductImgsrc = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("goodsproductImgsrc");
                    goodsproductPrice = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getBigDecimal("goodsproductPrice");
                    sort = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getLong("sort");
                    Long tempId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getLong("tempId");
                    String isHot = JSONObject.parseObject((String)JSONObject.toJSONString((Object)createArray.get(i))).getString("isHot");
                    ChannelStoreyGoods channelStoreyGoods = new ChannelStoreyGoods();
                    channelStoreyGoods.setTemp1(tempId.toString());
                    channelStoreyGoods.setIsHot(isHot);
                    channelStoreyGoods.setStoreTitle(storeTitle);
                    channelStoreyGoods.setGoodsproductId(goodsproductId);
                    channelStoreyGoods.setGoodsproductNo(goodsproductNo);
                    channelStoreyGoods.setGoodsproductName(goodsproductName);
                    channelStoreyGoods.setGoodsproductImgsrc(goodsproductImgsrc);
                    channelStoreyGoods.setGoodsproductPrice(goodsproductPrice);
                    channelStoreyGoods.setSort(sort);
                    channelStoreyGoods.setCreateUserId(loginUserId);
                    countAddChannelGoods = this.channelGoodsService.saveChannelStoreyGoods(channelStoreyGoods);
                }
            }
            if (!StringUtils.isEmpty((String)modifyArr)) {
                JSONArray modifyArray = JSONArray.parseArray((String)modifyArr);
                titleArray = JSONArray.parseArray((String)channleGoodsTitleArr);
                storeTitle = JSONObject.parseObject((String)JSONObject.toJSONString((Object)titleArray.get(0))).getString("title");
                for (i = 0; i < modifyArray.size(); ++i) {
                    goodsproductId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("goodsproductsId");
                    goodsproductNo = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("goodsproductNo");
                    goodsproductName = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("goodsproductName");
                    goodsproductImgsrc = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("goodsproductImgsrc");
                    goodsproductPrice = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getBigDecimal("goodsproductPrice");
                    sort = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("sort");
                    Long channelStoreyGoodsproductId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("id");
                    Long tempId = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getLong("tempId");
                    String isHot = JSONObject.parseObject((String)JSONObject.toJSONString((Object)modifyArray.get(i))).getString("isHot");
                    ChannelStoreyGoods channelStoreyGoods = new ChannelStoreyGoods();
                    channelStoreyGoods.setChannelStoreyGoodsproductId(channelStoreyGoodsproductId);
                    channelStoreyGoods.setTemp1(tempId.toString());
                    channelStoreyGoods.setIsHot(isHot);
                    channelStoreyGoods.setStoreTitle(storeTitle);
                    channelStoreyGoods.setGoodsproductId(goodsproductId);
                    channelStoreyGoods.setGoodsproductNo(goodsproductNo);
                    channelStoreyGoods.setGoodsproductName(goodsproductName);
                    channelStoreyGoods.setGoodsproductImgsrc(goodsproductImgsrc);
                    channelStoreyGoods.setGoodsproductPrice(goodsproductPrice);
                    channelStoreyGoods.setSort(sort);
                    channelStoreyGoods.setUpdateUserId(loginUserId);
                    countEditChannelGoods = this.channelGoodsService.updateChannelStoreyGoods(channelStoreyGoods);
                }
            }
            if (countAddChannelGoods > 0 || countEditChannelGoods > 0) {
                count = 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u6dfb\u52a0\u70ed\u9500\u63a8\u8350\u5546\u54c1\u5f02\u5e38\uff01" + e.getMessage(), (Throwable)e);
        }
        return count;
    }
}

