/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.ChannelAdver;
import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.bean.ChannelStoreyTag;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.channel.service.ChannelStoreyTagService;
import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelStoreyTagAdverController {
    private static final MyLogger LOGGER = new MyLogger(ChannelStoreyTagAdverController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final Long ATID = 161L;
    private static final Long ADVERTTYPE = 151L;
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    public static final String QUERYSTOREYTAGADVERBYPAGEBEAN_HTM = "queryStoreyTagAdverByPageBean.htm?storeyTagId=";
    public static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private ChannelStoreyService channelStoreyService;
    private ChannelStoreyTagService channelStoreyTagService;
    private ChannelAdverService channelAdverService;
    @Resource(name="InfoImageManageService")
    private InfoImageManageService infoImageManageService;

    @RequestMapping(value={"/queryStoreyTagAdverByPageBean"})
    public ModelAndView queryStoreyTagAdverByPageBean(PageBean pb, Long storeyTagId) {
        LOGGER.debug("======\u5206\u9875\u67e5\u770b\u9891\u9053\u697c\u5c42\u6807\u7b7e\u5e7f\u544a\u8bbe\u7f6e======");
        ChannelStoreyTag storeyTag = this.channelStoreyTagService.getChannelStoreyTagById(storeyTagId);
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyTag.getStoreyId());
        return new ModelAndView("jsp/channel/channel_storey_tag_adver_list", "pb", (Object)this.channelAdverService.selectchannelAdverByParam(pb, null, null, null, storeyTagId, ATID, ADVERTTYPE, null, null)).addObject("channelStorey", (Object)channelStorey).addObject("storeyTag", (Object)storeyTag);
    }

    @RequestMapping(value={"/showStoreyTagAdver"})
    public ModelAndView showStoreyTagAdver(Long channelAdverId, Long storeyTagId) {
        LOGGER.debug("======\u67e5\u770b\u9891\u9053\u697c\u5c42\u6807\u7b7e\u5e7f\u544a======");
        HashMap<String, Object> map = new HashMap<String, Object>();
        ChannelStoreyTag storeyTag = this.channelStoreyTagService.getChannelStoreyTagById(storeyTagId);
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyTag.getStoreyId());
        map.put("storeyTag", storeyTag);
        map.put("channelStorey", channelStorey);
        if (null != channelAdverId) {
            ChannelAdver channelAdver = this.channelAdverService.selectByPrimaryKey(channelAdverId);
            map.put("channelAdver", channelAdver);
        }
        return new ModelAndView("jsp/channel/showChannelStoreyTagAdver", "map", map);
    }

    @RequestMapping(value={"/createStoreyTagAdver"})
    public ModelAndView createStoreyTagAdver(MultipartHttpServletRequest request, HttpServletResponse response, @Valid ChannelAdver channelAdver, BindingResult bindingResult, Integer width, Integer height) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYSTOREYTAGADVERBYPAGEBEAN_HTM + channelAdver.getFloorTagId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("======\u6dfb\u52a0\u9891\u9053\u697c\u5c42\u6807\u7b7e\u5e7f\u544a======");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        MultipartFile muFile = request.getFile("imgSrc");
        if (null != muFile && muFile.getSize() > 0L) {
            channelAdver.setAdverPath(UploadUtil.uploadFileOne((MultipartFile)muFile));
            this.infoImageManageService.saveImage(channelAdver.getAdverPath());
        }
        channelAdver.setCreateUserId(loginUserId);
        this.channelAdverService.saveChannelAdver(channelAdver);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u697c\u5c42\u6807\u7b7e\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYSTOREYTAGADVERBYPAGEBEAN_HTM + channelAdver.getFloorTagId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateStoreyTagAdver"})
    public ModelAndView updateStoreyTagAdver(MultipartHttpServletRequest request, HttpServletResponse response, @Valid ChannelAdver channelAdver, BindingResult bindingResult, Integer width, Integer height) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYSTOREYTAGADVERBYPAGEBEAN_HTM + channelAdver.getFloorTagId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("======\u4fee\u6539\u9891\u9053\u697c\u5c42\u6807\u7b7e\u5e7f\u544a======");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        MultipartFile muFile = request.getFile("imgSrc");
        if (null != muFile && muFile.getSize() > 0L) {
            channelAdver.setAdverPath(UploadUtil.uploadFileOne((MultipartFile)muFile));
            this.infoImageManageService.saveImage(channelAdver.getAdverPath());
        }
        channelAdver.setUpdateUserId(loginUserId);
        this.channelAdverService.updateChannelAdver(channelAdver);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u697c\u5c42\u6807\u7b7e\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYSTOREYTAGADVERBYPAGEBEAN_HTM + channelAdver.getFloorTagId() + "&CSRFToken=" + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/deleteStoreyTagAdver"})
    public void deleteStoreyTagAdver(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("======\u5220\u9664\u9891\u9053\u697c\u5c42\u6807\u7b7e\u5e7f\u544a======");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        String[] adverIds = request.getParameterValues("adverIds[]");
        for (int i = 0; i < adverIds.length; ++i) {
            Long id = Long.valueOf(adverIds[i]);
            this.channelAdverService.deleteChannelAdver(id, loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u697c\u5c42\u6807\u7b7e\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    public ChannelAdverService getChannelAdverService() {
        return this.channelAdverService;
    }

    @Resource(name="ChannelAdverService")
    public void setChannelAdverService(ChannelAdverService channelAdverService) {
        this.channelAdverService = channelAdverService;
    }

    public ChannelStoreyTagService getChannelStoreyTagService() {
        return this.channelStoreyTagService;
    }

    @Resource(name="ChannelStoreyTagService")
    public void setChannelStoreyTagService(ChannelStoreyTagService channelStoreyTagService) {
        this.channelStoreyTagService = channelStoreyTagService;
    }

    public ChannelStoreyService getChannelStoreyService() {
        return this.channelStoreyService;
    }

    @Resource(name="ChannelStoreyService")
    public void setChannelStoreyService(ChannelStoreyService channelStoreyService) {
        this.channelStoreyService = channelStoreyService;
    }
}

