/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.bean.ChannelTrademark;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.channel.service.ChannelTrademarkService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelStoreyTrademarkController {
    private static final MyLogger LOGGER = new MyLogger(ChannelStoreyTrademarkController.class);
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    private ChannelStoreyService channelStoreyService;
    private ChannelTrademarkService channelTrademarkService;
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String STOREYID = "storeyId";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    private static final String QUERYCHANNELSTOREYTRADEMARKBYPAGEBEAN_HTM = "queryChannelStoreyTrademarkByPageBean.htm?storeyId=";

    @RequestMapping(value={"/queryChannelStoreyTrademarkByPageBean"})
    public ModelAndView queryChannelStoreyTrademarkByPageBean(PageBean pb, Long storeyId, HttpServletRequest request) {
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyId);
        return new ModelAndView("jsp/channel/channel_storey_Trademark_list", "pb", (Object)this.channelTrademarkService.selectchannelTrademarkByParam(pb, null, null, storeyId, null, null, null)).addObject("channelStorey", (Object)channelStorey);
    }

    @RequestMapping(value={"/querychannelstoreytrademarkbypagebeanajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryChannelStoreyTrademarkByPageBeanAjax(PageBean pb, Long storeyId, HttpServletRequest request, Long storeyTagId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pb", this.channelTrademarkService.selectchannelTrademarkByParam(pb, null, null, storeyId, storeyTagId, null, null));
        return map;
    }

    @RequestMapping(value={"/showChannelStoreyTrademark"})
    public ModelAndView showChannelStoreyTrademark(Long trademarkId, Long storeyId) {
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelStorey", channelStorey);
        if (null != trademarkId) {
            ChannelTrademark channelTrademark = this.channelTrademarkService.getChannelTrademarkById(trademarkId);
            map.put("channelTrademark", channelTrademark);
        }
        return new ModelAndView("jsp/channel/showChannelStoreyTrademark", "map", map);
    }

    @RequestMapping(value={"/showchannelstoreytrademarkajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ChannelTrademark showChannelStoreyTrademarkAjax(Long trademarkId) {
        return this.channelTrademarkService.getChannelTrademarkById(trademarkId);
    }

    @RequestMapping(value={"/createChannelStoreyTrademark"})
    public ModelAndView createChannelStoreyTrademark(HttpServletRequest request, HttpServletResponse response, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, Long storeyId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYTRADEMARKBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelTrademark.setCreateUserId(loginUserId);
            int n = this.channelTrademarkService.saveChannelTrademark(channelTrademark);
            mav.addObject(STOREYID, (Object)storeyId);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u697c\u5c42\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYCHANNELSTOREYTRADEMARKBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/createchannelstoreytrademarkajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createChannelStoreyTrademarkAjax(HttpServletRequest request, HttpServletResponse response, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, Long storeyId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        channelTrademark.setCreateUserId(loginUserId);
        int n = this.channelTrademarkService.saveChannelTrademark(channelTrademark);
        mav.addObject(STOREYID, (Object)storeyId);
        if (n > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u697c\u5c42\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        } else {
            LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
        }
        return n;
    }

    @RequestMapping(value={"/updateChannelStoreyTrademark"})
    public ModelAndView updateChannelStoreyTrademark(HttpServletRequest request, HttpServletResponse response, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, Long storeyId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYTRADEMARKBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelTrademark.setUpdateUserId(loginUserId);
            int n = this.channelTrademarkService.updateChannelTrademark(channelTrademark);
            mav.addObject(STOREYID, (Object)storeyId);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u697c\u5c42\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u9891\u9053\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYCHANNELSTOREYTRADEMARKBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/updatechannelstoreytrademarkajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateChannelStoreyTrademarkAjax(HttpServletRequest request, HttpServletResponse response, @Valid ChannelTrademark channelTrademark, BindingResult bindingResult, Long storeyId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        channelTrademark.setUpdateUserId(loginUserId);
        int n = this.channelTrademarkService.updateChannelTrademark(channelTrademark);
        if (n > 0) {
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u697c\u5c42\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
            LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u6210\u529f\uff01");
        } else {
            LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
        }
        return n;
    }

    @RequestMapping(value={"/deleteChannelStoreyTrademark"})
    public void deleteChannelStoreyTrademark(HttpServletRequest request, HttpServletResponse response) {
        String[] trademarkIds = request.getParameterValues("trademarkIds[]");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < trademarkIds.length; ++i) {
            this.channelTrademarkService.deleteChannelTrademark(Long.valueOf(trademarkIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u697c\u5c42\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/deletechannelstoreytrademarkajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void deleteChannelStoreyTrademarkAjax(HttpServletRequest request, HttpServletResponse response) {
        String[] trademarkIds = request.getParameterValues("trademarkId");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < trademarkIds.length; ++i) {
            this.channelTrademarkService.deleteChannelTrademark(Long.valueOf(trademarkIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u697c\u5c42\u54c1\u724c", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    public ChannelTrademarkService getChannelTrademarkService() {
        return this.channelTrademarkService;
    }

    @Resource(name="ChannelTrademarkService")
    public void setChannelTrademarkService(ChannelTrademarkService channelTrademarkService) {
        this.channelTrademarkService = channelTrademarkService;
    }

    public ChannelStoreyService getChannelStoreyService() {
        return this.channelStoreyService;
    }

    @Resource(name="ChannelStoreyService")
    public void setChannelStoreyService(ChannelStoreyService channelStoreyService) {
        this.channelStoreyService = channelStoreyService;
    }
}

