/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.Bar;
import com.qianjiang.system.service.BarService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class BarController {
    private static final MyLogger LOGGER = new MyLogger(BarController.class);
    @Resource(name="barService")
    private BarService barService;
    private String page = "barset.htm";

    @RequestMapping(value={"/barset"})
    public ModelAndView barSet(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/system/bar", "pb", (Object)this.barService.findByPageBean(pb, selectBean));
    }

    @RequestMapping(value={"/addbar"})
    public ModelAndView addBar(HttpServletRequest request, HttpServletResponse response, Bar bar) {
        this.barService.insertBar(bar);
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/delbar"})
    public ModelAndView delBar(HttpServletRequest request, HttpServletResponse response) {
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            pr.print(this.barService.deleteBar(request.getParameterValues("barId[]")));
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        return null;
    }

    @RequestMapping(value={"/findbarone"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Bar findBarOne(Long barId) {
        return this.barService.findByBarId(barId);
    }

    @RequestMapping(value={"/updatebar"})
    public ModelAndView updateBar(HttpServletRequest request, HttpServletResponse response, Bar bar) {
        this.barService.updateBar(bar);
        return new ModelAndView((View)new RedirectView(this.page));
    }
}

