/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.bean.ChannelStoreyGoods;
import com.qianjiang.channel.service.ChannelStoreyGoodsService;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.channel.service.GoodsCateService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelStoreyGoodsController {
    private static final MyLogger LOGGER = new MyLogger(ChannelStoreyGoodsController.class);
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String CHANNELSTOREY = "channelStorey";
    private static final String QUERYCHANNELSTOREYGOODSBYPAGEBEAN_HTM = "queryChannelStoreyGoodsByPageBean.htm?storeyId=";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    private ChannelStoreyService channelStoreyService;
    private ChannelStoreyGoodsService channelStoreyGoodsService;
    private GoodsCateService goodsCateService;

    @RequestMapping(value={"/queryChannelStoreyGoodsByPageBean"})
    public ModelAndView queryChannelStoreyGoodsByPageBean(PageBean pb, Long storeyId) {
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyId);
        return new ModelAndView("jsp/channel/channel_storey_goods_list", "pb", (Object)this.channelStoreyGoodsService.selectchannelStoreyGoodsByParam(pb, storeyId, null, null)).addObject(CHANNELSTOREY, (Object)channelStorey);
    }

    @RequestMapping(value={"/querychannelstoreygoodsbypagebeanajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> queryChannelStoreyGoodsByPageBeanAjax(PageBean pb, Long storeyId, Long storeyTagId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CHANNELSTOREY, this.channelStoreyService.getChannelStoreyById(storeyId));
        map.put("pb", this.channelStoreyGoodsService.selectchannelStoreyGoodsByParam(pb, storeyId, storeyTagId, null));
        return map;
    }

    @RequestMapping(value={"/showChannelStoreyGoods"})
    public ModelAndView showChannelStoreyGoods(Long channelStoreyGoodsproductId, Long storeyId) {
        ModelAndView mav = new ModelAndView();
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyId);
        if (null != channelStoreyGoodsproductId) {
            ChannelStoreyGoods channelStoreyGoods = this.channelStoreyGoodsService.getChannelStoreyGoodsById(channelStoreyGoodsproductId);
            mav.addObject("channelStoreyGoods", (Object)channelStoreyGoods);
        }
        mav.addObject(CHANNELSTOREY, (Object)channelStorey);
        mav.setViewName("jsp/channel/showChannelStoreyGoods");
        return mav;
    }

    @RequestMapping(value={"/showchannelstoreygoodsajax"})
    public ChannelStoreyGoods showChannelStoreyGoodsAjax(Long channelStoreyGoodsproductId, Long storeyId) {
        return this.channelStoreyGoodsService.getChannelStoreyGoodsById(channelStoreyGoodsproductId);
    }

    @RequestMapping(value={"/createChannelStoreyGoods"})
    public ModelAndView createChannelStoreyGoods(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long storeyId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYGOODSBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setCreateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setCreateUserId(loginUserId);
            }
            int n = this.channelStoreyGoodsService.saveChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u697c\u5c42\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYCHANNELSTOREYGOODSBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/createchannelstoreygoodsajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createChannelStoreyGoodsAjax(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long storeyId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        int n = 0;
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setCreateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setCreateUserId(loginUserId);
            }
            n = this.channelStoreyGoodsService.saveChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u697c\u5c42\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u697c\u5c42\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        return n;
    }

    @RequestMapping(value={"/updateChannelStoreyGoods"})
    public ModelAndView updateChannelStoreyGoods(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long storeyId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYGOODSBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setUpdateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setUpdateUserId(loginUserId);
            }
            int n = this.channelStoreyGoodsService.updateChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u697c\u5c42\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u697c\u5c42\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u697c\u5c42\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u9891\u9053\u697c\u5c42\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYCHANNELSTOREYGOODSBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/updatechannelstoreygoodsajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updateChannelStoreyGoodsAjax(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyGoods channelStoreyGoods, BindingResult bindingResult, Long storeyId) {
        if (bindingResult.hasErrors()) {
            return 0;
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        int n = 0;
        try {
            if (null == loginUserId) {
                channelStoreyGoods.setUpdateUserId(Long.valueOf(1L));
            } else {
                channelStoreyGoods.setUpdateUserId(loginUserId);
            }
            n = this.channelStoreyGoodsService.updateChannelStoreyGoods(channelStoreyGoods);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u697c\u5c42\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u697c\u5c42\u5546\u54c1\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u697c\u5c42\u5546\u54c1\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u9891\u9053\u697c\u5c42\u5546\u54c1\u5f02\u5e38\uff01", (Throwable)e);
        }
        return n;
    }

    @RequestMapping(value={"/deleteChannelStoreyGoods"})
    public void deleteChannelStoreyGoods(HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        String[] storeyGoodsIds = request.getParameterValues("storeyGoodsIds[]");
        for (int i = 0; i < storeyGoodsIds.length; ++i) {
            this.channelStoreyGoodsService.deleteChannelStoreyGoods(Long.valueOf(storeyGoodsIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u697c\u5c42\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/deletechannelstoreygoodsajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public void deleteChannelStoreyGoodsAjax(HttpServletRequest request, HttpServletResponse response) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        String[] storeyGoodsIds = request.getParameterValues("storeyGoodsId");
        for (int i = 0; i < storeyGoodsIds.length; ++i) {
            this.channelStoreyGoodsService.deleteChannelStoreyGoods(Long.valueOf(storeyGoodsIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u697c\u5c42\u5546\u54c1", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    public ChannelStoreyGoodsService getChannelStoreyGoodsService() {
        return this.channelStoreyGoodsService;
    }

    @Resource(name="ChannelStoreyGoodsService")
    public void setChannelStoreyGoodsService(ChannelStoreyGoodsService channelStoreyGoodsService) {
        this.channelStoreyGoodsService = channelStoreyGoodsService;
    }

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="ChannelGoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }

    public ChannelStoreyService getChannelStoreyService() {
        return this.channelStoreyService;
    }

    @Resource(name="ChannelStoreyService")
    public void setChannelStoreyService(ChannelStoreyService channelStoreyService) {
        this.channelStoreyService = channelStoreyService;
    }
}

