/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.ServiceSupport;
import com.qianjiang.system.service.HelpCenterService;
import com.qianjiang.system.service.ServiceSupportMapperService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ServiceSupportMapperController {
    private static final MyLogger LOGGER = new MyLogger(ServiceSupportMapperController.class);
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String SELECTSERVICESUPPORTLIST_HTM = "selectServiceSupportList.htm";
    private static final String HELPLIST = "helpList";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="serviceSupportMapperService")
    private ServiceSupportMapperService serviceSupportMapperService;
    @Resource(name="helpCenterService")
    private HelpCenterService helpCenterService;

    @RequestMapping(value={"/newServiceSupport"})
    public ModelAndView newServiceSupport(MultipartHttpServletRequest request, @Valid ServiceSupport serviceSupport, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(SELECTSERVICESUPPORTLIST_HTM));
        }
        try {
            MultipartFile muFile = request.getFile("imageSrc");
            if (null != muFile && muFile.getSize() > 0L) {
                serviceSupport.setServiceImageUrl(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
            }
            serviceSupport.setDelfalg("0");
            serviceSupport.setCreateTime(new Date());
            serviceSupport.setCreateUserId((Long)request.getSession().getAttribute(LOGINUSERID));
            this.serviceSupportMapperService.insertSelective(serviceSupport);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u670d\u52a1\u652f\u6301", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u670d\u52a1\u652f\u6301\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(SELECTSERVICESUPPORTLIST_HTM));
    }

    @RequestMapping(value={"/selectServiceSupportById"})
    public ModelAndView selectServiceSupportById(Long id) {
        ModelAndView mav = new ModelAndView();
        ServiceSupport serviceSupport = this.serviceSupportMapperService.selectByPrimaryKey(id);
        mav.setViewName("jsp/system/serviceSupport/show_serviceSupport");
        mav.addObject("serviceSupport", (Object)serviceSupport);
        mav.addObject(HELPLIST, (Object)this.helpCenterService.selectAll());
        return mav;
    }

    @RequestMapping(value={"/selectservicesupportbyidajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ServiceSupport selectservicesupportbyidajax(Long id) {
        return this.serviceSupportMapperService.selectByPrimaryKey(id);
    }

    @RequestMapping(value={"/updateServiceSupport"})
    public ModelAndView updateServiceSupport(MultipartHttpServletRequest request, @Valid ServiceSupport serviceSupport, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(SELECTSERVICESUPPORTLIST_HTM));
        }
        try {
            MultipartFile muFile = request.getFile("imageSrc");
            if (muFile != null && muFile.getSize() > 0L) {
                serviceSupport.setServiceImageUrl(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
            }
            serviceSupport.setUpdateTime(new Date());
            serviceSupport.setUpdateUserId((Long)request.getSession().getAttribute(LOGINUSERID));
            this.serviceSupportMapperService.updateByPrimaryKeySelective(serviceSupport);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u670d\u52a1\u652f\u6301", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u670d\u52a1\u652f\u6301\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(SELECTSERVICESUPPORTLIST_HTM));
    }

    @RequestMapping(value={"/newService"})
    public ModelAndView newService() {
        ModelAndView mav = new ModelAndView();
        mav.setViewName("jsp/system/serviceSupport/show_serviceSupport");
        mav.addObject(HELPLIST, (Object)this.helpCenterService.selectAll());
        return mav;
    }

    @RequestMapping(value={"/selectServiceSupportList"})
    public ModelAndView selectServiceSupportList(PageBean pb, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        this.serviceSupportMapperService.selectAllServiceSupport(pb);
        mav.setViewName("jsp/system/serviceSupport/serviceSupport_List");
        mav.addObject("pb", (Object)pb);
        mav.addObject(HELPLIST, (Object)this.helpCenterService.selectAll());
        return mav;
    }

    @RequestMapping(value={"/updateServiceSupportDelfalg"})
    public ModelAndView updateServiceSupportDelfalg(HttpServletRequest request) {
        try {
            String[] ids = request.getParameterValues("id[]");
            this.serviceSupportMapperService.updateServiceSupportByDelfalg(ids);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u670d\u52a1\u652f\u6301", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u670d\u52a1\u652f\u6301\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(SELECTSERVICESUPPORTLIST_HTM));
    }
}

