/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.goods.bean.GoodsTag;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsTagService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class TagController {
    private static final MyLogger LOGGER = new MyLogger(TagController.class);
    private static final String LOGGERINFO1 = "-->\u6807\u7b7e\u540d\u79f0\u3010";
    private static final String LOGGERINFO2 = "\u3011,\u7528\u6237\u540d\uff1a";
    @Resource(name="GoodsTagServiceImpl")
    private GoodsTagService goodsTagService;

    public GoodsTagService getGoodsTagService() {
        return this.goodsTagService;
    }

    public void setGoodsTagService(GoodsTagService goodsTagService) {
        this.goodsTagService = goodsTagService;
    }

    @RequestMapping(value={"/findGoodsTag"})
    public ModelAndView findGoodsTag(Long tagId) {
        GoodsTag goodsTag = this.goodsTagService.selectByPaimarykey(tagId);
        if (null != goodsTag.getTagName()) {
            LOGGER.info((Object)("\u6839\u636e\u6807\u7b7eID\u67e5\u8be2\u6240\u6709\u7684\u5546\u54c1\u6807\u7b7e,\u6807\u7b7e\u540d\u79f0\u4e3a:" + goodsTag.getTagName()));
        }
        return new ModelAndView("jsp/goods/goods_tag", "tag", (Object)goodsTag);
    }

    @RequestMapping(value={"/findAllTag"})
    public ModelAndView findAllTag(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        LOGGER.info((Object)"\u5206\u9875\u67e5\u8be2\u5546\u54c1\u6807\u7b7e");
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/goods/goods_tag", "pb", (Object)this.goodsTagService.selectAllTag(pb, selectBean));
    }

    @RequestMapping(value={"/deltag"})
    public ModelAndView deltag(Long tagId, HttpServletRequest request) {
        GoodsTag goodsTag = this.goodsTagService.selectByPaimarykey(tagId);
        this.goodsTagService.deleteByPrimaryKey(tagId, (String)request.getSession().getAttribute("name"));
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u5220\u9664\u5546\u54c1\u6807\u7b7e", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + goodsTag.getTagName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findAllTag.htm"));
    }

    @RequestMapping(value={"/addTag"})
    public ModelAndView addTag(@Valid GoodsTag record, HttpServletRequest request, MultipartHttpServletRequest request2) {
        this.goodsTagService.insertSelective(record);
        OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)((String)request.getSession().getAttribute("name")), (String)"\u6dfb\u52a0\u5546\u54c1\u6807\u7b7e", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + record.getTagName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findAllTag.htm"));
    }

    @RequestMapping(value={"/batchDelTag"})
    public ModelAndView batchDelTag(Long[] tagCheck, HttpServletRequest request) {
        LOGGER.info((Object)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u6807\u7b7e");
        this.goodsTagService.batchDeleteTag(tagCheck, (String)request.getSession().getAttribute("name"));
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)((String)request.getSession().getAttribute("name")), (String)"\u6279\u91cf\u5220\u9664\u5546\u54c1\u6807\u7b7e", (String)((String)request.getSession().getAttribute("operaPath") + ",\u7528\u6237\u540d\uff1a" + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findAllTag.htm"));
    }

    @RequestMapping(value={"/queryTagByParam"})
    public ModelAndView queryTagByParam(String columnName, String paramvalue) {
        if (null != columnName && null != paramvalue) {
            LOGGER.info((Object)("\u6839\u636e\u53c2\u6570\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2,\u53c2\u6570 \u5217\u540d\uff1a" + columnName + ",\u53c2\u6570\u7684\u503c\u4e3a:" + paramvalue));
        } else {
            LOGGER.info((Object)"\u6839\u636e\u53c2\u6570\u8fdb\u884c\u6a21\u7cca\u67e5\u8be2");
        }
        return new ModelAndView("jsp/goods/goods_tag", "tagList", (Object)this.goodsTagService.queryTagByParam(columnName, paramvalue));
    }

    @RequestMapping(value={"/updateTag"})
    public ModelAndView updateTag(@Valid GoodsTag tag, HttpServletRequest request, MultipartHttpServletRequest request2) {
        GoodsTag goodsTag = this.goodsTagService.selectByPaimarykey(tag.getTagId());
        this.goodsTagService.updateTagSelective(tag, (String)request.getSession().getAttribute("name"));
        OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)((String)request.getSession().getAttribute("name")), (String)"\u66f4\u65b0\u5546\u54c1\u6807\u7b7e", (String)((String)request.getSession().getAttribute("operaPath") + LOGGERINFO1 + goodsTag.getTagName() + LOGGERINFO2 + (String)request.getSession().getAttribute("name")));
        return new ModelAndView((View)new RedirectView("findAllTag.htm"));
    }

    @RequestMapping(value={"/checkTagName"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkTagName(String tagName) {
        if (null != tagName) {
            LOGGER.info((Object)("\u9a8c\u8bc1\u6807\u7b7e\u540d\u79f0\u662f\u5426\u53ef\u7528\u6807\u7b7e\u540d\u79f0\u4e3a\uff1a" + tagName));
        } else {
            LOGGER.info((Object)"\u9a8c\u8bc1\u6807\u7b7e\u540d\u79f0\u662f\u5426\u53ef\u7528");
        }
        return this.goodsTagService.checkTagName(tagName);
    }
}

