/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.manager.controller;

import com.qianjiang.comment.bean.Comment;
import com.qianjiang.comment.service.CommentServiceMapper;
import com.qianjiang.comment.service.ShareService;
import com.qianjiang.comment.vo.ShareVo;
import com.qianjiang.common.util.DateUtil;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.util.GoodsSearchBean;
import com.qianjiang.manager.bean.Authority;
import com.qianjiang.manager.bean.Manager;
import com.qianjiang.manager.bean.ManagerAuthority;
import com.qianjiang.manager.bean.valuebean.MenuVo;
import com.qianjiang.manager.service.AuthorityServiceInterface;
import com.qianjiang.manager.service.ManagerServiceInterface;
import com.qianjiang.manager.service.ManagerSmsService;
import com.qianjiang.manager.service.MenuServiceInterface;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.other.bean.CustomerAllInfo;
import com.qianjiang.system.bean.BasicSet;
import com.qianjiang.system.bean.StockWarning;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.StockWarningService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.util.MapUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="managerController")
public class ManagerController {
    private static final MyLogger LOGGER = new MyLogger(ManagerController.class);
    private static final String MANAGER = "manager";
    private static final String LOGINUSERID = "loginUserId";
    private static final String INITMANAGER_HTM = "initManager.htm";
    private static final String CHECKTYPE = "checkType";
    private static final String CHECKSUCCESS = "checkSuccess";
    private static final int HTHOUSAND = 100000;
    private static final String NAME = "name";
    private static final String ORDERLINEPAY = "orderLinePay";
    private static final String ORDERSTATUS = "orderStatus";
    private static final String ORDERMTYPE = "orderMType";
    private MenuServiceInterface menuServiceInterface;
    private ManagerServiceInterface managerService;
    private ManagerSmsService managerSmsService;
    @Resource(name="StockWarningService")
    private StockWarningService stockwarningservice;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="authorityService")
    private AuthorityServiceInterface authorityServiceInterface;
    @Resource(name="OrderService")
    private OrderService orderService;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="commentServiceMapper")
    private CommentServiceMapper commentServiceMapper;
    @Resource(name="shareServiceNew")
    private ShareService shareService;
    @Resource(name="GoodsService")
    private GoodsService goodsService;
    @Resource(name="managerService")
    private ManagerServiceInterface managerServiceInterface;

    @RequestMapping(value={"/iflogin"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int ifLogin(HttpServletRequest request, String name, String password, String code, String patchaFlag) {
        if ("1".equals(patchaFlag) && null == code || !code.equals(request.getSession().getAttribute("PATCHCA"))) {
            return -1;
        }
        if (null != name) {
            LOGGER.info((Object)("\u7ba1\u7406\u5458\u3010" + name + "\u3011\u767b\u9646"));
        }
        return this.managerService.ifManager(request, name, password);
    }

    @RequestMapping(value={"/tochromehelp"})
    public ModelAndView toChromeHelp() {
        return new ModelAndView("jsp/chrome_help");
    }

    @RequestMapping(value={"/controllerpanal"})
    public ModelAndView controllerPanal() {
        return new ModelAndView("jsp/page/controlpanel");
    }

    @RequestMapping(value={"/login11"})
    public ModelAndView managerLogin(String name, String password) {
        LOGGER.info((Object)"\u8df3\u8f6c\u5230\u9996\u9875");
        return new ModelAndView();
    }

    @RequestMapping(value={"index"})
    public ModelAndView loadIndex(HttpServletRequest request) {
        LOGGER.info((Object)"\u8df3\u8f6c\u5230\u9996\u9875");
        ModelAndView mav = new ModelAndView("jsp/index");
        try {
            Manager manager = this.managerService.queryManagerByName((String)request.getSession().getAttribute(NAME));
            mav.addObject(MANAGER, (Object)manager);
            request.getSession().setAttribute("menus", (Object)this.managerService.queryMenuByMangerName(manager.getUsername()));
            request.getSession().setAttribute("rootPageId", (Object)5594);
            request.getSession().setAttribute("parentPageId", (Object)5595);
            request.getSession().setAttribute("pageId", (Object)5596);
            Authority at = this.authorityServiceInterface.selectAuthByManagerId(manager.getId());
            request.getSession().setAttribute("designation", (Object)at.getDesignation());
            int countOrderToday = this.countOrder("1", "1");
            int countOrderYesterday = this.countOrder("2", "1");
            int countOrderUnPay = this.countOrder("3", "4");
            int countOrderUnDelivery = this.countOrder("4", "2");
            int countOrderRefund = this.countOrder("5", "9");
            int countOrderGood = this.countOrder("6", "10");
            long countCustomerToday = this.countCustomer("1");
            long countCustomerYesterday = this.countCustomer("2");
            long countCustomer = this.countCustomer("");
            long countConsult = this.countComment("1");
            long countShare = this.countComment("2");
            long countComments = this.countComment("3");
            int countGoods = this.countGood("1");
            int countOffShell = this.countGood("2");
            int countStock = this.countGood("3");
            int countWarning = this.countGood("4");
            mav.addObject("countOrderToday", (Object)countOrderToday);
            mav.addObject("countOrderYesterday", (Object)countOrderYesterday);
            mav.addObject("countOrderUnPay", (Object)countOrderUnPay);
            mav.addObject("countOrderUnDelivery", (Object)countOrderUnDelivery);
            mav.addObject("countOrderRefund", (Object)countOrderRefund);
            mav.addObject("countOrderGood", (Object)countOrderGood);
            mav.addObject("countCustomerToday", (Object)countCustomerToday);
            mav.addObject("countCustomerYesterday", (Object)countCustomerYesterday);
            mav.addObject("countCustomer", (Object)countCustomer);
            mav.addObject("countConsult", (Object)countConsult);
            mav.addObject("countShare", (Object)countShare);
            mav.addObject("countComments", (Object)countComments);
            mav.addObject("countGoods", (Object)countGoods);
            mav.addObject("countOffShell", (Object)countOffShell);
            mav.addObject("countStock", (Object)countStock);
            mav.addObject("countWarning", (Object)countWarning);
            BasicSet set = this.basicSetService.findBasicSet();
            String url = set.getBsetAddress();
            request.getSession().setAttribute("bsetAddressUrl", (Object)url);
            String bestThirdAddressUrl = set.getBsetThirdAddress();
            bestThirdAddressUrl = BasicSetUtil.getAddress((String)bestThirdAddressUrl);
            request.getSession().setAttribute("bestThirdAddressUrl", (Object)bestThirdAddressUrl);
            request.getSession().setAttribute("mobileAddressUrl", (Object)set.getMobileAddress());
            LOGGER.info((Object)("\u5546\u5bb6\u540e\u53f0,supplier\u7aef\u7684 :" + bestThirdAddressUrl));
            LOGGER.info((Object)("\u524d\u53f0\u7684\u57fa\u672c\u4fe1\u606f\u7684\u5730\u5740 :" + url));
            LOGGER.info((Object)("mobile\u7aef\u7684 :" + set.getMobileAddress()));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u8df3\u8f6c\u9996\u9875\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    private int countOrder(String orderType, String status) {
        String startTime = "";
        String endTime = "";
        Order order = new Order();
        order.setBusinessId(Long.valueOf(0L));
        order.setDelFlag("0");
        if (orderType != null && "1".equals(orderType)) {
            startTime = DateUtil.getSysCurrentDate() + " 00:00:00";
            endTime = DateUtil.getSysCurrentDate() + " 23:59:59";
            order.setStartTime(startTime);
            order.setEndTime(endTime);
        } else if (orderType != null && "2".equals(orderType)) {
            startTime = DateUtil.dateSub((int)-1) + " 00:00:00";
            endTime = DateUtil.dateSub((int)-1) + " 23:59:59";
            order.setStartTime(startTime);
            order.setEndTime(endTime);
        }
        Map paramMap = MapUtil.getParamsMap((Object)order);
        if ("2".equals(status)) {
            paramMap.put(ORDERSTATUS, "1");
        } else if ("3".equals(status)) {
            paramMap.put(ORDERSTATUS, "2");
        } else if ("4".equals(status)) {
            paramMap.put(ORDERSTATUS, "0");
            paramMap.put(ORDERLINEPAY, "1");
        } else if ("5".equals(status)) {
            paramMap.put(ORDERSTATUS, "");
            paramMap.put(ORDERLINEPAY, "0");
        } else if ("6".equals(status)) {
            paramMap.put(ORDERSTATUS, "3");
            paramMap.put(ORDERLINEPAY, "");
        } else if ("7".equals(status)) {
            paramMap.put(ORDERSTATUS, "4");
            paramMap.put(ORDERLINEPAY, "");
        } else if ("8".equals(status)) {
            paramMap.put(ORDERSTATUS, "");
            paramMap.put(ORDERLINEPAY, "");
            paramMap.put(ORDERMTYPE, "2");
        } else if ("9".equals(status)) {
            paramMap.put(ORDERSTATUS, "15");
            paramMap.put(ORDERLINEPAY, "1");
        } else if ("10".equals(status)) {
            paramMap.put(ORDERSTATUS, "14");
            paramMap.put(ORDERLINEPAY, "1");
        } else {
            paramMap.put(ORDERLINEPAY, "");
            paramMap.put(ORDERSTATUS, "");
            paramMap.put(ORDERMTYPE, "");
        }
        int count = 0;
        try {
            count = this.orderService.searchOrderCount(paramMap);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u7edf\u8ba1\u8ba2\u5355\u6570\u91cf\u9519\u8bef" + e.getMessage(), (Throwable)e);
        }
        return count;
    }

    private long countCustomer(String customerType) {
        String startTime = "";
        String endTime = "";
        CustomerAllInfo allInfo = new CustomerAllInfo();
        if (customerType != null && "1".equals(customerType)) {
            startTime = DateUtil.getSysCurrentDate() + " 00:00:00";
            endTime = DateUtil.getSysCurrentDate() + " 23:59:59";
            allInfo.setStartTime(startTime);
            allInfo.setEndTime(endTime);
        } else if (customerType != null && "2".equals(customerType)) {
            startTime = DateUtil.dateSub((int)-1) + " 00:00:00";
            endTime = DateUtil.dateSub((int)-1) + " 23:59:59";
            allInfo.setStartTime(startTime);
            allInfo.setEndTime(endTime);
        }
        long count = 0L;
        try {
            count = this.customerServiceMapper.selectCustmerSizeFilterThird(allInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u7edf\u8ba1\u4f1a\u5458\u6570\u91cf\u9519\u8bef" + e.getMessage(), (Throwable)e);
        }
        return count;
    }

    private long countComment(String commentType) {
        String startTime = "";
        String endTime = "";
        long count = 0L;
        Long thirdId = 0L;
        try {
            if (commentType != null && "1".equals(commentType)) {
                Comment comment = new Comment();
                comment.setIsDisplay("1");
                comment.setThirdId(thirdId);
                count = this.commentServiceMapper.queryConsultCount(comment);
            } else if (commentType != null && "2".equals(commentType)) {
                ShareVo shareVo = new ShareVo();
                startTime = DateUtil.getSysCurrentDate() + " 00:00:00";
                endTime = DateUtil.getSysCurrentDate() + " 23:59:59";
                shareVo.setCreateTime(DateUtil.stringtoDate((String)startTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                shareVo.setCreateTimeTo(DateUtil.stringtoDate((String)endTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                shareVo.setThirdId(thirdId);
                count = this.shareService.selectAllShareCount(shareVo);
            } else if (commentType != null && "3".equals(commentType)) {
                Comment comment = new Comment();
                startTime = DateUtil.getSysCurrentDate() + " 00:00:00";
                endTime = DateUtil.getSysCurrentDate() + " 23:59:59";
                comment.setPublishTime(DateUtil.stringtoDate((String)startTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                comment.setPublishTimeTo(DateUtil.stringtoDate((String)endTime, (String)DateUtil.DEFAULT_TIME_PATTERN));
                comment.setThirdId(thirdId);
                count = this.commentServiceMapper.queryCommentCount(comment);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u7edf\u8ba1\u6570\u91cf\u9519\u8bef" + e.getMessage(), (Throwable)e);
        }
        return count;
    }

    private int countGood(String goodType) {
        int count = 0;
        GoodsSearchBean searchBean = new GoodsSearchBean();
        searchBean.setCondition("1");
        searchBean.setGoodsCateId("-1");
        searchBean.setIsThird("0");
        searchBean.setShowFlag("1");
        searchBean.setStatus("-1");
        try {
            StockWarning sw = this.stockwarningservice.select();
            if (searchBean != null) {
                if ("1".equals(searchBean.getShowFlag())) {
                    searchBean.setCondition("-1");
                    searchBean.setSearchText("");
                    searchBean.setSwValue(sw.getSwValue());
                } else {
                    searchBean.setGoodsBrandId("-1");
                    searchBean.setGoodsCateId("-1");
                    searchBean.setGoodsKeyword("");
                    searchBean.setGoodsName("");
                    searchBean.setGoodsNo("");
                    searchBean.setShowFlag("0");
                    searchBean.setStatus("-1");
                    searchBean.setThirdName("");
                    searchBean.setSwValue(sw.getSwValue());
                }
                if (null != searchBean.getIsThird() && "0".equals(searchBean.getIsThird())) {
                    searchBean.setThirdName("");
                }
            }
            if (goodType != null && "1".equals(goodType)) {
                searchBean.setQueryStatus("1");
                count = this.goodsService.queryTotalCountBySearchBean(searchBean);
            } else if (goodType != null && "2".equals(goodType)) {
                searchBean.setQueryStatus("2");
                count = this.goodsService.queryTotalCountBySearchBean(searchBean);
            } else if (goodType != null && "3".equals(goodType)) {
                searchBean.setQueryStatus("3");
                count = this.goodsService.queryStockTotalCountBySearchBean(searchBean);
            } else if (goodType != null && "4".equals(goodType)) {
                searchBean.setQueryStatus("4");
                count = this.goodsService.queryElaryTotalCountBySearchBean(searchBean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u7edf\u8ba1\u6570\u91cf\u9519\u8bef" + e.getMessage(), (Throwable)e);
        }
        return count;
    }

    @RequestMapping(value={"/loadMenus"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<MenuVo> loadMenus(String name) {
        if (null != name) {
            LOGGER.info((Object)("\u7ba1\u7406\u5458\u3010" + name + "\u3011\u767b\u9646"));
        }
        return this.managerService.queryMenuByMangerName(name);
    }

    @RequestMapping(value={"/login"})
    public ModelAndView logOut(HttpServletRequest request) {
        request.getSession().removeAttribute(NAME);
        return new ModelAndView("jsp/begin");
    }

    @RequestMapping(value={"/initManager"})
    public ModelAndView initManager(PageBean pageBean, HttpServletRequest request, Manager manager) {
        Integer flag = (Integer)request.getSession().getAttribute("managerFlag");
        Long createId = null;
        if (flag != null && flag != 1) {
            createId = (Long)request.getSession().getAttribute(LOGINUSERID);
        }
        pageBean.setUrl(INITMANAGER_HTM);
        return new ModelAndView("jsp/core/manager/managerlist").addObject("pageBean", (Object)this.managerService.queryManagerList(manager, pageBean, createId));
    }

    @RequestMapping(value={"/queryAllManagerForWareHouse"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> queryAllManagerForWareHouse(PageBean pb) {
        pb.setPageSize(100000);
        return this.managerService.queryManagerList(new Manager(), pb, null).getList();
    }

    @RequestMapping(value={"/initSetting"})
    public ModelAndView initSetting() {
        return new ModelAndView("jsp/core/manager/settingcenter");
    }

    @RequestMapping(value={"/addManager"})
    public ModelAndView addManager(HttpServletRequest request, Manager manager, String authorityId, HttpServletResponse response, MultipartHttpServletRequest multipartRequest) {
        if (null != manager.getUsername()) {
            LOGGER.info((Object)("\u65b0\u589e\u540d\u79f0\u4e3a\u3010" + manager.getUsername() + "\u3011\u7ba1\u7406\u5458"));
        }
        Long createId = (Long)request.getSession().getAttribute(LOGINUSERID);
        manager.setCreateId(createId);
        this.managerService.addManager(manager, authorityId);
        OperaLogUtil.addOperaLog((HttpServletRequest)multipartRequest, (String)((String)multipartRequest.getSession().getAttribute(NAME)), (String)"\u6dfb\u52a0\u7ba1\u7406\u5458", (String)("\u6dfb\u52a0\u7ba1\u7406\u5458,\u7ba1\u7406\u5458\u540d:" + manager.getUsername()));
        return new ModelAndView((View)new RedirectView(INITMANAGER_HTM));
    }

    public void setImg(Manager manager, MultipartHttpServletRequest multipartRequest) {
        if (multipartRequest.getFile("file") != null && !"".equals(multipartRequest.getFile("file").getOriginalFilename())) {
            manager.setPhotoImg((String)UploadUtil.uploadFile((MultipartFile)multipartRequest.getFile("file")).get("oldimg"));
        }
    }

    @RequestMapping(value={"/configManager"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> configManager(String applyMobilephone, Manager manager) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != manager.getUsername()) {
            LOGGER.info((Object)("\u65b0\u589e\u540d\u79f0\u4e3a\u3010" + manager.getUsername() + "\u3011\u7ba1\u7406\u5458"));
        }
        manager.setUsername(applyMobilephone);
        int num = (int)((Math.random() * 9.0 + 1.0) * 100000.0);
        manager.setUserkey(Integer.valueOf(num).toString());
        manager.setCreateId(Long.valueOf(-1L));
        String authorityId = new String("1");
        this.managerService.addManager(manager, authorityId);
        Manager configManager = this.managerService.queryManagerById(manager.getId());
        map.put("configManager", configManager);
        map.put(MANAGER, manager);
        return map;
    }

    @RequestMapping(value={"/queryManagerById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Manager queryManagerById(HttpServletRequest request, Long id) {
        if (id != null) {
            Manager manager = this.managerService.queryManagerById(id);
            manager.setUserkey(null);
            if (null != manager.getUsername()) {
                LOGGER.info((Object)("\u83b7\u53d6\u7ba1\u7406\u5458\u3010" + manager.getUsername() + "\u3011\u7684\u4fe1\u606f"));
                return manager;
            }
        }
        return null;
    }

    @RequestMapping(value={"/queryByManager"})
    public ModelAndView queryByManager(Manager manager, PageBean pageBean, String[] attr) throws UnsupportedEncodingException {
        pageBean.setUrl("queryByManager.htm");
        return new ModelAndView("jsp/core/manager/managerlist", "pageBean", (Object)this.managerService.queryManagerList(manager, pageBean, null)).addObject(MANAGER, (Object)manager).addObject("attr", (Object)attr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/deleteManager"})
    public ModelAndView deleteManager(HttpServletRequest request, HttpServletResponse response, Long managerId) {
        PrintWriter pr = null;
        String[] customerIds = null;
        StringBuilder str = new StringBuilder("[");
        String empStr = "";
        try {
            pr = response.getWriter();
            if (managerId != null) {
                customerIds = new String[]{managerId + ""};
                for (String id : customerIds) {
                    str.append(id + ",");
                }
                empStr = str.toString().substring(0, str.length() - 1) + "]";
            } else {
                for (String id : customerIds = request.getParameterValues("parameterIds[]")) {
                    str.append(id + ",");
                }
                empStr = str.toString().substring(0, str.length() - 1) + "]";
            }
            pr.print(this.managerService.deleteManager(customerIds));
        }
        catch (IOException e) {
            OperaLogUtil.addOperaException((String)((String)request.getSession().getAttribute(NAME)), (Exception)e, (HttpServletRequest)request);
        }
        finally {
            OperaLogUtil.addOperaLog((HttpServletRequest)request, (String)((String)request.getSession().getAttribute(NAME)), (String)"\u5220\u9664\u7ba1\u7406\u5458", (String)("\u5220\u9664\u7ba1\u7406\u5458,\u7ba1\u7406\u5458\u7f16\u53f7:" + empStr));
            customerIds = null;
            str = null;
            pr = null;
            empStr = null;
        }
        return null;
    }

    @RequestMapping(value={"/deleteallmanager"})
    public ModelAndView deleteAllManager(HttpServletRequest request, HttpServletResponse response) {
        this.managerService.deleteManager(request.getParameterValues("managerid"));
        return new ModelAndView((View)new RedirectView(INITMANAGER_HTM));
    }

    @RequestMapping(value={"/delCloudManager"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> delCloudManager(String loginName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Manager manager = this.managerService.queryDelManagerByName(loginName);
        if (manager != null) {
            String[] managerIds = new String[]{Long.toString(manager.getId())};
            int line = this.managerService.deleteManager(managerIds);
            map.put("line", line);
        }
        return map;
    }

    @RequestMapping(value={"/enableCloudManager"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> enableCloudManager(String loginName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Manager manager = this.managerService.queryDelManagerByName(loginName);
        if (manager != null) {
            String[] managerIds = new String[]{Long.toString(manager.getId())};
            int line = this.managerService.enabledManager(managerIds);
            Manager newManager = this.managerService.queryManagerById(manager.getId());
            map.put("createTime", newManager.getCreateTime());
            map.put("line", line);
        }
        return map;
    }

    @RequestMapping(value={"/updateManager"})
    public ModelAndView updateManager(Manager manager, ManagerAuthority authority, MultipartHttpServletRequest multipartRequest, HttpServletRequest request) {
        String name;
        Manager managers;
        if (null != manager.getUsername()) {
            LOGGER.info((Object)("\u4fee\u6539\u7ba1\u7406\u5458\u3010" + manager.getUsername() + "\u3011\u7684\u4fe1\u606f"));
        }
        if ((managers = this.managerServiceInterface.queryDelManagerByName(name = (String)request.getSession().getAttribute(NAME))) != null && manager.getId().equals(managers.getId())) {
            request.getSession().removeAttribute(NAME);
            request.getSession().setAttribute(NAME, (Object)manager.getUsername());
        }
        this.managerService.updateManager(manager, authority);
        OperaLogUtil.addOperaLog((HttpServletRequest)multipartRequest, (String)((String)multipartRequest.getSession().getAttribute(NAME)), (String)"\u4fee\u6539\u7ba1\u7406\u5458", (String)("\u4fee\u6539\u7ba1\u7406\u5458,\u7f16\u53f7:" + manager.getId()));
        return new ModelAndView((View)new RedirectView(INITMANAGER_HTM));
    }

    @RequestMapping(value={"/checkUserKey"})
    public ModelAndView checkUserKey(HttpServletRequest request, HttpServletResponse response, String userKey) {
        if (null != userKey) {
            LOGGER.info((Object)("\u9a8c\u8bc1\u5bc6\u7801\u3010" + userKey + "\u3011\u662f\u5426\u6b63\u786e\uff01"));
        }
        try {
            response.getWriter().print(this.managerService.checkUserKey((String)request.getSession().getAttribute(NAME), userKey));
        }
        catch (IOException e) {
            OperaLogUtil.addOperaException((String)((String)request.getSession().getAttribute(NAME)), (Exception)e, (HttpServletRequest)request);
        }
        return null;
    }

    @RequestMapping(value={"/checkUserKeyMain"})
    public ModelAndView checkUserKeyMain(HttpServletRequest request, HttpServletResponse response, String userKey) {
        if (null != userKey) {
            LOGGER.info((Object)("\u9a8c\u8bc1\u5bc6\u7801\u3010" + userKey + "\u3011\u662f\u5426\u6b63\u786e\uff01"));
        }
        try {
            int f = this.managerService.checkUserKey((String)request.getSession().getAttribute(NAME), userKey);
            if (f == 1) {
                request.getSession().setAttribute(CHECKTYPE, (Object)"1");
                request.getSession().setAttribute(CHECKSUCCESS, (Object)"1");
            } else {
                request.getSession().setAttribute(CHECKTYPE, (Object)"");
                request.getSession().setAttribute(CHECKSUCCESS, (Object)"");
            }
            response.getWriter().print(f);
        }
        catch (IOException e) {
            OperaLogUtil.addOperaException((String)((String)request.getSession().getAttribute(NAME)), (Exception)e, (HttpServletRequest)request);
        }
        return null;
    }

    @RequestMapping(value={"/modifiedUserKey"})
    public ModelAndView modifiedUserKey(HttpServletRequest request, HttpServletResponse response, String userKey, String newuserkey) {
        if (null != userKey) {
            LOGGER.info((Object)("\u4fee\u6539\u5bc6\u7801\uff0c\u65e7\u5bc6\u7801\u4e3a\u3010" + userKey + "\u3011"));
        }
        try {
            if (request.getSession().getAttribute(CHECKTYPE) != null && "1".equals(request.getSession().getAttribute(CHECKTYPE))) {
                if (request.getSession().getAttribute(CHECKSUCCESS) != null && "1".equals(request.getSession().getAttribute(CHECKSUCCESS))) {
                    response.getWriter().print(this.managerService.modifiedUserKey((String)request.getSession().getAttribute(NAME), userKey, newuserkey));
                }
            } else if (request.getSession().getAttribute(CHECKTYPE) != null && "2".equals(request.getSession().getAttribute(CHECKTYPE))) {
                if (request.getSession().getAttribute(CHECKSUCCESS) != null && "1".equals(request.getSession().getAttribute(CHECKSUCCESS))) {
                    response.getWriter().print(this.managerService.modifiedUserKey((String)request.getSession().getAttribute(NAME), userKey, newuserkey));
                }
            } else {
                response.getWriter().print(0);
            }
            request.getSession().setAttribute(CHECKTYPE, (Object)"");
            request.getSession().setAttribute(CHECKSUCCESS, (Object)"");
        }
        catch (IOException e) {
            OperaLogUtil.addOperaException((String)((String)request.getSession().getAttribute(NAME)), (Exception)e, (HttpServletRequest)request);
        }
        return null;
    }

    @RequestMapping(value={"/updatePwd"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updatePwd(HttpServletRequest request, HttpServletResponse response, Long managerid, String newpwd) {
        int result = 0;
        try {
            Manager m = this.managerService.queryManagerById(managerid);
            String oldPwd = m.getUserkey();
            String name = m.getUsername();
            request.setAttribute(NAME, (Object)name);
            result = this.managerService.modifiedPwd((String)request.getSession().getAttribute(NAME), oldPwd, newpwd);
        }
        catch (Exception e) {
            OperaLogUtil.addOperaException((String)((String)request.getSession().getAttribute(NAME)), (Exception)e, (HttpServletRequest)request);
        }
        return result;
    }

    @RequestMapping(value={"/modifymanager"})
    public ModelAndView updateManager(Manager manager, HttpServletResponse response, MultipartHttpServletRequest multipartRequest) {
        if (null != manager.getUsername()) {
            LOGGER.info((Object)("\u4fee\u6539\u7ba1\u7406\u5458\u3010" + manager.getUsername() + "\u3011\u7684\u4fe1\u606f"));
        }
        if (multipartRequest.getSession().getAttribute(CHECKTYPE) != null && "1".equals(multipartRequest.getSession().getAttribute(CHECKTYPE)) && multipartRequest.getSession().getAttribute(CHECKSUCCESS) != null && "1".equals(multipartRequest.getSession().getAttribute(CHECKSUCCESS))) {
            this.managerService.updateManagerOnly(manager);
            Manager m = this.managerService.queryManagerById(manager.getId());
            multipartRequest.getSession().setAttribute("photoImg", (Object)m.getPhotoImg());
        } else if (multipartRequest.getSession().getAttribute(CHECKTYPE) != null && "2".equals(multipartRequest.getSession().getAttribute(CHECKTYPE)) && multipartRequest.getSession().getAttribute(CHECKSUCCESS) != null && "1".equals(multipartRequest.getSession().getAttribute(CHECKSUCCESS))) {
            this.managerService.updateManagerOnly(manager);
            Manager m = this.managerService.queryManagerById(manager.getId());
            multipartRequest.getSession().setAttribute("photoImg", (Object)m.getPhotoImg());
        }
        multipartRequest.getSession().setAttribute(CHECKTYPE, (Object)"");
        multipartRequest.getSession().setAttribute(CHECKSUCCESS, (Object)"");
        return new ModelAndView((View)new RedirectView("index.htm"));
    }

    @RequestMapping(value={"/sendcodecore"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int sendMobileCode(HttpServletRequest request, String mobile) {
        if (null != mobile) {
            LOGGER.info((Object)("\u53d1\u9001\u9a8c\u8bc1\u7801\u5230\u53f7\u7801\u4e3a\u3010" + mobile + "\u3011\u7684\u624b\u673a\u4e0a"));
        }
        return this.managerSmsService.sendPost((Long)request.getSession().getAttribute(LOGINUSERID), mobile);
    }

    @RequestMapping(value={"/getcodecore"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int getMCode(HttpServletRequest request, String code) throws IOException {
        int f;
        if (null != code) {
            LOGGER.info((Object)("\u68c0\u67e5\u624b\u673a\u9a8c\u8bc1\u7801\u3010" + code + "\u3011\u662f\u5426\u6b63\u786e"));
        }
        if ((f = this.managerSmsService.getMCode((Long)request.getSession().getAttribute(LOGINUSERID), code)) == 1) {
            request.getSession().setAttribute(CHECKTYPE, (Object)"2");
            request.getSession().setAttribute(CHECKSUCCESS, (Object)"1");
        } else {
            request.getSession().setAttribute(CHECKTYPE, (Object)"");
            request.getSession().setAttribute(CHECKSUCCESS, (Object)"");
        }
        return f;
    }

    @RequestMapping(value={"/getmobile"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Manager getMobile(HttpServletRequest request) {
        return this.managerSmsService.queryManagerById((Long)request.getSession().getAttribute(LOGINUSERID));
    }

    @RequestMapping(value={"/checkmanagerexist"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Long checkManagerExist(String usernamen) {
        if (null != usernamen) {
            LOGGER.info((Object)("\u9a8c\u8bc1\u7ba1\u7406\u5458\u3010" + usernamen + "\u3011\u662f\u5426\u5b58\u5728"));
        }
        return this.managerService.checkManagerExist(usernamen);
    }

    public ManagerServiceInterface getManagerService() {
        return this.managerService;
    }

    @Resource(name="managerService")
    public void setManagerService(ManagerServiceInterface managerService) {
        this.managerService = managerService;
    }

    public MenuServiceInterface getMenuServiceInterface() {
        return this.menuServiceInterface;
    }

    @Resource(name="menuServiceInterface")
    public void setMenuServiceInterface(MenuServiceInterface menuServiceInterface) {
        this.menuServiceInterface = menuServiceInterface;
    }

    public ManagerSmsService getManagerSmsService() {
        return this.managerSmsService;
    }

    @Resource(name="managerSmsService")
    public void setManagerSmsService(ManagerSmsService managerSmsService) {
        this.managerSmsService = managerSmsService;
    }
}

