/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.common.util.DateUtil;
import com.qianjiang.customer.bean.CustomerAddress;
import com.qianjiang.customer.bean.CustomerInfo;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.GoodsProductSon;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsProductSonService;
import com.qianjiang.goods.service.ProductWareService;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.BackOrder;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderGoods;
import com.qianjiang.order.bean.OrderLogger;
import com.qianjiang.order.service.BackOrderLogService;
import com.qianjiang.order.service.BackOrderService;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderGoodsService;
import com.qianjiang.order.service.OrderLogService;
import com.qianjiang.order.service.OrderLoggerService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.orderbartergoods.domain.OrderBarterGoodsDomain;
import com.qianjiang.orderbartergoods.service.OrderBarterGoodsService;
import com.qianjiang.other.bean.CityBean;
import com.qianjiang.other.bean.DistrictBean;
import com.qianjiang.other.bean.ProvinceBean;
import com.qianjiang.system.service.ILogisticsCompanyBiz;
import com.qianjiang.thirdaudit.bean.StoreInfo;
import com.qianjiang.thirdaudit.service.AuditService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UtilDate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class OrderController {
    public static final MyLogger LOGGER = new MyLogger(OrderController.class);
    private static final String STATUS = "status";
    private static final String ORDER = "order";
    private static final String PAGEBEAN = "pageBean";
    private static final String BEGINTIME = "beginTime";
    private static final String ENDTIME = "endTime";
    private static final String BEGINPRICE = "beginPrice";
    private static final String ENDPRICE = "endPrice";
    private static final String DATE = "yyyy-MM-dd";
    private OrderService orderService;
    private OrderCouponService orderCouponService;
    private OrderLogService orderLogService;
    @Resource(name="WareHouseService")
    private WareHouseService wareHouseService;
    @Resource(name="logisticsCompanyBizImpl")
    private ILogisticsCompanyBiz logisticsCompanyBiz;
    @Resource(name="auditService")
    private AuditService auditService;
    @Resource(name="orderLoggerService")
    private OrderLoggerService orderLoggerService;
    @Autowired
    private BackOrderService BackOrderService;
    @Autowired
    private CustomerPointServiceMapper customerPointServiceMapper;
    @Autowired
    private GoodsProductService goodsProductService;
    @Autowired
    private BackOrderService backOrderService;
    @Autowired
    private BackOrderLogService backOrderLogService;
    @Autowired
    private OrderBarterGoodsService orderBarterGoodsService;
    @Autowired
    private GoodsProductSonService goodsProductSonService;
    @Autowired
    private OrderGoodsService orderGoodsService;
    @Autowired
    private ProductWareService productWareService;

    @RequestMapping(value={"/syncBackOrder"})
    public void syncBackOrder(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = null;
        String data = this.getBody(request);
        HashMap<String, String> returnObj = new HashMap<String, String>();
        try {
            data = URLDecoder.decode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            returnObj.put("resultCode", "0");
            returnObj.put("message", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u6570\u636e");
            jsonObject = JSONObject.fromObject(returnObj);
            response.setContentType("text/html;charset=utf-8");
            PrintWriter out = null;
            try {
                out = response.getWriter();
                out.print(jsonObject);
                out.flush();
                out.close();
            }
            catch (IOException es) {
                es.printStackTrace();
            }
            return;
        }
        if (null == data) {
            returnObj.put("resultCode", "0");
            returnObj.put("message", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u6570\u636e");
        } else {
            String infoMobile;
            String orderCode;
            JSONObject object = JSONObject.fromObject((Object)data);
            String orderType = object.getString("order_type");
            if ("1".equals(orderType)) {
                JSONArray goodsArray;
                orderCode = object.getString("order_code");
                infoMobile = object.getString("info_mobile");
                CustomerInfo customerInfo = this.customerPointServiceMapper.selectCustInfoByMobile(infoMobile);
                String backOrderCode = object.getString("back_order_code");
                JSONArray goodsMapList = goodsArray = object.getJSONArray("goodsInfoList");
                BackOrder backOrder = new BackOrder();
                backOrder.setCustomerId(customerInfo.getCustomerId());
                BackOrder isBackOrder = this.backOrderService.isBackOrder(orderCode);
                backOrder.setBusinessId(Long.valueOf(0L));
                backOrder.setBackCheck("4");
                backOrder.setBackTime(new Date());
                backOrder.setIsBack("1");
                backOrder.setOrderCode(orderCode);
                backOrder.setBackReason("4");
                backOrder.setApplyCredentials("3");
                Order order = this.orderService.getPayOrderByCode(orderCode);
                Order orders = new Order();
                orders.setOrderId(order.getOrderId());
                orders.setBusinessId(Long.valueOf(0L));
                orders.setOrderStatus("17");
                this.orderService.updateOrderStatusByorderIdFortask(orders);
                if ("".equals(backOrder.getBackGoodsIdAndSum()) || null == backOrder.getBackGoodsIdAndSum()) {
                    backOrder.setBackPrice(order.getOrderPrice().subtract(order.getExpressPrice()));
                    List og = this.orderService.queryOrderGoods(order.getOrderId());
                    StringBuilder goodsInfo = new StringBuilder();
                    for (int i = 0; i < og.size(); ++i) {
                        if (i > 0) {
                            goodsInfo.append("-");
                        }
                        goodsInfo.append(((OrderGoods)og.get(i)).getGoodsInfoId() + "," + ((OrderGoods)og.get(i)).getGoodsInfoNum() + "," + ((OrderGoods)og.get(i)).getOrderGoodsId());
                    }
                    backOrder.setBackGoodsIdAndSum(goodsInfo.toString());
                }
                int count = 0;
                if (null == isBackOrder) {
                    backOrder.setBackOrderCode(backOrderCode);
                    count = this.backOrderService.insertBackOrderInfo(backOrder);
                    returnObj.put("resultCode", "1");
                    returnObj.put("message", "\u65b0\u589e\u9000\u8d27\u8ba2\u5355\u5b8c\u6210");
                    List orderGoods = this.orderGoodsService.selectOrderGoodsLists(order.getOrderId());
                    HashMap<String, Object> paramMap = new HashMap<String, Object>();
                    GoodsProductSon goodsProductSon = new GoodsProductSon();
                    for (OrderGoods orderGood : orderGoods) {
                        String[] goodsInfoItemNoS;
                        System.out.println("~~~~~~~~~\u8d27\u54c1\u56de\u6eda");
                        paramMap.put("stock", orderGood.getGoodsInfoNum());
                        paramMap.put("productId", orderGood.getGoodsInfoId());
                        paramMap.put("distinctId", "79");
                        this.productWareService.plusStockToWare(paramMap);
                        for (String itemNoS : goodsInfoItemNoS = orderGood.getGoodsInfoItemNoS().split(",")) {
                            goodsProductSon.setIsUse("0");
                            goodsProductSon.setGoodsInfoItemNoS(itemNoS);
                            this.goodsProductSonService.updateGoodsProductSons(goodsProductSon);
                        }
                    }
                }
            } else if ("2".equals(orderType)) {
                orderCode = object.getString("order_code");
                infoMobile = object.getString("info_mobile");
                CustomerInfo customerInfo = this.customerPointServiceMapper.selectCustInfoByMobile(infoMobile);
                String backOrderCode = object.getString("back_order_code");
                BackOrder backOrder = new BackOrder();
                backOrder.setCustomerId(customerInfo.getCustomerId());
                BackOrder isBackOrder = this.backOrderService.isBackOrder(orderCode);
                backOrder.setBusinessId(Long.valueOf(0L));
                backOrder.setBackCheck("4");
                backOrder.setBackTime(new Date());
                backOrder.setIsBack("3");
                backOrder.setOrderCode(orderCode);
                backOrder.setBackReason("4");
                backOrder.setApplyCredentials("3");
                Order order = this.orderService.getPayOrderByCode(orderCode);
                Order orders = new Order();
                orders.setOrderId(order.getOrderId());
                orders.setBusinessId(Long.valueOf(0L));
                orders.setOrderStatus("17");
                this.orderService.updateOrderStatusByorderIdFortask(orders);
                if ("".equals(backOrder.getBackGoodsIdAndSum()) || null == backOrder.getBackGoodsIdAndSum()) {
                    backOrder.setBackPrice(order.getOrderPrice().subtract(order.getExpressPrice()));
                    List og = this.orderService.queryOrderGoods(order.getOrderId());
                    StringBuilder goodsInfo = new StringBuilder();
                    for (int i = 0; i < og.size(); ++i) {
                        if (i > 0) {
                            goodsInfo.append("-");
                        }
                        goodsInfo.append(((OrderGoods)og.get(i)).getGoodsInfoId() + "," + ((OrderGoods)og.get(i)).getGoodsInfoNum() + "," + ((OrderGoods)og.get(i)).getOrderGoodsId());
                    }
                    backOrder.setBackGoodsIdAndSum(goodsInfo.toString());
                }
                int count = 0;
                if (null == isBackOrder) {
                    Object objects;
                    JSONArray goodsArray;
                    backOrder.setBackOrderCode(backOrderCode);
                    count = this.backOrderService.insertBackOrderInfo(backOrder);
                    Long barterId = this.backOrderService.selectLastId();
                    JSONArray goodsMapList = goodsArray = object.getJSONArray("goodsInfoList");
                    OrderBarterGoodsDomain orderBarterGoodsDomain = new OrderBarterGoodsDomain();
                    orderBarterGoodsDomain.setOrderBarterId(barterId);
                    orderBarterGoodsDomain.setCreateTiem(new Date());
                    orderBarterGoodsDomain.setBarterTime(new Date());
                    HashMap<Long, Long> productSon = new HashMap<Long, Long>();
                    HashMap<String, String> productSons = new HashMap<String, String>();
                    HashMap<String, Object> sMap = new HashMap<String, Object>();
                    Long[] goodsIdP = new Long[goodsMapList.size()];
                    Long[] goodsNum = new Long[goodsMapList.size()];
                    int numGoods = 0;
                    String[] goodsProductSonList = new String[goodsMapList.size()];
                    int index = 0;
                    int goodsProductSonNew = 0;
                    String[] skuCodeBarters = null;
                    GoodsProductSon goodsProductSon = null;
                    int i = 0;
                    int j1 = 0;
                    for (Map map : goodsMapList) {
                        objects = map.get("sku_code_barter");
                        if (objects == null || "".equals(objects)) continue;
                        skuCodeBarters = new String[j1 + 1];
                    }
                    for (Map map : goodsMapList) {
                        objects = map.get("sku_code_barter");
                        if (objects == null || "".equals(objects)) continue;
                        skuCodeBarters[i] = objects.toString();
                        ++i;
                    }
                    for (int j = 0; j < skuCodeBarters.length; ++j) {
                        void skuCodeBarter = skuCodeBarters[j];
                        sMap.put("goodsInfoItemNoS", skuCodeBarter);
                        sMap.put("isUse", "0");
                        goodsProductSon = this.goodsProductSonService.selectByGoodsItemNoS(sMap);
                        if (index == 0) {
                            productSon.put(goodsProductSon.getGoodsInfoId(), 1L);
                            productSons.put(goodsProductSon.getGoodsInfoItemNo(), goodsProductSon.getGoodsInfoItemNoS());
                            ++index;
                        } else if (productSon.get(goodsProductSon.getGoodsInfoId()) != null) {
                            productSon.put(goodsProductSon.getGoodsInfoId(), Long.parseLong(productSon.get(goodsProductSon.getGoodsInfoId()).toString()) + 1L);
                            productSons.put(goodsProductSon.getGoodsInfoItemNo(), productSons.get(goodsProductSon.getGoodsInfoItemNo()) + "," + goodsProductSon.getGoodsInfoItemNoS());
                        } else {
                            productSon.put(goodsProductSon.getGoodsInfoId(), 1L);
                            productSons.put(goodsProductSon.getGoodsInfoItemNo(), goodsProductSon.getGoodsInfoItemNoS());
                        }
                        for (Map.Entry entry : productSon.entrySet()) {
                            System.out.println("Key = " + entry.getKey() + ", Value = " + entry.getValue());
                            goodsIdP[numGoods] = (Long)entry.getKey();
                            goodsNum[numGoods] = (Long)entry.getValue();
                            ++numGoods;
                        }
                        for (Map.Entry entry : productSons.entrySet()) {
                            goodsProductSonList[goodsProductSonNew] = (String)entry.getValue();
                            ++goodsProductSonNew;
                        }
                        orderBarterGoodsDomain.setGoodsNum(goodsNum[j]);
                        GoodsProduct goodsProduct = this.goodsProductService.selectByGoodsInfoItemNo(goodsProductSon.getGoodsInfoItemNo());
                        orderBarterGoodsDomain.setGoodsInfoId(goodsProduct.getGoodsInfoId());
                        orderBarterGoodsDomain.setGoodsId(goodsProduct.getGoodsId());
                        orderBarterGoodsDomain.setGoodsInfoIdCover(Long.valueOf(111L));
                        orderBarterGoodsDomain.setGoodsIdCover(Long.valueOf(111L));
                        this.orderBarterGoodsService.saveOrderBarterGoods(orderBarterGoodsDomain);
                    }
                }
                this.orderService.updateBarterStatus(backOrder.getOrderId());
                returnObj.put("resultCode", "1");
                returnObj.put("message", "\u65b0\u589e\u6362\u8d27\u8ba2\u5355\u5b8c\u6210");
                List orderGoods = this.orderGoodsService.selectOrderGoodsLists(order.getOrderId());
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                GoodsProductSon goodsProductSon = new GoodsProductSon();
                for (OrderGoods orderGood : orderGoods) {
                    String[] goodsInfoItemNoS;
                    System.out.println("~~~~~~~~~\u8d27\u54c1\u56de\u6eda");
                    paramMap.put("stock", orderGood.getGoodsInfoNum());
                    paramMap.put("productId", orderGood.getGoodsInfoId());
                    paramMap.put("distinctId", "79");
                    this.productWareService.plusStockToWare(paramMap);
                    for (String itemNoS : goodsInfoItemNoS = orderGood.getGoodsInfoItemNoS().split(",")) {
                        goodsProductSon.setIsUse("0");
                        goodsProductSon.setGoodsInfoItemNoS(itemNoS);
                        this.goodsProductSonService.updateGoodsProductSons(goodsProductSon);
                    }
                }
            } else {
                returnObj.put("resultCode", "0");
                returnObj.put("message", "\u4f20\u5165\u7684\u8ba2\u5355\u72b6\u6001\u4e0d\u8bc6\u522b");
            }
            jsonObject = JSONObject.fromObject(returnObj);
            System.out.println("===return ==jsonObject=" + jsonObject.toString());
            response.setContentType("text/html;charset=utf-8");
            PrintWriter out = null;
            try {
                out = response.getWriter();
                out.print(jsonObject);
                out.flush();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/syncOrder"})
    public void syncOrder(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = null;
        String data = this.getBody(request);
        HashMap<String, String> returnObj = new HashMap<String, String>();
        try {
            data = URLDecoder.decode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            returnObj.put("resultCode", "0");
            returnObj.put("message", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u6570\u636e");
            jsonObject = JSONObject.fromObject(returnObj);
            response.setContentType("text/html;charset=utf-8");
            PrintWriter out = null;
            try {
                out = response.getWriter();
                out.print(jsonObject);
                out.flush();
                out.close();
            }
            catch (IOException es) {
                es.printStackTrace();
            }
            return;
        }
        if (null == data) {
            returnObj.put("resultCode", "0");
            returnObj.put("message", "\u672a\u83b7\u53d6\u5230\u8bf7\u6c42\u6570\u636e");
        } else {
            JSONObject object = JSONObject.fromObject((Object)data);
            JSONArray goodsArray = object.getJSONArray("goodsList");
            String createTime = object.getString("create_time");
            JSONArray goodsMapList = goodsArray;
            CustomerAddress customerAddress = new CustomerAddress();
            customerAddress.setAddressPhone(object.getString("address_phone"));
            String orderCode = object.getString("order_code");
            customerAddress.setAddressMoblie(object.getString("address_mobile"));
            customerAddress.setAddressDetail(object.getString("address_detail"));
            customerAddress.setAddressName(object.getString("address_name"));
            ProvinceBean province = new ProvinceBean();
            DistrictBean district = new DistrictBean();
            district.setDistrictName("\u9ec4\u6d66\u533a");
            district.setCityId(Long.valueOf(73L));
            district.setDistrictId(Long.valueOf(747L));
            CityBean city = new CityBean();
            province.setProvinceId(Long.valueOf(9L));
            province.setProvinceName("\u4e0a\u6d77");
            city.setCityId(Long.valueOf(73L));
            city.setCityName("\u4e0a\u6d77\u5e02");
            city.setProvinceId(Long.valueOf(9L));
            customerAddress.setProvince(province);
            customerAddress.setCity(city);
            customerAddress.setDistrict(district);
            CustomerInfo customerInfo = this.customerPointServiceMapper.selectCustInfoByMobile(object.getString("address_mobile"));
            customerAddress.setCustomerId(customerInfo.getCustomerId());
            String customerRemark = object.getString("customer_remark");
            BigDecimal goodsAllPrice = BigDecimal.valueOf(object.getLong("goods_all_price"));
            Long[] goodsIdP = new Long[goodsMapList.size()];
            Long[] goodsNum = new Long[goodsMapList.size()];
            int numGoods = 0;
            String[] goodsProductSonList = new String[goodsMapList.size()];
            int index = 0;
            int goodsProductSonNew = 0;
            HashMap<String, String> sMap = new HashMap<String, String>();
            HashMap<Long, Long> productSon = new HashMap<Long, Long>();
            HashMap<String, String> productSons = new HashMap<String, String>();
            for (Map map : goodsMapList) {
                String goodsInfoItemNoS = map.get("sku_Code").toString();
                sMap.put("goodsInfoItemNoS", goodsInfoItemNoS);
                sMap.put("isUse", "0");
                GoodsProductSon goodsProductSon = this.goodsProductSonService.selectByGoodsItemNoS(sMap);
                if (index == 0) {
                    productSon.put(goodsProductSon.getGoodsInfoId(), 1L);
                    productSons.put(goodsProductSon.getGoodsInfoItemNo(), goodsProductSon.getGoodsInfoItemNoS());
                    ++index;
                    continue;
                }
                if (productSon.get(goodsProductSon.getGoodsInfoId()) != null) {
                    productSon.put(goodsProductSon.getGoodsInfoId(), Long.parseLong(productSon.get(goodsProductSon.getGoodsInfoId()).toString()) + 1L);
                    productSons.put(goodsProductSon.getGoodsInfoItemNo(), productSons.get(goodsProductSon.getGoodsInfoItemNo()) + "," + goodsProductSon.getGoodsInfoItemNoS());
                    continue;
                }
                productSon.put(goodsProductSon.getGoodsInfoId(), 1L);
                productSons.put(goodsProductSon.getGoodsInfoItemNo(), goodsProductSon.getGoodsInfoItemNoS());
            }
            for (Map.Entry entry : productSon.entrySet()) {
                System.out.println("Key = " + entry.getKey() + ", Value = " + entry.getValue());
                goodsIdP[numGoods] = (Long)entry.getKey();
                goodsNum[numGoods] = (Long)entry.getValue();
                ++numGoods;
            }
            for (Map.Entry entry : productSons.entrySet()) {
                goodsProductSonList[goodsProductSonNew] = (String)entry.getValue();
                ++goodsProductSonNew;
            }
            this.orderService.saveAddOrderInterfacesNew(goodsAllPrice, new BigDecimal("10"), "25_EMS", customerRemark, goodsIdP, goodsNum, Long.valueOf(1690L), Long.valueOf(1L), orderCode, "0", "\u660e\u7ec6", customerAddress, "", "", goodsProductSonList, null, null);
            returnObj.put("resultCode", "1");
            returnObj.put("message", "\u9500\u552e\u8ba2\u5355\u65b0\u589e\u6210\u529f");
        }
        jsonObject = JSONObject.fromObject(returnObj);
        System.out.println("===return ==jsonObject=" + jsonObject.toString());
        response.setContentType("text/html;charset=utf-8");
        PrintWriter out = null;
        try {
            out = response.getWriter();
            out.print(jsonObject);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBody(HttpServletRequest request) {
        String body = null;
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            request.setCharacterEncoding("UTF-8");
            ServletInputStream inputStream = request.getInputStream();
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, "UTF-8"));
                char[] charBuffer = new char[128];
                int bytesRead = -1;
                while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                    stringBuilder.append(charBuffer, 0, bytesRead);
                    System.out.println(charBuffer);
                }
            } else {
                stringBuilder.append("");
            }
        }
        catch (IOException ex) {
            System.out.println(ex.toString());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ex) {
                    System.out.println(ex.toString());
                }
            }
        }
        body = stringBuilder.toString();
        return body;
    }

    @RequestMapping(value={"/saveRepairCost"})
    public ModelAndView saveRepairCost(String orderCode, Long goodsInfoId, BigDecimal repairPrice, String orderType, String isAssessment, BigDecimal goodsInfoPrice, HttpServletRequest request) {
        return null;
    }

    @RequestMapping(value={"/modifyorderprice"})
    public ModelAndView modifyOrderPrice(Long orderId, String orderCodex, Double price, HttpServletRequest request, String reason) {
        this.orderLogService.insertSelective(reason, orderId, request.getSession().getAttribute("name").toString(), "0");
        Order orderDetail = this.orderService.orderDetail(orderId);
        BigDecimal orderPrice = orderDetail.getOrderPrice();
        this.orderService.modifyOrderPrice(BigDecimal.valueOf(price), orderId);
        if ("1".equals("1")) {
            OrderLogger orderLogger = new OrderLogger();
            orderLogger.setName((String)request.getSession().getAttribute("name"));
            orderLogger.setOrderId(orderId.toString());
            orderLogger.setDetail("\u4fee\u6539\u4e86\u8ba2\u5355\u91d1\u989d\uff0c\u5c06\u539f\u59cb\u91d1\u989d" + orderPrice + "\u6539\u6210\u4e86" + price);
            orderLogger.setType("\u4fee\u6539\u8ba2\u5355\u91d1\u989d");
            orderLogger.setStatus("0");
            this.orderLoggerService.saveLogger(orderLogger);
        }
        Order order = this.orderService.orderDetail(orderId);
        List orderGoodses = this.orderService.queryOrderGoods(orderId);
        BigDecimal all = BigDecimal.ZERO;
        for (OrderGoods og : orderGoodses) {
            all = all.add(og.getGoodsBackPrice());
        }
        for (OrderGoods orderGoods : orderGoodses) {
            this.orderService.modifyGoodsBackPrice(orderGoods.getGoodsBackPrice().subtract(orderGoods.getGoodsBackPrice().multiply(BigDecimal.valueOf(price)).divide(all, 2)), orderId, orderGoods.getGoodsInfoId(), orderGoods.getGoodsCouponPrice());
        }
        String operaCode = "\u4fee\u6539\u8ba2\u5355\u4ef7\u683c";
        String operaContent = request.getSession().getAttribute("operaPath") + "\u51cf\u53bb\u8ba2\u5355" + orderCodex + "\u7684\u4ef7\u683c\uff1a" + price;
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)request.getSession().getAttribute("name").toString(), (String)operaCode, (String)operaContent);
        return new ModelAndView((View)new RedirectView("orderlist.htm"));
    }

    @RequestMapping(value={"/modifyOrderStatus"})
    public ModelAndView modifyOrderByKey(Long orderId, String orderStatus, HttpServletRequest request) {
        int count = this.orderService.modifyOrderByKey(orderId, orderStatus);
        if (count > 0) {
            if ("1".equals("1")) {
                OrderLogger orderLogger = new OrderLogger();
                orderLogger.setName((String)request.getSession().getAttribute("name"));
                orderLogger.setOrderId(orderId.toString());
                orderLogger.setDetail("\u5c06" + orderId.toString() + "\u8ba2\u5355\u4ece\u672a\u4ed8\u6b3e\u4fee\u6539\u6210\u4e86\u5df2\u4ed8\u6b3e");
                orderLogger.setType("\u4fee\u6539\u8ba2\u5355\u72b6\u6001");
                orderLogger.setStatus("0");
                this.orderLoggerService.saveLogger(orderLogger);
            }
            this.orderLogService.insertSelective(null, orderId, request.getSession().getAttribute("name").toString(), "6");
            return new ModelAndView((View)new RedirectView("orderlist.htm"));
        }
        return null;
    }

    @RequestMapping(value={"/orderlist"})
    public ModelAndView orderList(HttpServletRequest req, Order order, String orderType, String status, PageBean pageBean) {
        ModelAndView mav = null;
        Map result = null;
        pageBean.setUrl("orderlist.htm");
        String statusNew = status;
        if (StringUtils.isBlank((String)statusNew) || StringUtils.isEmpty((String)statusNew)) {
            statusNew = "1";
        }
        String startTime = "";
        String endTime = "";
        try {
            order.setBusinessId(Long.valueOf(0L));
            if (orderType != null && "1".equals(orderType)) {
                startTime = DateUtil.getSysCurrentDate() + " 00:00:00";
                endTime = DateUtil.getSysCurrentDate() + " 23:59:59";
                order.setStartTime(startTime);
                order.setEndTime(endTime);
            } else if (orderType != null && "2".equals(orderType)) {
                startTime = DateUtil.dateSub((int)-1) + " 00:00:00";
                endTime = DateUtil.dateSub((int)-1) + " 23:59:59";
                order.setStartTime(startTime);
                order.setEndTime(endTime);
            }
            result = this.orderService.newsearchOrderList(statusNew, order, pageBean);
            List ware = this.wareHouseService.findWares();
            Long wId = order.getWareId();
            pageBean = (PageBean)JSON.parseObject((String)JSON.toJSONString(result.get(PAGEBEAN)), PageBean.class);
            mav = new ModelAndView("jsp/order/orderlist");
            mav.addObject(ORDER, (Object)order);
            mav.addObject(STATUS, (Object)statusNew);
            mav.addObject("ware", (Object)ware);
            mav.addObject("getWareId", (Object)wId);
            mav.addObject("map", (Object)result);
            mav.addObject(PAGEBEAN, (Object)pageBean);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u67e5\u8be2\u8ba2\u5355\u5217\u8868\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/orderlististhird"})
    public ModelAndView orderLististhird(Order order, String status, PageBean pageBean, HttpServletRequest request) {
        String statusNew = status;
        if (StringUtils.isEmpty((String)statusNew)) {
            statusNew = "1";
        }
        pageBean.setUrl("jsp/order/thirdorderlist");
        ModelAndView mav = null;
        Map result = this.orderService.newsearchThirdOrderList(statusNew, order, pageBean);
        pageBean = (PageBean)JSON.parseObject((String)JSON.toJSONString(result.get(PAGEBEAN)), PageBean.class);
        mav = new ModelAndView("jsp/order/thirdorderlist");
        mav.addObject("map", (Object)result);
        mav.addObject(ORDER, (Object)order);
        mav.addObject(STATUS, (Object)statusNew);
        mav.addObject(PAGEBEAN, (Object)pageBean);
        return mav;
    }

    @RequestMapping(value={"/toaddorder"})
    public ModelAndView toaddorder() {
        return new ModelAndView("jsp/order/toaddorder").addObject("companyList", (Object)this.logisticsCompanyBiz.queryAllLogisticsCompany());
    }

    @RequestMapping(value={"/orderdetail"})
    public ModelAndView orderDetail(Long orderId, HttpServletRequest request) {
        return new ModelAndView("jsp/order/orderdetail", ORDER, (Object)this.orderService.orderDetail(orderId)).addObject("relations", (Object)this.orderService.queryContainerRalation(orderId)).addObject("orderLogs", (Object)this.orderLogService.selectOrderLogByOrderId(orderId));
    }

    @RequestMapping(value={"/queryysendgoodsorderlist"})
    public ModelAndView queryYSendGoodsOrderList(HttpServletRequest request, PageBean pageBean, String status, Order order) throws ParseException {
        String statusNew = status;
        pageBean.setUrl("queryysendgoodsorderlist.htm");
        List list = null;
        statusNew = "0";
        order.setOrderCargoStatus("5");
        String beginTime = request.getParameter(BEGINTIME);
        String endTime = request.getParameter(ENDTIME);
        String endPrice = request.getParameter(ENDPRICE);
        String beginPrice = request.getParameter(BEGINPRICE);
        return new ModelAndView("jsp/order/orderpickinglist").addObject(PAGEBEAN, (Object)this.orderService.queryYOrder((Object)beginTime, (Object)endTime, endPrice, beginPrice, order, pageBean, list)).addObject(STATUS, (Object)statusNew).addObject(ORDER, (Object)order).addObject(BEGINTIME, (Object)request.getParameter(BEGINTIME)).addObject(ENDTIME, (Object)request.getParameter(ENDTIME)).addObject(BEGINPRICE, (Object)request.getParameter(BEGINPRICE)).addObject(ENDPRICE, (Object)request.getParameter(ENDPRICE));
    }

    @RequestMapping(value={"/queryydeorderlist"})
    public ModelAndView queryYDeOrderList(HttpServletRequest request, PageBean pageBean, String status, Order order) throws ParseException {
        String statusNew = status;
        pageBean.setUrl("queryydeorderlist.htm");
        ArrayList<String> list = new ArrayList<String>();
        list.add("2");
        list.add("3");
        statusNew = "1";
        String beginTime = request.getParameter(BEGINTIME);
        String endTime = request.getParameter(ENDTIME);
        String endPrice = request.getParameter(ENDPRICE);
        String beginPrice = request.getParameter(BEGINPRICE);
        order.setOrderCargoStatus("4");
        return new ModelAndView("jsp/order/orderpickinglist").addObject(PAGEBEAN, (Object)this.orderService.queryYOrder((Object)beginTime, (Object)endTime, endPrice, beginPrice, order, pageBean, list)).addObject(STATUS, (Object)statusNew).addObject(ORDER, (Object)order).addObject(BEGINTIME, (Object)request.getParameter(BEGINTIME)).addObject(ENDTIME, (Object)request.getParameter(ENDTIME)).addObject(BEGINPRICE, (Object)request.getParameter(BEGINPRICE)).addObject(ENDPRICE, (Object)request.getParameter(ENDPRICE));
    }

    @RequestMapping(value={"/queryyorderlist"})
    public ModelAndView queryYOrderList(HttpServletRequest request, PageBean pageBean, String status, Order order) throws ParseException {
        String statusNew = status;
        pageBean.setUrl("queryyorderlist.htm");
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        list.add("3");
        statusNew = "2";
        String beginTime = request.getParameter(BEGINTIME);
        String endTime = request.getParameter(ENDTIME);
        String endPrice = request.getParameter(ENDPRICE);
        String beginPrice = request.getParameter(BEGINPRICE);
        order.setOrderCargoStatus("3");
        return new ModelAndView("jsp/order/orderpickinglist").addObject(PAGEBEAN, (Object)this.orderService.queryYOrder((Object)beginTime, (Object)endTime, endPrice, beginPrice, order, pageBean, list)).addObject(STATUS, (Object)statusNew).addObject(ORDER, (Object)order).addObject(BEGINTIME, (Object)request.getParameter(BEGINTIME)).addObject(ENDTIME, (Object)request.getParameter(ENDTIME)).addObject(BEGINPRICE, (Object)request.getParameter(BEGINPRICE)).addObject(ENDPRICE, (Object)request.getParameter(ENDPRICE)).addObject((Object)"orderCargoStatus");
    }

    @RequestMapping(value={"/saleCount"})
    public ModelAndView saleCount(String startTime, String endTime, HttpServletRequest request) {
        String startTimeNew = startTime;
        String endTimeNew = endTime;
        if (startTimeNew == null || endTimeNew == null || "".equals(startTimeNew) || "".equals(endTimeNew)) {
            endTimeNew = UtilDate.todayFormat((Date)new Date());
            startTimeNew = UtilDate.addDay((String)endTimeNew, (int)-6);
        }
        String sttime = startTimeNew;
        String entime = endTimeNew;
        List payTime = DateUtil.getAllDateBetween2Date((String)startTimeNew, (String)endTimeNew);
        List orderList = this.orderService.querySaleCountByDay(startTimeNew, endTimeNew);
        ArrayList<Long> count = new ArrayList<Long>();
        for (String time : payTime) {
            boolean flag = false;
            for (Order order : orderList) {
                if (!time.equals(DateUtil.dateToString((Date)order.getPayTime(), (String)DATE))) continue;
                flag = true;
                count.add(order.getDayCount());
            }
            if (flag) continue;
            count.add(0L);
        }
        JSONArray times = JSONArray.fromObject((Object)payTime);
        JSONArray counts = JSONArray.fromObject(count);
        return new ModelAndView("jsp/dataAnalysis/salecount").addObject("orderList", (Object)this.orderService.querySaleCountByDay(startTimeNew, endTimeNew)).addObject("counts", (Object)counts.toString()).addObject("times", (Object)times.toString()).addObject("startTime", (Object)sttime).addObject(ENDTIME, (Object)entime);
    }

    @RequestMapping(value={"/saleMoney"})
    public ModelAndView saleMoney(String startTime, String endTime, HttpServletRequest request) {
        String startTimeNew = startTime;
        String endTimeNew = endTime;
        if (startTimeNew == null || endTimeNew == null || "".equals(startTimeNew) || "".equals(endTimeNew)) {
            endTimeNew = UtilDate.todayFormat((Date)new Date());
            startTimeNew = UtilDate.addDay((String)endTimeNew, (int)-6);
        }
        String sttime = startTimeNew;
        String entime = endTimeNew;
        List payTime = DateUtil.getAllDateBetween2Date((String)startTimeNew, (String)endTimeNew);
        List orderList = this.orderService.querySaleMoneyByDay(startTimeNew, endTimeNew);
        ArrayList<BigDecimal> total = new ArrayList<BigDecimal>();
        for (String time : payTime) {
            boolean flag = false;
            for (Order order : orderList) {
                if (!time.equals(DateUtil.dateToString((Date)order.getPayTime(), (String)DATE))) continue;
                flag = true;
                total.add(order.getDayMoney());
            }
            if (flag) continue;
            total.add(new BigDecimal(0));
        }
        JSONArray times = JSONArray.fromObject((Object)payTime);
        JSONArray totals = JSONArray.fromObject(total);
        return new ModelAndView("jsp/dataAnalysis/salemoney").addObject("orderList", (Object)this.orderService.querySaleCountByDay(startTimeNew, endTimeNew)).addObject("totals", (Object)totals.toString()).addObject("times", (Object)times.toString()).addObject("startTime", (Object)sttime).addObject(ENDTIME, (Object)entime);
    }

    @RequestMapping(value={"exportallorder"})
    public void exportOrderList(HttpServletRequest request, HttpServletResponse response, String type, Order orderCondition) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("\u8ba2\u5355\u5217\u8868");
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        sheet.setColumnWidth(0, 6000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 6000);
        sheet.setColumnWidth(3, 6000);
        sheet.setColumnWidth(4, 6000);
        sheet.setColumnWidth(5, 6000);
        sheet.setColumnWidth(6, 6000);
        sheet.setColumnWidth(7, 6000);
        sheet.setColumnWidth(8, 6000);
        sheet.setColumnWidth(9, 6000);
        sheet.setColumnWidth(10, 6000);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u8ba2\u5355\u7f16\u53f7");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("\u603b\u4ef7");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("\u6570\u91cf");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("\u6536\u8d27\u4eba");
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("\u8054\u7cfb\u7535\u8bdd");
        cell.setCellStyle(style);
        cell = row.createCell(5);
        cell.setCellValue("\u4e0b\u5355\u65f6\u95f4");
        cell.setCellStyle(style);
        cell = row.createCell(6);
        cell.setCellValue("\u8ba2\u5355\u72b6\u6001");
        cell.setCellStyle(style);
        cell = row.createCell(7);
        cell.setCellValue("\u5b9e\u4ed8\u91d1\u989d");
        cell.setCellStyle(style);
        cell = row.createCell(8);
        cell.setCellValue("\u5546\u5bb6");
        cell.setCellStyle(style);
        cell = row.createCell(9);
        cell.setCellValue("\u5546\u54c1\u540d\u79f0");
        cell.setCellStyle(style);
        cell = row.createCell(10);
        cell.setCellValue("\u5546\u54c1\u7f16\u53f7");
        cell.setCellStyle(style);
        Long thirdId = (Long)request.getSession().getAttribute("thirdId");
        StoreInfo storeInfo = null;
        List list = null;
        if (thirdId != null) {
            storeInfo = this.auditService.selectByCustomerId(thirdId);
            orderCondition.setBusinessId(thirdId);
            list = this.orderService.queryBusinessIdOrderList(orderCondition);
        } else if (StringUtils.isNotEmpty((String)type) && type.equals("0")) {
            if (orderCondition.getOrderStatus() != null && orderCondition.getOrderStatus() != "") {
                if ("2".equals(orderCondition.getOrderStatus())) {
                    orderCondition.setOrderStatus("1");
                } else if ("3".equals(orderCondition.getOrderStatus())) {
                    orderCondition.setOrderStatus("2");
                } else if ("4".equals(orderCondition.getOrderStatus())) {
                    orderCondition.setOrderStatus("0");
                } else if ("5".equals(orderCondition.getOrderStatus())) {
                    orderCondition.setOrderStatus("");
                } else if ("6".equals(orderCondition.getOrderStatus())) {
                    orderCondition.setOrderStatus("3");
                } else if ("7".equals(orderCondition.getOrderStatus())) {
                    orderCondition.setOrderStatus("4");
                } else if ("8".equals(orderCondition.getOrderStatus())) {
                    orderCondition.setOrderStatus("");
                    orderCondition.setOrderMType("2");
                }
            }
            list = this.orderService.queryBossOrderList(orderCondition);
        } else if (StringUtils.isNotEmpty((String)type) && type.equals("1")) {
            list = this.orderService.queryThirdOrderList();
        }
        int q = 0;
        if (null != list) {
            for (int i = 0; i < list.size(); ++i) {
                row = sheet.createRow(i + 1 + q);
                Order order = (Order)list.get(i);
                if (null != order.getOrderCode()) {
                    row.createCell(0).setCellValue(order.getOrderCode());
                }
                if (null != order.getOrderOldPrice()) {
                    row.createCell(1).setCellValue(order.getOrderOldPrice() + "");
                }
                int num = 0;
                for (OrderGoods og : order.getOrderGoodsList()) {
                    num += og.getGoodsInfoNum().intValue();
                }
                if (null != order.getOrderGoodsList()) {
                    row.createCell(2).setCellValue((double)num);
                }
                if (null != order.getShippingPerson()) {
                    row.createCell(3).setCellValue(order.getShippingPerson());
                }
                if (null != order.getShippingMobile()) {
                    row.createCell(4).setCellValue(order.getShippingMobile());
                }
                if (null != order.getCreateTime()) {
                    row.createCell(5).setCellValue(new SimpleDateFormat(DATE).format(order.getCreateTime()));
                }
                String status = "";
                if (null != order.getOrderStatus()) {
                    if ("0".equals(order.getOrderStatus()) && null != order.getOrderLinePay()) {
                        if ("0".equals(order.getOrderLinePay())) {
                            status = "\u5f85\u53d1\u8d27";
                        } else if ("1".equals(order.getOrderLinePay())) {
                            status = "\u5f85\u4ed8\u6b3e";
                        }
                    }
                    if ("1".equals(order.getOrderStatus())) {
                        status = "\u5df2\u4ed8\u6b3e\u672a\u53d1\u8d27";
                    }
                    if ("2".equals(order.getOrderStatus())) {
                        status = "\u5df2\u53d1\u8d27";
                    }
                    if ("3".equals(order.getOrderStatus())) {
                        status = "\u5df2\u5b8c\u6210";
                    }
                    if ("4".equals(order.getOrderStatus())) {
                        status = "\u5df2\u53d6\u6d88";
                    }
                    if ("14".equals(order.getOrderStatus())) {
                        status = "\u9000\u5355\u5ba1\u6838\u4e2d";
                    }
                    if ("8".equals(order.getOrderStatus())) {
                        status = "\u540c\u610f\u9000\u8d27";
                    }
                    if ("9".equals(order.getOrderStatus())) {
                        status = "\u62d2\u7edd\u9000\u8d27";
                    }
                    if ("10".equals(order.getOrderStatus())) {
                        status = "\u5f85\u5546\u5bb6\u6536\u8d27";
                    }
                    if ("11".equals(order.getOrderStatus())) {
                        status = "\u9000\u5355\u7ed3\u675f";
                    }
                    if ("15".equals(order.getOrderStatus())) {
                        status = "\u9000\u6b3e\u5ba1\u6838\u4e2d";
                    }
                    if ("16".equals(order.getOrderStatus())) {
                        status = "\u5546\u5bb6\u6536\u8d27\u5931\u8d25";
                    }
                    if ("17".equals(order.getOrderStatus())) {
                        status = "\u5df2\u9000\u6b3e";
                    }
                    if ("18".equals(order.getOrderStatus())) {
                        status = "\u9000\u6b3e\u6210\u529f";
                    }
                    row.createCell(6).setCellValue(status);
                }
                if (null != order.getOrderPrice()) {
                    row.createCell(7).setCellValue(order.getOrderPrice() + "");
                }
                if (storeInfo != null) {
                    if (storeInfo.getStoreName() != null || storeInfo.getStoreName() != "") {
                        row.createCell(8).setCellValue(storeInfo.getStoreName());
                    } else {
                        row.createCell(8).setCellValue("\u6682\u65e0");
                    }
                } else if (null != order.getStoreName()) {
                    row.createCell(8).setCellValue(order.getStoreName());
                } else {
                    row.createCell(8).setCellValue("Boss");
                }
                for (int j = 0; j < ((Order)list.get(i)).getOrderGoodsList().size(); ++j) {
                    if (j != 0) {
                        row = sheet.createRow(i + 1 + q + j);
                    }
                    if (null != ((OrderGoods)((Order)list.get(i)).getOrderGoodsList().get(j)).getGoodsInfoName()) {
                        row.createCell(9).setCellValue(((OrderGoods)((Order)list.get(i)).getOrderGoodsList().get(j)).getGoodsInfoName());
                    }
                    if (null == ((OrderGoods)((Order)list.get(i)).getOrderGoodsList().get(j)).getGoodsInfoItemNo()) continue;
                    row.createCell(10).setCellValue(((OrderGoods)((Order)list.get(i)).getOrderGoodsList().get(j)).getGoodsInfoItemNo());
                }
                q += ((Order)list.get(i)).getOrderGoodsList().size();
            }
        }
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    @RequestMapping(value={"exportcheckedorder"})
    public void exportCheckedOrderList(HttpServletRequest request, HttpServletResponse response, String type, Long[] orderIds) {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("\u8ba2\u5355\u5217\u8868");
        HSSFRow row = sheet.createRow(0);
        HSSFCellStyle style = wb.createCellStyle();
        style.setAlignment((short)2);
        sheet.setColumnWidth(0, 6000);
        sheet.setColumnWidth(1, 6000);
        sheet.setColumnWidth(2, 6000);
        sheet.setColumnWidth(3, 6000);
        sheet.setColumnWidth(4, 6000);
        sheet.setColumnWidth(5, 6000);
        sheet.setColumnWidth(6, 6000);
        sheet.setColumnWidth(7, 6000);
        sheet.setColumnWidth(8, 6000);
        sheet.setColumnWidth(9, 6000);
        sheet.setColumnWidth(10, 6000);
        HSSFCell cell = row.createCell(0);
        cell.setCellValue("\u8ba2\u5355\u7f16\u53f7");
        cell.setCellStyle(style);
        cell = row.createCell(1);
        cell.setCellValue("\u603b\u4ef7");
        cell.setCellStyle(style);
        cell = row.createCell(2);
        cell.setCellValue("\u6570\u91cf");
        cell.setCellStyle(style);
        cell = row.createCell(3);
        cell.setCellValue("\u6536\u8d27\u4eba");
        cell.setCellStyle(style);
        cell = row.createCell(4);
        cell.setCellValue("\u8054\u7cfb\u7535\u8bdd");
        cell.setCellStyle(style);
        cell = row.createCell(5);
        cell.setCellValue("\u4e0b\u5355\u65f6\u95f4");
        cell.setCellStyle(style);
        cell = row.createCell(6);
        cell.setCellValue("\u8ba2\u5355\u72b6\u6001");
        cell.setCellStyle(style);
        cell = row.createCell(7);
        cell.setCellValue("\u5b9e\u4ed8\u91d1\u989d");
        cell.setCellStyle(style);
        cell = row.createCell(8);
        cell.setCellValue("\u5546\u5bb6");
        cell.setCellStyle(style);
        cell = row.createCell(9);
        cell.setCellValue("\u5546\u54c1\u540d\u79f0");
        cell.setCellStyle(style);
        cell = row.createCell(10);
        cell.setCellValue("\u5546\u54c1\u7f16\u53f7");
        cell.setCellStyle(style);
        cell = row.createCell(11);
        Long thirdId = (Long)request.getSession().getAttribute("thirdId");
        StoreInfo storeInfo = null;
        if (thirdId != null) {
            storeInfo = this.auditService.selectByCustomerId(thirdId);
        }
        List list = null;
        list = StringUtils.isNotEmpty((String)type) && type.equals("0") ? this.orderService.queryCheckedBossOrderList(orderIds) : (StringUtils.isNotEmpty((String)type) && type.equals("1") ? this.orderService.queryThirdOrderList() : this.orderService.queryCheckedBusinessIdOrderList(orderIds));
        int q = 0;
        if (null != list) {
            for (int i = 0; i < list.size(); ++i) {
                row = sheet.createRow(i + 1 + q);
                Order order = (Order)list.get(i);
                if (null != order.getOrderCode()) {
                    row.createCell(0).setCellValue(order.getOrderCode());
                }
                if (null != order.getOrderOldPrice()) {
                    row.createCell(1).setCellValue(order.getOrderOldPrice() + "");
                }
                int num = 0;
                for (OrderGoods og : order.getOrderGoodsList()) {
                    num += og.getGoodsInfoNum().intValue();
                }
                if (null != order.getOrderGoodsList()) {
                    row.createCell(2).setCellValue((double)num);
                }
                if (null != order.getShippingPerson()) {
                    row.createCell(3).setCellValue(order.getShippingPerson());
                }
                if (null != order.getShippingMobile()) {
                    row.createCell(4).setCellValue(order.getShippingMobile());
                }
                if (null != order.getCreateTime()) {
                    row.createCell(5).setCellValue(new SimpleDateFormat(DATE).format(order.getCreateTime()));
                }
                String status = "";
                if (null != order.getOrderStatus()) {
                    if ("0".equals(order.getOrderStatus()) && null != order.getOrderLinePay()) {
                        if ("0".equals(order.getOrderLinePay())) {
                            status = "\u5f85\u53d1\u8d27";
                        } else if ("1".equals(order.getOrderLinePay())) {
                            status = "\u5f85\u4ed8\u6b3e";
                        }
                    }
                    if ("1".equals(order.getOrderStatus())) {
                        status = "\u5df2\u4ed8\u6b3e\u672a\u53d1\u8d27";
                    }
                    if ("2".equals(order.getOrderStatus())) {
                        status = "\u5df2\u53d1\u8d27";
                    }
                    if ("3".equals(order.getOrderStatus())) {
                        status = "\u5df2\u5b8c\u6210";
                    }
                    if ("4".equals(order.getOrderStatus())) {
                        status = "\u5df2\u53d6\u6d88";
                    }
                    if ("14".equals(order.getOrderStatus())) {
                        status = "\u9000\u5355\u5ba1\u6838\u4e2d";
                    }
                    if ("8".equals(order.getOrderStatus())) {
                        status = "\u540c\u610f\u9000\u8d27";
                    }
                    if ("9".equals(order.getOrderStatus())) {
                        status = "\u62d2\u7edd\u9000\u8d27";
                    }
                    if ("10".equals(order.getOrderStatus())) {
                        status = "\u5f85\u5546\u5bb6\u6536\u8d27";
                    }
                    if ("11".equals(order.getOrderStatus())) {
                        status = "\u9000\u5355\u7ed3\u675f";
                    }
                    if ("15".equals(order.getOrderStatus())) {
                        status = "\u9000\u6b3e\u5ba1\u6838\u4e2d";
                    }
                    if ("16".equals(order.getOrderStatus())) {
                        status = "\u5546\u5bb6\u6536\u8d27\u5931\u8d25";
                    }
                    if ("17".equals(order.getOrderStatus())) {
                        status = "\u5df2\u9000\u6b3e";
                    }
                    if ("18".equals(order.getOrderStatus())) {
                        status = "\u9000\u6b3e\u6210\u529f";
                    }
                    row.createCell(6).setCellValue(status);
                }
                if (null != order.getOrderPrice()) {
                    row.createCell(7).setCellValue(order.getOrderPrice() + "");
                }
                if (storeInfo != null) {
                    if (storeInfo.getStoreName() != null || storeInfo.getStoreName() != "") {
                        row.createCell(8).setCellValue(storeInfo.getStoreName());
                    } else {
                        row.createCell(8).setCellValue("\u6682\u65e0");
                    }
                } else if (null != order.getStoreName()) {
                    row.createCell(8).setCellValue(order.getStoreName());
                } else {
                    row.createCell(8).setCellValue("Boss");
                }
                for (int j = 0; j < ((Order)list.get(i)).getOrderGoodsList().size(); ++j) {
                    if (j != 0) {
                        row = sheet.createRow(i + 1 + q + j);
                    }
                    if (null != ((OrderGoods)((Order)list.get(i)).getOrderGoodsList().get(j)).getGoodsInfoName()) {
                        row.createCell(9).setCellValue(((OrderGoods)((Order)list.get(i)).getOrderGoodsList().get(j)).getGoodsInfoName());
                    }
                    if (null == ((OrderGoods)((Order)list.get(i)).getOrderGoodsList().get(j)).getGoodsInfoItemNo()) continue;
                    row.createCell(10).setCellValue(((OrderGoods)((Order)list.get(i)).getOrderGoodsList().get(j)).getGoodsInfoItemNo());
                }
                q += ((Order)list.get(i)).getOrderGoodsList().size();
            }
        }
        String filename = String.valueOf(System.currentTimeMillis()).concat(".xls");
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment;filename=" + filename);
        try {
            ServletOutputStream ouputStream = response.getOutputStream();
            wb.write((OutputStream)ouputStream);
            ouputStream.flush();
            ouputStream.close();
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public OrderCouponService getOrderCouponService() {
        return this.orderCouponService;
    }

    @Resource(name="OrderCouponService")
    public void setOrderCouponService(OrderCouponService orderCouponService) {
        this.orderCouponService = orderCouponService;
    }

    public OrderLogService getOrderLogService() {
        return this.orderLogService;
    }

    @Resource(name="OrderLogService")
    public void setOrderLogService(OrderLogService orderLogService) {
        this.orderLogService = orderLogService;
    }
}

