/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.DeliveryPoint;
import com.qianjiang.system.service.DeliveryPointService;
import com.qianjiang.util.PageBean;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class DeliveryPointController {
    private static final Logger LOGGER = Logger.getLogger(DeliveryPointController.class);
    @Resource(name="DeliveryPointService")
    private DeliveryPointService deliveryPointService;
    private static final String LOGINUSERID = "loginUserId";
    private static final String NAME = "name";
    private static final String OPERAPATH = "operaPath";
    private static final String REDIRECT = "queryDeliveryPointByPb.htm";

    @RequestMapping(value={"/queryDeliveryPointByPb"})
    public ModelAndView queryDeliveryPointByPb(PageBean pb, Long districtId) {
        return new ModelAndView("jsp/system/deliverypoint/deliverypoint_list", "pb", (Object)this.deliveryPointService.selectAllDeliveryPointByPb(pb, districtId));
    }

    @RequestMapping(value={"/showDeliveryPoint"})
    public ModelAndView showDeliveryPoint(Long deliveryPointId) {
        ModelAndView mav = new ModelAndView();
        DeliveryPoint dp = this.deliveryPointService.getDeliveryPoint(deliveryPointId);
        if (null != dp) {
            mav.addObject("deliveryPoint", (Object)dp);
        }
        mav.setViewName("jsp/system/deliverypoint/show_deliverypoint");
        return mav;
    }

    @RequestMapping(value={"/selectDeliveryPointById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public DeliveryPoint selectDeliveryPointById(Long deliveryPointId) {
        return this.deliveryPointService.getDeliveryPoint(deliveryPointId);
    }

    @RequestMapping(value={"/createDeliveryPoint"})
    public ModelAndView createDeliveryPoint(@Valid DeliveryPoint deliveryPoint, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            LOGGER.debug((Object)"\u6dfb\u52a0\u81ea\u63d0\u70b9\u5c5e\u6027\u9519\u8bef");
            throw new RuntimeException("\u6dfb\u52a0\u81ea\u63d0\u70b9\u5c5e\u6027\u9519\u8bef");
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        deliveryPoint.setCreateUserId(loginUserId);
        this.deliveryPointService.saveDeliveryPoint(deliveryPoint);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u81ea\u63d0\u70b9", (String)(null == request.getSession().getAttribute(OPERAPATH) ? "" : request.getSession().getAttribute(OPERAPATH).toString()));
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/updateDeliveryPoint"})
    public ModelAndView updateDeliveryPoint(@Valid DeliveryPoint deliveryPoint, BindingResult bindingResult, HttpServletRequest request) {
        if (bindingResult.hasErrors()) {
            LOGGER.debug((Object)"\u4fee\u6539\u81ea\u63d0\u70b9\u5c5e\u6027\u9519\u8bef");
            throw new RuntimeException("\u4fee\u6539\u81ea\u63d0\u70b9\u5c5e\u6027\u9519\u8bef");
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        deliveryPoint.setUpdateUserId(loginUserId);
        this.deliveryPointService.updateDeliveryPoint(deliveryPoint);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u81ea\u63d0\u70b9", (String)request.getSession().getAttribute(OPERAPATH).toString());
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/deleteDeliveryPoint"})
    public ModelAndView deleteDeliveryPoint(Long deliveryPointId, HttpServletRequest request) {
        this.deliveryPointService.deleteDeliveryPoint(deliveryPointId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u81ea\u63d0\u70b9", (String)request.getSession().getAttribute(OPERAPATH).toString());
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/batchDelDeliveryPoint"})
    public ModelAndView batchDelDeliveryPoint(Long[] dpid, HttpServletRequest request) {
        this.deliveryPointService.batchDelDeliveryPoint(dpid);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6279\u91cf\u5220\u9664\u81ea\u63d0\u70b9", (String)request.getSession().getAttribute(OPERAPATH).toString());
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"changeDelDeliveryPointUserdStatus"})
    public ModelAndView changeDelDeliveryPointUserdStatus(Long deliveryPointId, HttpServletRequest request) {
        this.deliveryPointService.changeUserdStatus(deliveryPointId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6279\u91cf\u5220\u9664\u81ea\u63d0\u70b9", (String)request.getSession().getAttribute(OPERAPATH).toString());
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }
}

