/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.SysDictionary;
import com.qianjiang.system.cache.IDictionarysCache;
import com.qianjiang.system.controller.BaseController;
import com.qianjiang.system.service.ISysDictionaryBiz;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="sysDictionaryController")
public class SysDictionaryController
extends BaseController {
    private static final MyLogger LOGGER = new MyLogger(SysDictionaryController.class);
    private SysDictionary sysDictionary;
    private ISysDictionaryBiz sysDictionaryBizImpl;
    private static final String[] DICTIONARYS_LIST = new String[0];
    private IDictionarysCache dictionarysCache;
    private static final String INIT_SYSDICTIONARY = "initSysDictionary.htm";
    private static final String ADD_SYSDICTIONARY_JSP = "jsp/system/dic/sysdictionary_add";
    private static final String SYSDICTIONARY_LIST_JSP = "jsp/system/dic/sysdictionary_list";
    private static final String UPDATE_SYSDICTIONARY_JSP = "jsp/system/dic/sysdictionary_update";
    private static final String READ_SYSDICTIONARY_JSP = "jsp/system/dic/sysdictionary_read";
    private static final String PARENTID = "parentId";
    private static final String MSG = "msg";
    private static final String NAME = "name";
    private static final String CODE = "code";

    @RequestMapping(value={"/initSysDictionary"})
    public ModelAndView initSysDictionary(PageBean pageBean, HttpServletRequest request, @RequestParam(value="parentId", required=false, defaultValue="0") Integer parentId) {
        pageBean.setUrl("initSysDictionary.htm?parentId=" + parentId);
        ModelAndView mav = new ModelAndView();
        HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
        pa.put(PARENTID, parentId);
        mav.setViewName(SYSDICTIONARY_LIST_JSP);
        mav.addObject("pageBean", (Object)this.sysDictionaryBizImpl.getSysDictionaryByField(pa, pageBean));
        mav.addObject(MSG, request.getAttribute(MSG));
        mav.addObject(MSG, (Object)request.getParameter(MSG));
        mav.addObject(PARENTID, (Object)parentId);
        if (parentId != 0) {
            mav.addObject("parentInfo", (Object)this.getParentInfo(parentId));
        }
        return mav;
    }

    @RequestMapping(value={"/openAddSysDictionaryPage"})
    public ModelAndView openAddSysDictionaryPage(HttpServletRequest request, @RequestParam(value="parentId") Integer parentId) {
        ModelAndView mav = new ModelAndView();
        mav.setViewName(ADD_SYSDICTIONARY_JSP);
        mav.addObject(PARENTID, (Object)parentId);
        this.fullDictionarys(mav);
        return mav;
    }

    private SysDictionary getParentInfo(int parentId) {
        return this.sysDictionaryBizImpl.getSysDictionaryById(parentId);
    }

    @RequestMapping(value={"/addSysDictionary"})
    public ModelAndView addSysDictionary(SysDictionary sysDictionary, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        mav.addObject(PARENTID, (Object)sysDictionary.getParentId());
        try {
            boolean flag = this.sysDictionaryBizImpl.saveSysDictionary(sysDictionary);
            if (flag) {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58\u7cfb\u7edf\u5b57\u5178\u6210\u529f\uff01");
            } else {
                mav.addObject(MSG, (Object)"\u4fdd\u5b58\u7cfb\u7edf\u5b57\u5178\u5931\u8d25\uff01");
            }
            mav.setView((View)new RedirectView(INIT_SYSDICTIONARY));
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u7cfb\u7edf\u5b57\u5178\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fdd\u5b58\u7cfb\u7edf\u5b57\u5178\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/openUpdateSysDictionaryPage"})
    public ModelAndView openUpdateSysDictionaryPage(@RequestParam(value="id") Integer id) {
        ModelAndView mav = new ModelAndView();
        try {
            this.fullDictionarys(mav);
            mav.addObject("sysDictionary", (Object)this.sysDictionaryBizImpl.getSysDictionaryById(id.intValue()));
            mav.setViewName(UPDATE_SYSDICTIONARY_JSP);
        }
        catch (Exception e) {
            LOGGER.error("\u52a0\u8f7d\u7cfb\u7edf\u5b57\u5178\u5bf9\u8c61\u5931\u8d25\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u52a0\u8f7d\u7cfb\u7edf\u5b57\u5178\u5bf9\u8c61\u5931\u8d25\uff01");
            mav.setView((View)new RedirectView(INIT_SYSDICTIONARY));
            return mav;
        }
        return mav;
    }

    @RequestMapping(value={"/updateSysDictionary"})
    public ModelAndView updateSysDictionary(SysDictionary sysDictionary, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView();
        try {
            if (this.sysDictionaryBizImpl.updateSysDictionary(sysDictionary) >= 1) {
                mav.addObject(MSG, (Object)"\u4fee\u6539\u7cfb\u7edf\u5b57\u5178\u6210\u529f\uff01");
            } else {
                mav.addObject(MSG, (Object)"\u4fee\u6539\u7cfb\u7edf\u5b57\u5178\u5931\u8d25\uff01");
            }
            mav.setView((View)new RedirectView(INIT_SYSDICTIONARY));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u7cfb\u7edf\u5b57\u5178\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u4fee\u6539\u7cfb\u7edf\u5b57\u5178\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/readSysDictionary"})
    public ModelAndView readSysDictionary(@RequestParam(value="id") Integer id) {
        ModelAndView mav = new ModelAndView();
        if (id == 0) {
            mav.addObject(MSG, (Object)"\u7cfb\u7edf\u5b57\u5178\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u67e5\u8be2\uff01");
            mav.setView((View)new RedirectView(INIT_SYSDICTIONARY));
        } else {
            mav.setViewName(READ_SYSDICTIONARY_JSP);
            mav.addObject("sysDictionary", (Object)this.sysDictionaryBizImpl.getSysDictionaryById(id.intValue()));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteSysDictionary"})
    public ModelAndView deleteSysDictionary(@RequestParam(value="ids") String ids, @RequestParam(value="parentId") Integer parentId) {
        ModelAndView mav = new ModelAndView();
        mav.setView((View)new RedirectView(INIT_SYSDICTIONARY));
        mav.addObject(PARENTID, (Object)parentId);
        if (ids == null || ids.trim().length() == 0) {
            mav.addObject(MSG, (Object)"\u5bf9\u8c61id\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6267\u884c\u5220\u9664\u7cfb\u7edf\u5b57\u5178\u64cd\u4f5c\uff01");
            return mav;
        }
        try {
            if (parentId == 0) {
                HashMap<String, Integer> pa = new HashMap<String, Integer>(1);
                pa.put(PARENTID, parentId);
                pa.put("status", 1);
                PageBean pg = new PageBean();
                int pageSize = 1000;
                pg.setPageSize(pageSize);
                List childList = this.sysDictionaryBizImpl.getSysDictionaryByField(pa, pg).getList();
                if (childList != null && !childList.isEmpty()) {
                    mav.addObject(MSG, (Object)"\u60a8\u5220\u9664\u7684\u6b64\u5b57\u5178\u4fe1\u606f\uff0c\u5b58\u5728\u5b50\u5b57\u5178\u4fe1\u606f\uff0c\u6240\u4ee5\u7981\u6b62\u5220\u9664\uff01");
                    return mav;
                }
            }
            if (this.sysDictionaryBizImpl.deleteSysDictionary(ids) >= 1) {
                mav.addObject(MSG, (Object)"\u5220\u9664\u7cfb\u7edf\u5b57\u5178\u6210\u529f\uff01");
            } else {
                mav.addObject(MSG, (Object)"\u5220\u9664\u7cfb\u7edf\u5b57\u5178\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u7cfb\u7edf\u5b57\u5178\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.addObject(MSG, (Object)"\u5220\u9664\u7cfb\u7edf\u5b57\u5178\u5931\u8d25\uff01");
        }
        return mav;
    }

    @RequestMapping(value={"/querySysDictionary"})
    public ModelAndView querySysDictionary(@RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="code", required=false, defaultValue="") String code, PageBean pageBean, @RequestParam(value="parentId") Integer parentId) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        HashMap<String, String> queryParam = new HashMap<String, String>();
        param.put(PARENTID, parentId);
        if (name != null && name.trim().length() != 0) {
            param.put(NAME, name);
            queryParam.put(NAME, name);
            queryParam.put("searchField", NAME);
            queryParam.put("searchValue", name);
            queryParam.put("searchName", "\u5b57\u5178\u540d\u79f0");
        }
        if (code != null && code.trim().length() != 0) {
            param.put(CODE, code);
            queryParam.put(CODE, code);
            queryParam.put("searchField", CODE);
            queryParam.put("searchValue", code);
            queryParam.put("searchName", "\u5b57\u5178\u4ee3\u7801");
        }
        ModelAndView mav = new ModelAndView();
        mav.setViewName(SYSDICTIONARY_LIST_JSP);
        mav.addObject("queryParam", queryParam);
        try {
            mav.addObject("pageBean", (Object)this.sysDictionaryBizImpl.getSysDictionaryByField(param, pageBean));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u7cfb\u7edf\u5b57\u5178\u4fe1\u606f\u5f02\u5e38\uff01", (Throwable)e);
        }
        return mav;
    }

    private void fullDictionarys(ModelAndView mav) {
        for (String dep : DICTIONARYS_LIST) {
            try {
                mav.addObject(dep, this.dictionarysCache.getDictionaryByName(dep));
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u5f97\u5b57\u5178\u7f13\u5b58\u5f02\u5e38\uff0c\u5b57\u5178\u540d\uff1a" + dep, (Throwable)e);
            }
        }
    }

    public SysDictionary getSysDictionary() {
        return this.sysDictionary;
    }

    @Resource(name="sysDictionary")
    public void setSysDictionary(SysDictionary sysDictionary) {
        this.sysDictionary = sysDictionary;
    }

    public ISysDictionaryBiz getSysDictionaryBizImpl() {
        return this.sysDictionaryBizImpl;
    }

    @Resource(name="sysDictionaryBizImpl")
    public void setSysDictionaryBizImpl(ISysDictionaryBiz sysDictionaryBizImpl) {
        this.sysDictionaryBizImpl = sysDictionaryBizImpl;
    }

    public IDictionarysCache getDictionarysCache() {
        return this.dictionarysCache;
    }

    @Resource(name="dictionarysCache")
    public void setDictionarysCache(IDictionarysCache dictionarysCache) {
        this.dictionarysCache = dictionarysCache;
    }
}

