/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.information.controller;

import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.information.bean.InfoOPTag;
import com.qianjiang.information.bean.InformationOnePage;
import com.qianjiang.information.service.InfoOPTagService;
import com.qianjiang.information.service.InformationOnePageService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.temp.bean.SysTemp;
import com.qianjiang.temp.service.InfoSysTempService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.SelectBean;
import com.qianjiang.util.UploadUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class InformationOnePageController {
    private static final MyLogger LOGGER = new MyLogger(InformationOnePageController.class);
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String LOGINUSERID = "loginUserId";
    private static final String QUERYINFOONEPAGESBYPAGEBEAN_HTM = "queryInfoOnePagesByPageBean.htm?CSRFToken=";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="InformationOnePageService")
    private InformationOnePageService infoOnePageService;
    @Resource(name="InfoSysTempService")
    private InfoSysTempService channelSysTempService;
    @Resource(name="InfoOPTagService")
    private InfoOPTagService infoOPTagService;
    @Resource(name="InfoImageManageService")
    private InfoImageManageService infoImageManageService;

    @RequestMapping(value={"/queryInfoOnePagesByPageBean"})
    public ModelAndView queryInfoOnePagesByPageBean(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        LOGGER.debug("==============================\u67e5\u770b\u5355\u9875\u5217\u8868==============================");
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        List sysTempList = this.channelSysTempService.queryAllSystemp();
        this.removeNoUseTemp(sysTempList);
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/information/infoOnePageList", "pageBean", (Object)this.infoOnePageService.queryInfoOnePageByPageBean(pb, selectBean)).addObject("sysTempList", (Object)sysTempList);
    }

    private void removeNoUseTemp(List<SysTemp> sysTempList) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        list.add(4);
        list.add(6);
        list.add(7);
        list.add(8);
        ArrayList<SysTemp> removeList = new ArrayList<SysTemp>();
        for (SysTemp sysTemp : sysTempList) {
            if (!list.contains(sysTemp.getTempId())) continue;
            removeList.add(sysTemp);
        }
        sysTempList.removeAll(removeList);
    }

    @RequestMapping(value={"/showInfoOnePage"})
    public ModelAndView showInfoOnePage(HttpServletRequest request, HttpServletResponse response, Long infoOnePageId) {
        ModelAndView mav = new ModelAndView();
        List sysTempList = this.channelSysTempService.queryAllSystemp();
        mav.addObject("sysTempList", (Object)sysTempList);
        if (null != infoOnePageId) {
            LOGGER.debug("==============================\u67e5\u770b\u5355\u9875\u5e76\u8df3\u8f6c\u5230\u67e5\u770b\u6216\u4fee\u6539\u9875\u9762==============================");
            mav.addObject("infoOnePage", (Object)this.infoOnePageService.getInfoOnePageByID(infoOnePageId));
        }
        mav.setViewName("jsp/information/showInfoOnePage");
        return mav;
    }

    @RequestMapping(value={"/showinfoonepageajax"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public InformationOnePage showinfoonepageajax(HttpServletRequest request, HttpServletResponse response, Long infoOnePageId) {
        LOGGER.debug("==============================\u4fee\u6539\u9875\u9762==============================");
        return this.infoOnePageService.getInfoOnePageByID(infoOnePageId);
    }

    @ResponseBody
    @RequestMapping(value={"/getInfoOPTagByTempId"}, produces={"application/json;charset=UTF-8"})
    public List<InfoOPTag> getInfoOPTagByTempId(String tempId) {
        return this.infoOPTagService.findAllInfoOPTag(tempId);
    }

    @RequestMapping(value={"/addInfoOnePage"})
    public ModelAndView addInfoOnePage(MultipartHttpServletRequest request, HttpServletResponse response, @Valid InformationOnePage infoOnePage, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFOONEPAGESBYPAGEBEAN_HTM + request.getParameter("CSRFToken")));
        }
        LOGGER.debug("==============================\u6dfb\u52a0\u5355\u9875==============================");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        try {
            MultipartFile muFile;
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            if ((muFile = request.getFile("imageSrc")) != null && muFile.getSize() > 0L) {
                infoOnePage.setImgSrc(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
                this.infoImageManageService.saveImage(infoOnePage.getImgSrc());
            }
            infoOnePage.setCreateUserId(loginUserId);
            infoOnePage.setUpdateUserId(loginUserId);
            this.infoOnePageService.saveInfoOnePage(infoOnePage);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u5355\u9875", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("==============================\u6dfb\u52a0\u5355\u9875\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(QUERYINFOONEPAGESBYPAGEBEAN_HTM + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/updateInfoOnePage"})
    public ModelAndView updateInfoOnePage(MultipartHttpServletRequest request, HttpServletResponse response, @Valid InformationOnePage infoOnePage, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYINFOONEPAGESBYPAGEBEAN_HTM + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        LOGGER.debug("==============================\u4fee\u6539\u5355\u9875==============================");
        try {
            MultipartFile muFile;
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            if ((muFile = request.getFile("imageSrc")) != null && muFile.getSize() > 0L) {
                infoOnePage.setImgSrc(UploadUtil.uploadFileOne((MultipartFile)muFile, (HttpServletRequest)request));
                this.infoImageManageService.saveImage(infoOnePage.getImgSrc());
            }
            infoOnePage.setUpdateUserId(loginUserId);
            this.infoOnePageService.updateInfoOnePage(infoOnePage);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u5355\u9875", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("==============================\u4fee\u6539\u5355\u9875\u5931\u8d25\uff1a", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(QUERYINFOONEPAGESBYPAGEBEAN_HTM + request.getParameter("CSRFToken")));
    }

    @RequestMapping(value={"/delInfoOnePage"})
    public void delInfoOnePage(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("==============================\u5220\u9664\u5355\u9875==============================");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            String[] ids = request.getParameterValues("infoOnePageIds[]");
            for (int i = 0; i < ids.length; ++i) {
                Long id = Long.valueOf(ids[i]);
                this.infoOnePageService.delInfoOnePage(id, loginUserId);
            }
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u5355\u9875", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (NumberFormatException e) {
            LOGGER.error("==============================\u5220\u9664\u5355\u9875\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    @RequestMapping(value={"/checkInfoOPByTitle"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean checkInfoOPByTitle(String title, Long infoOPId) {
        if (null != infoOPId) {
            return this.infoOnePageService.checkAddInfoOPByTitle(title, infoOPId);
        }
        return this.infoOnePageService.checkAddInfoOPByTitle(title);
    }
}

