/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.system.bean.OSSConf;
import com.qianjiang.system.service.OSSConfService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class OSSConfController {
    private static final MyLogger logger = new MyLogger(OSSConfController.class);
    @Autowired
    private OSSConfService ossConfService;

    @RequestMapping(value={"/initOSSConf"})
    public ModelAndView initOSSConf(HttpServletRequest req, HttpServletResponse resp, PageBean pageBean) {
        ModelAndView mav = new ModelAndView();
        Map resultMap = new HashMap();
        pageBean.setUrl("initOSSConf.htm");
        try {
            resultMap = this.ossConfService.findAllOssConf(pageBean);
            mav.addAllObjects(resultMap);
            mav.setViewName("jsp/system/ossconf/ossconf_list");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("OSS\u5bf9\u8c61\u5b58\u50a8\u8bbe\u7f6e\u521d\u59cb\u5316\u5931\u8d25");
        }
        return mav;
    }

    @RequestMapping(value={"/findByOssId"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public OSSConf findByOssId(HttpServletRequest req, HttpServletResponse resp, Long ossId) {
        OSSConf ossConf = new OSSConf();
        try {
            ossConf = this.ossConfService.findByOssId(ossId);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u6839\u636e\u4e3b\u952e\u67e5\u8be2oss\u914d\u7f6e\u4fe1\u606f\u5931\u8d25" + e.getMessage(), (Throwable)e);
        }
        return ossConf;
    }

    @RequestMapping(value={"/updateOssConf"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> updateOssConf(HttpServletRequest req, HttpServletResponse resp, OSSConf oSSConf) {
        HashMap<String, Object> resultMap = new HashMap();
        Long userId = (Long)req.getSession().getAttribute("loginUserId");
        String userName = (String)req.getSession().getAttribute("name");
        try {
            oSSConf.setOssModifyId(userId);
            oSSConf.setOssModifyName(userName);
            resultMap = this.ossConfService.updateOssConf(oSSConf);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u4fee\u6539OSS\u8bbe\u7f6e\u9519\u8bef" + e.getMessage(), (Throwable)e);
            resultMap.put("result", false);
        }
        return resultMap;
    }
}

