/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.Channel;
import com.qianjiang.channel.bean.ChannelAdver;
import com.qianjiang.channel.service.ChannelAdverService;
import com.qianjiang.channel.service.ISysDictionaryBiz;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.image.service.InfoImageManageService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelAdverController {
    private static final String LOGINUSERID = "loginUserId";
    private static final String ATID = "atId";
    private static final String ADVERTYPE = "adverType";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String QUERYCHANNELADVERBYPAGEBEAN_HTM = "queryChannelAdverByPageBean.htm?CSRFToken=";
    private static final String CHANNELID = "&channelId=";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    @Resource(name="ChannelAdverService")
    private ChannelAdverService channelAdverService;
    @Resource(name="channelSysDictionaryBizImpl")
    private ISysDictionaryBiz sysDicBiz;
    @Resource(name="InfoImageManageService")
    private InfoImageManageService infoImageManageService;

    @RequestMapping(value={"/queryChannelAdverByPageBean"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map queryChannelAdverByPageBean(PageBean pb, Long channelId, Long floorId, Long floorTagId, Long atId, Long adverType, HttpServletRequest request) {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        Channel channel = this.channelService.findChannelByID(channelId);
        PageBean pageBean = this.channelAdverService.selectchannelAdverByParam(pb, channel.getChannelId(), null, null, null, atId, adverType, null, null);
        maps.put("pb", pageBean);
        maps.put("channel", channel);
        maps.put(ATID, atId);
        maps.put(ADVERTYPE, adverType);
        pb.setUrl(QUERYCHANNELADVERBYPAGEBEAN_HTM + request.getParameter("CSRFToken") + CHANNELID + channelId);
        return maps;
    }

    @RequestMapping(value={"/showChannelAdver"})
    public ModelAndView showChannelAdver(Long channelAdverId, Long channelId, Long atId, Long adverType) {
        Channel channel = this.channelService.findChannelByID(channelId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channel", channel);
        map.put(ATID, atId);
        map.put(ADVERTYPE, adverType);
        if (null != channelAdverId) {
            ChannelAdver channelAdver = this.channelAdverService.selectByPrimaryKey(channelAdverId);
            map.put("channelAdver", channelAdver);
        }
        return new ModelAndView("jsp/channel/showChannelAdver", "map", map);
    }

    @RequestMapping(value={"/createChannelAdver"})
    public ModelAndView createChannelAdver(MultipartHttpServletRequest request, HttpServletResponse response, @Valid ChannelAdver channelAdver, BindingResult bindingResult, Integer width, Integer height) {
        if (bindingResult.hasErrors()) {
            new ModelAndView((View)new RedirectView(QUERYCHANNELADVERBYPAGEBEAN_HTM + request.getParameter("CSRFToken") + CHANNELID + channelAdver.getChannelId())).addObject(ATID, (Object)channelAdver.getAtId()).addObject(ADVERTYPE, (Object)channelAdver.getAdverType());
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        MultipartFile muFile = request.getFile("imgSrc");
        if (null != muFile && muFile.getSize() > 0L) {
            channelAdver.setAdverPath(UploadUtil.uploadFileOne((MultipartFile)muFile));
            this.infoImageManageService.saveImage(channelAdver.getAdverPath());
        }
        channelAdver.setCreateUserId(loginUserId);
        this.channelAdverService.saveChannelAdver(channelAdver);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u9891\u9053\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYCHANNELADVERBYPAGEBEAN_HTM + request.getParameter("CSRFToken") + CHANNELID + channelAdver.getChannelId())).addObject(ATID, (Object)channelAdver.getAtId()).addObject(ADVERTYPE, (Object)channelAdver.getAdverType());
    }

    @RequestMapping(value={"/updateChannelAdver"})
    public ModelAndView updateChannelAdver(MultipartHttpServletRequest request, @Valid ChannelAdver channelAdver, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            new ModelAndView((View)new RedirectView(QUERYCHANNELADVERBYPAGEBEAN_HTM + request.getParameter("CSRFToken") + CHANNELID + channelAdver.getChannelId())).addObject(ATID, (Object)channelAdver.getAtId()).addObject(ADVERTYPE, (Object)channelAdver.getAdverType());
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        MultipartFile muFile = request.getFile("imgSrc");
        if (null != muFile && muFile.getSize() > 0L) {
            channelAdver.setAdverPath(UploadUtil.uploadFileOne((MultipartFile)muFile));
            this.infoImageManageService.saveImage(channelAdver.getAdverPath());
        }
        channelAdver.setUpdateUserId(loginUserId);
        this.channelAdverService.updateChannelAdver(channelAdver);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9891\u9053\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        return new ModelAndView((View)new RedirectView(QUERYCHANNELADVERBYPAGEBEAN_HTM + request.getParameter("CSRFToken") + CHANNELID + channelAdver.getChannelId())).addObject(ATID, (Object)channelAdver.getAtId()).addObject(ADVERTYPE, (Object)channelAdver.getAdverType());
    }

    @RequestMapping(value={"/deleteChannelAdver"})
    public void deleteChannelAdver(HttpServletRequest request) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        String[] adverIds = request.getParameterValues("adverIds[]");
        for (int i = 0; i < adverIds.length; ++i) {
            Long id = Long.valueOf(adverIds[i]);
            this.channelAdverService.deleteChannelAdver(id, loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u9891\u9053\u5e7f\u544a", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }
}

