/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.ChannelStorey;
import com.qianjiang.channel.bean.ChannelStoreyTag;
import com.qianjiang.channel.service.ChannelStoreyService;
import com.qianjiang.channel.service.ChannelStoreyTagService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelStoreyTagController {
    private static final MyLogger LOGGER = new MyLogger(ChannelStoreyTagController.class);
    private static final String LOGINUSERID = "loginUserId";
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    public static final String QUERYCHANNELSTOREYTAGBYPAGEBEAN_HTM = "queryChannelStoreyTagByPageBean.htm?storeyId=";
    public static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="SysChannelService")
    private SysChannelService channelService;
    private ChannelStoreyService channelStoreyService;
    private ChannelStoreyTagService channelStoreyTagService;

    @RequestMapping(value={"/queryChannelStoreyTagByPageBean"})
    public ModelAndView queryChannelStoreyTagByPageBean(PageBean pb, Long storeyId, HttpServletRequest request) {
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyId);
        return new ModelAndView("jsp/channel/channel_storey_Tag_list", "pb", (Object)this.channelStoreyTagService.selectchannelStoreyTagByParam(pb, storeyId, null, null)).addObject("channelStorey", (Object)channelStorey);
    }

    @RequestMapping(value={"/showChannelStoreyTag"})
    public ModelAndView showChannelStoreyTag(Long tagId, Long storeyId) {
        ChannelStorey channelStorey = this.channelStoreyService.getChannelStoreyById(storeyId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelStorey", channelStorey);
        if (null != tagId) {
            ChannelStoreyTag channelStoreyTag = this.channelStoreyTagService.getChannelStoreyTagById(tagId);
            map.put("channelStoreyTag", channelStoreyTag);
        }
        return new ModelAndView("jsp/channel/showChannelStoreyTag", "map", map);
    }

    @RequestMapping(value={"/createChannelStoreyTag"})
    public ModelAndView createChannelStoreyTag(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyTag channelStoreyTag, BindingResult bindingResult, Long storeyId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYTAGBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelStoreyTag.setCreateUserId(loginUserId);
            int n = this.channelStoreyTagService.saveChannelStoreyTag(channelStoreyTag);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u697c\u5c42\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u9891\u9053\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYCHANNELSTOREYTAGBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/updateChannelStoreyTag"})
    public ModelAndView updateChannelStoreyTag(HttpServletRequest request, HttpServletResponse response, @Valid ChannelStoreyTag channelStoreyTag, BindingResult bindingResult, Long storeyId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELSTOREYTAGBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            if (null == loginUserId) {
                loginUserId = 1L;
            }
            channelStoreyTag.setUpdateUserId(loginUserId);
            int n = this.channelStoreyTagService.updateChannelStoreyTag(channelStoreyTag);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u697c\u5c42\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fee\u6539\u9891\u9053\u54c1\u724c\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u9891\u9053\u54c1\u724c\u5f02\u5e38\uff01", (Throwable)e);
        }
        mav.setView((View)new RedirectView(QUERYCHANNELSTOREYTAGBYPAGEBEAN_HTM + storeyId + "&CSRFToken=" + request.getParameter("CSRFToken")));
        return mav;
    }

    @RequestMapping(value={"/deleteChannelStoreyTag"})
    public void deleteChannelStoreyTag(HttpServletRequest request, HttpServletResponse response) {
        String[] tagIds = request.getParameterValues("tagIds[]");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < tagIds.length; ++i) {
            this.channelStoreyTagService.deleteChannelStoreyTag(Long.valueOf(tagIds[i]), loginUserId);
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u697c\u5c42\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    @RequestMapping(value={"/deleteChannelStoreyTagPro"})
    public void deleteChannelStoreyTagPro(HttpServletRequest request, HttpServletResponse response) {
        String[] tagIds = request.getParameterValues("tagIds[]");
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        if (null == loginUserId) {
            loginUserId = 1L;
        }
        for (int i = 0; i < tagIds.length; ++i) {
            this.channelStoreyTagService.deleteByPrimaryKeyCallPro(Long.valueOf(tagIds[i]));
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u697c\u5c42\u6807\u7b7e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
    }

    public ChannelStoreyTagService getChannelStoreyTagService() {
        return this.channelStoreyTagService;
    }

    @Resource(name="ChannelStoreyTagService")
    public void setChannelStoreyTagService(ChannelStoreyTagService channelStoreyTagService) {
        this.channelStoreyTagService = channelStoreyTagService;
    }

    public ChannelStoreyService getChannelStoreyService() {
        return this.channelStoreyService;
    }

    @Resource(name="ChannelStoreyService")
    public void setChannelStoreyService(ChannelStoreyService channelStoreyService) {
        this.channelStoreyService = channelStoreyService;
    }
}

