/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.goods.bean.Goods;
import com.qianjiang.goods.bean.GoodsProduct;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GetOnOffService;
import com.qianjiang.goods.service.GoodsAuditService;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsCateService;
import com.qianjiang.goods.service.GoodsOpenSpecService;
import com.qianjiang.goods.service.GoodsProductService;
import com.qianjiang.goods.service.GoodsReleExpandParamService;
import com.qianjiang.goods.service.GoodsReleParamService;
import com.qianjiang.goods.service.GoodsService;
import com.qianjiang.goods.service.GoodsTagService;
import com.qianjiang.goods.service.SearchAsyncService;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.goods.util.GoodsSearchBean;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.goods.vo.GoodsProductVo;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.service.ServiceSupportMapperService;
import com.qianjiang.thirdaudit.service.AuditService;
import com.qianjiang.util.MyLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class GoodsAuditController {
    private static final String GOODSAUDIT_HTM = "goodsAudit.htm";
    private static final String LOGGERINFO1 = "\u3011-->\u7528\u6237\u540d\uff1a";
    private GoodsAuditService goodsAuditService;
    private GoodsProductService goodsProductService;
    private GoodsOpenSpecService goodsOpenSpecService;
    private WareHouseService wareHouseService;
    private GoodsBrandService goodsBrandService;
    private GoodsTagService goodsTagService;
    private GoodsCateService goodsCateService;
    private AuditService auditService;
    private GetOnOffService getOnOffService;
    @Resource(name="GoodsService")
    private GoodsService goodsService;
    @Resource(name="serviceSupportMapperService")
    private ServiceSupportMapperService serviceSupportMapperService;
    @Autowired
    private SearchAsyncService searchAsyncService;
    @Resource(name="GoodsReleParamService")
    private GoodsReleParamService goodsReleParamService;
    @Resource(name="GoodsReleExpandParamService")
    private GoodsReleExpandParamService goodsReleExpandParamService;
    private static final MyLogger LOGGER = new MyLogger(GoodsAuditController.class);

    public AuditService getAuditService() {
        return this.auditService;
    }

    @Resource(name="auditService")
    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public GoodsCateService getGoodsCateService() {
        return this.goodsCateService;
    }

    @Resource(name="GoodsCateService")
    public void setGoodsCateService(GoodsCateService goodsCateService) {
        this.goodsCateService = goodsCateService;
    }

    public GoodsTagService getGoodsTagService() {
        return this.goodsTagService;
    }

    @Resource(name="GoodsTagServiceImpl")
    public void setGoodsTagService(GoodsTagService goodsTagService) {
        this.goodsTagService = goodsTagService;
    }

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }

    public GoodsOpenSpecService getGoodsOpenSpecService() {
        return this.goodsOpenSpecService;
    }

    @Resource(name="GoodsOpenSpecService")
    public void setGoodsOpenSpecService(GoodsOpenSpecService goodsOpenSpecService) {
        this.goodsOpenSpecService = goodsOpenSpecService;
    }

    public WareHouseService getWareHouseService() {
        return this.wareHouseService;
    }

    @Resource(name="WareHouseService")
    public void setWareHouseService(WareHouseService wareHouseService) {
        this.wareHouseService = wareHouseService;
    }

    public GoodsProductService getGoodsProductService() {
        return this.goodsProductService;
    }

    @Resource(name="GoodsProductService")
    public void setGoodsProductService(GoodsProductService goodsProductService) {
        this.goodsProductService = goodsProductService;
    }

    public GoodsAuditService getGoodsAuditService() {
        return this.goodsAuditService;
    }

    @Resource(name="goodsAuditService")
    public void setGoodsAuditService(GoodsAuditService goodsAuditService) {
        this.goodsAuditService = goodsAuditService;
    }

    @RequestMapping(value={"/goodsAudit"})
    public ModelAndView goodsAudit(PageBean pageBean, HttpServletRequest request, GoodsSearchBean searchBean, Long oneCateId, Long twoCateId) {
        pageBean.setUrl("findAllGoods.htm");
        String pageNo = request.getParameter("pageNo");
        if (pageNo == null) {
            pageNo = "1";
        }
        pageBean.setFirstPageNo(Integer.parseInt(pageNo));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pageBean", this.goodsAuditService.selectAuditGoods(pageBean, searchBean));
        map.put("isThirdAuditUsed", this.getOnOffService.getOnOffFlag());
        if (null != searchBean.getGoodsName()) {
            LOGGER.info((Object)("\u83b7\u53d6\u5546\u54c1\u540d\u79f0\u4e3a\uff1a" + searchBean.getGoodsName() + "\u7684\u5ba1\u6838\u5217\u8868"));
        }
        List oneCateList = this.goodsCateService.querySonCateByParentIdAndName(Long.valueOf(0L), null);
        pageBean = (PageBean)JSON.parseObject((String)JSON.toJSONString(map.get("pageBean")), PageBean.class);
        ModelAndView mav = new ModelAndView("jsp/goods/goodsAudit").addObject("map", map).addObject("brandList", (Object)this.goodsBrandService.queryAllBrand()).addObject("tagList", (Object)this.goodsTagService.queryAllTag()).addObject("searchBean", (Object)searchBean).addObject("oneCateList", (Object)oneCateList).addObject("oneCateId", (Object)oneCateId).addObject("twoCateId", (Object)twoCateId).addObject("pageBean", (Object)pageBean);
        if (oneCateId != null) {
            List twoCateList = this.goodsCateService.querySonCateByParentIdAndName(oneCateId, null);
            mav.addObject("twoCateList", (Object)twoCateList);
            if (twoCateId != null) {
                List threeCateList = this.goodsCateService.querySonCateByParentIdAndName(twoCateId, null);
                mav.addObject("threeCateList", (Object)threeCateList);
            }
        }
        return mav;
    }

    @RequestMapping(value={"auditaction"})
    public ModelAndView auditAction(HttpServletRequest request) {
        return new ModelAndView("jsp/goods/goodsAuditButtom").addObject("isThirdAuditUsed", (Object)this.getOnOffService.getOnOffFlag());
    }

    @RequestMapping(value={"changeAuditAction"})
    public ModelAndView changeAuditAction(String isThirdAuditUsed) {
        int count = this.getOnOffService.updateOnOffFlag(isThirdAuditUsed);
        if (count > 0) {
            return new ModelAndView((View)new RedirectView("auditaction.htm"));
        }
        return null;
    }

    @RequestMapping(value={"auditByGoodsId"})
    public ModelAndView auditByGoodsId(HttpServletRequest request, Long goodsId) {
        Goods goods = this.goodsProductService.selectGoodsByGoodsId(goodsId);
        String name = (String)request.getSession().getAttribute("name");
        int count = this.goodsAuditService.auditByGoodsId(goodsId);
        List goodsProducts = this.goodsProductService.queryProductsByGoodsId(goodsId);
        if (goodsProducts != null) {
            for (int i = 0; i < goodsProducts.size(); ++i) {
                this.goodsProductService.auditProductAction(((GoodsProduct)goodsProducts.get(i)).getGoodsInfoId());
            }
        }
        this.searchAsyncService.insertOneGoodsIndexToEs(goodsId);
        if (count > 0) {
            if (null != goods.getGoodsName()) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)name, (String)"\u5546\u54c1\u5ba1\u6838\u901a\u8fc7", (String)("\u5546\u54c1\u5ba1\u6838\u901a\u8fc7-->\u5546\u54c1\u540d\u79f0\u3010" + goods.getGoodsName() + LOGGERINFO1 + name));
                LOGGER.info((Object)("\u5546\u54c1" + goods.getGoodsName() + "\u5546\u54c1\u5ba1\u6838\u901a\u8fc7\uff01"));
            }
            return new ModelAndView((View)new RedirectView(GOODSAUDIT_HTM));
        }
        return null;
    }

    @RequestMapping(value={"refuseAuditByGoodsId"})
    public ModelAndView refuseAuditByGoodsId(HttpServletRequest request, Long goodsId, String refuseReason) {
        Goods goods = this.goodsProductService.selectGoodsByGoodsId(goodsId);
        String name = (String)request.getSession().getAttribute("name");
        int count = this.goodsAuditService.refuseAuditByGoodsId(goodsId, refuseReason);
        if (count > 0) {
            if (null != goods.getGoodsName()) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)name, (String)"\u5546\u54c1\u5ba1\u6838\u62d2\u7edd", (String)("\u5546\u54c1\u5ba1\u6838\u62d2\u7edd-->\u5546\u54c1\u540d\u79f0\u3010" + goods.getGoodsName() + LOGGERINFO1 + name));
                LOGGER.info((Object)("\u5546\u54c1" + goods.getGoodsName() + "\u5ba1\u6838\u672a\u901a\u8fc7\uff01"));
            }
            return new ModelAndView((View)new RedirectView(GOODSAUDIT_HTM));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"previewGoods"})
    public ModelAndView previewGoods(Long goodsId, Long goodsInfoId) {
        HashMap<String, List> resultMap = new HashMap<String, List>();
        try {
            Goods goods = new Goods();
            ArrayList<GoodsProductVo> goodsProductVos = new ArrayList<GoodsProductVo>();
            if (goodsId == null && goodsInfoId != null) {
                GoodsProductVo goodsProductVo = this.goodsProductService.queryByPrimaryId(goodsInfoId);
                if (goodsProductVo != null && goodsProductVo.getGoodsId() != null) {
                    goods.setGoodsId(goodsProductVo.getGoodsId());
                    goods = this.goodsService.selectByPrimaryKey(goods.getGoodsId());
                    goodsProductVos.add(goodsProductVo);
                    resultMap.put("goodsProductVos", goodsProductVos);
                }
            } else {
                goods.setGoodsId(goodsId);
                goods = (Goods)JSON.parseObject((String)JSON.toJSONString((Object)this.goodsService.selectByPrimaryKey(goods.getGoodsId())), Goods.class);
                resultMap.put("goodsProductVos", this.goodsProductService.queryProductsForPreview(goods.getGoodsId()));
            }
            resultMap.put("goods", (List)goods);
            resultMap.put("goodsCateVo", (List)this.goodsCateService.queryGoodsCateById(goods.getCatId()));
            resultMap.put("goodsBrand", (List)this.goodsBrandService.queryBrandById(goods.getBrandId()));
            resultMap.put("releParamVos", this.goodsReleParamService.queryAllByGoodsId(goods.getGoodsId()));
            resultMap.put("expandParamVos", this.goodsReleExpandParamService.queryExpandParamsByGoodsId(goods.getGoodsId()));
            ModelAndView modelAndView = new ModelAndView("jsp/goods/goodsPreviewDetail").addAllObjects(resultMap);
            return modelAndView;
        }
        finally {
            resultMap = null;
        }
    }

    @RequestMapping(value={"/queryAuditByGoodsId"})
    public ModelAndView queryAllByGoodsId(Long goodsId, PageBean pb, SelectBean selectBean) {
        return new ModelAndView("jsp/goods/goodsAuditList", "pb", (Object)this.goodsProductService.queryAuditByGoodsId(goodsId, pb, selectBean)).addObject("specs", (Object)this.goodsOpenSpecService.queryOpenListByGoodsId(goodsId)).addObject("goodsId", (Object)goodsId).addObject("selectBean", (Object)selectBean).addObject("wareHouse", (Object)this.wareHouseService.queryAllWareHouse()).addObject("support", (Object)this.serviceSupportMapperService.selectAll());
    }

    @RequestMapping(value={"auditProductAction"})
    public ModelAndView auditProductAction(HttpServletRequest request, Long goodsInfoId) {
        GoodsProductVo goodsProductVo = this.goodsProductService.queryByPrimaryId(goodsInfoId);
        String name = (String)request.getSession().getAttribute("name");
        int count = this.goodsProductService.auditProductAction(goodsInfoId);
        this.searchAsyncService.insertOneGoodsIndexToEs(goodsProductVo.getGoodsId());
        if (count > 0) {
            if (null != goodsProductVo.getGoodsInfoName()) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)name, (String)"\u8d27\u54c1\u5ba1\u6838\u901a\u8fc7", (String)("\u8d27\u54c1\u5ba1\u6838\u901a\u8fc7-->\u8d27\u54c1\u540d\u79f0\u3010" + goodsProductVo.getGoodsInfoName() + LOGGERINFO1 + name));
                LOGGER.info((Object)("\u8d27\u54c1" + goodsProductVo.getGoodsInfoName() + "\u5ba1\u6838\u901a\u8fc7\uff01"));
            }
            return new ModelAndView((View)new RedirectView(GOODSAUDIT_HTM));
        }
        return null;
    }

    @RequestMapping(value={"refuseAuditProductAction"})
    public ModelAndView refuseAuditProductAction(HttpServletRequest request, Long goodsInfoId, String refuseReason) {
        GoodsProductVo goodsProductVo = this.goodsProductService.queryByPrimaryId(goodsInfoId);
        String name = (String)request.getSession().getAttribute("name");
        int count = this.goodsProductService.refuseAuditProductAction(goodsInfoId, refuseReason);
        if (count > 0) {
            if (null != goodsProductVo.getGoodsInfoName()) {
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)name, (String)"\u8d27\u54c1\u5ba1\u6838\u62d2\u7edd", (String)("\u8d27\u54c1\u5ba1\u6838\u62d2\u7edd-->\u8d27\u54c1\u540d\u79f0\u3010" + goodsProductVo.getGoodsInfoName() + LOGGERINFO1 + name));
                LOGGER.info((Object)("\u8d27\u54c1" + goodsProductVo.getGoodsInfoName() + "\u8d27\u54c1\u5ba1\u6838\u62d2\u7edd\uff01"));
            }
            return new ModelAndView((View)new RedirectView(GOODSAUDIT_HTM));
        }
        return null;
    }

    public GetOnOffService getGetOnOffService() {
        return this.getOnOffService;
    }

    @Resource(name="GetOnOffService")
    public void setGetOnOffService(GetOnOffService getOnOffService) {
        this.getOnOffService = getOnOffService;
    }
}

