/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.goods.controller;

import com.qianjiang.excel.FileBean;
import com.qianjiang.excel.ImportGoods;
import com.qianjiang.goods.bean.PageBean;
import com.qianjiang.goods.service.GoodsBrandService;
import com.qianjiang.goods.service.GoodsImportService;
import com.qianjiang.goods.service.GoodsTagService;
import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.goods.util.SelectBean;
import com.qianjiang.system.service.ServiceSupportMapperService;
import com.qianjiang.util.MyLogger;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class GoodsImportController {
    public static final MyLogger LOGGER = new MyLogger(GoodsImportController.class);
    private static final String QUERYALLIMPORT_HTM = "queryAllImport.htm";
    private static final String FINDALLSPEC_HTM = "findAllSpec.htm";
    private static final String FINDALLTYPE_HTM = "findAllType.htm";
    private GoodsImportService goodsImportService;
    @Resource(name="ImportGoods")
    private ImportGoods importGoods;
    private GoodsBrandService goodsBrandService;
    private GoodsTagService goodsTagService;
    private WareHouseService wareHouseService;
    @Resource(name="serviceSupportMapperService")
    private ServiceSupportMapperService serviceSupportMapperService;

    @RequestMapping(value={"/downImportExcel"})
    public void downImportExcel(HttpServletResponse response) {
        this.importGoods.exportProductList(response);
    }

    @RequestMapping(value={"/downImportExcels"})
    public void downImportExcels(HttpServletResponse response) {
        this.importGoods.exportProductLists(response);
    }

    @RequestMapping(value={"/downTypeImportExcels"})
    public void downTypeImportExcels(HttpServletResponse response) {
        this.importGoods.exportTypeProductLists(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/queryAllImport"})
    public ModelAndView queryAllImport(PageBean pageBean, SelectBean selectBean, HttpServletRequest request, String flag) {
        pageBean.setUrl(QUERYALLIMPORT_HTM);
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("pageBean", this.goodsImportService.selectAllGoodsImport(pageBean, selectBean, null));
            map.put("selectBean", selectBean);
            map.put("flag", flag);
            ModelAndView modelAndView = new ModelAndView("jsp/goods/goods_import", "map", map);
            return modelAndView;
        }
        finally {
            map = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/toPubImportGoods"})
    public ModelAndView toPubGoods(HttpServletRequest request, Long id, String type) {
        ModelAndView mav = null;
        if (type != null && "1".equals(type)) {
            request.getSession().setAttribute("importGoodsId", (Object)id);
            mav = new ModelAndView("jsp/goods/newupload");
        } else {
            mav = new ModelAndView("jsp/goods/import_upload");
        }
        try {
            mav.addObject("brandList", (Object)this.goodsBrandService.queryAllBrand());
            mav.addObject("tagList", (Object)this.goodsTagService.queryAllTag());
            mav.addObject("wareHouse", (Object)this.wareHouseService.queryAllWareHouse());
            mav.addObject("support", (Object)this.serviceSupportMapperService.selectAll());
            mav.addObject("importGoods", (Object)this.goodsImportService.selectByPrimaryKey(id));
            ModelAndView modelAndView = mav;
            return modelAndView;
        }
        finally {
            mav = null;
        }
    }

    @RequestMapping(value={"/batchDelImport"})
    public ModelAndView batchDelImport(Long[] importCheck, HttpServletRequest request) {
        this.goodsImportService.batchDelGoodsImport(importCheck);
        return new ModelAndView((View)new RedirectView(QUERYALLIMPORT_HTM));
    }

    @RequestMapping(value={"/updateImportAdded"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public boolean updateImportAdded(Long id) {
        return this.goodsImportService.updateGoodsImportAdded(id) > 0;
    }

    @RequestMapping(value={"/importGoods"})
    public ModelAndView importGoods(HttpServletRequest request, HttpServletResponse response, Long goodsCateId, MultipartHttpServletRequest request2) {
        int num = 0;
        try {
            request.setAttribute("imThirdId", (Object)0L);
            request.setAttribute("imThirdName", (Object)"BOSS");
            MultipartFile file = request2.getFile("importExcel");
            FileBean fileBean = new FileBean();
            fileBean.setFileb(file.getBytes());
            fileBean.setOriginalFilename(file.getOriginalFilename());
            if (!this.goodsImportService.importGoodsByExcel(Long.valueOf(0L), "BOSS", fileBean)) {
                num = 1;
            }
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return new ModelAndView((View)new RedirectView("queryAllImport.htm?flag=" + num));
        }
        return new ModelAndView((View)new RedirectView("queryAllImport.htm?flag=" + num));
    }

    @RequestMapping(value={"/importGoodsModel"})
    public ModelAndView importGoodsModel(HttpServletRequest request, HttpServletResponse response, Long goodsCateId, MultipartHttpServletRequest request2) {
        int num = 0;
        try {
            MultipartFile file = request2.getFile("importExcels");
            FileBean fileBean = new FileBean();
            fileBean.setFileb(file.getBytes());
            fileBean.setOriginalFilename(file.getOriginalFilename());
            if (!this.goodsImportService.importGoodsByExcels(fileBean)) {
                num = 1;
            }
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return new ModelAndView((View)new RedirectView("findAllSpec.htm?flag=" + num));
        }
        return new ModelAndView((View)new RedirectView("findAllSpec.htm?flag=" + num));
    }

    @RequestMapping(value={"/importTypeGoodsModel"})
    public ModelAndView importTypeGoodsModel(HttpServletRequest request, HttpServletResponse response, Long goodsCateId, MultipartHttpServletRequest request2) {
        int num = 0;
        try {
            MultipartFile file = request2.getFile("importTypeExcels");
            FileBean fileBean = new FileBean();
            fileBean.setFileb(file.getBytes());
            fileBean.setOriginalFilename(file.getOriginalFilename());
            if (!this.goodsImportService.importTypeGoodsByExcels(fileBean)) {
                num = 1;
            }
        }
        catch (Exception e) {
            LOGGER.error("" + e);
            return new ModelAndView((View)new RedirectView("findAllType.htm?flag=" + num));
        }
        return new ModelAndView((View)new RedirectView("findAllType.htm?flag=" + num));
    }

    public GoodsImportService getGoodsImportService() {
        return this.goodsImportService;
    }

    @Resource(name="GoodsImportService")
    public void setGoodsImportService(GoodsImportService goodsImportService) {
        this.goodsImportService = goodsImportService;
    }

    public GoodsBrandService getGoodsBrandService() {
        return this.goodsBrandService;
    }

    @Resource(name="GoodsBrandService")
    public void setGoodsBrandService(GoodsBrandService goodsBrandService) {
        this.goodsBrandService = goodsBrandService;
    }

    public GoodsTagService getGoodsTagService() {
        return this.goodsTagService;
    }

    @Resource(name="GoodsTagServiceImpl")
    public void setGoodsTagService(GoodsTagService goodsTagService) {
        this.goodsTagService = goodsTagService;
    }

    @Resource(name="WareHouseService")
    public void setWareHouseService(WareHouseService wareHouseService) {
        this.wareHouseService = wareHouseService;
    }
}

