/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.controller;

import com.qianjiang.mobile.bean.MobHomePage;
import com.qianjiang.mobile.service.MobHomePageService;
import com.qianjiang.mobile.service.MobPageCateServcie;
import com.qianjiang.mobile.vo.MobHomePageVo;
import com.qianjiang.system.mobile.service.MobSiteBasicService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.util.BasicSetUtil;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.xml.XmlElementUtil;
import com.qianjiang.util.xml.XmlUtil;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.w3c.dom.Element;

@Controller
public class MobHomePageController {
    private static final Logger LOGGER = Logger.getLogger(MobHomePageController.class);
    private static final String APPCONT = "app_cont";
    private static final String ROLLADV = "roll_adv";
    private static final String FULLROLL = "fullRoll";
    private static final String GOODSMOD = "goodsmod";
    private static final String BLANKBOX = "blankbox";
    private static final String DIVIDING = "dividing";
    private static final String IMGNAV = "imagenav";
    private static final String STYLE = "style";
    private static final String WIDTHB = "widthB";
    private static final String HEIGHTB = "heightB";
    private static final String MUSICNAME = "musicname";
    private static final String BLANK_BOX = "blank-box";
    private static final String QUERYMOBHOMEPAGE_HTM = "queryMobHomePage.htm";
    XmlUtil xmlUtil = new XmlUtil();
    XmlElementUtil xmlElementUtil = new XmlElementUtil();
    static final Long STOREID = -1L;
    static final String xmlFilePath = "templete_mobile/xml/9gdemo.xml";
    static final String xslFilePath = "templete_mobile/xsl/9gdemo_save.xsl";
    static final String htmlFilePath = "templete_mobile/html/9gdemo.html";
    @Resource(name="MobHomePageService")
    private MobHomePageService mobHomePageService;
    @Resource(name="MobSiteBasicService")
    private MobSiteBasicService mobSiteBasicService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="MobPageCateServcie")
    private MobPageCateServcie mobPageCateServcie;

    @RequestMapping(value={"/queryMobHomePage"})
    public ModelAndView queryMobHomePage(Long merchantId) {
        Long merchantIdNew = merchantId;
        ModelAndView mav = new ModelAndView();
        if (null == merchantIdNew) {
            merchantIdNew = STOREID;
        }
        mav.addObject("merchantId", (Object)merchantIdNew);
        MobHomePage currHomePage = this.mobHomePageService.getCurrHomePageByMerchantId(merchantIdNew);
        mav.addObject("currHomePage", (Object)currHomePage);
        List list = this.mobHomePageService.selectAllUnstatusByMerchantId(merchantIdNew);
        mav.addObject("homePages", (Object)list);
        mav.setViewName("jsp/mobile/mob_home_page_list");
        return mav;
    }

    @RequestMapping(value={"/setMobHomePage"})
    public ModelAndView setMobMain(Long merchantId, Long homePageId, HttpServletRequest request) {
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        ModelAndView mav = new ModelAndView();
        if (null == merchantId) {
            merchantId = STOREID;
        }
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = null;
        homePage = null == homePageId ? this.mobHomePageService.initHomePage(merchantId, null, null, filepath, loginUserId) : this.mobHomePageService.getHomePageById(homePageId);
        org.w3c.dom.Document doc = this.xmlUtil.str2Document(homePage.getDoc());
        String filePath = request.getSession().getServletContext().getRealPath("/");
        String xmlFileName = xmlFilePath.replace(".xml", "_" + merchantId + "_" + homePageId + ".xml");
        String fileName = filePath + xmlFileName;
        this.xmlUtil.createXml(fileName, doc);
        mav.addObject("xmlFilePath", (Object)xmlFileName);
        mav.addObject("merchantId", (Object)merchantId);
        mav.addObject("homePage", (Object)homePage);
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        mav.addObject("mobSiteBasic", (Object)this.mobSiteBasicService.selectCurrMobSiteBasic(basePath));
        mav.setViewName("jsp/mobile/templete_mobile");
        return mav;
    }

    @RequestMapping(value={"/saveAllMod"})
    public ModelAndView saveAllMod(Long homePageId, HttpServletRequest request) {
        MobHomePage homePage = this.mobHomePageService.getHomePageById(homePageId);
        org.w3c.dom.Document document = this.xmlUtil.str2Document(homePage.getDoc());
        Element root = document.getDocumentElement();
        this.xmlElementUtil.removeElement(root, APPCONT);
        this.xmlElementUtil.removeElement(root, "img_adv");
        this.xmlElementUtil.removeElement(root, ROLLADV);
        this.xmlElementUtil.removeElement(root, FULLROLL);
        this.xmlElementUtil.removeElement(root, "text");
        this.xmlElementUtil.removeElement(root, GOODSMOD);
        this.xmlElementUtil.removeElement(root, BLANKBOX);
        this.xmlElementUtil.removeElement(root, DIVIDING);
        this.xmlElementUtil.removeElement(root, IMGNAV);
        String ipCont = request.getParameter("ipCont");
        Document doc = Jsoup.parse((String)ipCont);
        Elements items = doc.getElementsByClass("item");
        for (int i = 0; i < items.size(); ++i) {
            org.jsoup.nodes.Element a;
            String href;
            org.jsoup.nodes.Element item = items.get(i);
            String itemId = item.attr("id");
            String id = itemId.substring(8);
            if (itemId.indexOf(APPCONT) != -1) {
                Element newAppCont = root.getOwnerDocument().createElement(APPCONT);
                this.xmlElementUtil.setElementAttr(newAppCont, "id", id);
                root.appendChild(newAppCont);
                Elements imgs = item.getElementsByClass("imgapp");
                for (int j = 0; j < imgs.size(); ++j) {
                    org.jsoup.nodes.Element img = imgs.get(j);
                    String imgId = img.attr("id").substring(2);
                    String src = img.attr("src");
                    href = img.parent().attr("href");
                    String sRow = imgId.substring(3, 4);
                    String sCol = imgId.substring(5, 6);
                    String rows = imgId.substring(7, 8);
                    String cols = imgId.substring(9);
                    int width = Integer.valueOf(cols) * 160;
                    int height = Integer.valueOf(rows) * 160;
                    Double widthvalue = new Double(width) / 2.0;
                    Double heightvalue = new Double(height) / 2.0;
                    String left = "left:" + ((Integer.valueOf(sCol) - 1) * 160 / 2 - 1) + "px;";
                    String top = "top:" + (Integer.valueOf(sRow) - 1) * 160 / 2 + "px;";
                    String style = "position:absolute;" + left + top;
                    String widthB = widthvalue / 320.0 * 100.0 + "%";
                    String heightB = heightvalue / 320.0 * 100.0 + "%";
                    String leftB = (new Double(sCol) - 1.0) * 160.0 / 2.0 / 320.0 * 100.0 + "%";
                    String topB = (new Double(sRow) - 1.0) * 160.0 / 2.0 / 320.0 * 100.0 + "%";
                    String styleB = "position:absolute;left:" + leftB + ";top:" + topB + ";";
                    Element newA = newAppCont.getOwnerDocument().createElement("a");
                    this.xmlElementUtil.setElementAttr(newA, "href", href);
                    Element newImg = newA.getOwnerDocument().createElement("img");
                    this.xmlElementUtil.setElementAttr(newImg, "id", imgId);
                    this.xmlElementUtil.setElementAttr(newImg, "src", src);
                    this.xmlElementUtil.setElementAttr(newImg, "class", "imgapp");
                    this.xmlElementUtil.setElementAttr(newImg, "width", widthvalue.toString());
                    this.xmlElementUtil.setElementAttr(newImg, "height", heightvalue.toString());
                    this.xmlElementUtil.setElementAttr(newImg, STYLE, style);
                    this.xmlElementUtil.setElementAttr(newImg, WIDTHB, widthB);
                    this.xmlElementUtil.setElementAttr(newImg, HEIGHTB, heightB);
                    this.xmlElementUtil.setElementAttr(newImg, "styleB", styleB);
                    newA.appendChild(newImg);
                    newAppCont.appendChild(newA);
                }
                continue;
            }
            if (itemId.indexOf("img_adv_") != -1) {
                org.jsoup.nodes.Element a2 = item.getElementsByTag("a").get(0);
                org.jsoup.nodes.Element img = a2.getElementsByTag("img").get(0);
                String href2 = a2.attr("href");
                String src = img.attr("src");
                Element newImgAdv = root.getOwnerDocument().createElement("img_adv");
                this.xmlElementUtil.setElementAttr(newImgAdv, "id", id);
                root.appendChild(newImgAdv);
                Element newA = newImgAdv.getOwnerDocument().createElement("a");
                this.xmlElementUtil.setElementAttr(newA, "href", href2);
                Element newImg = newA.getOwnerDocument().createElement("img");
                this.xmlElementUtil.setElementAttr(newImg, "src", src);
                this.xmlElementUtil.setElementAttr(newImg, "width", "100%");
                this.xmlElementUtil.setElementAttr(newImg, WIDTHB, "100%");
                newA.appendChild(newImg);
                newImgAdv.appendChild(newA);
                continue;
            }
            if (itemId.indexOf(ROLLADV) != -1) {
                Elements slides = item.getElementsByClass("swiper-slide");
                Element newImgAdv = root.getOwnerDocument().createElement(ROLLADV);
                this.xmlElementUtil.setElementAttr(newImgAdv, "id", id);
                root.appendChild(newImgAdv);
                for (int j = 1; j < slides.size() - 1; ++j) {
                    org.jsoup.nodes.Element slide = slides.get(j);
                    a = slide.getElementsByTag("a").get(0);
                    org.jsoup.nodes.Element img = a.getElementsByTag("img").get(0);
                    href = a.attr("href");
                    String src = img.attr("src");
                    Element newA = newImgAdv.getOwnerDocument().createElement("roll_a");
                    this.xmlElementUtil.setElementAttr(newA, "href", href);
                    Element newImg = newA.getOwnerDocument().createElement("img");
                    this.xmlElementUtil.setElementAttr(newImg, "src", src);
                    this.xmlElementUtil.setElementAttr(newImg, "width", "100%");
                    this.xmlElementUtil.setElementAttr(newImg, WIDTHB, "100%");
                    this.xmlElementUtil.setElementAttr(newImg, "height", "155px");
                    this.xmlElementUtil.setElementAttr(newImg, HEIGHTB, "50%");
                    newA.appendChild(newImg);
                    newImgAdv.appendChild(newA);
                }
                continue;
            }
            if (itemId.indexOf(FULLROLL) != -1) {
                String sd = item.getElementsByClass("fullRollSD").get(0).val();
                String music = "";
                if (!item.getElementsByTag("audio").isEmpty()) {
                    music = item.getElementsByTag("audio").get(0).attr("src");
                }
                String musicname = "";
                if (!item.getElementsByClass(MUSICNAME).isEmpty()) {
                    musicname = item.getElementsByClass(MUSICNAME).get(0).val();
                }
                Element newFullRoll = root.getOwnerDocument().createElement(FULLROLL);
                this.xmlElementUtil.setElementAttr(newFullRoll, "id", id);
                this.xmlElementUtil.setElementAttr(newFullRoll, "sd", sd);
                this.xmlElementUtil.setElementAttr(newFullRoll, "music", music);
                this.xmlElementUtil.setElementAttr(newFullRoll, MUSICNAME, musicname);
                root.appendChild(newFullRoll);
                Elements slides = item.getElementsByClass("swiper-slide");
                for (int j = 1; j < slides.size() - 1; ++j) {
                    org.jsoup.nodes.Element slide = slides.get(j);
                    org.jsoup.nodes.Element a3 = slide.getElementsByTag("a").get(0);
                    org.jsoup.nodes.Element img = a3.getElementsByTag("img").get(0);
                    String href3 = a3.attr("href");
                    String src = img.attr("src");
                    Element newA = newFullRoll.getOwnerDocument().createElement("roll_a");
                    this.xmlElementUtil.setElementAttr(newA, "href", href3);
                    Element newImg = newA.getOwnerDocument().createElement("img");
                    this.xmlElementUtil.setElementAttr(newImg, "src", src);
                    this.xmlElementUtil.setElementAttr(newImg, WIDTHB, "100%");
                    this.xmlElementUtil.setElementAttr(newImg, HEIGHTB, "100%");
                    newA.appendChild(newImg);
                    newFullRoll.appendChild(newA);
                }
                continue;
            }
            if (itemId.indexOf("text_app") != -1) {
                String content = item.html();
                Element newText = root.getOwnerDocument().createElement("text");
                newText.setNodeValue(content);
                this.xmlElementUtil.setElementValue(newText, content);
                this.xmlElementUtil.setElementAttr(newText, "id", id);
                root.appendChild(newText);
                continue;
            }
            if (itemId.indexOf(GOODSMOD) != -1) {
                String styleClass = item.attr("styleClass");
                Element newGoodsmod = root.getOwnerDocument().createElement(GOODSMOD);
                this.xmlElementUtil.setElementAttr(newGoodsmod, "id", id);
                this.xmlElementUtil.setElementAttr(newGoodsmod, "class", styleClass);
                root.appendChild(newGoodsmod);
                Elements as = item.getElementsByTag("a");
                for (int j = 0; j < as.size(); ++j) {
                    a = as.get(j);
                    String href4 = a.attr("href");
                    String src = a.getElementsByTag("img").get(0).attr("src");
                    String name = a.getElementsByTag("h3").get(0).html();
                    String price = a.getElementsByTag("span").get(0).html();
                    Element newLi = newGoodsmod.getOwnerDocument().createElement("li");
                    Element newA = newLi.getOwnerDocument().createElement("goods_a");
                    this.xmlElementUtil.setElementAttr(newA, "href", href4);
                    this.xmlElementUtil.setElementAttr(newA, "name", name);
                    this.xmlElementUtil.setElementAttr(newA, "price", price);
                    Element newImg = newA.getOwnerDocument().createElement("img");
                    this.xmlElementUtil.setElementAttr(newImg, "src", src);
                    newA.appendChild(newImg);
                    newLi.appendChild(newA);
                    newGoodsmod.appendChild(newLi);
                }
                continue;
            }
            if (itemId.indexOf(BLANKBOX) != -1) {
                String height = "30px;";
                if (item.getElementsByClass(BLANK_BOX) != null && item.getElementsByClass(BLANK_BOX).get(0) != null && item.getElementsByClass(BLANK_BOX).get(0).attr(STYLE) != null && item.getElementsByClass(BLANK_BOX).get(0).attr(STYLE).split(":").length > 1) {
                    height = item.getElementsByClass(BLANK_BOX).get(0).attr(STYLE).split(":")[1];
                }
                Element newBlankbox = root.getOwnerDocument().createElement(BLANKBOX);
                this.xmlElementUtil.setElementAttr(newBlankbox, "id", id);
                this.xmlElementUtil.setElementAttr(newBlankbox, "height", height);
                root.appendChild(newBlankbox);
                continue;
            }
            if (itemId.indexOf(DIVIDING) != -1) {
                Element newBlankbox = root.getOwnerDocument().createElement(DIVIDING);
                this.xmlElementUtil.setElementAttr(newBlankbox, "id", id);
                root.appendChild(newBlankbox);
                continue;
            }
            if (itemId.indexOf(IMGNAV) == -1) continue;
            Elements navItem = item.getElementsByClass("img-nav-item");
            Element newImgNav = root.getOwnerDocument().createElement(IMGNAV);
            this.xmlElementUtil.setElementAttr(newImgNav, "id", id);
            root.appendChild(newImgNav);
            for (int j = 0; j < navItem.size(); ++j) {
                org.jsoup.nodes.Element slide = navItem.get(j);
                a = slide.getElementsByTag("a").get(0);
                org.jsoup.nodes.Element img = a.getElementsByTag("img").get(0);
                href = a.attr("href");
                String data_img = a.attr("data-img");
                String data_name = a.attr("data-name");
                String data_chs = a.attr("data-chs");
                String data_chs2 = a.attr("data-chs2");
                String data_tag = a.attr("data-tag");
                String src = img.attr("src");
                Element newA = newImgNav.getOwnerDocument().createElement("img_nav_a");
                this.xmlElementUtil.setElementAttr(newA, "href", href);
                this.xmlElementUtil.setElementAttr(newA, "data-img", data_img);
                this.xmlElementUtil.setElementAttr(newA, "data-name", data_name);
                this.xmlElementUtil.setElementAttr(newA, "data-chs", data_chs);
                this.xmlElementUtil.setElementAttr(newA, "data-chs2", data_chs2);
                this.xmlElementUtil.setElementAttr(newA, "data-tag", data_tag);
                Element newImg = newA.getOwnerDocument().createElement("img");
                this.xmlElementUtil.setElementAttr(newImg, "src", src);
                newA.appendChild(newImg);
                newImgNav.appendChild(newA);
            }
        }
        homePage.setTemp4("0");
        homePage.setPageState(Integer.valueOf(0));
        if ("1".equals(request.getParameter("pageState"))) {
            homePage.setPageState(Integer.valueOf(1));
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView("queryMobPageList.htm"));
    }

    @RequestMapping(value={"/openHomePage"})
    public ModelAndView openHomePage(Long homePageId, Long merchantId) {
        this.mobHomePageService.openHomePageByHIdAndMId(homePageId, merchantId);
        return new ModelAndView((View)new RedirectView("queryMobPageList.htm"));
    }

    @RequestMapping(value={"/deleteHomePage"})
    public ModelAndView deleteHomePage(Long homePageId) {
        this.mobHomePageService.deleteHomePageById(homePageId);
        return new ModelAndView((View)new RedirectView(QUERYMOBHOMEPAGE_HTM));
    }

    private String mkToken() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }

    private String mkRSV() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }

    @RequestMapping(value={"/ajaxGetRSV"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String ajaxGetRSV(HttpServletRequest request) {
        return (String)request.getSession().getAttribute("rsv");
    }

    @RequestMapping(value={"/updateMobHomePageForShare"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Boolean updateMobHomePageForShare(MobHomePage homePage, HttpServletRequest request) {
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u5220\u9664\u7a7a\u767d\u5360\u4f4d\u91cd\u590d\u63d0\u4ea4===========");
            return Boolean.FALSE;
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        try {
            if (homePage.getSort() == null) {
                homePage.setSort(Integer.valueOf(0));
            }
            Long loginUserId = (Long)request.getAttribute("loginUserId");
            this.mobHomePageService.updateHomePage(homePage, loginUserId);
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u79fb\u52a8\u7aef\u9875\u9762\u57fa\u672c\u4fe1\u606f\u66f4\u65b0\u5f02\u5e38\uff1a=>", (Throwable)e);
            return Boolean.FALSE;
        }
    }

    @RequestMapping(value={"/ajaxQueryMobSiteBasicNew"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, String> ajaxQueryMobSiteBasicNew(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(Long.valueOf(-1L), filepath, loginUserId);
        String path = request.getContextPath();
        String basePath = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + path + "/";
        map.put("logo", this.mobSiteBasicService.selectCurrMobSiteBasic(basePath).getTemp1());
        map.put("title", homePage.getTitle());
        map.put("shareTimelineDesc", homePage.getFriendsDesc());
        map.put("sendAppMessageDesc", homePage.getFriendDesc());
        return map;
    }

    @RequestMapping(value={"/queryMobPageList"})
    public ModelAndView queryMobHomeList(MobHomePageVo vo, PageBean pageBean, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView("jsp/mobile/mob_page_list");
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("delflag", "0");
            mav.addObject("pageCateList", (Object)this.mobPageCateServcie.selectAll(params));
            String mobileAddress = BasicSetUtil.getAddress((String)this.getMobileAddress(request));
            mav.addObject("siteAddress", (Object)mobileAddress);
            mav.addObject("search", (Object)vo);
            vo.setIsThird("0");
            vo.setTemp4("0");
            vo.setTemp3("0");
            mav.addObject("pb", (Object)this.mobHomePageService.selectMobPageByPb(vo, pageBean));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u9875\u9762\u8bbe\u7f6e\u5217\u8868\u9519\u8bef", (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/ajaxQueryMobPageList"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, Object> ajaxQueryMobPageList(MobHomePageVo vo, PageBean pageBean, HttpServletRequest request) {
        HashMap<String, Object> mav = new HashMap<String, Object>();
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("delflag", "0");
            mav.put("pageCateList", this.mobPageCateServcie.selectAll(params));
            String mobileAddress = BasicSetUtil.getAddress((String)this.getMobileAddress(request));
            mav.put("siteAddress", mobileAddress);
            mav.put("search", vo);
            vo.setIsThird("0");
            vo.setTemp4("0");
            vo.setTemp3("0");
            mav.put("pb", this.mobHomePageService.selectMobPageByPb(vo, pageBean));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u9875\u9762\u8bbe\u7f6e\u5217\u8868\u9519\u8bef", (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/chooseMobPage"})
    public ModelAndView chooseMobPage(MobHomePageVo vo, PageBean pageBean) {
        ModelAndView mav = new ModelAndView("jsp/mobile/choose_mob_page");
        try {
            mav.addObject("search", (Object)vo);
            vo.setTemp4("0");
            vo.setTemp3("1");
            mav.addObject("pb", (Object)this.mobHomePageService.selectMobPageByPb(vo, pageBean));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u6a21\u677f\u9009\u62e9\u5217\u8868\u9519\u8bef", (Throwable)e);
        }
        return mav;
    }

    @RequestMapping(value={"/addMobPage"})
    public ModelAndView addMobPage(MobHomePageVo vo, HttpServletRequest request) {
        ModelAndView mav = new ModelAndView((View)new RedirectView("chooseMobPage.htm"));
        try {
            vo.setMerchantId(Long.valueOf(-1L));
            vo.setIsThird("0");
            vo.setStoreId(Long.valueOf(0L));
            String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
            Long loginUserId = (Long)request.getAttribute("loginUserId");
            long res = this.mobHomePageService.addMobPage(vo, filepath, loginUserId);
            if (res > 0L) {
                mav.setView((View)new RedirectView("setMobHomePage.htm".concat("?homePageId=").concat(String.valueOf(res))));
                return mav;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u6a21\u677f\u9009\u62e9\u5217\u8868\u9519\u8bef", (Throwable)e);
        }
        mav.addObject("msg", (Object)"\u9009\u4e2d\u5931\u8d25");
        return mav;
    }

    @RequestMapping(value={"/isUsed"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, String> isUsed(MobHomePageVo vo) {
        int res = 0;
        try {
            res = this.mobHomePageService.isUsed(vo.getHomePageIds());
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u9875\u9762\u8bbe\u7f6e\u662f\u5426\u4f7f\u7528\u9519\u8bef", (Throwable)e);
        }
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("res", String.valueOf(res));
        return resMap;
    }

    @RequestMapping(value={"/deleteMobPage"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map<String, String> deleteMobPage(MobHomePageVo vo) {
        int res = 0;
        try {
            res = this.mobHomePageService.deleteMobPage(vo.getHomePageIds());
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u9875\u9762\u8bbe\u7f6e\u5220\u9664\u9519\u8bef", (Throwable)e);
        }
        HashMap<String, String> resMap = new HashMap<String, String>();
        resMap.put("res", String.valueOf(res));
        return resMap;
    }

    private String getMobileAddress(HttpServletRequest request) {
        String mobileAddress = this.basicSetService.findBasicSet().getMobileAddress();
        mobileAddress = BasicSetUtil.getAddress((String)mobileAddress);
        return mobileAddress;
    }
}

