/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.controller;

import com.qianjiang.mobile.bean.MobHomePage;
import com.qianjiang.mobile.service.MobHomePageService;
import com.qianjiang.util.xml.XmlElementUtil;
import com.qianjiang.util.xml.XmlUtil;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Controller
public class MobHomeRollAdverController {
    private static final Logger LOGGER = Logger.getLogger(MobHomeRollAdverController.class);
    XmlUtil xmlUtil = new XmlUtil();
    XmlElementUtil xmlElementUtil = new XmlElementUtil();
    static final Long STOREID = -1L;
    static final String xmlFilePath = "templete_mobile/xml/9gdemo.xml";
    static final String xslFilePath = "templete_mobile/xsl/9gdemo_save.xsl";
    static final String htmlFilePath = "templete_mobile/html/9gdemo.html";
    private static final String SETMOBHOMEPAGE_HTM = "setMobHomePage.htm";
    private static final String ROLL_ADV = "roll_adv";
    private static final String ROLL_A = "roll_a";
    @Resource(name="MobHomePageService")
    private MobHomePageService mobHomePageService;

    @RequestMapping(value={"/saveRollAdv"})
    public ModelAndView saveRollAdv(Long merchantId, HttpServletRequest request) {
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u4fdd\u5b58\u8f6e\u64ad\u5e7f\u544a\u91cd\u590d\u63d0\u4ea4===========");
            return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        Element root = document.getDocumentElement();
        String rollImgAdvId = request.getParameter("rollImgAdvId");
        String[] src = request.getParameterValues("rollImgAdvSrc");
        String[] href = request.getParameterValues("rollImgAdvHref");
        if (null != rollImgAdvId && !"".equals(rollImgAdvId)) {
            this.updateAdvElement(root, rollImgAdvId, src, href);
        } else {
            this.createAdvElement(root, src, href);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
    }

    private void createAdvElement(Element root, String[] src, String[] href) {
        Element[] rollAdvs = this.xmlElementUtil.getElementsByName(root, ROLL_ADV);
        int max = 0;
        for (Element el : rollAdvs) {
            int temp = Integer.valueOf(el.getAttribute("id"));
            if (temp <= max) continue;
            max = temp;
        }
        Element newImgAdv = root.getOwnerDocument().createElement(ROLL_ADV);
        this.xmlElementUtil.setElementAttr(newImgAdv, "id", String.valueOf(max + 1));
        root.appendChild(newImgAdv);
        for (int i = 0; i < src.length; ++i) {
            Element newA = newImgAdv.getOwnerDocument().createElement(ROLL_A);
            this.xmlElementUtil.setElementAttr(newA, "href", href[i]);
            Element newImg = newA.getOwnerDocument().createElement("img");
            this.xmlElementUtil.setElementAttr(newImg, "src", src[i]);
            this.xmlElementUtil.setElementAttr(newImg, "width", "100%");
            this.xmlElementUtil.setElementAttr(newImg, "widthB", "100%");
            this.xmlElementUtil.setElementAttr(newImg, "height", "155px");
            this.xmlElementUtil.setElementAttr(newImg, "heightB", "50%");
            newA.appendChild(newImg);
            newImgAdv.appendChild(newA);
        }
    }

    private void updateAdvElement(Element root, String rollImgAdvId, String[] src, String[] href) {
        Element[] rollAdvs;
        Node oldImgAdv = null;
        for (Element el : rollAdvs = this.xmlElementUtil.getElementsByName(root, ROLL_ADV)) {
            Element[] as;
            if (!el.getAttribute("id").equals(rollImgAdvId)) continue;
            oldImgAdv = el;
            for (Element a : as = this.xmlElementUtil.getElementsByName(el, ROLL_A)) {
                el.removeChild(a);
            }
        }
        for (int i = 0; i < src.length; ++i) {
            Element newA = oldImgAdv.getOwnerDocument().createElement(ROLL_A);
            this.xmlElementUtil.setElementAttr(newA, "href", href[i]);
            Element newImg = newA.getOwnerDocument().createElement("img");
            this.xmlElementUtil.setElementAttr(newImg, "src", src[i]);
            this.xmlElementUtil.setElementAttr(newImg, "width", "100%");
            this.xmlElementUtil.setElementAttr(newImg, "widthB", "100%");
            this.xmlElementUtil.setElementAttr(newImg, "height", "155px");
            this.xmlElementUtil.setElementAttr(newImg, "heightB", "50%");
            newA.appendChild(newImg);
            oldImgAdv.appendChild(newA);
        }
    }

    @RequestMapping(value={"/deleteRollAdv"})
    public ModelAndView deleteRollAdv(Long merchantId, HttpServletRequest request) {
        Element[] rollAdvs;
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u5220\u9664\u8f6e\u64ad\u5e7f\u544a\u91cd\u590d\u63d0\u4ea4===========");
            return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        String id = request.getParameter("id");
        Element root = document.getDocumentElement();
        for (Element el : rollAdvs = this.xmlElementUtil.getElementsByName(root, ROLL_ADV)) {
            if (!this.xmlElementUtil.getElementAttr(el, "id").equals(id)) continue;
            root.removeChild(el);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView(SETMOBHOMEPAGE_HTM));
    }

    private String mkToken() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }

    private String mkRSV() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }
}

