/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.controller;

import com.qianjiang.mobile.bean.MobStorey;
import com.qianjiang.mobile.service.MobStoreyService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.PageBean;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class MobStoreyController {
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private static final String REDIRECT = "queryMobStoreyByPageBean.htm";
    @Resource(name="MobStoreyService")
    private MobStoreyService mobStoreyService;

    @RequestMapping(value={"/queryMobStoreyByPageBean"})
    public ModelAndView queryMobStoreyByPageBean(PageBean pb) {
        return new ModelAndView("jsp/mobile/mobstorey_list", "pb", (Object)this.mobStoreyService.selectMobStoreyByPb(pb));
    }

    @RequestMapping(value={"/showMobStorey"})
    public ModelAndView showMobStorey(Long mobStoreyId) {
        ModelAndView mav = new ModelAndView();
        if (null != mobStoreyId) {
            MobStorey mobStorey = this.mobStoreyService.getMobStorey(mobStoreyId);
            mav.addObject("mobStorey", (Object)mobStorey);
        }
        mav.setViewName("jsp/mobile/show_mobstorey");
        return mav;
    }

    @RequestMapping(value={"/createMobStorey"})
    public ModelAndView createMobStorey(HttpServletRequest request, @Valid MobStorey mobStorey, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(REDIRECT));
        }
        this.mobStoreyService.createMobStorey(mobStorey);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u79fb\u52a8\u7248\u697c\u5c42", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/updateMobStorey"})
    public ModelAndView updateMobStorey(HttpServletRequest request, @Valid MobStorey mobStorey, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(REDIRECT));
        }
        this.mobStoreyService.updateMobStorey(mobStorey);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u79fb\u52a8\u7248\u697c\u5c42", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/deleteMobStorey"})
    public ModelAndView deleteMobStorey(Long mobStoreyId, HttpServletRequest request) {
        this.mobStoreyService.deleteMobStorey(mobStoreyId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u79fb\u52a8\u7248\u697c\u5c42", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/changeMobStoreyUserdStatus"})
    public ModelAndView changeMobStoreyUserdStatus(Long mobStoreyId, HttpServletRequest request) {
        this.mobStoreyService.changeMobStoreyUserdStatus(mobStoreyId);
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u79fb\u52a8\u7248\u697c\u5c42\u542f\u7528\u72b6\u6001", (String)((String)request.getSession().getAttribute(OPERAPATH)));
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }
}

