/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.system.controller;

import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.service.PayService;
import com.qianjiang.system.util.SelectBean;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import com.qianjiang.util.UploadUtil;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class PayController {
    private static final MyLogger LOGGER = new MyLogger(PayController.class);
    public static final String NAME = "name";
    public static final String OPERAPATH = "operaPath";
    private String page = "payset.htm";
    private String wxpage = "paywx.htm";
    private static final String NETLOGO = "netLogo";
    private static final String LOGGERINFO1 = ",\u7528\u6237\u540d:";
    @Resource(name="payService")
    private PayService payService;

    @RequestMapping(value={"/payset"})
    public ModelAndView paySet(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/customer/paymentMode", "pb", (Object)this.payService.findByPageBean(pb, selectBean));
    }

    @RequestMapping(value={"/paywx"})
    public ModelAndView paywx(HttpServletRequest request, HttpServletResponse response, PageBean pb, SelectBean selectBean) {
        if ("".equals(selectBean.getSearchText())) {
            selectBean.setCondition("");
        }
        request.setAttribute("selectBean", (Object)selectBean);
        return new ModelAndView("jsp/system/wxset", "pb", (Object)this.payService.findPayByPayType(pb, selectBean));
    }

    @RequestMapping(value={"/addpay"})
    public ModelAndView addPay(MultipartHttpServletRequest request, HttpServletResponse response, @Valid Pay pay, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(this.page));
        }
        try {
            MultipartFile file = request.getFile(NETLOGO);
            if (!file.isEmpty()) {
                pay.setPayImage(UploadUtil.uploadFileOne((MultipartFile)file, (HttpServletRequest)request));
            }
            this.payService.insertPay(pay);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u652f\u4ed8\u63a5\u53e3\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u6dfb\u52a0\u652f\u4ed8\u63a5\u53e3\u8bbe\u7f6e\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.page));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/delpay"})
    public ModelAndView deletePay(HttpServletRequest request, HttpServletResponse response) {
        try (PrintWriter pr = null;){
            pr = response.getWriter();
            pr.print(this.payService.deletePay(request.getParameterValues("payIds[]")));
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u652f\u4ed8\u63a5\u53e3\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        return null;
    }

    @RequestMapping(value={"/findpayone"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Pay findPayOne(Long payid) {
        return this.payService.findByPayId(payid);
    }

    @RequestMapping(value={"/findpayAll"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Object> findpayAll() {
        return this.payService.queryAllPaySet();
    }

    @RequestMapping(value={"/updatepay"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map updatePay(MultipartHttpServletRequest request, @Valid Pay pay) {
        LOGGER.debug("==========ajax\u68c0\u67e5\u542f\u7528\u7684\u652f\u4ed8\u65b9\u5f0f\u6570\u91cf==========");
        Object result = new HashedMap();
        try {
            MultipartFile file = request.getFile(NETLOGO);
            if (file != null && !file.isEmpty()) {
                pay.setPayImage(UploadUtil.uploadFileOne((MultipartFile)file, (HttpServletRequest)request));
            }
            result = this.payService.updatePay(pay);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u652f\u4ed8\u63a5\u53e3\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u652f\u4ed8\u63a5\u53e3\u8bbe\u7f6e\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return result;
    }

    @RequestMapping(value={"/updatePayForwx"})
    public ModelAndView updatePayForwx(MultipartHttpServletRequest request, HttpServletResponse response, @Valid Pay pay, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(this.wxpage));
        }
        try {
            MultipartFile file = request.getFile(NETLOGO);
            if (!file.isEmpty()) {
                pay.setPayImage(UploadUtil.uploadFileOne((MultipartFile)file, (HttpServletRequest)request));
            }
            this.payService.updatePay(pay);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u652f\u4ed8\u63a5\u53e3\u8bbe\u7f6e", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u652f\u4ed8\u63a5\u53e3\u8bbe\u7f6e\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.wxpage));
    }

    @RequestMapping(value={"/updateUserdStatusForPay"})
    public ModelAndView updateUserdStatusForPay(Long payId, HttpServletRequest request) {
        try {
            this.payService.updateUserdStatus(payId);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u652f\u4ed8\u63a5\u53e3\u542f\u7528\u72b6\u6001", (String)request.getSession().getAttribute(OPERAPATH).toString());
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u652f\u4ed8\u63a5\u53e3\u542f\u7528\u72b6\u6001\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/upUserdStatusForwxPay"})
    public ModelAndView upUserdStatusForwxPay(Long payId, HttpServletRequest request) {
        try {
            this.payService.updateUserdStatus(payId);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u652f\u4ed8\u63a5\u53e3\u542f\u7528\u72b6\u6001", (String)request.getSession().getAttribute(OPERAPATH).toString());
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u652f\u4ed8\u63a5\u53e3\u542f\u7528\u72b6\u6001\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.wxpage));
    }

    @RequestMapping(value={"/changeDefaultForPay"})
    public ModelAndView changeDefaultForPay(Long payId, HttpServletRequest request) {
        try {
            this.payService.changeDefault(payId);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9ed8\u8ba4\u652f\u4ed8\u63a5\u53e3", (String)request.getSession().getAttribute(OPERAPATH).toString());
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\u9ed8\u8ba4\u652f\u4ed8\u63a5\u53e3\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/deletePaySetOne"})
    public ModelAndView deletePaySetOne(Long payId) {
        this.payService.deletePaySetById(payId);
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/deletePaySetBatch"})
    public ModelAndView deletePaySetBatch(Long[] payIds) {
        for (Long payId : payIds) {
            this.payService.deletePaySetById(payId);
        }
        return new ModelAndView((View)new RedirectView(this.page));
    }

    @RequestMapping(value={"/updatepayhelp"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int updatePayHelp(HttpServletRequest request, Pay pay) {
        try {
            this.payService.updatePayHelp(pay);
            String customerName = (String)request.getSession().getAttribute(NAME);
            OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u652f\u4ed8\u95ee\u9898\u63cf\u8ff0", (String)(request.getSession().getAttribute(OPERAPATH) + LOGGERINFO1 + customerName));
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        return 1;
    }
}

