/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.util;

import com.qianjiang.util.HttpRequest;
import com.qianjiang.util.MD5;
import com.qianjiang.util.MyLogger;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class KuaiDiUtil {
    public static final MyLogger LOGGER = new MyLogger(KuaiDiUtil.class);

    private KuaiDiUtil() {
    }

    public static String execLookKuaiDi(String expressType, String expressNo) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(KuaiDiUtil.class.getResource("/").getPath() + "config/kuaidi100.properties")));
            Properties p = new Properties();
            p.load(in);
            String url = "http://api.kuaidi100.com/api?id=" + p.getProperty("key") + "&com=" + expressType + "&nu=" + expressNo + "&show=" + p.getProperty("show") + "&muti=" + p.getProperty("muti") + "&order=" + p.getProperty("order");
            HttpClient httpClient = new HttpClient();
            GetMethod getMethod = new GetMethod(url);
            httpClient.getParams().setParameter("http.protocol.content-charset", (Object)"utf-8");
            getMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler());
            int statusCode = httpClient.executeMethod((HttpMethod)getMethod);
            ((InputStream)in).close();
            if (statusCode == 200) {
                StringBuilder temp = new StringBuilder();
                InputStream in2 = getMethod.getResponseBodyAsStream();
                BufferedReader buffer = new BufferedReader(new InputStreamReader(in2, "utf-8"));
                String tempstr = "";
                while ((tempstr = buffer.readLine()) != null) {
                    temp = temp.append(tempstr);
                }
                buffer.close();
                in2.close();
                String result = temp.toString().trim();
                return result;
            }
            return "Can't get page:";
        }
        catch (FileNotFoundException e) {
            LOGGER.error("" + e);
            return "";
        }
        catch (IOException e) {
            LOGGER.error("" + e);
            return "";
        }
    }

    public static List<Map<Object, Object>> getKuaiDiInfo4Firm(String param) {
        ArrayList<Map<Object, Object>> orderList = new ArrayList<Map<Object, Object>>();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(KuaiDiUtil.class.getResource("/").getPath() + "config/kuaidi100enterprise.properties")));
            Properties p = new Properties();
            p.load(in);
            String customer = p.getProperty("customer");
            String key = p.getProperty("key");
            String url = p.getProperty("url");
            String sign = MD5.encode(param + key + customer);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("param", param);
            params.put("sign", sign);
            params.put("customer", customer);
            new HttpRequest();
            String resp = HttpRequest.postData(url, params, "utf-8").toString();
            JSONObject result = JSONObject.fromObject((Object)resp);
            if ("200".equals(result.get("status"))) {
                JSONArray kuaidiList = (JSONArray)result.get("data");
                if (kuaidiList != null && kuaidiList.size() > 0) {
                    for (int i = 0; i < kuaidiList.size(); ++i) {
                        JSONObject jobj = JSONObject.fromObject((Object)kuaidiList.get(i));
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("ftime", jobj.get("ftime"));
                        map.put("context", jobj.get("context"));
                        orderList.add(map);
                    }
                }
            } else {
                LOGGER.error("\u5feb\u9012\u67e5\u8be2\u8fd4\u56de\u6570\u636e\u9519\u8bef");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u5feb\u9012\u67e5\u8be2\u9519\u8bef");
        }
        return orderList;
    }

    public static void main(String[] args) {
        String emsCode = "yuantong";
        String emsCompCode = "889152850862860147";
        String param = "{\"com\":\"" + emsCode + "\",\"num\":\"" + emsCompCode + "\"}";
        List<Map<Object, Object>> result = KuaiDiUtil.getKuaiDiInfo4Firm(param);
        System.out.println(result.toString());
    }
}

