/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.controller;

import com.qianjiang.customer.bean.CustomerPointLevel;
import com.qianjiang.customer.service.CustomerPointServiceMapper;
import com.qianjiang.customer.service.CustomerServiceMapper;
import com.qianjiang.customer.service.PointLevelServiceMapper;
import com.qianjiang.util.PageBean;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller(value="pointLevelController")
public class PointLevelController {
    private static final String REDIRECT = "initPointLevel.htm";
    private PointLevelServiceMapper pointLevelServiceMapper;
    @Resource(name="customerServiceMapper")
    private CustomerServiceMapper customerServiceMapper;
    @Resource(name="customerPointServiceMapper")
    private CustomerPointServiceMapper customerPointServiceMapper;
    private static final Logger LOGGER = Logger.getLogger(PointLevelController.class);

    @RequestMapping(value={"/initPointLevel"})
    public ModelAndView initPointLevel(PageBean pageBean) {
        pageBean.setUrl(REDIRECT);
        return new ModelAndView("jsp/customer/customerlevel", "pageBean", (Object)this.pointLevelServiceMapper.selectAllPointLevel(pageBean));
    }

    @RequestMapping(value={"/addPointLevel"})
    public ModelAndView addPointLevel(@Valid CustomerPointLevel customerPointLevel, String pointNeed1) {
        if (null != customerPointLevel.getPointLevelName()) {
            LOGGER.info((Object)("\u6dfb\u52a0\u4f1a\u5458\u7b49\u7ea7\u540d\u79f0\u4e3a\uff1a" + customerPointLevel.getPointLevelName()));
        }
        customerPointLevel.setPointNeed(customerPointLevel.getPointNeed() + "~" + pointNeed1);
        this.pointLevelServiceMapper.addPointLevel(customerPointLevel);
        LOGGER.debug((Object)"\u6dfb\u52a0\u4f1a\u5458\u7b49\u7ea7");
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/validatePointLevel"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int validatePointLevel(String pointLelvelId, String pointLevelName, String pointDiscount, Long pointNeed, Long pointNeed1) {
        int result = 0;
        boolean isBreak = false;
        Long pointStart = pointNeed;
        Long pointEnd = pointNeed1;
        if (pointStart >= pointEnd) {
            result = 1;
        } else {
            List pointLevelList = this.pointLevelServiceMapper.selectAllPointLevel();
            if (pointLevelList != null && !pointLevelList.isEmpty()) {
                for (CustomerPointLevel customerPointLevel : pointLevelList) {
                    if (!pointLelvelId.equals(customerPointLevel.getPointLevelId().toString())) {
                        if (pointLevelName != null && pointLevelName.equals(customerPointLevel.getPointLevelName())) {
                            result = 2;
                            isBreak = true;
                            break;
                        }
                        String[] pointArrays = customerPointLevel.getPointNeed().split("~");
                        for (int i = 0; i < pointArrays.length; ++i) {
                            if (pointStart >= Long.valueOf(pointArrays[0]) && pointStart < Long.valueOf(pointArrays[1])) {
                                result = 3;
                                isBreak = true;
                                break;
                            }
                            if (pointEnd > Long.valueOf(pointArrays[0]) && pointEnd <= Long.valueOf(pointArrays[1])) {
                                result = 33;
                                isBreak = true;
                                break;
                            }
                            BigDecimal b1 = new BigDecimal(pointDiscount);
                            BigDecimal b2 = customerPointLevel.getPointDiscount();
                            if (pointStart >= Long.valueOf(pointArrays[1])) {
                                if (b1.compareTo(b2) != 1 && b1.compareTo(b2) != 0) continue;
                                result = 4;
                                isBreak = true;
                                break;
                            }
                            if (b1.compareTo(b2) != -1 && b1.compareTo(b2) != 0) continue;
                            result = 4;
                            isBreak = true;
                            break;
                        }
                    }
                    if (!isBreak) continue;
                    break;
                }
            }
        }
        return result;
    }

    @RequestMapping(value={"/queryPointLevelById"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public CustomerPointLevel queryPointLevelById(Long pointLevelId) {
        CustomerPointLevel customerPointLevel = this.pointLevelServiceMapper.selectPointLevelById(pointLevelId);
        if (null != customerPointLevel.getPointLevelName()) {
            LOGGER.info((Object)("\u83b7\u53d6\u4f1a\u5458\u7b49\u7ea7\u540d\u79f0\u4e3a\uff1a" + customerPointLevel.getPointLevelName() + "\u7684\u4fe1\u606f"));
        }
        return this.pointLevelServiceMapper.selectPointLevelById(pointLevelId);
    }

    @RequestMapping(value={"/updatePointLevel"})
    public ModelAndView updatePointLevel(@Valid CustomerPointLevel customerPointLevel, String pointNeed1) throws UnsupportedEncodingException {
        if (null != customerPointLevel.getPointLevelName()) {
            LOGGER.info((Object)("\u4fee\u6539\u4f1a\u5458\u7b49\u7ea7\u540d\u79f0\u4e3a\uff1a" + customerPointLevel.getPointLevelName() + "\u7684\u4fe1\u606f"));
        }
        customerPointLevel.setPointNeed(customerPointLevel.getPointNeed() + "~" + pointNeed1);
        this.pointLevelServiceMapper.updatePointLevel(customerPointLevel);
        LOGGER.debug((Object)("\u4fee\u6539\u4f1a\u5458\u7b49\u7ea7:" + customerPointLevel.getPointLevelName()));
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/deletePointLevel"})
    public ModelAndView deletePointLevel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            pr.print(this.pointLevelServiceMapper.deletePointLevel(request.getParameterValues("parameterIds[]")));
        }
        finally {
            LOGGER.debug((Object)"\u5220\u9664\u4f1a\u5458\u7b49\u7ea7");
            pr = null;
        }
        return null;
    }

    @RequestMapping(value={"/deleteNewPointLevel"})
    public ModelAndView deleteNewPointLevel(HttpServletRequest request, HttpServletResponse response, Long pointLevelId) throws IOException {
        String[] pointLevelIds = new String[]{"" + pointLevelId + ""};
        this.pointLevelServiceMapper.deletePointLevel(pointLevelIds);
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/deleteAllNewPointLevel"})
    public ModelAndView deleteAllNewCustomer(HttpServletRequest request, Long[] pointLevelId) {
        String[] pointLevelIds = request.getParameterValues("pointLevelId");
        this.pointLevelServiceMapper.deletePointLevel(pointLevelIds);
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    @RequestMapping(value={"/deletePointLevelValidate"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int deletePointLevelValidate(HttpServletRequest request) {
        int result = 0;
        String[] pointLevelIds = request.getParameterValues("pointLevelId");
        if (pointLevelIds != null && pointLevelIds.length > 0) {
            String pointLevelId;
            String[] arr$ = pointLevelIds;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (result = this.customerServiceMapper.queryInfoCountByLevelId(Long.valueOf(pointLevelId = arr$[i$]))) <= 0; ++i$) {
            }
        } else {
            result = -1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/checkExistPointLevelName"}, method={RequestMethod.POST})
    public ModelAndView checkExistPointLevelName(String pointLevelName, HttpServletResponse response) throws IOException {
        if (null != pointLevelName) {
            LOGGER.info((Object)("\u9a8c\u8bc1\u4f1a\u5458\u7b49\u7ea7\u540d\u79f0\uff1a" + pointLevelName + "\u662f\u5426\u5b58\u5728\uff01"));
        }
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            pr.print(this.pointLevelServiceMapper.selectPointLevelByName(pointLevelName));
        }
        finally {
            pr = null;
        }
        return null;
    }

    @RequestMapping(value={"/getPointLevel"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<CustomerPointLevel> getPointLevel(PageBean pageBean) {
        return this.pointLevelServiceMapper.selectAllPointLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/checkExistDefaultPointLevel"})
    public ModelAndView checkExistDefaultPointLevel(HttpServletResponse response) throws IOException {
        PrintWriter pr = null;
        try {
            pr = response.getWriter();
            pr.print(this.pointLevelServiceMapper.selectDefaultPointLevel());
        }
        finally {
            pr = null;
        }
        return null;
    }

    @RequestMapping(value={"/getmaxpoint"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String getMaxPoint() {
        return this.customerPointServiceMapper.getMaxCustomerPointLevelPoint() + "";
    }

    @RequestMapping(value={"/deleteallcustomerpointlevel"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int deleteAllCustomerPointLevel() {
        return this.customerPointServiceMapper.deleteAllCustomerPointLevel();
    }

    public PointLevelServiceMapper getPointLevelServiceMapper() {
        return this.pointLevelServiceMapper;
    }

    @Resource(name="pointLevelServiceMapper")
    public void setPointLevelServiceMapper(PointLevelServiceMapper pointLevelServiceMapper) {
        this.pointLevelServiceMapper = pointLevelServiceMapper;
    }
}

