/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.channel.controller;

import com.qianjiang.channel.bean.Channel;
import com.qianjiang.channel.bean.ChannelBar;
import com.qianjiang.channel.service.ChannelBarService;
import com.qianjiang.channel.service.SysChannelService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class ChannelBarController {
    private SysChannelService channelService;
    private ChannelBarService channelBarService;
    private static final MyLogger LOGGER = new MyLogger(ChannelBarController.class);
    private static final String LOGINUSERID = "loginUserId";
    private static final String SHOW_ACTION = "showChannelBar.htm";
    public static final String NAME = "name";
    private static final String CHANNEL = "channel";
    private static final String CHANNELID = "channelId";
    private static final String QUERYCHANNELBAR = "queryChannelBarByPageBean.htm?channelId=";
    private static final String CSRFTOKEN = "CSRFToken";
    private static final String CSRFTOKENSTRING = "&CSRFToken=";
    private static final String USERNAME = ",\u7528\u6237\u540d:";
    public static final String OPERAPATH = "operaPath";

    @RequestMapping(value={"/queryChannelBarByPageBean"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Map queryChannelBarByPageBean(PageBean pb, Long channelId, HttpServletRequest request) {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        PageBean pageBean = this.channelBarService.selectChannelBarByParam(pb, channelId, null, null);
        Channel channel = this.channelService.findChannelByID(channelId);
        maps.put("pb", pageBean);
        maps.put(CHANNEL, channel);
        maps.put(CHANNELID, channelId);
        return maps;
    }

    @RequestMapping(value={"/showChannelBar"})
    public ModelAndView showChannelBar(Long barId, Long channelId) {
        Channel channel = this.channelService.findChannelByID(channelId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(CHANNEL, channel);
        if (null != barId) {
            ChannelBar sysBarConf = this.channelBarService.getChannelBarById(barId);
            map.put("sysBarConf", sysBarConf);
        }
        return new ModelAndView("jsp/channel/showChannelBar", "map", map);
    }

    @RequestMapping(value={"/createChannelBar"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int createChannelBar(HttpServletRequest request, HttpServletResponse response, ChannelBar sysBarConf, Long channelId) {
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        try {
            sysBarConf.setBarType(Long.valueOf(2L));
            if (null == loginUserId) {
                sysBarConf.setInsertId(Long.valueOf(1L));
            } else {
                sysBarConf.setInsertId(loginUserId);
            }
            int n = this.channelBarService.saveChannelBar(sysBarConf);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u6dfb\u52a0\u9891\u9053\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
                LOGGER.debug("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u6210\u529f\uff01");
            } else {
                LOGGER.debug("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u5931\u8d25\uff01");
            }
            return n;
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            return 0;
        }
    }

    @RequestMapping(value={"/updateChannelBar"})
    public ModelAndView updateChannelBar(HttpServletRequest request, @Valid ChannelBar sysBarConf, BindingResult bindingResult, Long channelId) {
        if (bindingResult.hasErrors()) {
            return new ModelAndView((View)new RedirectView(QUERYCHANNELBAR + sysBarConf.getChannelId() + CSRFTOKENSTRING + request.getParameter(CSRFTOKEN)));
        }
        Long loginUserId = (Long)request.getSession().getAttribute(LOGINUSERID);
        ModelAndView mav = new ModelAndView();
        try {
            sysBarConf.setBarType(Long.valueOf(2L));
            if (null == loginUserId) {
                sysBarConf.setModifyId(Long.valueOf(1L));
            } else {
                sysBarConf.setModifyId(loginUserId);
            }
            sysBarConf.setDeleteStatus(Integer.valueOf(0));
            int n = this.channelBarService.updateChannelBar(sysBarConf);
            mav.addObject(CHANNELID, (Object)channelId);
            if (n > 0) {
                String customerName = (String)request.getSession().getAttribute(NAME);
                OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u4fee\u6539\u9891\u9053\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
                LOGGER.debug("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u6210\u529f\uff01");
                mav.setView((View)new RedirectView(QUERYCHANNELBAR + sysBarConf.getChannelId() + CSRFTOKENSTRING + request.getParameter(CSRFTOKEN)));
            } else {
                LOGGER.debug("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u5931\u8d25\uff01");
                mav.setView((View)new RedirectView(SHOW_ACTION));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5bfc\u822a\u8bbe\u7f6e\u5bf9\u8c61\u5f02\u5e38\uff01", (Throwable)e);
            mav.setView((View)new RedirectView(SHOW_ACTION));
        }
        return mav;
    }

    @RequestMapping(value={"/deleteChannelBar"})
    public void deleteChannelBar(HttpServletRequest request, HttpServletResponse response) {
        String[] barIds = request.getParameterValues("barIds[]");
        for (int i = 0; i < barIds.length; ++i) {
            this.channelBarService.deleteChannelBar(Long.valueOf(barIds[i]));
        }
        String customerName = (String)request.getSession().getAttribute(NAME);
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)customerName, (String)"\u5220\u9664\u9891\u9053\u5bfc\u822a", (String)(request.getSession().getAttribute(OPERAPATH) + USERNAME + customerName));
    }

    public SysChannelService getChannelService() {
        return this.channelService;
    }

    @Resource(name="SysChannelService")
    public void setChannelService(SysChannelService channelService) {
        this.channelService = channelService;
    }

    public ChannelBarService getChannelBarService() {
        return this.channelBarService;
    }

    @Resource(name="ChannelBarService")
    public void setChannelBarService(ChannelBarService channelBarService) {
        this.channelBarService = channelBarService;
    }
}

