/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.customer.controller;

import com.alibaba.fastjson.JSON;
import com.qianjiang.customer.bean.WxBill;
import com.qianjiang.customer.service.WxBillService;
import com.qianjiang.system.bean.Pay;
import com.qianjiang.system.service.OrderPayService;
import com.qianjiang.util.PageBean;
import com.qianjiang.utils.HttpUtil;
import com.qianjiang.utils.PayCommonUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class WxBillController {
    @Resource(name="OrderPayService")
    private OrderPayService orderPayService;
    @Autowired
    private WxBillService wxBillService;
    private PayCommonUtil payCommonUtil;
    private HttpUtil httpUtil;

    @RequestMapping(value={"wxbillList"})
    public ModelAndView wxbillList(WxBill wxBill, String startTimex, String endTimex, PageBean pageBean) throws UnsupportedEncodingException {
        ModelAndView mav = null;
        Map result = null;
        pageBean.setUrl("wxbillList.htm");
        wxBill.setStartTime(startTimex);
        wxBill.setEndTime(endTimex);
        result = this.wxBillService.selectWxBillList(wxBill, pageBean);
        WxBill bill = this.wxBillService.selectSumWxBill();
        pageBean = (PageBean)JSON.parseObject((String)JSON.toJSONString(result.get("pageBean")), PageBean.class);
        mav = new ModelAndView("jsp/report/wxbill");
        mav.addObject("map", (Object)result);
        mav.addObject("wxBill", (Object)wxBill);
        mav.addObject("bill", (Object)bill);
        mav.addObject("startTimex", (Object)startTimex);
        mav.addObject("endTimex", (Object)endTimex);
        mav.addObject("pageBean", (Object)pageBean);
        return mav;
    }

    @Transactional
    @RequestMapping(value={"wxReconciliation"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public int downloadWxBill(String choosetime) throws ParseException {
        int rows = 0;
        String[] sp = choosetime.split("-");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < sp.length; ++i) {
            if (i == 2) {
                String a = sp[i].substring(0, 2);
                buffer.append(a);
                continue;
            }
            buffer.append(sp[i]);
        }
        WxBill bill = new WxBill();
        bill.setStartTime(choosetime.substring(0, 10));
        int flag = this.wxBillService.checkRepeat(bill);
        if (flag != 0) {
            rows = 2;
            return rows;
        }
        Date da = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        String format2 = format.format(da);
        if (choosetime.substring(0, 10).equals(format2.substring(0, 10))) {
            rows = 4;
            return rows;
        }
        String substring = format2.substring(0, 10);
        String[] split3 = substring.split("-");
        StringBuffer buffer2 = new StringBuffer();
        for (int i = 0; i < split3.length; ++i) {
            buffer2.append(split3[i]);
        }
        if (Integer.valueOf(buffer.toString()) > Integer.valueOf(buffer2.toString())) {
            rows = 5;
            return rows;
        }
        int buildRandom = PayCommonUtil.buildRandom((int)10);
        String nonce_str = buildRandom + "";
        Pay pay = this.orderPayService.selectByPrimaryKey(Long.valueOf(37L));
        String appid = pay.getApiKey();
        String mch_id = pay.getPartner();
        String key = pay.getPartnerKey();
        TreeMap<String, String> packageParams = new TreeMap<String, String>();
        packageParams.put("appid", "wx73fc7cad3265020d");
        packageParams.put("bill_date", buffer.toString());
        packageParams.put("bill_type", "ALL");
        packageParams.put("mch_id", "1361354602");
        packageParams.put("nonce_str", nonce_str);
        String sign = PayCommonUtil.createSign((String)"UTF-8", packageParams, (String)"Senseshieldshensishuduncaiwu1234");
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("appid", "wx73fc7cad3265020d");
        params.put("bill_date", buffer.toString());
        params.put("bill_type", "ALL");
        params.put("mch_id", "1361354602");
        params.put("nonce_str", nonce_str);
        params.put("sign", sign);
        String requestXml = PayCommonUtil.getRequestXml(params);
        String postData = HttpUtil.postData((String)"https://api.mch.weixin.qq.com/pay/downloadbill", (String)requestXml, null);
        try {
            if (postData != null) {
                String[] split = postData.split("\n");
                for (int i = 1; i < split.length - 2; ++i) {
                    String back_status;
                    String trade_status;
                    String bill_price;
                    String goods_name;
                    String me_code;
                    String wx_code;
                    String[] split2 = split[i].split(",");
                    WxBill wxBill = new WxBill();
                    String trade_date = split2[0].substring(1);
                    if (!trade_date.equals("")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Date tradedate = sdf.parse(trade_date);
                        wxBill.setTradeDate(tradedate);
                    }
                    if (!(wx_code = split2[5].substring(1)).equals("")) {
                        wxBill.setWxCode(wx_code);
                    }
                    if (!(me_code = split2[6].substring(1)).equals("")) {
                        wxBill.setMeCode(me_code);
                    }
                    if (!(goods_name = split2[20].substring(1)).equals("")) {
                        wxBill.setGoodsName(goods_name);
                    }
                    if (!(bill_price = split2[12].substring(1)).equals("")) {
                        wxBill.setBillPrice(new BigDecimal(bill_price));
                    }
                    if (!(trade_status = split2[9].substring(1)).equals("")) {
                        wxBill.setTradeStatus(trade_status);
                        if ("SUCCESS".equals(trade_status)) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            Date success_date = sdf.parse(trade_date);
                            wxBill.setSuccessDate(success_date);
                        }
                    }
                    if (!(back_status = split2[19].substring(1)).equals("")) {
                        wxBill.setBackStatus(back_status);
                        if ("SUCCESS".equals(back_status)) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            Date back_date = sdf.parse(trade_date);
                            wxBill.setBackDate(back_date);
                            wxBill.setWxBackcode(split2[14].substring(1));
                            wxBill.setMeBackcode(split2[15].substring(1));
                            wxBill.setBillPrice(new BigDecimal(split2[16].substring(1)));
                        }
                    }
                    rows = this.wxBillService.addWxBill(wxBill);
                }
            } else {
                rows = 3;
            }
            return rows;
        }
        catch (Exception e) {
            e.printStackTrace();
            rows = 3;
            return rows;
        }
    }
}

