/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.mobile.controller;

import com.qianjiang.mobile.bean.MobHomePage;
import com.qianjiang.mobile.service.MobHomePageService;
import com.qianjiang.util.xml.XmlElementUtil;
import com.qianjiang.util.xml.XmlUtil;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Date;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Controller
public class MobHomeTextController {
    private static final Logger LOGGER = Logger.getLogger(MobHomeTextController.class);
    private static final String REDIRECT = "setMobHomePage.htm";
    XmlUtil xmlUtil = new XmlUtil();
    XmlElementUtil xmlElementUtil = new XmlElementUtil();
    static final String xmlFilePath = "templete_mobile/xml/9gdemo.xml";
    @Resource(name="MobHomePageService")
    private MobHomePageService mobHomePageService;

    @RequestMapping(value={"/saveText"})
    public ModelAndView saveText(Long merchantId, HttpServletRequest request) {
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u4fdd\u5b58\u6587\u5b57\u91cd\u590d\u63d0\u4ea4===========");
            return new ModelAndView((View)new RedirectView(REDIRECT));
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        Element root = document.getDocumentElement();
        String textId = request.getParameter("textId");
        String content = request.getParameter("content");
        if (null != textId && !"".equals(textId)) {
            this.updateTextElement(root, textId, content);
        } else {
            this.createTextElement(root, content);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    private void createTextElement(Element root, String content) {
        Element[] texts = this.xmlElementUtil.getElementsByName(root, "text");
        int max = 0;
        for (Element el : texts) {
            int temp = Integer.valueOf(el.getAttribute("id"));
            if (temp <= max) continue;
            max = temp;
        }
        Element newText = root.getOwnerDocument().createElement("text");
        newText.setNodeValue(content);
        this.xmlElementUtil.setElementValue(newText, content);
        this.xmlElementUtil.setElementAttr(newText, "id", String.valueOf(max + 1));
        root.appendChild(newText);
    }

    private void updateTextElement(Element root, String textId, String content) {
        Element[] texts;
        Node oldText = null;
        for (Element el : texts = this.xmlElementUtil.getElementsByName(root, "text")) {
            if (!el.getAttribute("id").equals(textId)) continue;
            oldText = el;
        }
        oldText.setNodeValue(content);
        this.xmlElementUtil.setElementValue((Element)oldText, content);
    }

    @RequestMapping(value={"/deleteText"})
    public ModelAndView deleteText(Long merchantId, HttpServletRequest request) {
        Element[] texts;
        String rsv = request.getParameter("rsv");
        if (null != rsv && !rsv.equals(request.getSession().getAttribute("rsv"))) {
            LOGGER.info((Object)"==========\u5220\u9664\u6587\u5b57\u91cd\u590d\u63d0\u4ea4===========");
            return new ModelAndView((View)new RedirectView(REDIRECT));
        }
        request.getSession().setAttribute("rsv", (Object)this.mkRSV());
        String filepath = request.getSession().getServletContext().getRealPath("/") + "/";
        Long loginUserId = (Long)request.getAttribute("loginUserId");
        MobHomePage homePage = this.mobHomePageService.selectHomePageByMerchantId(merchantId, filepath, loginUserId);
        Document document = this.xmlUtil.str2Document(homePage.getDoc());
        String id = request.getParameter("id");
        Element root = document.getDocumentElement();
        for (Element el : texts = this.xmlElementUtil.getElementsByName(root, "text")) {
            if (!this.xmlElementUtil.getElementAttr(el, "id").equals(id)) continue;
            root.removeChild(el);
        }
        homePage.setDoc(this.xmlUtil.document2Str(document));
        homePage.setTemp1(this.mkToken());
        this.mobHomePageService.updateHomePage(homePage, loginUserId);
        return new ModelAndView((View)new RedirectView(REDIRECT));
    }

    private String mkToken() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }

    private String mkRSV() {
        String tokenValue = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(new Date().toString().getBytes());
            tokenValue = new BigInteger(1, md.digest()).toString(16);
            LOGGER.debug((Object)("==========token\u7801\u4e3a" + tokenValue));
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u751f\u6210token\u7801\u9519\u8bef\uff1a=>", (Throwable)e);
        }
        return tokenValue;
    }
}

