/*
 * Decompiled with CFR 0.152.
 */
package com.qianjiang.order.controller;

import com.qianjiang.goods.service.WareHouseService;
import com.qianjiang.operlog.util.IPAddress;
import com.qianjiang.operlog.util.OperaLogUtil;
import com.qianjiang.order.bean.Order;
import com.qianjiang.order.bean.OrderExpress;
import com.qianjiang.order.bean.OrderLogger;
import com.qianjiang.order.service.OrderCouponService;
import com.qianjiang.order.service.OrderLogService;
import com.qianjiang.order.service.OrderLoggerService;
import com.qianjiang.order.service.OrderService;
import com.qianjiang.system.service.BasicSetService;
import com.qianjiang.system.service.ILogisticsCompanyBiz;
import com.qianjiang.system.service.LogisticsSingleService;
import com.qianjiang.util.MyLogger;
import com.qianjiang.util.PageBean;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class OrderCargoController {
    public static final MyLogger LOGGER = new MyLogger(OrderCargoController.class);
    private static final String PAGEBEAN = "pageBean";
    private static final String ORDER = "order";
    private static final String YSTATUS = "yStatus";
    private static final String RELATIONS = "relations";
    private static final String STATUS = "status";
    private OrderService orderService;
    private OrderCouponService orderCouponService;
    private OrderLogService orderLogService;
    @Resource(name="logisticsCompanyBizImpl")
    private ILogisticsCompanyBiz iLogisticsCompanyBiz;
    @Resource(name="LogisticsSingleService")
    private LogisticsSingleService logisticsSingleService;
    @Resource(name="basicSetService")
    private BasicSetService basicSetService;
    @Resource(name="WareHouseService")
    private WareHouseService wareHouseService;
    @Resource(name="orderLoggerService")
    private OrderLoggerService orderLoggerService;

    @RequestMapping(value={"/orderpickinglist"})
    public ModelAndView orderPickingList(Order order, PageBean pageBean, HttpServletRequest request, String status) {
        String statusNew = status;
        statusNew = "5";
        order.setOrderStatus("1");
        order.setOrderCargoStatus("0");
        order.setBusinessId(Long.valueOf(0L));
        pageBean.setUrl("orderpickinglist.htm");
        return new ModelAndView("jsp/order/orderpickinglist", PAGEBEAN, (Object)this.orderService.searchOrderList(order, pageBean)).addObject(ORDER, (Object)order).addObject(STATUS, (Object)statusNew);
    }

    @RequestMapping(value={"/printView"})
    public ModelAndView printview(String str) {
        return new ModelAndView("jsp/order/printorderpickinglist").addObject("str", (Object)str);
    }

    @RequestMapping(value={"/orderpicking"})
    public ModelAndView orderPicking(Long[] orderId, HttpServletRequest request, String status, String yStatus) {
        String pickingName = request.getSession().getAttribute("name").toString();
        Map map = this.orderService.queryByPincking(orderId, Long.valueOf(0L), pickingName, status);
        return new ModelAndView("jsp/order/printtakepro").addObject("map", (Object)map).addObject(YSTATUS, (Object)yStatus);
    }

    @RequestMapping(value={"/printorderpickinglist"})
    public ModelAndView printorderpickinglist(String str, HttpServletRequest request) {
        String title = "";
        try {
            title = new String(str.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("", (Throwable)e);
        }
        return new ModelAndView("jsp/order/printorderpickinglist").addObject("str", (Object)title);
    }

    @RequestMapping(value={"/orderdeliverylist"})
    public ModelAndView orderDeliveryList(Order order, PageBean pageBean, Long[] orderIds, HttpServletRequest request, String status) {
        order.setOrderStatus("1");
        String statusNew = status;
        statusNew = "4";
        order.setOrderCargoStatus("1");
        order.setBusinessId(Long.valueOf(0L));
        pageBean.setUrl("orderdeliverylist.htm");
        return new ModelAndView("jsp/order/orderpickinglist", PAGEBEAN, (Object)this.orderService.searchOrderList(order, pageBean, orderIds)).addObject(ORDER, (Object)order);
    }

    @RequestMapping(value={"/ordercontainer"})
    public ModelAndView orderContainer(Long orderId, HttpServletRequest request, String yStatus) {
        this.orderService.initContainerRelation(orderId);
        List relations = this.orderService.queryContainerRalation(orderId);
        Order order = this.orderService.getPayOrder(orderId);
        return new ModelAndView("jsp/order/printoutstock").addObject(ORDER, (Object)order).addObject(RELATIONS, (Object)relations).addObject(YSTATUS, (Object)yStatus);
    }

    @RequestMapping(value={"/addcontainer"})
    public ModelAndView addContainer(Long orderId, HttpServletRequest request) {
        this.orderService.addContainerRalation(orderId);
        return new ModelAndView((View)new RedirectView("ordercontainer.htm")).addObject("orderId", (Object)orderId);
    }

    @RequestMapping(value={"/delrelationbyid"})
    public ModelAndView delRelationById(Long relationId, Long orderId, HttpServletRequest request) {
        this.orderService.delRelationById(relationId);
        return new ModelAndView((View)new RedirectView("ordercontainer.htm")).addObject("orderId", (Object)orderId);
    }

    @RequestMapping(value={"/sendorder"})
    public ModelAndView sendOrder(OrderExpress orderExpress) {
        this.orderService.sendOrder(orderExpress);
        return new ModelAndView((View)new RedirectView("orderlist.htm"));
    }

    @RequestMapping(value={"/ordersendgoods"})
    public ModelAndView orderSendGoods(Order order, PageBean pageBean, HttpServletRequest request, String status) {
        String statusNew = status;
        statusNew = "3";
        order.setOrderStatus("1");
        order.setOrderCargoStatus("2");
        order.setBusinessId(Long.valueOf(0L));
        pageBean.setUrl("ordersendgoods.htm");
        return new ModelAndView("jsp/order/orderpickinglist", PAGEBEAN, (Object)this.orderService.searchOrderList(order, pageBean)).addObject(ORDER, (Object)order);
    }

    @RequestMapping(value={"/toSendgoodsorder"})
    public ModelAndView toSendGoodsOrder(Long orderId, HttpServletRequest request, String status, String yStatus) {
        return new ModelAndView("jsp/order/printshipments").addObject("orderId", (Object)orderId).addObject(STATUS, (Object)status).addObject(YSTATUS, (Object)yStatus);
    }

    @RequestMapping(value={"suspendorder"})
    public ModelAndView suspendOrder(Long orderId, String orderStatus, String reason, HttpServletRequest request, String orderCodex, String sign) {
        this.orderCouponService.modifyCouponStatus(orderId);
        int count = this.orderService.modifyOrderByKey(orderId, orderStatus, reason);
        String operaCode = "\u8ba2\u5355\u64cd\u4f5c";
        String operaContent = request.getSession().getAttribute("operaPath") + "  \u4e2d\u65ad\u8ba2\u5355\uff1a" + orderCodex + " \u4e2d\u65ad\u539f\u56e0:" + reason;
        OperaLogUtil.addOperaLog((String)IPAddress.getIpAddr((HttpServletRequest)request), (String)request.getSession().getAttribute("name").toString(), (String)operaCode, (String)operaContent);
        if ("1".equals("1")) {
            OrderLogger orderLogger = new OrderLogger();
            orderLogger.setName((String)request.getSession().getAttribute("name"));
            orderLogger.setOrderId(orderId.toString());
            orderLogger.setDetail(operaContent);
            orderLogger.setType("\u53d6\u6d88\u8ba2\u5355");
            orderLogger.setStatus("0");
            this.orderLoggerService.saveLogger(orderLogger);
        }
        this.orderLogService.insertSelective(reason, orderId, request.getSession().getAttribute("name").toString(), "1");
        if (count > 0) {
            if ("0".equals(sign)) {
                return new ModelAndView((View)new RedirectView("orderlist.htm"));
            }
            if ("1".equals(sign)) {
                return new ModelAndView((View)new RedirectView("orderpickinglist.htm"));
            }
            return new ModelAndView((View)new RedirectView("orderdeliverylist.htm"));
        }
        return null;
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    @Resource(name="OrderService")
    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public OrderCouponService getOrderCouponService() {
        return this.orderCouponService;
    }

    @Resource(name="OrderCouponService")
    public void setOrderCouponService(OrderCouponService orderCouponService) {
        this.orderCouponService = orderCouponService;
    }

    public OrderLogService getOrderLogService() {
        return this.orderLogService;
    }

    @Resource(name="OrderLogService")
    public void setOrderLogService(OrderLogService orderLogService) {
        this.orderLogService = orderLogService;
    }
}

